/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.model.system.configurations.CaptchaEffect;
import org.cyclos.model.system.configurations.CaptchaProvider;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Embeddable
public class CaptchaConfiguration
implements Cloneable,
PersistenceWeaved,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="captcha_provider")
    private CaptchaProvider provider;
    @Basic
    @Column(name="captcha_text_length")
    private Integer textLength;
    @Basic
    @Column(name="captcha_text_color")
    private String textColor;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="captcha_effect")
    private CaptchaEffect effect;
    @Basic
    @Column(name="captcha_recaptcha_key")
    private String recaptchaKey;
    @Basic
    @Column(name="captcha_recaptcha_secret")
    private String recaptchaSecret;
    @Basic
    @Column(name="captcha_public_registration")
    private Boolean useOnPublicRegistration;
    @Basic
    @Column(name="captcha_forgot_password")
    private Boolean useOnForgotPassword;
    static final long serialVersionUID = -3533564655242520199L;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public CaptchaConfiguration() {
        this.provider = CaptchaProvider.INTERNAL;
        this.textLength = 6;
        this.textColor = "#202020";
        this.effect = CaptchaEffect.SHADOW;
        this.useOnPublicRegistration = true;
        this.useOnForgotPassword = true;
    }

    public CaptchaEffect getEffect() {
        return this._persistence_get_effect();
    }

    public CaptchaProvider getProvider() {
        return this._persistence_get_provider();
    }

    public String getRecaptchaKey() {
        return this._persistence_get_recaptchaKey();
    }

    public String getRecaptchaSecret() {
        return this._persistence_get_recaptchaSecret();
    }

    public String getTextColor() {
        return this._persistence_get_textColor();
    }

    public Integer getTextLength() {
        return this._persistence_get_textLength();
    }

    public boolean isRecaptchaSecretSet() {
        return StringHelper.isNotBlank((Object)this._persistence_get_recaptchaSecret());
    }

    public boolean isUseOnForgotPassword() {
        return Boolean.TRUE.equals(this._persistence_get_useOnForgotPassword());
    }

    public boolean isUseOnPublicRegistration() {
        return Boolean.TRUE.equals(this._persistence_get_useOnPublicRegistration());
    }

    public void setEffect(CaptchaEffect captchaEffect) {
        this._persistence_set_effect(captchaEffect);
    }

    public void setProvider(CaptchaProvider captchaProvider) {
        this._persistence_set_provider(captchaProvider);
    }

    public void setRecaptchaKey(String string) {
        this._persistence_set_recaptchaKey(string);
    }

    public void setRecaptchaSecret(String string) {
        this._persistence_set_recaptchaSecret(string);
    }

    public void setTextColor(String string) {
        this._persistence_set_textColor(string);
    }

    public void setTextLength(Integer n) {
        this._persistence_set_textLength(n);
    }

    public void setUseOnForgotPassword(boolean bl) {
        this._persistence_set_useOnForgotPassword(bl);
    }

    public void setUseOnPublicRegistration(boolean bl) {
        this._persistence_set_useOnPublicRegistration(bl);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CaptchaConfiguration(persistenceObject);
    }

    public CaptchaConfiguration(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "recaptchaKey") {
            return this.recaptchaKey;
        }
        if (string == "recaptchaSecret") {
            return this.recaptchaSecret;
        }
        if (string == "provider") {
            return this.provider;
        }
        if (string == "effect") {
            return this.effect;
        }
        if (string == "textLength") {
            return this.textLength;
        }
        if (string == "useOnPublicRegistration") {
            return this.useOnPublicRegistration;
        }
        if (string == "textColor") {
            return this.textColor;
        }
        if (string == "useOnForgotPassword") {
            return this.useOnForgotPassword;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "recaptchaKey") {
            this.recaptchaKey = (String)object;
            return;
        }
        if (string == "recaptchaSecret") {
            this.recaptchaSecret = (String)object;
            return;
        }
        if (string == "provider") {
            this.provider = (CaptchaProvider)object;
            return;
        }
        if (string == "effect") {
            this.effect = (CaptchaEffect)object;
            return;
        }
        if (string == "textLength") {
            this.textLength = (Integer)object;
            return;
        }
        if (string == "useOnPublicRegistration") {
            this.useOnPublicRegistration = (Boolean)object;
            return;
        }
        if (string == "textColor") {
            this.textColor = (String)object;
            return;
        }
        if (string == "useOnForgotPassword") {
            this.useOnForgotPassword = (Boolean)object;
            return;
        }
    }

    public String _persistence_get_recaptchaKey() {
        this._persistence_checkFetched("recaptchaKey");
        return this.recaptchaKey;
    }

    public void _persistence_set_recaptchaKey(String string) {
        this._persistence_checkFetchedForSet("recaptchaKey");
        this._persistence_propertyChange("recaptchaKey", this.recaptchaKey, string);
        this.recaptchaKey = string;
    }

    public String _persistence_get_recaptchaSecret() {
        this._persistence_checkFetched("recaptchaSecret");
        return this.recaptchaSecret;
    }

    public void _persistence_set_recaptchaSecret(String string) {
        this._persistence_checkFetchedForSet("recaptchaSecret");
        this._persistence_propertyChange("recaptchaSecret", this.recaptchaSecret, string);
        this.recaptchaSecret = string;
    }

    public CaptchaProvider _persistence_get_provider() {
        this._persistence_checkFetched("provider");
        return this.provider;
    }

    public void _persistence_set_provider(CaptchaProvider captchaProvider) {
        this._persistence_checkFetchedForSet("provider");
        this._persistence_propertyChange("provider", this.provider, captchaProvider);
        this.provider = captchaProvider;
    }

    public CaptchaEffect _persistence_get_effect() {
        this._persistence_checkFetched("effect");
        return this.effect;
    }

    public void _persistence_set_effect(CaptchaEffect captchaEffect) {
        this._persistence_checkFetchedForSet("effect");
        this._persistence_propertyChange("effect", this.effect, captchaEffect);
        this.effect = captchaEffect;
    }

    public Integer _persistence_get_textLength() {
        this._persistence_checkFetched("textLength");
        return this.textLength;
    }

    public void _persistence_set_textLength(Integer n) {
        this._persistence_checkFetchedForSet("textLength");
        this._persistence_propertyChange("textLength", this.textLength, n);
        this.textLength = n;
    }

    public Boolean _persistence_get_useOnPublicRegistration() {
        this._persistence_checkFetched("useOnPublicRegistration");
        return this.useOnPublicRegistration;
    }

    public void _persistence_set_useOnPublicRegistration(Boolean bl) {
        this._persistence_checkFetchedForSet("useOnPublicRegistration");
        this._persistence_propertyChange("useOnPublicRegistration", this.useOnPublicRegistration, bl);
        this.useOnPublicRegistration = bl;
    }

    public String _persistence_get_textColor() {
        this._persistence_checkFetched("textColor");
        return this.textColor;
    }

    public void _persistence_set_textColor(String string) {
        this._persistence_checkFetchedForSet("textColor");
        this._persistence_propertyChange("textColor", this.textColor, string);
        this.textColor = string;
    }

    public Boolean _persistence_get_useOnForgotPassword() {
        this._persistence_checkFetched("useOnForgotPassword");
        return this.useOnForgotPassword;
    }

    public void _persistence_set_useOnForgotPassword(Boolean bl) {
        this._persistence_checkFetchedForSet("useOnForgotPassword");
        this._persistence_propertyChange("useOnForgotPassword", this.useOnForgotPassword, bl);
        this.useOnForgotPassword = bl;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

