/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.contentmanagement.AdminHelpContent;
import org.cyclos.entities.contentmanagement.Banner;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.contentmanagement.EmailTemplate;
import org.cyclos.entities.contentmanagement.FooterContent;
import org.cyclos.entities.contentmanagement.FrontendDashboardContent;
import org.cyclos.entities.contentmanagement.FrontendFooterContent;
import org.cyclos.entities.contentmanagement.FrontendHelpContent;
import org.cyclos.entities.contentmanagement.FrontendHomeContent;
import org.cyclos.entities.contentmanagement.GuestHomeContent;
import org.cyclos.entities.contentmanagement.HeaderContent;
import org.cyclos.entities.contentmanagement.HomeContent;
import org.cyclos.entities.contentmanagement.LoggedUserHomeContent;
import org.cyclos.entities.contentmanagement.LoginFooterContent;
import org.cyclos.entities.contentmanagement.LoginHeaderContent;
import org.cyclos.entities.contentmanagement.MenuEntry;
import org.cyclos.entities.contentmanagement.MobileHelpContent;
import org.cyclos.entities.contentmanagement.MobilePosHelpContent;
import org.cyclos.entities.contentmanagement.PayFooterContent;
import org.cyclos.entities.contentmanagement.PayHeaderContent;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.contentmanagement.UserHelpContent;
import org.cyclos.entities.contentmanagement.WelcomeContent;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.AddressConfiguration;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.ConfigurationGuestProfileField;
import org.cyclos.entities.system.ConfigurationImage;
import org.cyclos.entities.system.CustomScriptConfiguration;
import org.cyclos.entities.system.CustomSessionConfiguration;
import org.cyclos.entities.system.DefaultUserImage;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.DynamicOidcClientConfiguration;
import org.cyclos.entities.system.IpGeolocationConfiguration;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.system.SmtpConfiguration;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.system.UserFormatConfiguration;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.utils.Dimensions;
import org.cyclos.entities.utils.FileSize;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.entities.utils.LatLong;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.accounts.AccountStatusIndicator;
import org.cyclos.model.banking.accounts.DefaultAccountHistoryPeriod;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentNature;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.marketplace.advertisements.AdInitialSearchType;
import org.cyclos.model.marketplace.advertisements.AdOrderBy;
import org.cyclos.model.marketplace.categories.AdCategoryResultType;
import org.cyclos.model.system.configurations.AllowAccessMode;
import org.cyclos.model.system.configurations.DefaultConfigurationType;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.configurations.FrontendDashboardAccounts;
import org.cyclos.model.system.configurations.FrontendLandingPage;
import org.cyclos.model.system.configurations.MapPreference;
import org.cyclos.model.system.configurations.MenuType;
import org.cyclos.model.system.configurations.ResultType;
import org.cyclos.model.system.configurations.TaskLoggingMode;
import org.cyclos.model.system.configurations.UserSearchInMenuMode;
import org.cyclos.model.system.languages.DateFormat;
import org.cyclos.model.system.languages.ListSeparator;
import org.cyclos.model.system.languages.NumberFormat;
import org.cyclos.model.system.languages.TimeFormat;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.UsesScript;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.EmailValidation;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.UserOrderBy;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="configurations")
public class Configuration
extends ConfigurationEntity
implements DefinesNetwork,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="default_type")
    private DefaultConfigurationType defaultType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    private Network network;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id", updatable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private Configuration parent;
    @OneToMany(mappedBy="parent")
    private List<Configuration> children = new ArrayList<Configuration>();
    @Basic
    @Column(name="define_root_url")
    private boolean defineRootUrl;
    @Basic
    @Column(name="root_url")
    private String rootUrl;
    @Basic
    @Column(name="path")
    private String path;
    @Basic
    @Column(name="api_url")
    private String apiUrl;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="allow_access_mode")
    private AllowAccessMode allowAccessMode;
    @Basic
    @Lob
    @Column(name="firebase_private_key")
    private String firebasePrivateKey;
    @ElementCollection
    @Column(name="name")
    @CollectionTable(name="configurations_locked_properties", joinColumns={@JoinColumn(name="configuration_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"configuration_id", "name"})})
    private Set<String> lockedProperties = new HashSet<String>();
    @ElementCollection
    @Column(name="name")
    @CollectionTable(name="configurations_defined_properties", joinColumns={@JoinColumn(name="configuration_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"configuration_id", "name"})})
    private Set<String> definedProperties = new HashSet<String>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    private List<BaseStaticContent> staticContents = new ArrayList<BaseStaticContent>();
    @Basic
    @Column(name="use_left_space_for_guests")
    private Boolean useLeftSpaceForGuests;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    private Set<ConfigurationImage> images = new HashSet<ConfigurationImage>();
    @Basic
    @Column(name="generated_username")
    private Boolean generatedUsername;
    @Basic
    @Column(name="generated_username_length")
    private Integer generatedUsernameLength;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="username_min_length")), @AttributeOverride(name="max", column=@Column(name="username_max_length"))})
    private IntegerRange usernameLength;
    @Basic
    @Column(name="username_regex", length=500)
    private String regexForUsername;
    @Basic
    @Column(name="email_required")
    private Boolean emailRequired = Boolean.TRUE;
    @Basic
    @Column(name="email_unique")
    private Boolean emailUnique = Boolean.FALSE;
    @Basic
    @Column(name="include_in_sitemap")
    private Boolean includeInSitemap;
    @Basic
    @Column(name="allow_multiple_reports")
    private Boolean allowMultipleReports;
    @Basic
    @Column(name="name_label")
    private String nameLabel;
    @ElementCollection
    @CollectionTable(name="configurations_email_validation", joinColumns={@JoinColumn(name="configuration_id")})
    @Column(name="email_validation")
    @Enumerated(value=EnumType.STRING)
    private Set<EmailValidation> emailValidation = new HashSet<EmailValidation>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ConfigurationGuestProfileField> guestProfileFields = new HashSet<ConfigurationGuestProfileField>();
    @ManyToMany
    @JoinTable(name="configurations_ad_fields", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="field_id")})
    private Set<AdCustomField> adFieldsVisibleToGuests;
    @Basic
    @Column(name="default_city")
    private String defaultCity;
    @Basic
    @Column(name="default_region")
    private String defaultRegion;
    @Basic
    @Column(name="enable_extension")
    private Boolean landLineEnableExtension;
    @Basic
    @Column(name="landline_required")
    private Boolean landLineRequired;
    @Basic
    @Column(name="always_show_international_phone_number")
    private Boolean alwaysShowInternationalPhoneNumber;
    @Basic
    @Column(name="mobile_required")
    private Boolean mobileRequired;
    @Basic
    @Column(name="mobile_unique")
    private Boolean mobileUnique;
    @Basic
    @Column(name="required_address")
    private Boolean requiredAddress;
    @Basic
    @Column(name="profile_image_required")
    private Boolean profileImageRequired;
    @Transient
    private TempImage uploadedDefaultUserImage;
    @OneToMany(mappedBy="configuration")
    private Set<DefaultUserImage> defaultUserImages;
    @Basic
    @Column(name="application_name")
    private String applicationName;
    @Basic
    @Lob
    @Column(name="application_description")
    private String applicationDescription;
    @Basic
    @Column(name="application_username")
    private String applicationUsername;
    @Basic
    @Column(name="login_url")
    private String loginUrl;
    @Basic
    @Column(name="logout_url")
    private String logoutUrl;
    @Basic
    @Column(name="notify_logins_on_new_devices")
    private Boolean notifyLoginsOnNewDevices;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="frontend")
    private Frontend frontend;
    @Basic
    @Column(name="allow_frontend_switching")
    private Boolean allowFrontendSwitching;
    @Basic
    @Column(name="frontend_title")
    private String frontendTitle;
    @Basic
    @Column(name="frontend_mobile_title")
    private String frontendMobileTitle;
    @Basic
    @Column(name="frontend_mobile_menu_title")
    private String frontendMobileMenuTitle;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="frontend_mobile_landing_page")
    private FrontendLandingPage frontendMobileLandingPage;
    @Basic
    @Column(name="frontend_menu_bar")
    private Boolean frontendMenuBar;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="frontend_dashboard_accounts")
    private FrontendDashboardAccounts frontendDashboardAccounts;
    @Basic
    @Column(name="frontend_dashboard_users")
    private Boolean frontendDashboardUsers;
    @Basic
    @Column(name="frontend_dashboard_ads")
    private Boolean frontendDashboardAds;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="users_theme_id")
    private Theme usersTheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="guests_theme_id")
    private Theme guestsTheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="mobile_theme_id")
    private Theme mobileTheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="app_theme_id")
    private Theme appTheme;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pay_theme_id")
    private Theme payTheme;
    @Basic
    @Column(name="skip_products_view")
    private Boolean skipProductsView;
    @Basic
    @Column(name="skip_total_count")
    private Boolean skipTotalCount;
    @Basic
    @Column(name="autocomplete_results")
    private Integer autocompleteResults;
    @Basic
    @Column(name="max_results")
    private Integer maxResults;
    @Basic
    @Column(name="use_map")
    private Boolean useMap;
    @Basic
    @Column(name="map_server_api_key")
    private String mapServerApiKey;
    @Basic
    @Column(name="map_browser_api_key")
    private String mapBrowserApiKey;
    @Basic
    @Column(name="max_results_on_map")
    private Integer maxResultsOnMap;
    @Basic
    @Column(name="max_guest_temp_images")
    private Integer maxGuestTempImages;
    @Basic
    @Column(name="max_user_temp_images")
    private Integer maxUserTempImages;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="latitude", column=@Column(name="default_map_latitude")), @AttributeOverride(name="longitude", column=@Column(name="default_map_longitude"))})
    private LatLong defaultMapLocation;
    @Basic
    @Column(name="default_map_zoom_web")
    private Integer defaultMapZoomWeb;
    @Basic
    @Column(name="default_map_zoom_mobile")
    private Integer defaultMapZoomMobile;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="map_preference_mobile")
    private MapPreference mapPreferenceMobile;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="map_directory_field_id")
    private UserCustomField mapDirectoryField;
    @Basic
    @Column(name="default_email_privacy")
    @Enumerated(value=EnumType.STRING)
    private FieldVisibility defaultEmailPrivacy;
    @Basic
    @Column(name="default_address_privacy")
    @Enumerated(value=EnumType.STRING)
    private FieldVisibility defaultAddressPrivacy;
    @Basic
    @Column(name="default_phone_privacy")
    @Enumerated(value=EnumType.STRING)
    private FieldVisibility defaultPhonePrivacy;
    @Basic
    @Column(name="default_account_history_period")
    @Enumerated(value=EnumType.STRING)
    private DefaultAccountHistoryPeriod defaultAccountHistoryPeriod;
    @ElementCollection
    @Column(name="indicator")
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="configurations_account_status_indicators", joinColumns={@JoinColumn(name="configuration_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"configuration_id", "indicator"})})
    private Set<AccountStatusIndicator> accountStatusIndicators = new HashSet<AccountStatusIndicator>();
    @Basic
    @Column(name="basic_profile_field_account_title")
    @Enumerated(value=EnumType.STRING)
    private BasicProfileField basicProfileFieldInAccountTitle;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="custom_profile_field_account_title_id")
    private UserCustomField customProfileFieldsInAccountTitle;
    @ElementCollection
    @CollectionTable(name="configurations_basic_fields_account", joinColumns={@JoinColumn(name="configuration_id")})
    @Column(name="field")
    @Enumerated(value=EnumType.STRING)
    private Set<BasicProfileField> basicProfileFieldsInAccount;
    @ManyToMany
    @JoinTable(name="configurations_custom_fields_account", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="field_id")})
    private Set<UserCustomField> customProfileFieldsInAccount;
    @ElementCollection
    @CollectionTable(name="configurations_privacy_controlled_basic_fields", joinColumns={@JoinColumn(name="configuration_id")})
    @Column(name="field")
    @Enumerated(value=EnumType.STRING)
    private Set<BasicProfileField> privacyControlledBasicFields;
    @ManyToMany
    @JoinTable(name="configurations_privacy_controlled_custom_fields", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="field_id")})
    private Set<UserCustomField> privacyControlledCustomFields;
    @Basic
    @Column(name="users_menu_type")
    @Enumerated(value=EnumType.STRING)
    private MenuType usersMenuType;
    @Basic
    @Column(name="guests_menu_type")
    @Enumerated(value=EnumType.STRING)
    private MenuType guestsMenuType;
    @Basic
    @Column(name="max_left_banners")
    private Integer maxLeftBanners;
    @Basic
    @Column(name="max_right_banners")
    private Integer maxRightBanners;
    @Basic
    @Column(name="banner_rotate_seconds")
    private Integer bannerRotateSeconds;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="scriptParameters", column=@Column(name="link_generation_script_parameters"))})
    @AssociationOverrides(value={@AssociationOverride(name="script", joinColumns={@JoinColumn(name="link_generation_script_id")})})
    private CustomScriptConfiguration linkGenerationConfiguration;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="scriptParameters", column=@Column(name="phone_number_script_parameters"))})
    @AssociationOverrides(value={@AssociationOverride(name="script", joinColumns={@JoinColumn(name="phone_number_script_id")})})
    private CustomScriptConfiguration phoneNumberHandlingConfiguration;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="scriptParameters", column=@Column(name="notification_script_parameters"))})
    @AssociationOverrides(value={@AssociationOverride(name="script", joinColumns={@JoinColumn(name="notification_script_id")})})
    private CustomScriptConfiguration notificationConfiguration;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="scriptParameters", column=@Column(name="ip_geolocation_script_parameters")), @AttributeOverride(name="expiration.amount", column=@Column(name="ip_geolocation_expiration_amount")), @AttributeOverride(name="expiration.field", column=@Column(name="ip_geolocation_expiration_field"))})
    @AssociationOverrides(value={@AssociationOverride(name="script", joinColumns={@JoinColumn(name="ip_geolocation_script_id")})})
    private IpGeolocationConfiguration ipGeolocationConfiguration;
    @Embedded
    private AccountNumberConfiguration accountNumberConfiguration;
    @Embedded
    private CustomSessionConfiguration customSessionConfiguration;
    @Embedded
    private OutboundSmsConfiguration outboundSmsConfiguration;
    @Embedded
    private SmtpConfiguration smtpConfiguration;
    @Embedded
    private CaptchaConfiguration captchaConfiguration;
    @Embedded
    private AddressConfiguration addressConfiguration;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="separator", column=@Column(name="user_format_managers_separator")), @AttributeOverride(name="basicField1", column=@Column(name="user_format_managers_basic1")), @AttributeOverride(name="basicField2", column=@Column(name="user_format_managers_basic2")), @AttributeOverride(name="basicField3", column=@Column(name="user_format_managers_basic3")), @AttributeOverride(name="basicField4", column=@Column(name="user_format_managers_basic4")), @AttributeOverride(name="basicField5", column=@Column(name="user_format_managers_basic5"))})
    @AssociationOverrides(value={@AssociationOverride(name="customField1", joinColumns={@JoinColumn(name="user_format_managers_custom1")}), @AssociationOverride(name="customField2", joinColumns={@JoinColumn(name="user_format_managers_custom2")}), @AssociationOverride(name="customField3", joinColumns={@JoinColumn(name="user_format_managers_custom3")}), @AssociationOverride(name="customField4", joinColumns={@JoinColumn(name="user_format_managers_custom4")}), @AssociationOverride(name="customField5", joinColumns={@JoinColumn(name="user_format_managers_custom5")})})
    private UserFormatConfiguration userFormatForManagers;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="separator", column=@Column(name="user_format_others_separator")), @AttributeOverride(name="basicField1", column=@Column(name="user_format_others_basic1")), @AttributeOverride(name="basicField2", column=@Column(name="user_format_others_basic2")), @AttributeOverride(name="basicField3", column=@Column(name="user_format_others_basic3")), @AttributeOverride(name="basicField4", column=@Column(name="user_format_others_basic4")), @AttributeOverride(name="basicField5", column=@Column(name="user_format_others_basic5"))})
    @AssociationOverrides(value={@AssociationOverride(name="customField1", joinColumns={@JoinColumn(name="user_format_others_custom1")}), @AssociationOverride(name="customField2", joinColumns={@JoinColumn(name="user_format_others_custom2")}), @AssociationOverride(name="customField3", joinColumns={@JoinColumn(name="user_format_others_custom3")}), @AssociationOverride(name="customField4", joinColumns={@JoinColumn(name="user_format_others_custom4")}), @AssociationOverride(name="customField5", joinColumns={@JoinColumn(name="user_format_others_custom5")})})
    private UserFormatConfiguration userFormatForOthers;
    @Embedded
    private DynamicOidcClientConfiguration dynamicOidcClientConfiguration = new DynamicOidcClientConfiguration();
    @Basic
    @Column(name="email_name")
    private String emailName;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="users_result_type")
    private ResultType usersResultType;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="ads_result_type")
    private ResultType adsResultType;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="users_sort_order")
    private UserOrderBy usersSortOrder;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="ads_sort_order")
    private AdOrderBy adsSortOrder;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="ad_categories_result_type")
    private AdCategoryResultType adCategoriesResultType;
    @Basic
    @Column(name="ad_subcategories_results")
    private Integer adSubCategoriesResults;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="ad_initial_search_type")
    private AdInitialSearchType adInitialSearchType;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="size", column=@Column(name="max_upload_size")), @AttributeOverride(name="unit", column=@Column(name="max_upload_unit"))})
    private FileSize maxUploadSize;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="size", column=@Column(name="max_png_size")), @AttributeOverride(name="unit", column=@Column(name="max_png_unit"))})
    private FileSize maxPngSize;
    @Basic
    @Column(name="jpeg_quality")
    private Integer jpegQuality;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="width", column=@Column(name="max_image_width")), @AttributeOverride(name="height", column=@Column(name="max_image_height"))})
    private Dimensions maxImageDimensions;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="width", column=@Column(name="max_medium_thumb_width")), @AttributeOverride(name="height", column=@Column(name="max_medium_thumb_height"))})
    private Dimensions maxMediumThumbDimensions;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="width", column=@Column(name="max_small_thumb_width")), @AttributeOverride(name="height", column=@Column(name="max_small_thumb_height"))})
    private Dimensions maxSmallThumbDimensions;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="width", column=@Column(name="max_tiny_thumb_width")), @AttributeOverride(name="height", column=@Column(name="max_tiny_thumb_height"))})
    private Dimensions maxTinyThumbDimensions;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="language_id")
    private Language defaultLanguage;
    @ManyToMany
    @JoinTable(name="configurations_languages", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="language_id")})
    private Set<Language> allowedLanguages = new HashSet<Language>();
    @Basic
    @Column(name="country")
    private String country;
    @Basic
    @Column(name="given_very_bad_refs")
    private Integer givenVeryBadRefs;
    @Basic
    @Column(name="received_very_bad_refs")
    private Integer receivedVeryBadRefs;
    @Basic
    @Column(name="denied_invoices")
    private Integer deniedInvoices;
    @Basic
    @Column(name="invalid_username_attempts")
    private Integer invalidUsernameAttempts;
    @Basic
    @Column(name="invalid_pos_payer_attempts")
    private Integer invalidPosPayerAttempts;
    @Basic
    @Column(name="invalid_totp_attempts")
    private Integer invalidTotpAttempts;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="remote_address_block_time_amount")), @AttributeOverride(name="field", column=@Column(name="remote_address_block_time_field"))})
    private TimeInterval remoteAddressBlockTime;
    @Basic
    @Column(name="max_blocked_users")
    private Integer maxBlockedUsers;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="remote_address_block_time_by_blocked_users_amount")), @AttributeOverride(name="field", column=@Column(name="remote_address_block_time_by_blocked_users_field"))})
    private TimeInterval remoteAddressBlockTimeByBlockedUsers;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="forgot_password_mode")
    private ForgotPasswordMode forgotPasswordMode;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="forgot_password_send_medium")
    private SendMedium forgotPasswordSendMedium;
    @Basic
    @Column(name="require_security_question_on_registration")
    private Boolean requireSecurityQuestionOnRegistration;
    @ManyToMany
    @JoinTable(name="configurations_initial_groups", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<UserGroup> possibleInitialGroups = new HashSet<UserGroup>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="large_screen_reg_wizard_id")
    private RegistrationWizard largeScreenRegistrationWizard;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="medium_screen_reg_wizard_id")
    private RegistrationWizard mediumScreenRegistrationWizard;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="small_screen_reg_wizard_id")
    private RegistrationWizard smallScreenRegistrationWizard;
    @Basic
    @Column(name="community_menu_label")
    private String communityMenuLabel;
    @Basic
    @Column(name="marketplace_menu_label")
    private String marketplaceMenuLabel;
    @ManyToMany
    @JoinTable(name="configurations_groups_user_search", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groupsForUserSearch = new HashSet<BasicGroup>();
    @ManyToMany
    @JoinTable(name="configurations_groups_user_search_in_menu", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groupsForUserSearchInMenu = new HashSet<BasicGroup>();
    @ManyToMany
    @JoinTable(name="configurations_groups_view_profile", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groupsForViewProfile = new HashSet<BasicGroup>();
    @ManyToMany
    @JoinTable(name="configurations_groups_user_directory", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groupsForUserDirectory = new HashSet<BasicGroup>();
    @ManyToMany
    @JoinTable(name="configurations_visible_ad_categories", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<AdCategory> visibleAdCategories = new HashSet<AdCategory>();
    @ManyToMany
    @JoinTable(name="configurations_visible_ad_currencies", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="currency_id")})
    private Set<Currency> visibleAdCurrencies = new HashSet<Currency>();
    @ManyToMany
    @JoinTable(name="configurations_visible_ad_groups", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> visibleAdGroups = new HashSet<BasicGroup>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="user_search_in_menu_mode")
    private UserSearchInMenuMode userSearchInMenuMode = UserSearchInMenuMode.ALL_IN_USER_SEARCH;
    @Basic
    @Column(name="has_ads_view_permission")
    private Boolean allowViewUserAd;
    @Basic
    @Column(name="has_web_shop_view_permission")
    private Boolean allowViewUserWebShop;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.ALL})
    private Set<ChannelConfiguration> channelConfigurations = new HashSet<ChannelConfiguration>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="l10n_date_format")
    private DateFormat dateFormat;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="l10n_time_format")
    private TimeFormat timeFormat;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="l10n_number_format")
    private NumberFormat numberFormat;
    @Basic
    @Column(name="distance_unit")
    @Enumerated(value=EnumType.STRING)
    private DistanceUnit distanceUnit;
    @Basic
    @Column(name="l10n_time_zone_id")
    private String timeZoneId;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="l10n_list_separator")
    private ListSeparator listSeparator;
    @Basic
    @Column(name="enable_services_log")
    private Boolean enableServicesLog;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="tasks_logging_mode")
    private TaskLoggingMode tasksLoggingMode;
    @Basic
    @Column(name="max_log_entries")
    private Integer maxLogEntries;
    @Basic
    @Column(name="log_services_parameters")
    private Boolean logServicesParameters;
    @Basic
    @Column(name="log_services_writes_only")
    private Boolean logServicesWritesOnly;
    @Basic
    @Column(name="log_services_results")
    private Boolean logServicesResults;
    @Basic
    @Column(name="log_services_for_guests")
    private Boolean logServicesForGuests;
    @Basic
    @Column(name="allow_quick_payment_mobile")
    private Boolean allowQuickPaymentMobile;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="images_last_modified", nullable=false)
    private Date imagesLastModified;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="sitemap_last_modified", nullable=false)
    private Date sitemapLastModified;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="api_descriptor_last_modified", nullable=false)
    private Date apiDescriptorLastModified;
    @Basic
    @Column(name="enable_bluetooth_printer_mobile")
    private Boolean enableBluetoothPrinterMobile;
    @Basic
    @Column(name="apply_default_user_search_filters_on_payment")
    private Boolean applyDefaultUserSearchFiltersOnPayment;
    @Basic
    @Column(name="apple_store_url_mobile")
    private String appleStoreUrlMobile;
    @Basic
    @Column(name="play_store_url_mobile")
    private String playStoreUrlMobile;
    @Basic
    @Column(name="hide_ad_price_to_guests")
    private Boolean hideAdPriceToGuests;
    @Basic
    @Column(name="hide_ad_owner_to_guests")
    private Boolean hideAdOwnerToGuests;
    @Basic
    @Column(name="individual_document_directory", nullable=true)
    private String individualDocumentDirectory;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="voucher_buying_menu")
    private UserMainMenu voucherBuyingMenu;
    @ManyToMany(mappedBy="manageSpecificConfigurations")
    private Set<AdminProduct> managedSpecificConfigurationsByProducts = new HashSet<AdminProduct>();
    @ManyToMany(mappedBy="manageContentSpecificConfigurations")
    private Set<AdminProduct> managedContentSpecificConfigurationsByProducts = new HashSet<AdminProduct>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.ALL})
    private Set<Banner> banners = new HashSet<Banner>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.ALL})
    private Set<MenuEntry> menuEntries = new HashSet<MenuEntry>();
    @OneToMany(mappedBy="configuration", cascade={CascadeType.ALL})
    private Set<Theme> themes = new HashSet<Theme>();
    static final long serialVersionUID = 3870515119726520691L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_parent_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_payTheme_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_usersTheme_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_customProfileFieldsInAccountTitle_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_defaultLanguage_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_mobileTheme_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_mapDirectoryField_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_mediumScreenRegistrationWizard_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_appTheme_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_smallScreenRegistrationWizard_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_largeScreenRegistrationWizard_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_guestsTheme_vh;

    public void addStaticContent(BaseStaticContent baseStaticContent) {
        baseStaticContent.setConfiguration(this);
        this._persistence_get_staticContents().add(baseStaticContent);
    }

    public AccountNumberConfiguration getAccountNumberConfiguration() {
        return this._persistence_get_accountNumberConfiguration();
    }

    public Set<AccountStatusIndicator> getAccountStatusIndicators() {
        return this._persistence_get_accountStatusIndicators();
    }

    public AdCategoryResultType getAdCategoriesResultType() {
        return this._persistence_get_adCategoriesResultType();
    }

    public AddressConfiguration getAddressConfiguration() {
        return this._persistence_get_addressConfiguration();
    }

    public Set<AdCustomField> getAdFieldsVisibleToGuests() {
        return this._persistence_get_adFieldsVisibleToGuests();
    }

    public AdInitialSearchType getAdInitialSearchType() {
        return this._persistence_get_adInitialSearchType();
    }

    public AdminHelpContent getAdminHelpContent() {
        return (AdminHelpContent)this.getStaticContent(StaticContentNature.ADMIN_HELP);
    }

    public ResultType getAdsResultType() {
        return this._persistence_get_adsResultType();
    }

    public AdOrderBy getAdsSortOrder() {
        return this._persistence_get_adsSortOrder();
    }

    public Integer getAdSubCategoriesResults() {
        return this._persistence_get_adSubCategoriesResults();
    }

    public AllowAccessMode getAllowAccessMode() {
        return this._persistence_get_allowAccessMode();
    }

    public Set<Language> getAllowedLanguages() {
        return this._persistence_get_allowedLanguages();
    }

    public Boolean getAllowFrontendSwitching() {
        return this._persistence_get_allowFrontendSwitching();
    }

    public Boolean getAllowMultipleReports() {
        return this._persistence_get_allowMultipleReports();
    }

    public Boolean getAllowQuickPaymentMobile() {
        return this._persistence_get_allowQuickPaymentMobile();
    }

    public Boolean getAllowViewUserAd() {
        return this._persistence_get_allowViewUserAd();
    }

    public Boolean getAllowViewUserWebShop() {
        return this._persistence_get_allowViewUserWebShop();
    }

    public Boolean getAlwaysShowInternationalPhoneNumber() {
        return this._persistence_get_alwaysShowInternationalPhoneNumber();
    }

    public Date getApiDescriptorLastModified() {
        return this._persistence_get_apiDescriptorLastModified();
    }

    public String getApiUrl() {
        return this._persistence_get_apiUrl();
    }

    public String getAppleStoreUrlMobile() {
        return this._persistence_get_appleStoreUrlMobile();
    }

    public String getApplicationDescription() {
        return this._persistence_get_applicationDescription();
    }

    public String getApplicationName() {
        return this._persistence_get_applicationName();
    }

    public String getApplicationUsername() {
        return this._persistence_get_applicationUsername();
    }

    public Boolean getApplyDefaultUserSearchFiltersOnPayment() {
        return this._persistence_get_applyDefaultUserSearchFiltersOnPayment();
    }

    public Theme getAppTheme() {
        return this._persistence_get_appTheme();
    }

    public Integer getAutocompleteResults() {
        return this._persistence_get_autocompleteResults();
    }

    public Integer getBannerRotateSeconds() {
        return this._persistence_get_bannerRotateSeconds();
    }

    public CaptchaConfiguration getCaptchaConfiguration() {
        return this._persistence_get_captchaConfiguration();
    }

    public ChannelConfiguration getChannelConfiguration(Channel channel) {
        return this._persistence_get_channelConfigurations().stream().filter(channelConfiguration -> channelConfiguration.getChannel().equals(channel)).findFirst().orElse(null);
    }

    public Set<ChannelConfiguration> getChannelConfigurations() {
        return this._persistence_get_channelConfigurations();
    }

    public Set<Channel> getChannels() {
        Set<ChannelConfiguration> set = this.getChannelConfigurations();
        HashSet<Channel> hashSet = new HashSet<Channel>();
        for (ChannelConfiguration channelConfiguration : set) {
            if (!channelConfiguration.isDefined() || !channelConfiguration.isEnabled()) continue;
            hashSet.add(channelConfiguration.getChannel());
        }
        return hashSet;
    }

    public List<Configuration> getChildren() {
        return this._persistence_get_children();
    }

    public String getCommunityMenuLabel() {
        return this._persistence_get_communityMenuLabel();
    }

    public String getCountry() {
        return this._persistence_get_country();
    }

    public CustomSessionConfiguration getCustomSessionConfiguration() {
        return this._persistence_get_customSessionConfiguration();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.CONFIGURATION;
    }

    public DateFormat getDateFormat() {
        return this._persistence_get_dateFormat();
    }

    public DefaultAccountHistoryPeriod getDefaultAccountHistoryPeriod() {
        return this._persistence_get_defaultAccountHistoryPeriod();
    }

    public FieldVisibility getDefaultAddressPrivacy() {
        return this._persistence_get_defaultAddressPrivacy();
    }

    public String getDefaultCity() {
        return this._persistence_get_defaultCity();
    }

    public FieldVisibility getDefaultEmailPrivacy() {
        return this._persistence_get_defaultEmailPrivacy();
    }

    public Language getDefaultLanguage() {
        return this._persistence_get_defaultLanguage();
    }

    public LatLong getDefaultMapLocation() {
        return this._persistence_get_defaultMapLocation();
    }

    public Integer getDefaultMapZoomMobile() {
        return this._persistence_get_defaultMapZoomMobile();
    }

    public Integer getDefaultMapZoomWeb() {
        return this._persistence_get_defaultMapZoomWeb();
    }

    public FieldVisibility getDefaultPhonePrivacy() {
        return this._persistence_get_defaultPhonePrivacy();
    }

    public String getDefaultRegion() {
        return this._persistence_get_defaultRegion();
    }

    public DefaultConfigurationType getDefaultType() {
        return this._persistence_get_defaultType();
    }

    public DefaultUserImage getDefaultUserImage() {
        return (DefaultUserImage)CollectionHelper.first((Iterable)this._persistence_get_defaultUserImages());
    }

    public Set<String> getDefinedProperties() {
        return this._persistence_get_definedProperties();
    }

    public Integer getDeniedInvoices() {
        return this._persistence_get_deniedInvoices();
    }

    public DistanceUnit getDistanceUnit() {
        return this._persistence_get_distanceUnit();
    }

    public DynamicOidcClientConfiguration getDynamicOidcClientConfiguration() {
        return this._persistence_get_dynamicOidcClientConfiguration();
    }

    public String getEmailName() {
        return this._persistence_get_emailName();
    }

    public Boolean getEmailRequired() {
        return this._persistence_get_emailRequired();
    }

    public EmailTemplate getEmailTemplate() {
        return (EmailTemplate)this.getStaticContent(StaticContentNature.EMAIL_TEMPLATE);
    }

    public Boolean getEmailUnique() {
        return this._persistence_get_emailUnique();
    }

    public Set<EmailValidation> getEmailValidation() {
        return this._persistence_get_emailValidation();
    }

    public Boolean getEnableBluetoothPrinterMobile() {
        return this._persistence_get_enableBluetoothPrinterMobile();
    }

    public Boolean getEnableServicesLog() {
        return this._persistence_get_enableServicesLog();
    }

    public String getFirebasePrivateKey() {
        return this._persistence_get_firebasePrivateKey();
    }

    public FooterContent getFooterContent() {
        return (FooterContent)this.getStaticContent(StaticContentNature.FOOTER);
    }

    public ForgotPasswordMode getForgotPasswordMode() {
        return this._persistence_get_forgotPasswordMode();
    }

    public SendMedium getForgotPasswordSendMedium() {
        return this._persistence_get_forgotPasswordSendMedium();
    }

    public Frontend getFrontend() {
        return this._persistence_get_frontend();
    }

    public FrontendDashboardAccounts getFrontendDashboardAccounts() {
        return this._persistence_get_frontendDashboardAccounts();
    }

    public Boolean getFrontendDashboardAds() {
        return this._persistence_get_frontendDashboardAds();
    }

    public FrontendDashboardContent getFrontendDashboardContent() {
        return (FrontendDashboardContent)this.getStaticContent(StaticContentNature.FRONTEND_DASHBOARD);
    }

    public Boolean getFrontendDashboardUsers() {
        return this._persistence_get_frontendDashboardUsers();
    }

    public FrontendFooterContent getFrontendFooterContent() {
        return (FrontendFooterContent)this.getStaticContent(StaticContentNature.FRONTEND_FOOTER);
    }

    public FrontendHelpContent getFrontendHelpContent() {
        return (FrontendHelpContent)this.getStaticContent(StaticContentNature.FRONTEND_HELP);
    }

    public FrontendHomeContent getFrontendHomeContent() {
        return (FrontendHomeContent)this.getStaticContent(StaticContentNature.FRONTEND_HOME);
    }

    public Boolean getFrontendMenuBar() {
        return this._persistence_get_frontendMenuBar();
    }

    public FrontendLandingPage getFrontendMobileLandingPage() {
        return this._persistence_get_frontendMobileLandingPage();
    }

    public String getFrontendMobileMenuTitle() {
        return this._persistence_get_frontendMobileMenuTitle();
    }

    public String getFrontendMobileTitle() {
        return this._persistence_get_frontendMobileTitle();
    }

    public String getFrontendTitle() {
        return this._persistence_get_frontendTitle();
    }

    public Boolean getGeneratedUsername() {
        return this._persistence_get_generatedUsername();
    }

    public Integer getGeneratedUsernameLength() {
        return this._persistence_get_generatedUsernameLength();
    }

    public Integer getGivenVeryBadRefs() {
        return this._persistence_get_givenVeryBadRefs();
    }

    public Set<BasicGroup> getGroupsForUserDirectory() {
        return this._persistence_get_groupsForUserDirectory();
    }

    public Set<BasicGroup> getGroupsForUserSearch() {
        return this._persistence_get_groupsForUserSearch();
    }

    public Set<BasicGroup> getGroupsForUserSearchInMenu() {
        return this._persistence_get_groupsForUserSearchInMenu();
    }

    public Set<BasicGroup> getGroupsForViewProfile() {
        return this._persistence_get_groupsForViewProfile();
    }

    public GuestHomeContent getGuestHomeContent() {
        return (GuestHomeContent)this.getStaticContent(StaticContentNature.GUEST_HOME);
    }

    public Set<ConfigurationGuestProfileField> getGuestProfileFields() {
        return this._persistence_get_guestProfileFields();
    }

    public MenuType getGuestsMenuType() {
        return this._persistence_get_guestsMenuType();
    }

    public Theme getGuestsTheme() {
        return this._persistence_get_guestsTheme();
    }

    public HeaderContent getHeaderContent() {
        return (HeaderContent)this.getStaticContent(StaticContentNature.HEADER);
    }

    public HomeContent getHomeContent() {
        return (HomeContent)this.getStaticContent(StaticContentNature.HOME);
    }

    public Set<ConfigurationImage> getImages() {
        return this._persistence_get_images();
    }

    public Date getImagesLastModified() {
        return this._persistence_get_imagesLastModified();
    }

    public Boolean getIncludeInSitemap() {
        return this._persistence_get_includeInSitemap();
    }

    public String getIndividualDocumentDirectory() {
        return this._persistence_get_individualDocumentDirectory();
    }

    public Integer getInvalidPosPayerAttempts() {
        return this._persistence_get_invalidPosPayerAttempts();
    }

    public Integer getInvalidTotpAttempts() {
        return this._persistence_get_invalidTotpAttempts();
    }

    public Integer getInvalidUsernameAttempts() {
        return this._persistence_get_invalidUsernameAttempts();
    }

    public IpGeolocationConfiguration getIpGeolocationConfiguration() {
        return this._persistence_get_ipGeolocationConfiguration();
    }

    public Integer getJpegQuality() {
        return this._persistence_get_jpegQuality();
    }

    public Boolean getLandLineEnableExtension() {
        return this._persistence_get_landLineEnableExtension();
    }

    public Boolean getLandLineRequired() {
        return this._persistence_get_landLineRequired();
    }

    public RegistrationWizard getLargeScreenRegistrationWizard() {
        return this._persistence_get_largeScreenRegistrationWizard();
    }

    public int getLevel() {
        if (this._persistence_get_parent() == null) {
            return 1;
        }
        return 1 + this._persistence_get_parent().getLevel();
    }

    public CustomScriptConfiguration getLinkGenerationConfiguration() {
        return this._persistence_get_linkGenerationConfiguration();
    }

    public ListSeparator getListSeparator() {
        return this._persistence_get_listSeparator();
    }

    public Set<String> getLockedProperties() {
        return this._persistence_get_lockedProperties();
    }

    public LoggedUserHomeContent getLoggedUserHomeContent() {
        return (LoggedUserHomeContent)this.getStaticContent(StaticContentNature.LOGGED_USER_HOME);
    }

    public LoginFooterContent getLoginFooterContent() {
        return (LoginFooterContent)this.getStaticContent(StaticContentNature.LOGIN_FOOTER);
    }

    public LoginHeaderContent getLoginHeaderContent() {
        return (LoginHeaderContent)this.getStaticContent(StaticContentNature.LOGIN_HEADER);
    }

    public String getLoginUrl() {
        return this._persistence_get_loginUrl();
    }

    public String getLogoutUrl() {
        return this._persistence_get_logoutUrl();
    }

    public Boolean getLogServicesForGuests() {
        return this._persistence_get_logServicesForGuests();
    }

    public Boolean getLogServicesParameters() {
        return this._persistence_get_logServicesParameters();
    }

    public Boolean getLogServicesResults() {
        return this._persistence_get_logServicesResults();
    }

    public Boolean getLogServicesWritesOnly() {
        return this._persistence_get_logServicesWritesOnly();
    }

    public String getMapBrowserApiKey() {
        return this._persistence_get_mapBrowserApiKey();
    }

    public UserCustomField getMapDirectoryField() {
        return this._persistence_get_mapDirectoryField();
    }

    public MapPreference getMapPreferenceMobile() {
        return this._persistence_get_mapPreferenceMobile();
    }

    public String getMapServerApiKey() {
        return this._persistence_get_mapServerApiKey();
    }

    public String getMarketplaceMenuLabel() {
        return this._persistence_get_marketplaceMenuLabel();
    }

    public Integer getMaxBlockedUsers() {
        return this._persistence_get_maxBlockedUsers();
    }

    public Integer getMaxGuestTempImages() {
        return this._persistence_get_maxGuestTempImages();
    }

    public Dimensions getMaxImageDimensions() {
        return this._persistence_get_maxImageDimensions();
    }

    public Integer getMaxLeftBanners() {
        return this._persistence_get_maxLeftBanners();
    }

    public Integer getMaxLogEntries() {
        return this._persistence_get_maxLogEntries();
    }

    public Dimensions getMaxMediumThumbDimensions() {
        return this._persistence_get_maxMediumThumbDimensions();
    }

    public FileSize getMaxPngSize() {
        return this._persistence_get_maxPngSize();
    }

    public Integer getMaxResults() {
        return this._persistence_get_maxResults();
    }

    public Integer getMaxResultsOnMap() {
        return this._persistence_get_maxResultsOnMap();
    }

    public Integer getMaxRightBanners() {
        return this._persistence_get_maxRightBanners();
    }

    public Dimensions getMaxSmallThumbDimensions() {
        return this._persistence_get_maxSmallThumbDimensions();
    }

    public Dimensions getMaxTinyThumbDimensions() {
        return this._persistence_get_maxTinyThumbDimensions();
    }

    public FileSize getMaxUploadSize() {
        return this._persistence_get_maxUploadSize();
    }

    public Integer getMaxUserTempImages() {
        return this._persistence_get_maxUserTempImages();
    }

    public RegistrationWizard getMediumScreenRegistrationWizard() {
        return this._persistence_get_mediumScreenRegistrationWizard();
    }

    public MobileHelpContent getMobileHelpContent() {
        return (MobileHelpContent)this.getStaticContent(StaticContentNature.MOBILE_HELP);
    }

    public MobilePosHelpContent getMobilePosHelpContent() {
        return (MobilePosHelpContent)this.getStaticContent(StaticContentNature.MOBILE_POS_HELP);
    }

    public Boolean getMobileRequired() {
        return this._persistence_get_mobileRequired();
    }

    public Theme getMobileTheme() {
        return this._persistence_get_mobileTheme();
    }

    public Boolean getMobileUnique() {
        return this._persistence_get_mobileUnique();
    }

    public String getNameLabel() {
        return this._persistence_get_nameLabel();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public CustomScriptConfiguration getNotificationConfiguration() {
        return this._persistence_get_notificationConfiguration();
    }

    public Boolean getNotifyLoginsOnNewDevices() {
        return this._persistence_get_notifyLoginsOnNewDevices();
    }

    public NumberFormat getNumberFormat() {
        return this._persistence_get_numberFormat();
    }

    public OutboundSmsConfiguration getOutboundSmsConfiguration() {
        return this._persistence_get_outboundSmsConfiguration();
    }

    public Configuration getParent() {
        return this._persistence_get_parent();
    }

    public String getPath() {
        return this._persistence_get_path();
    }

    public PayFooterContent getPayFooterContent() {
        return (PayFooterContent)this.getStaticContent(StaticContentNature.PAY_FOOTER);
    }

    public PayHeaderContent getPayHeaderContent() {
        return (PayHeaderContent)this.getStaticContent(StaticContentNature.PAY_HEADER);
    }

    public Theme getPayTheme() {
        return this._persistence_get_payTheme();
    }

    public CustomScriptConfiguration getPhoneNumberHandlingConfiguration() {
        return this._persistence_get_phoneNumberHandlingConfiguration();
    }

    public String getPlayStoreUrlMobile() {
        return this._persistence_get_playStoreUrlMobile();
    }

    public Set<UserGroup> getPossibleInitialGroups() {
        return this._persistence_get_possibleInitialGroups();
    }

    public Set<ProfileField> getPrivacyControlledProfileFields() {
        HashSet<ProfileField> hashSet = new HashSet<ProfileField>();
        if (this._persistence_get_privacyControlledBasicFields() != null) {
            hashSet.addAll(this._persistence_get_privacyControlledBasicFields());
        }
        if (this._persistence_get_privacyControlledCustomFields() != null) {
            hashSet.addAll(this._persistence_get_privacyControlledCustomFields());
        }
        return hashSet;
    }

    public ProfileField getProfileFieldInAccountTitle() {
        return (ProfileField)ObjectHelper.defaultValue((Object)this._persistence_get_basicProfileFieldInAccountTitle(), (Object)this._persistence_get_customProfileFieldsInAccountTitle());
    }

    public Set<ProfileField> getProfileFieldsInAccount() {
        HashSet<ProfileField> hashSet = new HashSet<ProfileField>();
        if (this._persistence_get_basicProfileFieldsInAccount() != null) {
            hashSet.addAll(this._persistence_get_basicProfileFieldsInAccount());
        }
        if (this._persistence_get_customProfileFieldsInAccount() != null) {
            hashSet.addAll(this._persistence_get_customProfileFieldsInAccount());
        }
        return hashSet;
    }

    public Integer getReceivedVeryBadRefs() {
        return this._persistence_get_receivedVeryBadRefs();
    }

    public String getRegexForUsername() {
        return this._persistence_get_regexForUsername();
    }

    public TimeInterval getRemoteAddressBlockTime() {
        return this._persistence_get_remoteAddressBlockTime();
    }

    public TimeInterval getRemoteAddressBlockTimeByBlockedUsers() {
        return this._persistence_get_remoteAddressBlockTimeByBlockedUsers();
    }

    public Boolean getRequiredAddress() {
        return this._persistence_get_requiredAddress();
    }

    public Boolean getRequireSecurityQuestionOnRegistration() {
        return this._persistence_get_requireSecurityQuestionOnRegistration();
    }

    public String getRootUrl() {
        return this._persistence_get_rootUrl();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.CONFIGURATION;
    }

    public Date getSitemapLastModified() {
        return this._persistence_get_sitemapLastModified();
    }

    public Boolean getSkipProductsView() {
        return this._persistence_get_skipProductsView();
    }

    public Boolean getSkipTotalCount() {
        return this._persistence_get_skipTotalCount();
    }

    public RegistrationWizard getSmallScreenRegistrationWizard() {
        return this._persistence_get_smallScreenRegistrationWizard();
    }

    public SmtpConfiguration getSmtpConfiguration() {
        return this._persistence_get_smtpConfiguration();
    }

    public <T extends BaseStaticContent> T getStaticContent(StaticContentNature staticContentNature) {
        return (T)(this._persistence_get_staticContents() == null ? null : (BaseStaticContent)this._persistence_get_staticContents().stream().filter(baseStaticContent -> baseStaticContent.getNature() == staticContentNature).findFirst().orElse(null));
    }

    public TaskLoggingMode getTasksLoggingMode() {
        return this._persistence_get_tasksLoggingMode();
    }

    public TimeFormat getTimeFormat() {
        return this._persistence_get_timeFormat();
    }

    public TimeZone getTimeZone() {
        return this._persistence_get_timeZoneId() == null ? null : TimeZone.getTimeZone(this._persistence_get_timeZoneId());
    }

    public String getTimeZoneId() {
        return this._persistence_get_timeZoneId();
    }

    public TempImage getUploadedDefaultUserImage() {
        return this.uploadedDefaultUserImage;
    }

    public Boolean getUseLeftSpaceForGuests() {
        return this._persistence_get_useLeftSpaceForGuests();
    }

    public Boolean getUseMap() {
        return this._persistence_get_useMap();
    }

    public UserFormatConfiguration getUserFormatForManagers() {
        return this._persistence_get_userFormatForManagers();
    }

    public UserFormatConfiguration getUserFormatForOthers() {
        return this._persistence_get_userFormatForOthers();
    }

    public UserHelpContent getUserHelpContent() {
        return (UserHelpContent)this.getStaticContent(StaticContentNature.USER_HELP);
    }

    public IntegerRange getUsernameLength() {
        return this._persistence_get_usernameLength();
    }

    public UserSearchInMenuMode getUserSearchInMenuMode() {
        return this._persistence_get_userSearchInMenuMode();
    }

    public MenuType getUsersMenuType() {
        return this._persistence_get_usersMenuType();
    }

    public ResultType getUsersResultType() {
        return this._persistence_get_usersResultType();
    }

    public UserOrderBy getUsersSortOrder() {
        return this._persistence_get_usersSortOrder();
    }

    public Theme getUsersTheme() {
        return this._persistence_get_usersTheme();
    }

    public Set<AdCategory> getVisibleAdCategories() {
        return this._persistence_get_visibleAdCategories();
    }

    public Set<Currency> getVisibleAdCurrencies() {
        return this._persistence_get_visibleAdCurrencies();
    }

    public Set<BasicGroup> getVisibleAdGroups() {
        return this._persistence_get_visibleAdGroups();
    }

    public UserMainMenu getVoucherBuyingMenu() {
        return this._persistence_get_voucherBuyingMenu();
    }

    public WelcomeContent getWelcomeContent() {
        return (WelcomeContent)this.getStaticContent(StaticContentNature.WELCOME);
    }

    public boolean isDefaultConfig() {
        return this.getDefaultType() != null;
    }

    public boolean isDefineRootUrl() {
        return this._persistence_get_defineRootUrl();
    }

    public boolean isFirebasePrivateKeySet() {
        return StringHelper.isNotBlank((Object)this._persistence_get_firebasePrivateKey());
    }

    public boolean isForGuests() {
        return this._persistence_get_defaultType() != null || this._persistence_get_defineRootUrl() || StringHelper.isNotBlank((Object)this._persistence_get_path());
    }

    public boolean isHideAdOwnerToGuests() {
        return Boolean.TRUE.equals(this._persistence_get_hideAdOwnerToGuests());
    }

    public boolean isHideAdPriceToGuests() {
        return Boolean.TRUE.equals(this._persistence_get_hideAdPriceToGuests());
    }

    public boolean isMapServerApiKeySet() {
        return StringHelper.isNotBlank((Object)this._persistence_get_mapServerApiKey());
    }

    public boolean isProfileImageRequired() {
        return Boolean.TRUE.equals(this._persistence_get_profileImageRequired());
    }

    public void setAccountNumberConfiguration(AccountNumberConfiguration accountNumberConfiguration) {
        this._persistence_set_accountNumberConfiguration(accountNumberConfiguration);
    }

    public void setAccountStatusIndicators(Set<AccountStatusIndicator> set) {
        this._persistence_set_accountStatusIndicators(set);
    }

    public void setAdCategoriesResultType(AdCategoryResultType adCategoryResultType) {
        this._persistence_set_adCategoriesResultType(adCategoryResultType);
    }

    public void setAddressConfiguration(AddressConfiguration addressConfiguration) {
        this._persistence_set_addressConfiguration((AddressConfiguration)ObjectHelper.defaultValue((Object)addressConfiguration, (Object)new AddressConfiguration()));
    }

    public void setAdFieldsVisibleToGuests(Set<AdCustomField> set) {
        this._persistence_set_adFieldsVisibleToGuests(set);
    }

    public void setAdInitialSearchType(AdInitialSearchType adInitialSearchType) {
        this._persistence_set_adInitialSearchType(adInitialSearchType);
    }

    public void setAdsResultType(ResultType resultType) {
        this._persistence_set_adsResultType(resultType);
    }

    public void setAdsSortOrder(AdOrderBy adOrderBy) {
        this._persistence_set_adsSortOrder(adOrderBy);
    }

    public void setAdSubCategoriesResults(Integer n) {
        this._persistence_set_adSubCategoriesResults(n);
    }

    public void setAllowAccessMode(AllowAccessMode allowAccessMode) {
        this._persistence_set_allowAccessMode(allowAccessMode);
    }

    public void setAllowedLanguages(Set<Language> set) {
        this._persistence_set_allowedLanguages(set);
    }

    public void setAllowFrontendSwitching(Boolean bl) {
        this._persistence_set_allowFrontendSwitching(bl);
    }

    public void setAllowMultipleReports(Boolean bl) {
        this._persistence_set_allowMultipleReports(bl);
    }

    public void setAllowQuickPaymentMobile(Boolean bl) {
        this._persistence_set_allowQuickPaymentMobile(bl);
    }

    public void setAllowViewUserAd(Boolean bl) {
        this._persistence_set_allowViewUserAd(bl);
    }

    public void setAllowViewUserWebShop(Boolean bl) {
        this._persistence_set_allowViewUserWebShop(bl);
    }

    public void setAlwaysShowInternationalPhoneNumber(Boolean bl) {
        this._persistence_set_alwaysShowInternationalPhoneNumber(bl);
    }

    public void setApiDescriptorLastModified(Date date) {
        this._persistence_set_apiDescriptorLastModified(date);
    }

    public void setApiUrl(String string) {
        this._persistence_set_apiUrl(string);
    }

    public void setAppleStoreUrlMobile(String string) {
        this._persistence_set_appleStoreUrlMobile(string);
    }

    public void setApplicationDescription(String string) {
        this._persistence_set_applicationDescription(string);
    }

    public void setApplicationName(String string) {
        this._persistence_set_applicationName(string);
    }

    public void setApplicationUsername(String string) {
        this._persistence_set_applicationUsername(string);
    }

    public void setApplyDefaultUserSearchFiltersOnPayment(Boolean bl) {
        this._persistence_set_applyDefaultUserSearchFiltersOnPayment(bl);
    }

    public void setAppTheme(Theme theme) {
        this._persistence_set_appTheme(theme);
    }

    public void setAutocompleteResults(Integer n) {
        this._persistence_set_autocompleteResults(n);
    }

    public void setBannerRotateSeconds(Integer n) {
        this._persistence_set_bannerRotateSeconds(n);
    }

    public void setCaptchaConfiguration(CaptchaConfiguration captchaConfiguration) {
        this._persistence_set_captchaConfiguration(captchaConfiguration);
    }

    public void setChildren(List<Configuration> list) {
        this._persistence_set_children(list);
    }

    public void setCommunityMenuLabel(String string) {
        this._persistence_set_communityMenuLabel(string);
    }

    public void setCountry(String string) {
        this._persistence_set_country(string);
    }

    public void setCustomSessionConfiguration(CustomSessionConfiguration customSessionConfiguration) {
        this._persistence_set_customSessionConfiguration(customSessionConfiguration);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this._persistence_set_dateFormat(dateFormat);
    }

    public void setDefaultAccountHistoryPeriod(DefaultAccountHistoryPeriod defaultAccountHistoryPeriod) {
        this._persistence_set_defaultAccountHistoryPeriod(defaultAccountHistoryPeriod);
    }

    public void setDefaultAddressPrivacy(FieldVisibility fieldVisibility) {
        this._persistence_set_defaultAddressPrivacy(fieldVisibility);
    }

    public void setDefaultCity(String string) {
        this._persistence_set_defaultCity(string);
    }

    public void setDefaultEmailPrivacy(FieldVisibility fieldVisibility) {
        this._persistence_set_defaultEmailPrivacy(fieldVisibility);
    }

    public void setDefaultLanguage(Language language) {
        this._persistence_set_defaultLanguage(language);
    }

    public void setDefaultMapLocation(LatLong latLong) {
        this._persistence_set_defaultMapLocation(latLong);
    }

    public void setDefaultMapZoomMobile(Integer n) {
        this._persistence_set_defaultMapZoomMobile(n);
    }

    public void setDefaultMapZoomWeb(Integer n) {
        this._persistence_set_defaultMapZoomWeb(n);
    }

    public void setDefaultPhonePrivacy(FieldVisibility fieldVisibility) {
        this._persistence_set_defaultPhonePrivacy(fieldVisibility);
    }

    public void setDefaultRegion(String string) {
        this._persistence_set_defaultRegion(string);
    }

    public void setDefaultType(DefaultConfigurationType defaultConfigurationType) {
        this._persistence_set_defaultType(defaultConfigurationType);
    }

    public void setDefaultUserImage(DefaultUserImage defaultUserImage) {
        this._persistence_set_defaultUserImages(CollectionHelper.asSet((Object[])new DefaultUserImage[]{defaultUserImage}));
    }

    public void setDefinedProperties(Set<String> set) {
        this._persistence_set_definedProperties(set);
    }

    public void setDefineRootUrl(boolean bl) {
        this._persistence_set_defineRootUrl(bl);
    }

    public void setDeniedInvoices(Integer n) {
        this._persistence_set_deniedInvoices(n);
    }

    public void setDistanceUnit(DistanceUnit distanceUnit) {
        this._persistence_set_distanceUnit(distanceUnit);
    }

    public void setDynamicOidcClientConfiguration(DynamicOidcClientConfiguration dynamicOidcClientConfiguration) {
        this._persistence_set_dynamicOidcClientConfiguration(dynamicOidcClientConfiguration);
    }

    public void setEmailName(String string) {
        this._persistence_set_emailName(string);
    }

    public void setEmailRequired(Boolean bl) {
        this._persistence_set_emailRequired(bl);
    }

    public void setEmailUnique(Boolean bl) {
        this._persistence_set_emailUnique(bl);
    }

    public void setEmailValidation(Set<EmailValidation> set) {
        this._persistence_set_emailValidation(set);
    }

    public void setEnableBluetoothPrinterMobile(Boolean bl) {
        this._persistence_set_enableBluetoothPrinterMobile(bl);
    }

    public void setEnableServicesLog(Boolean bl) {
        this._persistence_set_enableServicesLog(bl);
    }

    public void setFirebasePrivateKey(String string) {
        this._persistence_set_firebasePrivateKey(string);
    }

    public void setForgotPasswordMode(ForgotPasswordMode forgotPasswordMode) {
        this._persistence_set_forgotPasswordMode(forgotPasswordMode);
    }

    public void setForgotPasswordSendMedium(SendMedium sendMedium) {
        this._persistence_set_forgotPasswordSendMedium(sendMedium);
    }

    public void setFrontend(Frontend frontend) {
        this._persistence_set_frontend(frontend);
    }

    public void setFrontendDashboardAccounts(FrontendDashboardAccounts frontendDashboardAccounts) {
        this._persistence_set_frontendDashboardAccounts(frontendDashboardAccounts);
    }

    public void setFrontendDashboardAds(Boolean bl) {
        this._persistence_set_frontendDashboardAds(bl);
    }

    public void setFrontendDashboardUsers(Boolean bl) {
        this._persistence_set_frontendDashboardUsers(bl);
    }

    public void setFrontendMenuBar(Boolean bl) {
        this._persistence_set_frontendMenuBar(bl);
    }

    public void setFrontendMobileLandingPage(FrontendLandingPage frontendLandingPage) {
        this._persistence_set_frontendMobileLandingPage(frontendLandingPage);
    }

    public void setFrontendMobileMenuTitle(String string) {
        this._persistence_set_frontendMobileMenuTitle(string);
    }

    public void setFrontendMobileTitle(String string) {
        this._persistence_set_frontendMobileTitle(string);
    }

    public void setFrontendTitle(String string) {
        this._persistence_set_frontendTitle(string);
    }

    public void setGeneratedUsername(Boolean bl) {
        this._persistence_set_generatedUsername(bl);
    }

    public void setGeneratedUsernameLength(Integer n) {
        this._persistence_set_generatedUsernameLength(n);
    }

    public void setGivenVeryBadRefs(Integer n) {
        this._persistence_set_givenVeryBadRefs(n);
    }

    public void setGroupsForUserDirectory(Set<BasicGroup> set) {
        this._persistence_set_groupsForUserDirectory(set);
    }

    public void setGroupsForUserSearch(Set<BasicGroup> set) {
        this._persistence_set_groupsForUserSearch(set);
    }

    public void setGroupsForUserSearchInMenu(Set<BasicGroup> set) {
        this._persistence_set_groupsForUserSearchInMenu(set);
    }

    public void setGroupsForViewProfile(Set<BasicGroup> set) {
        this._persistence_set_groupsForViewProfile(set);
    }

    public void setGuestProfileFields(Set<ConfigurationGuestProfileField> set) {
        this._persistence_set_guestProfileFields(set);
    }

    public void setGuestsMenuType(MenuType menuType) {
        this._persistence_set_guestsMenuType(menuType);
    }

    public void setGuestsTheme(Theme theme) {
        this._persistence_set_guestsTheme(theme);
    }

    public void setHideAdOwnerToGuests(Boolean bl) {
        this._persistence_set_hideAdOwnerToGuests(bl);
    }

    public void setHideAdPriceToGuests(Boolean bl) {
        this._persistence_set_hideAdPriceToGuests(bl);
    }

    public void setImages(Set<ConfigurationImage> set) {
        this._persistence_set_images(set);
    }

    public void setImagesLastModified(Date date) {
        this._persistence_set_imagesLastModified(date);
    }

    public void setIncludeInSitemap(Boolean bl) {
        this._persistence_set_includeInSitemap(bl);
    }

    public void setIndividualDocumentDirectory(String string) {
        this._persistence_set_individualDocumentDirectory(string);
    }

    public void setInvalidPosPayerAttempts(Integer n) {
        this._persistence_set_invalidPosPayerAttempts(n);
    }

    public void setInvalidTotpAttempts(Integer n) {
        this._persistence_set_invalidTotpAttempts(n);
    }

    public void setInvalidUsernameAttempts(Integer n) {
        this._persistence_set_invalidUsernameAttempts(n);
    }

    public void setIpGeolocationConfiguration(IpGeolocationConfiguration ipGeolocationConfiguration) {
        this._persistence_set_ipGeolocationConfiguration(ipGeolocationConfiguration);
    }

    public void setJpegQuality(Integer n) {
        this._persistence_set_jpegQuality(n);
    }

    public void setLandLineEnableExtension(Boolean bl) {
        this._persistence_set_landLineEnableExtension(bl);
    }

    public void setLandLineRequired(Boolean bl) {
        this._persistence_set_landLineRequired(bl);
    }

    public void setLargeScreenRegistrationWizard(RegistrationWizard registrationWizard) {
        this._persistence_set_largeScreenRegistrationWizard(registrationWizard);
    }

    public void setLinkGenerationConfiguration(CustomScriptConfiguration customScriptConfiguration) {
        this._persistence_set_linkGenerationConfiguration(customScriptConfiguration);
    }

    public void setListSeparator(ListSeparator listSeparator) {
        this._persistence_set_listSeparator(listSeparator);
    }

    public void setLockedProperties(Set<String> set) {
        this._persistence_set_lockedProperties(set);
    }

    public void setLoginUrl(String string) {
        this._persistence_set_loginUrl(string);
    }

    public void setLogoutUrl(String string) {
        this._persistence_set_logoutUrl(string);
    }

    public void setLogServicesForGuests(Boolean bl) {
        this._persistence_set_logServicesForGuests(bl);
    }

    public void setLogServicesParameters(Boolean bl) {
        this._persistence_set_logServicesParameters(bl);
    }

    public void setLogServicesResults(Boolean bl) {
        this._persistence_set_logServicesResults(bl);
    }

    public void setLogServicesWritesOnly(Boolean bl) {
        this._persistence_set_logServicesWritesOnly(bl);
    }

    public void setMapBrowserApiKey(String string) {
        this._persistence_set_mapBrowserApiKey(string);
    }

    public void setMapDirectoryField(UserCustomField userCustomField) {
        this._persistence_set_mapDirectoryField(userCustomField);
    }

    public void setMapPreferenceMobile(MapPreference mapPreference) {
        this._persistence_set_mapPreferenceMobile(mapPreference);
    }

    public void setMapServerApiKey(String string) {
        this._persistence_set_mapServerApiKey(string);
    }

    public void setMarketplaceMenuLabel(String string) {
        this._persistence_set_marketplaceMenuLabel(string);
    }

    public void setMaxBlockedUsers(Integer n) {
        this._persistence_set_maxBlockedUsers(n);
    }

    public void setMaxGuestTempImages(Integer n) {
        this._persistence_set_maxGuestTempImages(n);
    }

    public void setMaxImageDimensions(Dimensions dimensions) {
        this._persistence_set_maxImageDimensions(dimensions);
    }

    public void setMaxLeftBanners(Integer n) {
        this._persistence_set_maxLeftBanners(n);
    }

    public void setMaxLogEntries(Integer n) {
        this._persistence_set_maxLogEntries(n);
    }

    public void setMaxMediumThumbDimensions(Dimensions dimensions) {
        this._persistence_set_maxMediumThumbDimensions(dimensions);
    }

    public void setMaxPngSize(FileSize fileSize) {
        this._persistence_set_maxPngSize(fileSize);
    }

    public void setMaxResults(Integer n) {
        this._persistence_set_maxResults(n);
    }

    public void setMaxResultsOnMap(Integer n) {
        this._persistence_set_maxResultsOnMap(n);
    }

    public void setMaxRightBanners(Integer n) {
        this._persistence_set_maxRightBanners(n);
    }

    public void setMaxSmallThumbDimensions(Dimensions dimensions) {
        this._persistence_set_maxSmallThumbDimensions(dimensions);
    }

    public void setMaxTinyThumbDimensions(Dimensions dimensions) {
        this._persistence_set_maxTinyThumbDimensions(dimensions);
    }

    public void setMaxUploadSize(FileSize fileSize) {
        this._persistence_set_maxUploadSize(fileSize);
    }

    public void setMaxUserTempImages(Integer n) {
        this._persistence_set_maxUserTempImages(n);
    }

    public void setMediumScreenRegistrationWizard(RegistrationWizard registrationWizard) {
        this._persistence_set_mediumScreenRegistrationWizard(registrationWizard);
    }

    public void setMobileRequired(Boolean bl) {
        this._persistence_set_mobileRequired(bl);
    }

    public void setMobileTheme(Theme theme) {
        this._persistence_set_mobileTheme(theme);
    }

    public void setMobileUnique(Boolean bl) {
        this._persistence_set_mobileUnique(bl);
    }

    public void setNameLabel(String string) {
        this._persistence_set_nameLabel(string);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setNotificationConfiguration(CustomScriptConfiguration customScriptConfiguration) {
        this._persistence_set_notificationConfiguration(customScriptConfiguration);
    }

    public void setNotifyLoginsOnNewDevices(Boolean bl) {
        this._persistence_set_notifyLoginsOnNewDevices(bl);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this._persistence_set_numberFormat(numberFormat);
    }

    public void setOutboundSmsConfiguration(OutboundSmsConfiguration outboundSmsConfiguration) {
        this._persistence_set_outboundSmsConfiguration(outboundSmsConfiguration);
    }

    public void setParent(Configuration configuration) {
        this._persistence_set_parent(configuration);
    }

    public void setPath(String string) {
        this._persistence_set_path(string);
    }

    public void setPayTheme(Theme theme) {
        this._persistence_set_payTheme(theme);
    }

    public void setPhoneNumberHandlingConfiguration(CustomScriptConfiguration customScriptConfiguration) {
        this._persistence_set_phoneNumberHandlingConfiguration(customScriptConfiguration);
    }

    public void setPlayStoreUrlMobile(String string) {
        this._persistence_set_playStoreUrlMobile(string);
    }

    public void setPossibleInitialGroups(Set<UserGroup> set) {
        this._persistence_set_possibleInitialGroups(set);
    }

    public void setPrivacyControlledProfileFields(Set<ProfileField> set) {
        this._persistence_set_privacyControlledBasicFields(new HashSet());
        this._persistence_set_privacyControlledCustomFields(new HashSet());
        if (set != null) {
            for (ProfileField profileField : set) {
                if (profileField instanceof BasicProfileField) {
                    this._persistence_get_privacyControlledBasicFields().add((BasicProfileField)profileField);
                    continue;
                }
                if (!(profileField instanceof UserCustomField)) continue;
                this._persistence_get_privacyControlledCustomFields().add((UserCustomField)profileField);
            }
        }
    }

    public void setProfileFieldInAccountTitle(ProfileField profileField) {
        this._persistence_set_basicProfileFieldInAccountTitle((BasicProfileField)ObjectHelper.ifType((Object)profileField, BasicProfileField.class));
        this._persistence_set_customProfileFieldsInAccountTitle((UserCustomField)ObjectHelper.ifType((Object)profileField, UserCustomField.class));
    }

    public void setProfileFieldsInAccount(Set<ProfileField> set) {
        this._persistence_set_basicProfileFieldsInAccount(new HashSet());
        this._persistence_set_customProfileFieldsInAccount(new HashSet());
        if (set != null) {
            for (ProfileField profileField : set) {
                if (profileField instanceof BasicProfileField) {
                    this._persistence_get_basicProfileFieldsInAccount().add((BasicProfileField)profileField);
                    continue;
                }
                if (!(profileField instanceof UserCustomField)) continue;
                this._persistence_get_customProfileFieldsInAccount().add((UserCustomField)profileField);
            }
        }
    }

    public void setProfileImageRequired(boolean bl) {
        this._persistence_set_profileImageRequired(bl);
    }

    public void setReceivedVeryBadRefs(Integer n) {
        this._persistence_set_receivedVeryBadRefs(n);
    }

    public void setRegexForUsername(String string) {
        this._persistence_set_regexForUsername(string);
    }

    public void setRemoteAddressBlockTime(TimeInterval timeInterval) {
        this._persistence_set_remoteAddressBlockTime(timeInterval);
    }

    public void setRemoteAddressBlockTimeByBlockedUsers(TimeInterval timeInterval) {
        this._persistence_set_remoteAddressBlockTimeByBlockedUsers(timeInterval);
    }

    public void setRequiredAddress(Boolean bl) {
        this._persistence_set_requiredAddress(bl);
    }

    public void setRequireSecurityQuestionOnRegistration(Boolean bl) {
        this._persistence_set_requireSecurityQuestionOnRegistration(bl);
    }

    public void setRootUrl(String string) {
        this._persistence_set_rootUrl(string);
    }

    public void setSitemapLastModified(Date date) {
        this._persistence_set_sitemapLastModified(date);
    }

    public void setSkipProductsView(Boolean bl) {
        this._persistence_set_skipProductsView(bl);
    }

    public void setSkipTotalCount(Boolean bl) {
        this._persistence_set_skipTotalCount(bl);
    }

    public void setSmallScreenRegistrationWizard(RegistrationWizard registrationWizard) {
        this._persistence_set_smallScreenRegistrationWizard(registrationWizard);
    }

    public void setSmtpConfiguration(SmtpConfiguration smtpConfiguration) {
        this._persistence_set_smtpConfiguration(smtpConfiguration);
    }

    public void setTasksLoggingMode(TaskLoggingMode taskLoggingMode) {
        this._persistence_set_tasksLoggingMode(taskLoggingMode);
    }

    public void setTimeFormat(TimeFormat timeFormat) {
        this._persistence_set_timeFormat(timeFormat);
    }

    public void setTimeZoneId(String string) {
        this._persistence_set_timeZoneId(string);
    }

    public void setUploadedDefaultUserImage(TempImage tempImage) {
        this.uploadedDefaultUserImage = tempImage;
    }

    public void setUseLeftSpaceForGuests(Boolean bl) {
        this._persistence_set_useLeftSpaceForGuests(bl);
    }

    public void setUseMap(Boolean bl) {
        this._persistence_set_useMap(bl);
    }

    public void setUserFormatForManagers(UserFormatConfiguration userFormatConfiguration) {
        this._persistence_set_userFormatForManagers(userFormatConfiguration);
    }

    public void setUserFormatForOthers(UserFormatConfiguration userFormatConfiguration) {
        this._persistence_set_userFormatForOthers(userFormatConfiguration);
    }

    public void setUsernameLength(IntegerRange integerRange) {
        this._persistence_set_usernameLength(integerRange);
    }

    public void setUserSearchInMenuMode(UserSearchInMenuMode userSearchInMenuMode) {
        this._persistence_set_userSearchInMenuMode(userSearchInMenuMode);
    }

    public void setUsersMenuType(MenuType menuType) {
        this._persistence_set_usersMenuType(menuType);
    }

    public void setUsersResultType(ResultType resultType) {
        this._persistence_set_usersResultType(resultType);
    }

    public void setUsersSortOrder(UserOrderBy userOrderBy) {
        this._persistence_set_usersSortOrder(userOrderBy);
    }

    public void setUsersTheme(Theme theme) {
        this._persistence_set_usersTheme(theme);
    }

    public void setVisibleAdCategories(Set<AdCategory> set) {
        this._persistence_set_visibleAdCategories(set);
    }

    public void setVisibleAdCurrencies(Set<Currency> set) {
        this._persistence_set_visibleAdCurrencies(set);
    }

    public void setVisibleAdGroups(Set<BasicGroup> set) {
        this._persistence_set_visibleAdGroups(set);
    }

    public void setVoucherBuyingMenu(UserMainMenu userMainMenu) {
        this._persistence_set_voucherBuyingMenu(userMainMenu);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_parent_vh != null) {
            this._persistence_parent_vh = (WeavedAttributeValueHolderInterface)this._persistence_parent_vh.clone();
        }
        if (this._persistence_payTheme_vh != null) {
            this._persistence_payTheme_vh = (WeavedAttributeValueHolderInterface)this._persistence_payTheme_vh.clone();
        }
        if (this._persistence_usersTheme_vh != null) {
            this._persistence_usersTheme_vh = (WeavedAttributeValueHolderInterface)this._persistence_usersTheme_vh.clone();
        }
        if (this._persistence_customProfileFieldsInAccountTitle_vh != null) {
            this._persistence_customProfileFieldsInAccountTitle_vh = (WeavedAttributeValueHolderInterface)this._persistence_customProfileFieldsInAccountTitle_vh.clone();
        }
        if (this._persistence_defaultLanguage_vh != null) {
            this._persistence_defaultLanguage_vh = (WeavedAttributeValueHolderInterface)this._persistence_defaultLanguage_vh.clone();
        }
        if (this._persistence_mobileTheme_vh != null) {
            this._persistence_mobileTheme_vh = (WeavedAttributeValueHolderInterface)this._persistence_mobileTheme_vh.clone();
        }
        if (this._persistence_mapDirectoryField_vh != null) {
            this._persistence_mapDirectoryField_vh = (WeavedAttributeValueHolderInterface)this._persistence_mapDirectoryField_vh.clone();
        }
        if (this._persistence_mediumScreenRegistrationWizard_vh != null) {
            this._persistence_mediumScreenRegistrationWizard_vh = (WeavedAttributeValueHolderInterface)this._persistence_mediumScreenRegistrationWizard_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_appTheme_vh != null) {
            this._persistence_appTheme_vh = (WeavedAttributeValueHolderInterface)this._persistence_appTheme_vh.clone();
        }
        if (this._persistence_smallScreenRegistrationWizard_vh != null) {
            this._persistence_smallScreenRegistrationWizard_vh = (WeavedAttributeValueHolderInterface)this._persistence_smallScreenRegistrationWizard_vh.clone();
        }
        if (this._persistence_largeScreenRegistrationWizard_vh != null) {
            this._persistence_largeScreenRegistrationWizard_vh = (WeavedAttributeValueHolderInterface)this._persistence_largeScreenRegistrationWizard_vh.clone();
        }
        if (this._persistence_guestsTheme_vh != null) {
            this._persistence_guestsTheme_vh = (WeavedAttributeValueHolderInterface)this._persistence_guestsTheme_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Configuration();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "distanceUnit") {
            return this.distanceUnit;
        }
        if (string == "playStoreUrlMobile") {
            return this.playStoreUrlMobile;
        }
        if (string == "parent") {
            return this.parent;
        }
        if (string == "jpegQuality") {
            return this.jpegQuality;
        }
        if (string == "maxTinyThumbDimensions") {
            return this.maxTinyThumbDimensions;
        }
        if (string == "emailValidation") {
            return this.emailValidation;
        }
        if (string == "logServicesParameters") {
            return this.logServicesParameters;
        }
        if (string == "autocompleteResults") {
            return this.autocompleteResults;
        }
        if (string == "dateFormat") {
            return this.dateFormat;
        }
        if (string == "listSeparator") {
            return this.listSeparator;
        }
        if (string == "customProfileFieldsInAccount") {
            return this.customProfileFieldsInAccount;
        }
        if (string == "marketplaceMenuLabel") {
            return this.marketplaceMenuLabel;
        }
        if (string == "allowViewUserAd") {
            return this.allowViewUserAd;
        }
        if (string == "remoteAddressBlockTime") {
            return this.remoteAddressBlockTime;
        }
        if (string == "mobileUnique") {
            return this.mobileUnique;
        }
        if (string == "payTheme") {
            return this.payTheme;
        }
        if (string == "path") {
            return this.path;
        }
        if (string == "themes") {
            return this.themes;
        }
        if (string == "apiUrl") {
            return this.apiUrl;
        }
        if (string == "maxLeftBanners") {
            return this.maxLeftBanners;
        }
        if (string == "logServicesResults") {
            return this.logServicesResults;
        }
        if (string == "mobileRequired") {
            return this.mobileRequired;
        }
        if (string == "children") {
            return this.children;
        }
        if (string == "managedContentSpecificConfigurationsByProducts") {
            return this.managedContentSpecificConfigurationsByProducts;
        }
        if (string == "receivedVeryBadRefs") {
            return this.receivedVeryBadRefs;
        }
        if (string == "customSessionConfiguration") {
            return this.customSessionConfiguration;
        }
        if (string == "usersTheme") {
            return this.usersTheme;
        }
        if (string == "frontendMobileMenuTitle") {
            return this.frontendMobileMenuTitle;
        }
        if (string == "enableServicesLog") {
            return this.enableServicesLog;
        }
        if (string == "frontendTitle") {
            return this.frontendTitle;
        }
        if (string == "images") {
            return this.images;
        }
        if (string == "frontendMobileTitle") {
            return this.frontendMobileTitle;
        }
        if (string == "guestsMenuType") {
            return this.guestsMenuType;
        }
        if (string == "emailName") {
            return this.emailName;
        }
        if (string == "requireSecurityQuestionOnRegistration") {
            return this.requireSecurityQuestionOnRegistration;
        }
        if (string == "generatedUsername") {
            return this.generatedUsername;
        }
        if (string == "defaultMapLocation") {
            return this.defaultMapLocation;
        }
        if (string == "banners") {
            return this.banners;
        }
        if (string == "allowQuickPaymentMobile") {
            return this.allowQuickPaymentMobile;
        }
        if (string == "dynamicOidcClientConfiguration") {
            return this.dynamicOidcClientConfiguration;
        }
        if (string == "usersResultType") {
            return this.usersResultType;
        }
        if (string == "voucherBuyingMenu") {
            return this.voucherBuyingMenu;
        }
        if (string == "menuEntries") {
            return this.menuEntries;
        }
        if (string == "communityMenuLabel") {
            return this.communityMenuLabel;
        }
        if (string == "staticContents") {
            return this.staticContents;
        }
        if (string == "forgotPasswordSendMedium") {
            return this.forgotPasswordSendMedium;
        }
        if (string == "enableBluetoothPrinterMobile") {
            return this.enableBluetoothPrinterMobile;
        }
        if (string == "maxImageDimensions") {
            return this.maxImageDimensions;
        }
        if (string == "emailRequired") {
            return this.emailRequired;
        }
        if (string == "givenVeryBadRefs") {
            return this.givenVeryBadRefs;
        }
        if (string == "frontendDashboardUsers") {
            return this.frontendDashboardUsers;
        }
        if (string == "alwaysShowInternationalPhoneNumber") {
            return this.alwaysShowInternationalPhoneNumber;
        }
        if (string == "customProfileFieldsInAccountTitle") {
            return this.customProfileFieldsInAccountTitle;
        }
        if (string == "hideAdOwnerToGuests") {
            return this.hideAdOwnerToGuests;
        }
        if (string == "adsResultType") {
            return this.adsResultType;
        }
        if (string == "remoteAddressBlockTimeByBlockedUsers") {
            return this.remoteAddressBlockTimeByBlockedUsers;
        }
        if (string == "individualDocumentDirectory") {
            return this.individualDocumentDirectory;
        }
        if (string == "maxResultsOnMap") {
            return this.maxResultsOnMap;
        }
        if (string == "maxUserTempImages") {
            return this.maxUserTempImages;
        }
        if (string == "defaultUserImages") {
            return this.defaultUserImages;
        }
        if (string == "invalidUsernameAttempts") {
            return this.invalidUsernameAttempts;
        }
        if (string == "basicProfileFieldsInAccount") {
            return this.basicProfileFieldsInAccount;
        }
        if (string == "defaultLanguage") {
            return this.defaultLanguage;
        }
        if (string == "defaultMapZoomMobile") {
            return this.defaultMapZoomMobile;
        }
        if (string == "mobileTheme") {
            return this.mobileTheme;
        }
        if (string == "hideAdPriceToGuests") {
            return this.hideAdPriceToGuests;
        }
        if (string == "includeInSitemap") {
            return this.includeInSitemap;
        }
        if (string == "defaultPhonePrivacy") {
            return this.defaultPhonePrivacy;
        }
        if (string == "usersMenuType") {
            return this.usersMenuType;
        }
        if (string == "deniedInvoices") {
            return this.deniedInvoices;
        }
        if (string == "userSearchInMenuMode") {
            return this.userSearchInMenuMode;
        }
        if (string == "allowAccessMode") {
            return this.allowAccessMode;
        }
        if (string == "applicationName") {
            return this.applicationName;
        }
        if (string == "nameLabel") {
            return this.nameLabel;
        }
        if (string == "adSubCategoriesResults") {
            return this.adSubCategoriesResults;
        }
        if (string == "adFieldsVisibleToGuests") {
            return this.adFieldsVisibleToGuests;
        }
        if (string == "useLeftSpaceForGuests") {
            return this.useLeftSpaceForGuests;
        }
        if (string == "notifyLoginsOnNewDevices") {
            return this.notifyLoginsOnNewDevices;
        }
        if (string == "maxSmallThumbDimensions") {
            return this.maxSmallThumbDimensions;
        }
        if (string == "linkGenerationConfiguration") {
            return this.linkGenerationConfiguration;
        }
        if (string == "rootUrl") {
            return this.rootUrl;
        }
        if (string == "regexForUsername") {
            return this.regexForUsername;
        }
        if (string == "visibleAdGroups") {
            return this.visibleAdGroups;
        }
        if (string == "addressConfiguration") {
            return this.addressConfiguration;
        }
        if (string == "guestProfileFields") {
            return this.guestProfileFields;
        }
        if (string == "applicationUsername") {
            return this.applicationUsername;
        }
        if (string == "tasksLoggingMode") {
            return this.tasksLoggingMode;
        }
        if (string == "generatedUsernameLength") {
            return this.generatedUsernameLength;
        }
        if (string == "allowMultipleReports") {
            return this.allowMultipleReports;
        }
        if (string == "visibleAdCategories") {
            return this.visibleAdCategories;
        }
        if (string == "useMap") {
            return this.useMap;
        }
        if (string == "skipTotalCount") {
            return this.skipTotalCount;
        }
        if (string == "country") {
            return this.country;
        }
        if (string == "accountStatusIndicators") {
            return this.accountStatusIndicators;
        }
        if (string == "forgotPasswordMode") {
            return this.forgotPasswordMode;
        }
        if (string == "landLineEnableExtension") {
            return this.landLineEnableExtension;
        }
        if (string == "notificationConfiguration") {
            return this.notificationConfiguration;
        }
        if (string == "managedSpecificConfigurationsByProducts") {
            return this.managedSpecificConfigurationsByProducts;
        }
        if (string == "maxUploadSize") {
            return this.maxUploadSize;
        }
        if (string == "maxLogEntries") {
            return this.maxLogEntries;
        }
        if (string == "groupsForUserSearch") {
            return this.groupsForUserSearch;
        }
        if (string == "invalidTotpAttempts") {
            return this.invalidTotpAttempts;
        }
        if (string == "usernameLength") {
            return this.usernameLength;
        }
        if (string == "visibleAdCurrencies") {
            return this.visibleAdCurrencies;
        }
        if (string == "landLineRequired") {
            return this.landLineRequired;
        }
        if (string == "outboundSmsConfiguration") {
            return this.outboundSmsConfiguration;
        }
        if (string == "privacyControlledBasicFields") {
            return this.privacyControlledBasicFields;
        }
        if (string == "maxResults") {
            return this.maxResults;
        }
        if (string == "maxRightBanners") {
            return this.maxRightBanners;
        }
        if (string == "groupsForViewProfile") {
            return this.groupsForViewProfile;
        }
        if (string == "logServicesForGuests") {
            return this.logServicesForGuests;
        }
        if (string == "lockedProperties") {
            return this.lockedProperties;
        }
        if (string == "skipProductsView") {
            return this.skipProductsView;
        }
        if (string == "userFormatForManagers") {
            return this.userFormatForManagers;
        }
        if (string == "defaultCity") {
            return this.defaultCity;
        }
        if (string == "defaultMapZoomWeb") {
            return this.defaultMapZoomWeb;
        }
        if (string == "mapDirectoryField") {
            return this.mapDirectoryField;
        }
        if (string == "firebasePrivateKey") {
            return this.firebasePrivateKey;
        }
        if (string == "frontendMobileLandingPage") {
            return this.frontendMobileLandingPage;
        }
        if (string == "bannerRotateSeconds") {
            return this.bannerRotateSeconds;
        }
        if (string == "adInitialSearchType") {
            return this.adInitialSearchType;
        }
        if (string == "adCategoriesResultType") {
            return this.adCategoriesResultType;
        }
        if (string == "applyDefaultUserSearchFiltersOnPayment") {
            return this.applyDefaultUserSearchFiltersOnPayment;
        }
        if (string == "mediumScreenRegistrationWizard") {
            return this.mediumScreenRegistrationWizard;
        }
        if (string == "logServicesWritesOnly") {
            return this.logServicesWritesOnly;
        }
        if (string == "applicationDescription") {
            return this.applicationDescription;
        }
        if (string == "logoutUrl") {
            return this.logoutUrl;
        }
        if (string == "imagesLastModified") {
            return this.imagesLastModified;
        }
        if (string == "appleStoreUrlMobile") {
            return this.appleStoreUrlMobile;
        }
        if (string == "emailUnique") {
            return this.emailUnique;
        }
        if (string == "allowFrontendSwitching") {
            return this.allowFrontendSwitching;
        }
        if (string == "frontendDashboardAccounts") {
            return this.frontendDashboardAccounts;
        }
        if (string == "userFormatForOthers") {
            return this.userFormatForOthers;
        }
        if (string == "groupsForUserDirectory") {
            return this.groupsForUserDirectory;
        }
        if (string == "privacyControlledCustomFields") {
            return this.privacyControlledCustomFields;
        }
        if (string == "definedProperties") {
            return this.definedProperties;
        }
        if (string == "defaultAccountHistoryPeriod") {
            return this.defaultAccountHistoryPeriod;
        }
        if (string == "maxGuestTempImages") {
            return this.maxGuestTempImages;
        }
        if (string == "captchaConfiguration") {
            return this.captchaConfiguration;
        }
        if (string == "defaultEmailPrivacy") {
            return this.defaultEmailPrivacy;
        }
        if (string == "frontendDashboardAds") {
            return this.frontendDashboardAds;
        }
        if (string == "allowViewUserWebShop") {
            return this.allowViewUserWebShop;
        }
        if (string == "defineRootUrl") {
            return this.defineRootUrl;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "invalidPosPayerAttempts") {
            return this.invalidPosPayerAttempts;
        }
        if (string == "mapPreferenceMobile") {
            return this.mapPreferenceMobile;
        }
        if (string == "profileImageRequired") {
            return this.profileImageRequired;
        }
        if (string == "appTheme") {
            return this.appTheme;
        }
        if (string == "numberFormat") {
            return this.numberFormat;
        }
        if (string == "requiredAddress") {
            return this.requiredAddress;
        }
        if (string == "loginUrl") {
            return this.loginUrl;
        }
        if (string == "usersSortOrder") {
            return this.usersSortOrder;
        }
        if (string == "smallScreenRegistrationWizard") {
            return this.smallScreenRegistrationWizard;
        }
        if (string == "maxMediumThumbDimensions") {
            return this.maxMediumThumbDimensions;
        }
        if (string == "largeScreenRegistrationWizard") {
            return this.largeScreenRegistrationWizard;
        }
        if (string == "channelConfigurations") {
            return this.channelConfigurations;
        }
        if (string == "basicProfileFieldInAccountTitle") {
            return this.basicProfileFieldInAccountTitle;
        }
        if (string == "timeZoneId") {
            return this.timeZoneId;
        }
        if (string == "defaultRegion") {
            return this.defaultRegion;
        }
        if (string == "frontendMenuBar") {
            return this.frontendMenuBar;
        }
        if (string == "sitemapLastModified") {
            return this.sitemapLastModified;
        }
        if (string == "mapBrowserApiKey") {
            return this.mapBrowserApiKey;
        }
        if (string == "possibleInitialGroups") {
            return this.possibleInitialGroups;
        }
        if (string == "defaultType") {
            return this.defaultType;
        }
        if (string == "smtpConfiguration") {
            return this.smtpConfiguration;
        }
        if (string == "guestsTheme") {
            return this.guestsTheme;
        }
        if (string == "maxBlockedUsers") {
            return this.maxBlockedUsers;
        }
        if (string == "apiDescriptorLastModified") {
            return this.apiDescriptorLastModified;
        }
        if (string == "allowedLanguages") {
            return this.allowedLanguages;
        }
        if (string == "accountNumberConfiguration") {
            return this.accountNumberConfiguration;
        }
        if (string == "timeFormat") {
            return this.timeFormat;
        }
        if (string == "groupsForUserSearchInMenu") {
            return this.groupsForUserSearchInMenu;
        }
        if (string == "phoneNumberHandlingConfiguration") {
            return this.phoneNumberHandlingConfiguration;
        }
        if (string == "mapServerApiKey") {
            return this.mapServerApiKey;
        }
        if (string == "ipGeolocationConfiguration") {
            return this.ipGeolocationConfiguration;
        }
        if (string == "defaultAddressPrivacy") {
            return this.defaultAddressPrivacy;
        }
        if (string == "adsSortOrder") {
            return this.adsSortOrder;
        }
        if (string == "maxPngSize") {
            return this.maxPngSize;
        }
        if (string == "frontend") {
            return this.frontend;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "distanceUnit") {
            this.distanceUnit = (DistanceUnit)object;
            return;
        }
        if (string == "playStoreUrlMobile") {
            this.playStoreUrlMobile = (String)object;
            return;
        }
        if (string == "parent") {
            this.parent = (Configuration)object;
            return;
        }
        if (string == "jpegQuality") {
            this.jpegQuality = (Integer)object;
            return;
        }
        if (string == "maxTinyThumbDimensions") {
            this.maxTinyThumbDimensions = (Dimensions)object;
            return;
        }
        if (string == "emailValidation") {
            this.emailValidation = (Set)object;
            return;
        }
        if (string == "logServicesParameters") {
            this.logServicesParameters = (Boolean)object;
            return;
        }
        if (string == "autocompleteResults") {
            this.autocompleteResults = (Integer)object;
            return;
        }
        if (string == "dateFormat") {
            this.dateFormat = (DateFormat)object;
            return;
        }
        if (string == "listSeparator") {
            this.listSeparator = (ListSeparator)object;
            return;
        }
        if (string == "customProfileFieldsInAccount") {
            this.customProfileFieldsInAccount = (Set)object;
            return;
        }
        if (string == "marketplaceMenuLabel") {
            this.marketplaceMenuLabel = (String)object;
            return;
        }
        if (string == "allowViewUserAd") {
            this.allowViewUserAd = (Boolean)object;
            return;
        }
        if (string == "remoteAddressBlockTime") {
            this.remoteAddressBlockTime = (TimeInterval)object;
            return;
        }
        if (string == "mobileUnique") {
            this.mobileUnique = (Boolean)object;
            return;
        }
        if (string == "payTheme") {
            this.payTheme = (Theme)object;
            return;
        }
        if (string == "path") {
            this.path = (String)object;
            return;
        }
        if (string == "themes") {
            this.themes = (Set)object;
            return;
        }
        if (string == "apiUrl") {
            this.apiUrl = (String)object;
            return;
        }
        if (string == "maxLeftBanners") {
            this.maxLeftBanners = (Integer)object;
            return;
        }
        if (string == "logServicesResults") {
            this.logServicesResults = (Boolean)object;
            return;
        }
        if (string == "mobileRequired") {
            this.mobileRequired = (Boolean)object;
            return;
        }
        if (string == "children") {
            this.children = (List)object;
            return;
        }
        if (string == "managedContentSpecificConfigurationsByProducts") {
            this.managedContentSpecificConfigurationsByProducts = (Set)object;
            return;
        }
        if (string == "receivedVeryBadRefs") {
            this.receivedVeryBadRefs = (Integer)object;
            return;
        }
        if (string == "customSessionConfiguration") {
            this.customSessionConfiguration = (CustomSessionConfiguration)object;
            return;
        }
        if (string == "usersTheme") {
            this.usersTheme = (Theme)object;
            return;
        }
        if (string == "frontendMobileMenuTitle") {
            this.frontendMobileMenuTitle = (String)object;
            return;
        }
        if (string == "enableServicesLog") {
            this.enableServicesLog = (Boolean)object;
            return;
        }
        if (string == "frontendTitle") {
            this.frontendTitle = (String)object;
            return;
        }
        if (string == "images") {
            this.images = (Set)object;
            return;
        }
        if (string == "frontendMobileTitle") {
            this.frontendMobileTitle = (String)object;
            return;
        }
        if (string == "guestsMenuType") {
            this.guestsMenuType = (MenuType)object;
            return;
        }
        if (string == "emailName") {
            this.emailName = (String)object;
            return;
        }
        if (string == "requireSecurityQuestionOnRegistration") {
            this.requireSecurityQuestionOnRegistration = (Boolean)object;
            return;
        }
        if (string == "generatedUsername") {
            this.generatedUsername = (Boolean)object;
            return;
        }
        if (string == "defaultMapLocation") {
            this.defaultMapLocation = (LatLong)object;
            return;
        }
        if (string == "banners") {
            this.banners = (Set)object;
            return;
        }
        if (string == "allowQuickPaymentMobile") {
            this.allowQuickPaymentMobile = (Boolean)object;
            return;
        }
        if (string == "dynamicOidcClientConfiguration") {
            this.dynamicOidcClientConfiguration = (DynamicOidcClientConfiguration)object;
            return;
        }
        if (string == "usersResultType") {
            this.usersResultType = (ResultType)object;
            return;
        }
        if (string == "voucherBuyingMenu") {
            this.voucherBuyingMenu = (UserMainMenu)object;
            return;
        }
        if (string == "menuEntries") {
            this.menuEntries = (Set)object;
            return;
        }
        if (string == "communityMenuLabel") {
            this.communityMenuLabel = (String)object;
            return;
        }
        if (string == "staticContents") {
            this.staticContents = (List)object;
            return;
        }
        if (string == "forgotPasswordSendMedium") {
            this.forgotPasswordSendMedium = (SendMedium)object;
            return;
        }
        if (string == "enableBluetoothPrinterMobile") {
            this.enableBluetoothPrinterMobile = (Boolean)object;
            return;
        }
        if (string == "maxImageDimensions") {
            this.maxImageDimensions = (Dimensions)object;
            return;
        }
        if (string == "emailRequired") {
            this.emailRequired = (Boolean)object;
            return;
        }
        if (string == "givenVeryBadRefs") {
            this.givenVeryBadRefs = (Integer)object;
            return;
        }
        if (string == "frontendDashboardUsers") {
            this.frontendDashboardUsers = (Boolean)object;
            return;
        }
        if (string == "alwaysShowInternationalPhoneNumber") {
            this.alwaysShowInternationalPhoneNumber = (Boolean)object;
            return;
        }
        if (string == "customProfileFieldsInAccountTitle") {
            this.customProfileFieldsInAccountTitle = (UserCustomField)object;
            return;
        }
        if (string == "hideAdOwnerToGuests") {
            this.hideAdOwnerToGuests = (Boolean)object;
            return;
        }
        if (string == "adsResultType") {
            this.adsResultType = (ResultType)object;
            return;
        }
        if (string == "remoteAddressBlockTimeByBlockedUsers") {
            this.remoteAddressBlockTimeByBlockedUsers = (TimeInterval)object;
            return;
        }
        if (string == "individualDocumentDirectory") {
            this.individualDocumentDirectory = (String)object;
            return;
        }
        if (string == "maxResultsOnMap") {
            this.maxResultsOnMap = (Integer)object;
            return;
        }
        if (string == "maxUserTempImages") {
            this.maxUserTempImages = (Integer)object;
            return;
        }
        if (string == "defaultUserImages") {
            this.defaultUserImages = (Set)object;
            return;
        }
        if (string == "invalidUsernameAttempts") {
            this.invalidUsernameAttempts = (Integer)object;
            return;
        }
        if (string == "basicProfileFieldsInAccount") {
            this.basicProfileFieldsInAccount = (Set)object;
            return;
        }
        if (string == "defaultLanguage") {
            this.defaultLanguage = (Language)object;
            return;
        }
        if (string == "defaultMapZoomMobile") {
            this.defaultMapZoomMobile = (Integer)object;
            return;
        }
        if (string == "mobileTheme") {
            this.mobileTheme = (Theme)object;
            return;
        }
        if (string == "hideAdPriceToGuests") {
            this.hideAdPriceToGuests = (Boolean)object;
            return;
        }
        if (string == "includeInSitemap") {
            this.includeInSitemap = (Boolean)object;
            return;
        }
        if (string == "defaultPhonePrivacy") {
            this.defaultPhonePrivacy = (FieldVisibility)object;
            return;
        }
        if (string == "usersMenuType") {
            this.usersMenuType = (MenuType)object;
            return;
        }
        if (string == "deniedInvoices") {
            this.deniedInvoices = (Integer)object;
            return;
        }
        if (string == "userSearchInMenuMode") {
            this.userSearchInMenuMode = (UserSearchInMenuMode)object;
            return;
        }
        if (string == "allowAccessMode") {
            this.allowAccessMode = (AllowAccessMode)object;
            return;
        }
        if (string == "applicationName") {
            this.applicationName = (String)object;
            return;
        }
        if (string == "nameLabel") {
            this.nameLabel = (String)object;
            return;
        }
        if (string == "adSubCategoriesResults") {
            this.adSubCategoriesResults = (Integer)object;
            return;
        }
        if (string == "adFieldsVisibleToGuests") {
            this.adFieldsVisibleToGuests = (Set)object;
            return;
        }
        if (string == "useLeftSpaceForGuests") {
            this.useLeftSpaceForGuests = (Boolean)object;
            return;
        }
        if (string == "notifyLoginsOnNewDevices") {
            this.notifyLoginsOnNewDevices = (Boolean)object;
            return;
        }
        if (string == "maxSmallThumbDimensions") {
            this.maxSmallThumbDimensions = (Dimensions)object;
            return;
        }
        if (string == "linkGenerationConfiguration") {
            this.linkGenerationConfiguration = (CustomScriptConfiguration)object;
            return;
        }
        if (string == "rootUrl") {
            this.rootUrl = (String)object;
            return;
        }
        if (string == "regexForUsername") {
            this.regexForUsername = (String)object;
            return;
        }
        if (string == "visibleAdGroups") {
            this.visibleAdGroups = (Set)object;
            return;
        }
        if (string == "addressConfiguration") {
            this.addressConfiguration = (AddressConfiguration)object;
            return;
        }
        if (string == "guestProfileFields") {
            this.guestProfileFields = (Set)object;
            return;
        }
        if (string == "applicationUsername") {
            this.applicationUsername = (String)object;
            return;
        }
        if (string == "tasksLoggingMode") {
            this.tasksLoggingMode = (TaskLoggingMode)object;
            return;
        }
        if (string == "generatedUsernameLength") {
            this.generatedUsernameLength = (Integer)object;
            return;
        }
        if (string == "allowMultipleReports") {
            this.allowMultipleReports = (Boolean)object;
            return;
        }
        if (string == "visibleAdCategories") {
            this.visibleAdCategories = (Set)object;
            return;
        }
        if (string == "useMap") {
            this.useMap = (Boolean)object;
            return;
        }
        if (string == "skipTotalCount") {
            this.skipTotalCount = (Boolean)object;
            return;
        }
        if (string == "country") {
            this.country = (String)object;
            return;
        }
        if (string == "accountStatusIndicators") {
            this.accountStatusIndicators = (Set)object;
            return;
        }
        if (string == "forgotPasswordMode") {
            this.forgotPasswordMode = (ForgotPasswordMode)object;
            return;
        }
        if (string == "landLineEnableExtension") {
            this.landLineEnableExtension = (Boolean)object;
            return;
        }
        if (string == "notificationConfiguration") {
            this.notificationConfiguration = (CustomScriptConfiguration)object;
            return;
        }
        if (string == "managedSpecificConfigurationsByProducts") {
            this.managedSpecificConfigurationsByProducts = (Set)object;
            return;
        }
        if (string == "maxUploadSize") {
            this.maxUploadSize = (FileSize)object;
            return;
        }
        if (string == "maxLogEntries") {
            this.maxLogEntries = (Integer)object;
            return;
        }
        if (string == "groupsForUserSearch") {
            this.groupsForUserSearch = (Set)object;
            return;
        }
        if (string == "invalidTotpAttempts") {
            this.invalidTotpAttempts = (Integer)object;
            return;
        }
        if (string == "usernameLength") {
            this.usernameLength = (IntegerRange)object;
            return;
        }
        if (string == "visibleAdCurrencies") {
            this.visibleAdCurrencies = (Set)object;
            return;
        }
        if (string == "landLineRequired") {
            this.landLineRequired = (Boolean)object;
            return;
        }
        if (string == "outboundSmsConfiguration") {
            this.outboundSmsConfiguration = (OutboundSmsConfiguration)object;
            return;
        }
        if (string == "privacyControlledBasicFields") {
            this.privacyControlledBasicFields = (Set)object;
            return;
        }
        if (string == "maxResults") {
            this.maxResults = (Integer)object;
            return;
        }
        if (string == "maxRightBanners") {
            this.maxRightBanners = (Integer)object;
            return;
        }
        if (string == "groupsForViewProfile") {
            this.groupsForViewProfile = (Set)object;
            return;
        }
        if (string == "logServicesForGuests") {
            this.logServicesForGuests = (Boolean)object;
            return;
        }
        if (string == "lockedProperties") {
            this.lockedProperties = (Set)object;
            return;
        }
        if (string == "skipProductsView") {
            this.skipProductsView = (Boolean)object;
            return;
        }
        if (string == "userFormatForManagers") {
            this.userFormatForManagers = (UserFormatConfiguration)object;
            return;
        }
        if (string == "defaultCity") {
            this.defaultCity = (String)object;
            return;
        }
        if (string == "defaultMapZoomWeb") {
            this.defaultMapZoomWeb = (Integer)object;
            return;
        }
        if (string == "mapDirectoryField") {
            this.mapDirectoryField = (UserCustomField)object;
            return;
        }
        if (string == "firebasePrivateKey") {
            this.firebasePrivateKey = (String)object;
            return;
        }
        if (string == "frontendMobileLandingPage") {
            this.frontendMobileLandingPage = (FrontendLandingPage)object;
            return;
        }
        if (string == "bannerRotateSeconds") {
            this.bannerRotateSeconds = (Integer)object;
            return;
        }
        if (string == "adInitialSearchType") {
            this.adInitialSearchType = (AdInitialSearchType)object;
            return;
        }
        if (string == "adCategoriesResultType") {
            this.adCategoriesResultType = (AdCategoryResultType)object;
            return;
        }
        if (string == "applyDefaultUserSearchFiltersOnPayment") {
            this.applyDefaultUserSearchFiltersOnPayment = (Boolean)object;
            return;
        }
        if (string == "mediumScreenRegistrationWizard") {
            this.mediumScreenRegistrationWizard = (RegistrationWizard)object;
            return;
        }
        if (string == "logServicesWritesOnly") {
            this.logServicesWritesOnly = (Boolean)object;
            return;
        }
        if (string == "applicationDescription") {
            this.applicationDescription = (String)object;
            return;
        }
        if (string == "logoutUrl") {
            this.logoutUrl = (String)object;
            return;
        }
        if (string == "imagesLastModified") {
            this.imagesLastModified = (Date)object;
            return;
        }
        if (string == "appleStoreUrlMobile") {
            this.appleStoreUrlMobile = (String)object;
            return;
        }
        if (string == "emailUnique") {
            this.emailUnique = (Boolean)object;
            return;
        }
        if (string == "allowFrontendSwitching") {
            this.allowFrontendSwitching = (Boolean)object;
            return;
        }
        if (string == "frontendDashboardAccounts") {
            this.frontendDashboardAccounts = (FrontendDashboardAccounts)object;
            return;
        }
        if (string == "userFormatForOthers") {
            this.userFormatForOthers = (UserFormatConfiguration)object;
            return;
        }
        if (string == "groupsForUserDirectory") {
            this.groupsForUserDirectory = (Set)object;
            return;
        }
        if (string == "privacyControlledCustomFields") {
            this.privacyControlledCustomFields = (Set)object;
            return;
        }
        if (string == "definedProperties") {
            this.definedProperties = (Set)object;
            return;
        }
        if (string == "defaultAccountHistoryPeriod") {
            this.defaultAccountHistoryPeriod = (DefaultAccountHistoryPeriod)object;
            return;
        }
        if (string == "maxGuestTempImages") {
            this.maxGuestTempImages = (Integer)object;
            return;
        }
        if (string == "captchaConfiguration") {
            this.captchaConfiguration = (CaptchaConfiguration)object;
            return;
        }
        if (string == "defaultEmailPrivacy") {
            this.defaultEmailPrivacy = (FieldVisibility)object;
            return;
        }
        if (string == "frontendDashboardAds") {
            this.frontendDashboardAds = (Boolean)object;
            return;
        }
        if (string == "allowViewUserWebShop") {
            this.allowViewUserWebShop = (Boolean)object;
            return;
        }
        if (string == "defineRootUrl") {
            this.defineRootUrl = (Boolean)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "invalidPosPayerAttempts") {
            this.invalidPosPayerAttempts = (Integer)object;
            return;
        }
        if (string == "mapPreferenceMobile") {
            this.mapPreferenceMobile = (MapPreference)object;
            return;
        }
        if (string == "profileImageRequired") {
            this.profileImageRequired = (Boolean)object;
            return;
        }
        if (string == "appTheme") {
            this.appTheme = (Theme)object;
            return;
        }
        if (string == "numberFormat") {
            this.numberFormat = (NumberFormat)object;
            return;
        }
        if (string == "requiredAddress") {
            this.requiredAddress = (Boolean)object;
            return;
        }
        if (string == "loginUrl") {
            this.loginUrl = (String)object;
            return;
        }
        if (string == "usersSortOrder") {
            this.usersSortOrder = (UserOrderBy)object;
            return;
        }
        if (string == "smallScreenRegistrationWizard") {
            this.smallScreenRegistrationWizard = (RegistrationWizard)object;
            return;
        }
        if (string == "maxMediumThumbDimensions") {
            this.maxMediumThumbDimensions = (Dimensions)object;
            return;
        }
        if (string == "largeScreenRegistrationWizard") {
            this.largeScreenRegistrationWizard = (RegistrationWizard)object;
            return;
        }
        if (string == "channelConfigurations") {
            this.channelConfigurations = (Set)object;
            return;
        }
        if (string == "basicProfileFieldInAccountTitle") {
            this.basicProfileFieldInAccountTitle = (BasicProfileField)object;
            return;
        }
        if (string == "timeZoneId") {
            this.timeZoneId = (String)object;
            return;
        }
        if (string == "defaultRegion") {
            this.defaultRegion = (String)object;
            return;
        }
        if (string == "frontendMenuBar") {
            this.frontendMenuBar = (Boolean)object;
            return;
        }
        if (string == "sitemapLastModified") {
            this.sitemapLastModified = (Date)object;
            return;
        }
        if (string == "mapBrowserApiKey") {
            this.mapBrowserApiKey = (String)object;
            return;
        }
        if (string == "possibleInitialGroups") {
            this.possibleInitialGroups = (Set)object;
            return;
        }
        if (string == "defaultType") {
            this.defaultType = (DefaultConfigurationType)object;
            return;
        }
        if (string == "smtpConfiguration") {
            this.smtpConfiguration = (SmtpConfiguration)object;
            return;
        }
        if (string == "guestsTheme") {
            this.guestsTheme = (Theme)object;
            return;
        }
        if (string == "maxBlockedUsers") {
            this.maxBlockedUsers = (Integer)object;
            return;
        }
        if (string == "apiDescriptorLastModified") {
            this.apiDescriptorLastModified = (Date)object;
            return;
        }
        if (string == "allowedLanguages") {
            this.allowedLanguages = (Set)object;
            return;
        }
        if (string == "accountNumberConfiguration") {
            this.accountNumberConfiguration = (AccountNumberConfiguration)object;
            return;
        }
        if (string == "timeFormat") {
            this.timeFormat = (TimeFormat)object;
            return;
        }
        if (string == "groupsForUserSearchInMenu") {
            this.groupsForUserSearchInMenu = (Set)object;
            return;
        }
        if (string == "phoneNumberHandlingConfiguration") {
            this.phoneNumberHandlingConfiguration = (CustomScriptConfiguration)object;
            return;
        }
        if (string == "mapServerApiKey") {
            this.mapServerApiKey = (String)object;
            return;
        }
        if (string == "ipGeolocationConfiguration") {
            this.ipGeolocationConfiguration = (IpGeolocationConfiguration)object;
            return;
        }
        if (string == "defaultAddressPrivacy") {
            this.defaultAddressPrivacy = (FieldVisibility)object;
            return;
        }
        if (string == "adsSortOrder") {
            this.adsSortOrder = (AdOrderBy)object;
            return;
        }
        if (string == "maxPngSize") {
            this.maxPngSize = (FileSize)object;
            return;
        }
        if (string == "frontend") {
            this.frontend = (Frontend)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public DistanceUnit _persistence_get_distanceUnit() {
        this._persistence_checkFetched("distanceUnit");
        return this.distanceUnit;
    }

    public void _persistence_set_distanceUnit(DistanceUnit distanceUnit) {
        this._persistence_checkFetchedForSet("distanceUnit");
        this._persistence_propertyChange("distanceUnit", this.distanceUnit, distanceUnit);
        this.distanceUnit = distanceUnit;
    }

    public String _persistence_get_playStoreUrlMobile() {
        this._persistence_checkFetched("playStoreUrlMobile");
        return this.playStoreUrlMobile;
    }

    public void _persistence_set_playStoreUrlMobile(String string) {
        this._persistence_checkFetchedForSet("playStoreUrlMobile");
        this._persistence_propertyChange("playStoreUrlMobile", this.playStoreUrlMobile, string);
        this.playStoreUrlMobile = string;
    }

    protected void _persistence_initialize_parent_vh() {
        if (this._persistence_parent_vh == null) {
            this._persistence_parent_vh = new ValueHolder((Object)this.parent);
            this._persistence_parent_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_parent_vh() {
        Configuration configuration;
        this._persistence_initialize_parent_vh();
        if ((this._persistence_parent_vh.isCoordinatedWithProperty() || this._persistence_parent_vh.isNewlyWeavedValueHolder()) && (configuration = this._persistence_get_parent()) != this._persistence_parent_vh.getValue()) {
            this._persistence_set_parent(configuration);
        }
        return this._persistence_parent_vh;
    }

    public void _persistence_set_parent_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_parent_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Configuration configuration = this._persistence_get_parent();
            if (configuration != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_parent((Configuration)object);
            }
        } else {
            this.parent = null;
        }
    }

    public Configuration _persistence_get_parent() {
        this._persistence_checkFetched("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (Configuration)this._persistence_parent_vh.getValue();
        return this.parent;
    }

    public void _persistence_set_parent(Configuration configuration) {
        this._persistence_checkFetchedForSet("parent");
        this._persistence_initialize_parent_vh();
        this.parent = (Configuration)this._persistence_parent_vh.getValue();
        this._persistence_propertyChange("parent", this.parent, configuration);
        this.parent = configuration;
        this._persistence_parent_vh.setValue((Object)configuration);
    }

    public Integer _persistence_get_jpegQuality() {
        this._persistence_checkFetched("jpegQuality");
        return this.jpegQuality;
    }

    public void _persistence_set_jpegQuality(Integer n) {
        this._persistence_checkFetchedForSet("jpegQuality");
        this._persistence_propertyChange("jpegQuality", this.jpegQuality, n);
        this.jpegQuality = n;
    }

    public Dimensions _persistence_get_maxTinyThumbDimensions() {
        this._persistence_checkFetched("maxTinyThumbDimensions");
        return this.maxTinyThumbDimensions;
    }

    public void _persistence_set_maxTinyThumbDimensions(Dimensions dimensions) {
        this._persistence_checkFetchedForSet("maxTinyThumbDimensions");
        this._persistence_propertyChange("maxTinyThumbDimensions", this.maxTinyThumbDimensions, dimensions);
        this.maxTinyThumbDimensions = dimensions;
    }

    public Set _persistence_get_emailValidation() {
        this._persistence_checkFetched("emailValidation");
        return this.emailValidation;
    }

    public void _persistence_set_emailValidation(Set set) {
        this._persistence_checkFetchedForSet("emailValidation");
        this._persistence_propertyChange("emailValidation", this.emailValidation, set);
        this.emailValidation = set;
    }

    public Boolean _persistence_get_logServicesParameters() {
        this._persistence_checkFetched("logServicesParameters");
        return this.logServicesParameters;
    }

    public void _persistence_set_logServicesParameters(Boolean bl) {
        this._persistence_checkFetchedForSet("logServicesParameters");
        this._persistence_propertyChange("logServicesParameters", this.logServicesParameters, bl);
        this.logServicesParameters = bl;
    }

    public Integer _persistence_get_autocompleteResults() {
        this._persistence_checkFetched("autocompleteResults");
        return this.autocompleteResults;
    }

    public void _persistence_set_autocompleteResults(Integer n) {
        this._persistence_checkFetchedForSet("autocompleteResults");
        this._persistence_propertyChange("autocompleteResults", this.autocompleteResults, n);
        this.autocompleteResults = n;
    }

    public DateFormat _persistence_get_dateFormat() {
        this._persistence_checkFetched("dateFormat");
        return this.dateFormat;
    }

    public void _persistence_set_dateFormat(DateFormat dateFormat) {
        this._persistence_checkFetchedForSet("dateFormat");
        this._persistence_propertyChange("dateFormat", this.dateFormat, dateFormat);
        this.dateFormat = dateFormat;
    }

    public ListSeparator _persistence_get_listSeparator() {
        this._persistence_checkFetched("listSeparator");
        return this.listSeparator;
    }

    public void _persistence_set_listSeparator(ListSeparator listSeparator) {
        this._persistence_checkFetchedForSet("listSeparator");
        this._persistence_propertyChange("listSeparator", this.listSeparator, listSeparator);
        this.listSeparator = listSeparator;
    }

    public Set _persistence_get_customProfileFieldsInAccount() {
        this._persistence_checkFetched("customProfileFieldsInAccount");
        return this.customProfileFieldsInAccount;
    }

    public void _persistence_set_customProfileFieldsInAccount(Set set) {
        this._persistence_checkFetchedForSet("customProfileFieldsInAccount");
        this._persistence_propertyChange("customProfileFieldsInAccount", this.customProfileFieldsInAccount, set);
        this.customProfileFieldsInAccount = set;
    }

    public String _persistence_get_marketplaceMenuLabel() {
        this._persistence_checkFetched("marketplaceMenuLabel");
        return this.marketplaceMenuLabel;
    }

    public void _persistence_set_marketplaceMenuLabel(String string) {
        this._persistence_checkFetchedForSet("marketplaceMenuLabel");
        this._persistence_propertyChange("marketplaceMenuLabel", this.marketplaceMenuLabel, string);
        this.marketplaceMenuLabel = string;
    }

    public Boolean _persistence_get_allowViewUserAd() {
        this._persistence_checkFetched("allowViewUserAd");
        return this.allowViewUserAd;
    }

    public void _persistence_set_allowViewUserAd(Boolean bl) {
        this._persistence_checkFetchedForSet("allowViewUserAd");
        this._persistence_propertyChange("allowViewUserAd", this.allowViewUserAd, bl);
        this.allowViewUserAd = bl;
    }

    public TimeInterval _persistence_get_remoteAddressBlockTime() {
        this._persistence_checkFetched("remoteAddressBlockTime");
        return this.remoteAddressBlockTime;
    }

    public void _persistence_set_remoteAddressBlockTime(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("remoteAddressBlockTime");
        this._persistence_propertyChange("remoteAddressBlockTime", this.remoteAddressBlockTime, timeInterval);
        this.remoteAddressBlockTime = timeInterval;
    }

    public Boolean _persistence_get_mobileUnique() {
        this._persistence_checkFetched("mobileUnique");
        return this.mobileUnique;
    }

    public void _persistence_set_mobileUnique(Boolean bl) {
        this._persistence_checkFetchedForSet("mobileUnique");
        this._persistence_propertyChange("mobileUnique", this.mobileUnique, bl);
        this.mobileUnique = bl;
    }

    protected void _persistence_initialize_payTheme_vh() {
        if (this._persistence_payTheme_vh == null) {
            this._persistence_payTheme_vh = new ValueHolder((Object)this.payTheme);
            this._persistence_payTheme_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_payTheme_vh() {
        Theme theme;
        this._persistence_initialize_payTheme_vh();
        if ((this._persistence_payTheme_vh.isCoordinatedWithProperty() || this._persistence_payTheme_vh.isNewlyWeavedValueHolder()) && (theme = this._persistence_get_payTheme()) != this._persistence_payTheme_vh.getValue()) {
            this._persistence_set_payTheme(theme);
        }
        return this._persistence_payTheme_vh;
    }

    public void _persistence_set_payTheme_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_payTheme_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Theme theme = this._persistence_get_payTheme();
            if (theme != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_payTheme((Theme)object);
            }
        } else {
            this.payTheme = null;
        }
    }

    public Theme _persistence_get_payTheme() {
        this._persistence_checkFetched("payTheme");
        this._persistence_initialize_payTheme_vh();
        this.payTheme = (Theme)this._persistence_payTheme_vh.getValue();
        return this.payTheme;
    }

    public void _persistence_set_payTheme(Theme theme) {
        this._persistence_checkFetchedForSet("payTheme");
        this._persistence_initialize_payTheme_vh();
        this.payTheme = (Theme)this._persistence_payTheme_vh.getValue();
        this._persistence_propertyChange("payTheme", this.payTheme, theme);
        this.payTheme = theme;
        this._persistence_payTheme_vh.setValue((Object)theme);
    }

    public String _persistence_get_path() {
        this._persistence_checkFetched("path");
        return this.path;
    }

    public void _persistence_set_path(String string) {
        this._persistence_checkFetchedForSet("path");
        this._persistence_propertyChange("path", this.path, string);
        this.path = string;
    }

    public Set _persistence_get_themes() {
        this._persistence_checkFetched("themes");
        return this.themes;
    }

    public void _persistence_set_themes(Set set) {
        this._persistence_checkFetchedForSet("themes");
        this._persistence_propertyChange("themes", this.themes, set);
        this.themes = set;
    }

    public String _persistence_get_apiUrl() {
        this._persistence_checkFetched("apiUrl");
        return this.apiUrl;
    }

    public void _persistence_set_apiUrl(String string) {
        this._persistence_checkFetchedForSet("apiUrl");
        this._persistence_propertyChange("apiUrl", this.apiUrl, string);
        this.apiUrl = string;
    }

    public Integer _persistence_get_maxLeftBanners() {
        this._persistence_checkFetched("maxLeftBanners");
        return this.maxLeftBanners;
    }

    public void _persistence_set_maxLeftBanners(Integer n) {
        this._persistence_checkFetchedForSet("maxLeftBanners");
        this._persistence_propertyChange("maxLeftBanners", this.maxLeftBanners, n);
        this.maxLeftBanners = n;
    }

    public Boolean _persistence_get_logServicesResults() {
        this._persistence_checkFetched("logServicesResults");
        return this.logServicesResults;
    }

    public void _persistence_set_logServicesResults(Boolean bl) {
        this._persistence_checkFetchedForSet("logServicesResults");
        this._persistence_propertyChange("logServicesResults", this.logServicesResults, bl);
        this.logServicesResults = bl;
    }

    public Boolean _persistence_get_mobileRequired() {
        this._persistence_checkFetched("mobileRequired");
        return this.mobileRequired;
    }

    public void _persistence_set_mobileRequired(Boolean bl) {
        this._persistence_checkFetchedForSet("mobileRequired");
        this._persistence_propertyChange("mobileRequired", this.mobileRequired, bl);
        this.mobileRequired = bl;
    }

    public List _persistence_get_children() {
        this._persistence_checkFetched("children");
        return this.children;
    }

    public void _persistence_set_children(List list) {
        this._persistence_checkFetchedForSet("children");
        this._persistence_propertyChange("children", this.children, list);
        this.children = list;
    }

    public Set _persistence_get_managedContentSpecificConfigurationsByProducts() {
        this._persistence_checkFetched("managedContentSpecificConfigurationsByProducts");
        return this.managedContentSpecificConfigurationsByProducts;
    }

    public void _persistence_set_managedContentSpecificConfigurationsByProducts(Set set) {
        this._persistence_checkFetchedForSet("managedContentSpecificConfigurationsByProducts");
        this._persistence_propertyChange("managedContentSpecificConfigurationsByProducts", this.managedContentSpecificConfigurationsByProducts, set);
        this.managedContentSpecificConfigurationsByProducts = set;
    }

    public Integer _persistence_get_receivedVeryBadRefs() {
        this._persistence_checkFetched("receivedVeryBadRefs");
        return this.receivedVeryBadRefs;
    }

    public void _persistence_set_receivedVeryBadRefs(Integer n) {
        this._persistence_checkFetchedForSet("receivedVeryBadRefs");
        this._persistence_propertyChange("receivedVeryBadRefs", this.receivedVeryBadRefs, n);
        this.receivedVeryBadRefs = n;
    }

    public CustomSessionConfiguration _persistence_get_customSessionConfiguration() {
        this._persistence_checkFetched("customSessionConfiguration");
        return this.customSessionConfiguration;
    }

    public void _persistence_set_customSessionConfiguration(CustomSessionConfiguration customSessionConfiguration) {
        this._persistence_checkFetchedForSet("customSessionConfiguration");
        this._persistence_propertyChange("customSessionConfiguration", this.customSessionConfiguration, customSessionConfiguration);
        this.customSessionConfiguration = customSessionConfiguration;
    }

    protected void _persistence_initialize_usersTheme_vh() {
        if (this._persistence_usersTheme_vh == null) {
            this._persistence_usersTheme_vh = new ValueHolder((Object)this.usersTheme);
            this._persistence_usersTheme_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_usersTheme_vh() {
        Theme theme;
        this._persistence_initialize_usersTheme_vh();
        if ((this._persistence_usersTheme_vh.isCoordinatedWithProperty() || this._persistence_usersTheme_vh.isNewlyWeavedValueHolder()) && (theme = this._persistence_get_usersTheme()) != this._persistence_usersTheme_vh.getValue()) {
            this._persistence_set_usersTheme(theme);
        }
        return this._persistence_usersTheme_vh;
    }

    public void _persistence_set_usersTheme_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_usersTheme_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Theme theme = this._persistence_get_usersTheme();
            if (theme != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_usersTheme((Theme)object);
            }
        } else {
            this.usersTheme = null;
        }
    }

    public Theme _persistence_get_usersTheme() {
        this._persistence_checkFetched("usersTheme");
        this._persistence_initialize_usersTheme_vh();
        this.usersTheme = (Theme)this._persistence_usersTheme_vh.getValue();
        return this.usersTheme;
    }

    public void _persistence_set_usersTheme(Theme theme) {
        this._persistence_checkFetchedForSet("usersTheme");
        this._persistence_initialize_usersTheme_vh();
        this.usersTheme = (Theme)this._persistence_usersTheme_vh.getValue();
        this._persistence_propertyChange("usersTheme", this.usersTheme, theme);
        this.usersTheme = theme;
        this._persistence_usersTheme_vh.setValue((Object)theme);
    }

    public String _persistence_get_frontendMobileMenuTitle() {
        this._persistence_checkFetched("frontendMobileMenuTitle");
        return this.frontendMobileMenuTitle;
    }

    public void _persistence_set_frontendMobileMenuTitle(String string) {
        this._persistence_checkFetchedForSet("frontendMobileMenuTitle");
        this._persistence_propertyChange("frontendMobileMenuTitle", this.frontendMobileMenuTitle, string);
        this.frontendMobileMenuTitle = string;
    }

    public Boolean _persistence_get_enableServicesLog() {
        this._persistence_checkFetched("enableServicesLog");
        return this.enableServicesLog;
    }

    public void _persistence_set_enableServicesLog(Boolean bl) {
        this._persistence_checkFetchedForSet("enableServicesLog");
        this._persistence_propertyChange("enableServicesLog", this.enableServicesLog, bl);
        this.enableServicesLog = bl;
    }

    public String _persistence_get_frontendTitle() {
        this._persistence_checkFetched("frontendTitle");
        return this.frontendTitle;
    }

    public void _persistence_set_frontendTitle(String string) {
        this._persistence_checkFetchedForSet("frontendTitle");
        this._persistence_propertyChange("frontendTitle", this.frontendTitle, string);
        this.frontendTitle = string;
    }

    public Set _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(Set set) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, set);
        this.images = set;
    }

    public String _persistence_get_frontendMobileTitle() {
        this._persistence_checkFetched("frontendMobileTitle");
        return this.frontendMobileTitle;
    }

    public void _persistence_set_frontendMobileTitle(String string) {
        this._persistence_checkFetchedForSet("frontendMobileTitle");
        this._persistence_propertyChange("frontendMobileTitle", this.frontendMobileTitle, string);
        this.frontendMobileTitle = string;
    }

    public MenuType _persistence_get_guestsMenuType() {
        this._persistence_checkFetched("guestsMenuType");
        return this.guestsMenuType;
    }

    public void _persistence_set_guestsMenuType(MenuType menuType) {
        this._persistence_checkFetchedForSet("guestsMenuType");
        this._persistence_propertyChange("guestsMenuType", this.guestsMenuType, menuType);
        this.guestsMenuType = menuType;
    }

    public String _persistence_get_emailName() {
        this._persistence_checkFetched("emailName");
        return this.emailName;
    }

    public void _persistence_set_emailName(String string) {
        this._persistence_checkFetchedForSet("emailName");
        this._persistence_propertyChange("emailName", this.emailName, string);
        this.emailName = string;
    }

    public Boolean _persistence_get_requireSecurityQuestionOnRegistration() {
        this._persistence_checkFetched("requireSecurityQuestionOnRegistration");
        return this.requireSecurityQuestionOnRegistration;
    }

    public void _persistence_set_requireSecurityQuestionOnRegistration(Boolean bl) {
        this._persistence_checkFetchedForSet("requireSecurityQuestionOnRegistration");
        this._persistence_propertyChange("requireSecurityQuestionOnRegistration", this.requireSecurityQuestionOnRegistration, bl);
        this.requireSecurityQuestionOnRegistration = bl;
    }

    public Boolean _persistence_get_generatedUsername() {
        this._persistence_checkFetched("generatedUsername");
        return this.generatedUsername;
    }

    public void _persistence_set_generatedUsername(Boolean bl) {
        this._persistence_checkFetchedForSet("generatedUsername");
        this._persistence_propertyChange("generatedUsername", this.generatedUsername, bl);
        this.generatedUsername = bl;
    }

    public LatLong _persistence_get_defaultMapLocation() {
        this._persistence_checkFetched("defaultMapLocation");
        return this.defaultMapLocation;
    }

    public void _persistence_set_defaultMapLocation(LatLong latLong) {
        this._persistence_checkFetchedForSet("defaultMapLocation");
        this._persistence_propertyChange("defaultMapLocation", this.defaultMapLocation, latLong);
        this.defaultMapLocation = latLong;
    }

    public Set _persistence_get_banners() {
        this._persistence_checkFetched("banners");
        return this.banners;
    }

    public void _persistence_set_banners(Set set) {
        this._persistence_checkFetchedForSet("banners");
        this._persistence_propertyChange("banners", this.banners, set);
        this.banners = set;
    }

    public Boolean _persistence_get_allowQuickPaymentMobile() {
        this._persistence_checkFetched("allowQuickPaymentMobile");
        return this.allowQuickPaymentMobile;
    }

    public void _persistence_set_allowQuickPaymentMobile(Boolean bl) {
        this._persistence_checkFetchedForSet("allowQuickPaymentMobile");
        this._persistence_propertyChange("allowQuickPaymentMobile", this.allowQuickPaymentMobile, bl);
        this.allowQuickPaymentMobile = bl;
    }

    public DynamicOidcClientConfiguration _persistence_get_dynamicOidcClientConfiguration() {
        this._persistence_checkFetched("dynamicOidcClientConfiguration");
        return this.dynamicOidcClientConfiguration;
    }

    public void _persistence_set_dynamicOidcClientConfiguration(DynamicOidcClientConfiguration dynamicOidcClientConfiguration) {
        this._persistence_checkFetchedForSet("dynamicOidcClientConfiguration");
        this._persistence_propertyChange("dynamicOidcClientConfiguration", this.dynamicOidcClientConfiguration, dynamicOidcClientConfiguration);
        this.dynamicOidcClientConfiguration = dynamicOidcClientConfiguration;
    }

    public ResultType _persistence_get_usersResultType() {
        this._persistence_checkFetched("usersResultType");
        return this.usersResultType;
    }

    public void _persistence_set_usersResultType(ResultType resultType) {
        this._persistence_checkFetchedForSet("usersResultType");
        this._persistence_propertyChange("usersResultType", this.usersResultType, resultType);
        this.usersResultType = resultType;
    }

    public UserMainMenu _persistence_get_voucherBuyingMenu() {
        this._persistence_checkFetched("voucherBuyingMenu");
        return this.voucherBuyingMenu;
    }

    public void _persistence_set_voucherBuyingMenu(UserMainMenu userMainMenu) {
        this._persistence_checkFetchedForSet("voucherBuyingMenu");
        this._persistence_propertyChange("voucherBuyingMenu", this.voucherBuyingMenu, userMainMenu);
        this.voucherBuyingMenu = userMainMenu;
    }

    public Set _persistence_get_menuEntries() {
        this._persistence_checkFetched("menuEntries");
        return this.menuEntries;
    }

    public void _persistence_set_menuEntries(Set set) {
        this._persistence_checkFetchedForSet("menuEntries");
        this._persistence_propertyChange("menuEntries", this.menuEntries, set);
        this.menuEntries = set;
    }

    public String _persistence_get_communityMenuLabel() {
        this._persistence_checkFetched("communityMenuLabel");
        return this.communityMenuLabel;
    }

    public void _persistence_set_communityMenuLabel(String string) {
        this._persistence_checkFetchedForSet("communityMenuLabel");
        this._persistence_propertyChange("communityMenuLabel", this.communityMenuLabel, string);
        this.communityMenuLabel = string;
    }

    public List _persistence_get_staticContents() {
        this._persistence_checkFetched("staticContents");
        return this.staticContents;
    }

    public void _persistence_set_staticContents(List list) {
        this._persistence_checkFetchedForSet("staticContents");
        this._persistence_propertyChange("staticContents", this.staticContents, list);
        this.staticContents = list;
    }

    public SendMedium _persistence_get_forgotPasswordSendMedium() {
        this._persistence_checkFetched("forgotPasswordSendMedium");
        return this.forgotPasswordSendMedium;
    }

    public void _persistence_set_forgotPasswordSendMedium(SendMedium sendMedium) {
        this._persistence_checkFetchedForSet("forgotPasswordSendMedium");
        this._persistence_propertyChange("forgotPasswordSendMedium", this.forgotPasswordSendMedium, sendMedium);
        this.forgotPasswordSendMedium = sendMedium;
    }

    public Boolean _persistence_get_enableBluetoothPrinterMobile() {
        this._persistence_checkFetched("enableBluetoothPrinterMobile");
        return this.enableBluetoothPrinterMobile;
    }

    public void _persistence_set_enableBluetoothPrinterMobile(Boolean bl) {
        this._persistence_checkFetchedForSet("enableBluetoothPrinterMobile");
        this._persistence_propertyChange("enableBluetoothPrinterMobile", this.enableBluetoothPrinterMobile, bl);
        this.enableBluetoothPrinterMobile = bl;
    }

    public Dimensions _persistence_get_maxImageDimensions() {
        this._persistence_checkFetched("maxImageDimensions");
        return this.maxImageDimensions;
    }

    public void _persistence_set_maxImageDimensions(Dimensions dimensions) {
        this._persistence_checkFetchedForSet("maxImageDimensions");
        this._persistence_propertyChange("maxImageDimensions", this.maxImageDimensions, dimensions);
        this.maxImageDimensions = dimensions;
    }

    public Boolean _persistence_get_emailRequired() {
        this._persistence_checkFetched("emailRequired");
        return this.emailRequired;
    }

    public void _persistence_set_emailRequired(Boolean bl) {
        this._persistence_checkFetchedForSet("emailRequired");
        this._persistence_propertyChange("emailRequired", this.emailRequired, bl);
        this.emailRequired = bl;
    }

    public Integer _persistence_get_givenVeryBadRefs() {
        this._persistence_checkFetched("givenVeryBadRefs");
        return this.givenVeryBadRefs;
    }

    public void _persistence_set_givenVeryBadRefs(Integer n) {
        this._persistence_checkFetchedForSet("givenVeryBadRefs");
        this._persistence_propertyChange("givenVeryBadRefs", this.givenVeryBadRefs, n);
        this.givenVeryBadRefs = n;
    }

    public Boolean _persistence_get_frontendDashboardUsers() {
        this._persistence_checkFetched("frontendDashboardUsers");
        return this.frontendDashboardUsers;
    }

    public void _persistence_set_frontendDashboardUsers(Boolean bl) {
        this._persistence_checkFetchedForSet("frontendDashboardUsers");
        this._persistence_propertyChange("frontendDashboardUsers", this.frontendDashboardUsers, bl);
        this.frontendDashboardUsers = bl;
    }

    public Boolean _persistence_get_alwaysShowInternationalPhoneNumber() {
        this._persistence_checkFetched("alwaysShowInternationalPhoneNumber");
        return this.alwaysShowInternationalPhoneNumber;
    }

    public void _persistence_set_alwaysShowInternationalPhoneNumber(Boolean bl) {
        this._persistence_checkFetchedForSet("alwaysShowInternationalPhoneNumber");
        this._persistence_propertyChange("alwaysShowInternationalPhoneNumber", this.alwaysShowInternationalPhoneNumber, bl);
        this.alwaysShowInternationalPhoneNumber = bl;
    }

    protected void _persistence_initialize_customProfileFieldsInAccountTitle_vh() {
        if (this._persistence_customProfileFieldsInAccountTitle_vh == null) {
            this._persistence_customProfileFieldsInAccountTitle_vh = new ValueHolder((Object)this.customProfileFieldsInAccountTitle);
            this._persistence_customProfileFieldsInAccountTitle_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_customProfileFieldsInAccountTitle_vh() {
        UserCustomField userCustomField;
        this._persistence_initialize_customProfileFieldsInAccountTitle_vh();
        if ((this._persistence_customProfileFieldsInAccountTitle_vh.isCoordinatedWithProperty() || this._persistence_customProfileFieldsInAccountTitle_vh.isNewlyWeavedValueHolder()) && (userCustomField = this._persistence_get_customProfileFieldsInAccountTitle()) != this._persistence_customProfileFieldsInAccountTitle_vh.getValue()) {
            this._persistence_set_customProfileFieldsInAccountTitle(userCustomField);
        }
        return this._persistence_customProfileFieldsInAccountTitle_vh;
    }

    public void _persistence_set_customProfileFieldsInAccountTitle_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_customProfileFieldsInAccountTitle_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserCustomField userCustomField = this._persistence_get_customProfileFieldsInAccountTitle();
            if (userCustomField != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_customProfileFieldsInAccountTitle((UserCustomField)object);
            }
        } else {
            this.customProfileFieldsInAccountTitle = null;
        }
    }

    public UserCustomField _persistence_get_customProfileFieldsInAccountTitle() {
        this._persistence_checkFetched("customProfileFieldsInAccountTitle");
        this._persistence_initialize_customProfileFieldsInAccountTitle_vh();
        this.customProfileFieldsInAccountTitle = (UserCustomField)this._persistence_customProfileFieldsInAccountTitle_vh.getValue();
        return this.customProfileFieldsInAccountTitle;
    }

    public void _persistence_set_customProfileFieldsInAccountTitle(UserCustomField userCustomField) {
        this._persistence_checkFetchedForSet("customProfileFieldsInAccountTitle");
        this._persistence_initialize_customProfileFieldsInAccountTitle_vh();
        this.customProfileFieldsInAccountTitle = (UserCustomField)this._persistence_customProfileFieldsInAccountTitle_vh.getValue();
        this._persistence_propertyChange("customProfileFieldsInAccountTitle", this.customProfileFieldsInAccountTitle, userCustomField);
        this.customProfileFieldsInAccountTitle = userCustomField;
        this._persistence_customProfileFieldsInAccountTitle_vh.setValue((Object)userCustomField);
    }

    public Boolean _persistence_get_hideAdOwnerToGuests() {
        this._persistence_checkFetched("hideAdOwnerToGuests");
        return this.hideAdOwnerToGuests;
    }

    public void _persistence_set_hideAdOwnerToGuests(Boolean bl) {
        this._persistence_checkFetchedForSet("hideAdOwnerToGuests");
        this._persistence_propertyChange("hideAdOwnerToGuests", this.hideAdOwnerToGuests, bl);
        this.hideAdOwnerToGuests = bl;
    }

    public ResultType _persistence_get_adsResultType() {
        this._persistence_checkFetched("adsResultType");
        return this.adsResultType;
    }

    public void _persistence_set_adsResultType(ResultType resultType) {
        this._persistence_checkFetchedForSet("adsResultType");
        this._persistence_propertyChange("adsResultType", this.adsResultType, resultType);
        this.adsResultType = resultType;
    }

    public TimeInterval _persistence_get_remoteAddressBlockTimeByBlockedUsers() {
        this._persistence_checkFetched("remoteAddressBlockTimeByBlockedUsers");
        return this.remoteAddressBlockTimeByBlockedUsers;
    }

    public void _persistence_set_remoteAddressBlockTimeByBlockedUsers(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("remoteAddressBlockTimeByBlockedUsers");
        this._persistence_propertyChange("remoteAddressBlockTimeByBlockedUsers", this.remoteAddressBlockTimeByBlockedUsers, timeInterval);
        this.remoteAddressBlockTimeByBlockedUsers = timeInterval;
    }

    public String _persistence_get_individualDocumentDirectory() {
        this._persistence_checkFetched("individualDocumentDirectory");
        return this.individualDocumentDirectory;
    }

    public void _persistence_set_individualDocumentDirectory(String string) {
        this._persistence_checkFetchedForSet("individualDocumentDirectory");
        this._persistence_propertyChange("individualDocumentDirectory", this.individualDocumentDirectory, string);
        this.individualDocumentDirectory = string;
    }

    public Integer _persistence_get_maxResultsOnMap() {
        this._persistence_checkFetched("maxResultsOnMap");
        return this.maxResultsOnMap;
    }

    public void _persistence_set_maxResultsOnMap(Integer n) {
        this._persistence_checkFetchedForSet("maxResultsOnMap");
        this._persistence_propertyChange("maxResultsOnMap", this.maxResultsOnMap, n);
        this.maxResultsOnMap = n;
    }

    public Integer _persistence_get_maxUserTempImages() {
        this._persistence_checkFetched("maxUserTempImages");
        return this.maxUserTempImages;
    }

    public void _persistence_set_maxUserTempImages(Integer n) {
        this._persistence_checkFetchedForSet("maxUserTempImages");
        this._persistence_propertyChange("maxUserTempImages", this.maxUserTempImages, n);
        this.maxUserTempImages = n;
    }

    public Set _persistence_get_defaultUserImages() {
        this._persistence_checkFetched("defaultUserImages");
        return this.defaultUserImages;
    }

    public void _persistence_set_defaultUserImages(Set set) {
        this._persistence_checkFetchedForSet("defaultUserImages");
        this._persistence_propertyChange("defaultUserImages", this.defaultUserImages, set);
        this.defaultUserImages = set;
    }

    public Integer _persistence_get_invalidUsernameAttempts() {
        this._persistence_checkFetched("invalidUsernameAttempts");
        return this.invalidUsernameAttempts;
    }

    public void _persistence_set_invalidUsernameAttempts(Integer n) {
        this._persistence_checkFetchedForSet("invalidUsernameAttempts");
        this._persistence_propertyChange("invalidUsernameAttempts", this.invalidUsernameAttempts, n);
        this.invalidUsernameAttempts = n;
    }

    public Set _persistence_get_basicProfileFieldsInAccount() {
        this._persistence_checkFetched("basicProfileFieldsInAccount");
        return this.basicProfileFieldsInAccount;
    }

    public void _persistence_set_basicProfileFieldsInAccount(Set set) {
        this._persistence_checkFetchedForSet("basicProfileFieldsInAccount");
        this._persistence_propertyChange("basicProfileFieldsInAccount", this.basicProfileFieldsInAccount, set);
        this.basicProfileFieldsInAccount = set;
    }

    protected void _persistence_initialize_defaultLanguage_vh() {
        if (this._persistence_defaultLanguage_vh == null) {
            this._persistence_defaultLanguage_vh = new ValueHolder((Object)this.defaultLanguage);
            this._persistence_defaultLanguage_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_defaultLanguage_vh() {
        Language language;
        this._persistence_initialize_defaultLanguage_vh();
        if ((this._persistence_defaultLanguage_vh.isCoordinatedWithProperty() || this._persistence_defaultLanguage_vh.isNewlyWeavedValueHolder()) && (language = this._persistence_get_defaultLanguage()) != this._persistence_defaultLanguage_vh.getValue()) {
            this._persistence_set_defaultLanguage(language);
        }
        return this._persistence_defaultLanguage_vh;
    }

    public void _persistence_set_defaultLanguage_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_defaultLanguage_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Language language = this._persistence_get_defaultLanguage();
            if (language != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_defaultLanguage((Language)object);
            }
        } else {
            this.defaultLanguage = null;
        }
    }

    public Language _persistence_get_defaultLanguage() {
        this._persistence_checkFetched("defaultLanguage");
        this._persistence_initialize_defaultLanguage_vh();
        this.defaultLanguage = (Language)this._persistence_defaultLanguage_vh.getValue();
        return this.defaultLanguage;
    }

    public void _persistence_set_defaultLanguage(Language language) {
        this._persistence_checkFetchedForSet("defaultLanguage");
        this._persistence_initialize_defaultLanguage_vh();
        this.defaultLanguage = (Language)this._persistence_defaultLanguage_vh.getValue();
        this._persistence_propertyChange("defaultLanguage", this.defaultLanguage, language);
        this.defaultLanguage = language;
        this._persistence_defaultLanguage_vh.setValue((Object)language);
    }

    public Integer _persistence_get_defaultMapZoomMobile() {
        this._persistence_checkFetched("defaultMapZoomMobile");
        return this.defaultMapZoomMobile;
    }

    public void _persistence_set_defaultMapZoomMobile(Integer n) {
        this._persistence_checkFetchedForSet("defaultMapZoomMobile");
        this._persistence_propertyChange("defaultMapZoomMobile", this.defaultMapZoomMobile, n);
        this.defaultMapZoomMobile = n;
    }

    protected void _persistence_initialize_mobileTheme_vh() {
        if (this._persistence_mobileTheme_vh == null) {
            this._persistence_mobileTheme_vh = new ValueHolder((Object)this.mobileTheme);
            this._persistence_mobileTheme_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_mobileTheme_vh() {
        Theme theme;
        this._persistence_initialize_mobileTheme_vh();
        if ((this._persistence_mobileTheme_vh.isCoordinatedWithProperty() || this._persistence_mobileTheme_vh.isNewlyWeavedValueHolder()) && (theme = this._persistence_get_mobileTheme()) != this._persistence_mobileTheme_vh.getValue()) {
            this._persistence_set_mobileTheme(theme);
        }
        return this._persistence_mobileTheme_vh;
    }

    public void _persistence_set_mobileTheme_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_mobileTheme_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Theme theme = this._persistence_get_mobileTheme();
            if (theme != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_mobileTheme((Theme)object);
            }
        } else {
            this.mobileTheme = null;
        }
    }

    public Theme _persistence_get_mobileTheme() {
        this._persistence_checkFetched("mobileTheme");
        this._persistence_initialize_mobileTheme_vh();
        this.mobileTheme = (Theme)this._persistence_mobileTheme_vh.getValue();
        return this.mobileTheme;
    }

    public void _persistence_set_mobileTheme(Theme theme) {
        this._persistence_checkFetchedForSet("mobileTheme");
        this._persistence_initialize_mobileTheme_vh();
        this.mobileTheme = (Theme)this._persistence_mobileTheme_vh.getValue();
        this._persistence_propertyChange("mobileTheme", this.mobileTheme, theme);
        this.mobileTheme = theme;
        this._persistence_mobileTheme_vh.setValue((Object)theme);
    }

    public Boolean _persistence_get_hideAdPriceToGuests() {
        this._persistence_checkFetched("hideAdPriceToGuests");
        return this.hideAdPriceToGuests;
    }

    public void _persistence_set_hideAdPriceToGuests(Boolean bl) {
        this._persistence_checkFetchedForSet("hideAdPriceToGuests");
        this._persistence_propertyChange("hideAdPriceToGuests", this.hideAdPriceToGuests, bl);
        this.hideAdPriceToGuests = bl;
    }

    public Boolean _persistence_get_includeInSitemap() {
        this._persistence_checkFetched("includeInSitemap");
        return this.includeInSitemap;
    }

    public void _persistence_set_includeInSitemap(Boolean bl) {
        this._persistence_checkFetchedForSet("includeInSitemap");
        this._persistence_propertyChange("includeInSitemap", this.includeInSitemap, bl);
        this.includeInSitemap = bl;
    }

    public FieldVisibility _persistence_get_defaultPhonePrivacy() {
        this._persistence_checkFetched("defaultPhonePrivacy");
        return this.defaultPhonePrivacy;
    }

    public void _persistence_set_defaultPhonePrivacy(FieldVisibility fieldVisibility) {
        this._persistence_checkFetchedForSet("defaultPhonePrivacy");
        this._persistence_propertyChange("defaultPhonePrivacy", this.defaultPhonePrivacy, fieldVisibility);
        this.defaultPhonePrivacy = fieldVisibility;
    }

    public MenuType _persistence_get_usersMenuType() {
        this._persistence_checkFetched("usersMenuType");
        return this.usersMenuType;
    }

    public void _persistence_set_usersMenuType(MenuType menuType) {
        this._persistence_checkFetchedForSet("usersMenuType");
        this._persistence_propertyChange("usersMenuType", this.usersMenuType, menuType);
        this.usersMenuType = menuType;
    }

    public Integer _persistence_get_deniedInvoices() {
        this._persistence_checkFetched("deniedInvoices");
        return this.deniedInvoices;
    }

    public void _persistence_set_deniedInvoices(Integer n) {
        this._persistence_checkFetchedForSet("deniedInvoices");
        this._persistence_propertyChange("deniedInvoices", this.deniedInvoices, n);
        this.deniedInvoices = n;
    }

    public UserSearchInMenuMode _persistence_get_userSearchInMenuMode() {
        this._persistence_checkFetched("userSearchInMenuMode");
        return this.userSearchInMenuMode;
    }

    public void _persistence_set_userSearchInMenuMode(UserSearchInMenuMode userSearchInMenuMode) {
        this._persistence_checkFetchedForSet("userSearchInMenuMode");
        this._persistence_propertyChange("userSearchInMenuMode", this.userSearchInMenuMode, userSearchInMenuMode);
        this.userSearchInMenuMode = userSearchInMenuMode;
    }

    public AllowAccessMode _persistence_get_allowAccessMode() {
        this._persistence_checkFetched("allowAccessMode");
        return this.allowAccessMode;
    }

    public void _persistence_set_allowAccessMode(AllowAccessMode allowAccessMode) {
        this._persistence_checkFetchedForSet("allowAccessMode");
        this._persistence_propertyChange("allowAccessMode", this.allowAccessMode, allowAccessMode);
        this.allowAccessMode = allowAccessMode;
    }

    public String _persistence_get_applicationName() {
        this._persistence_checkFetched("applicationName");
        return this.applicationName;
    }

    public void _persistence_set_applicationName(String string) {
        this._persistence_checkFetchedForSet("applicationName");
        this._persistence_propertyChange("applicationName", this.applicationName, string);
        this.applicationName = string;
    }

    public String _persistence_get_nameLabel() {
        this._persistence_checkFetched("nameLabel");
        return this.nameLabel;
    }

    public void _persistence_set_nameLabel(String string) {
        this._persistence_checkFetchedForSet("nameLabel");
        this._persistence_propertyChange("nameLabel", this.nameLabel, string);
        this.nameLabel = string;
    }

    public Integer _persistence_get_adSubCategoriesResults() {
        this._persistence_checkFetched("adSubCategoriesResults");
        return this.adSubCategoriesResults;
    }

    public void _persistence_set_adSubCategoriesResults(Integer n) {
        this._persistence_checkFetchedForSet("adSubCategoriesResults");
        this._persistence_propertyChange("adSubCategoriesResults", this.adSubCategoriesResults, n);
        this.adSubCategoriesResults = n;
    }

    public Set _persistence_get_adFieldsVisibleToGuests() {
        this._persistence_checkFetched("adFieldsVisibleToGuests");
        return this.adFieldsVisibleToGuests;
    }

    public void _persistence_set_adFieldsVisibleToGuests(Set set) {
        this._persistence_checkFetchedForSet("adFieldsVisibleToGuests");
        this._persistence_propertyChange("adFieldsVisibleToGuests", this.adFieldsVisibleToGuests, set);
        this.adFieldsVisibleToGuests = set;
    }

    public Boolean _persistence_get_useLeftSpaceForGuests() {
        this._persistence_checkFetched("useLeftSpaceForGuests");
        return this.useLeftSpaceForGuests;
    }

    public void _persistence_set_useLeftSpaceForGuests(Boolean bl) {
        this._persistence_checkFetchedForSet("useLeftSpaceForGuests");
        this._persistence_propertyChange("useLeftSpaceForGuests", this.useLeftSpaceForGuests, bl);
        this.useLeftSpaceForGuests = bl;
    }

    public Boolean _persistence_get_notifyLoginsOnNewDevices() {
        this._persistence_checkFetched("notifyLoginsOnNewDevices");
        return this.notifyLoginsOnNewDevices;
    }

    public void _persistence_set_notifyLoginsOnNewDevices(Boolean bl) {
        this._persistence_checkFetchedForSet("notifyLoginsOnNewDevices");
        this._persistence_propertyChange("notifyLoginsOnNewDevices", this.notifyLoginsOnNewDevices, bl);
        this.notifyLoginsOnNewDevices = bl;
    }

    public Dimensions _persistence_get_maxSmallThumbDimensions() {
        this._persistence_checkFetched("maxSmallThumbDimensions");
        return this.maxSmallThumbDimensions;
    }

    public void _persistence_set_maxSmallThumbDimensions(Dimensions dimensions) {
        this._persistence_checkFetchedForSet("maxSmallThumbDimensions");
        this._persistence_propertyChange("maxSmallThumbDimensions", this.maxSmallThumbDimensions, dimensions);
        this.maxSmallThumbDimensions = dimensions;
    }

    public CustomScriptConfiguration _persistence_get_linkGenerationConfiguration() {
        this._persistence_checkFetched("linkGenerationConfiguration");
        return this.linkGenerationConfiguration;
    }

    public void _persistence_set_linkGenerationConfiguration(CustomScriptConfiguration customScriptConfiguration) {
        this._persistence_checkFetchedForSet("linkGenerationConfiguration");
        this._persistence_propertyChange("linkGenerationConfiguration", this.linkGenerationConfiguration, customScriptConfiguration);
        this.linkGenerationConfiguration = customScriptConfiguration;
    }

    public String _persistence_get_rootUrl() {
        this._persistence_checkFetched("rootUrl");
        return this.rootUrl;
    }

    public void _persistence_set_rootUrl(String string) {
        this._persistence_checkFetchedForSet("rootUrl");
        this._persistence_propertyChange("rootUrl", this.rootUrl, string);
        this.rootUrl = string;
    }

    public String _persistence_get_regexForUsername() {
        this._persistence_checkFetched("regexForUsername");
        return this.regexForUsername;
    }

    public void _persistence_set_regexForUsername(String string) {
        this._persistence_checkFetchedForSet("regexForUsername");
        this._persistence_propertyChange("regexForUsername", this.regexForUsername, string);
        this.regexForUsername = string;
    }

    public Set _persistence_get_visibleAdGroups() {
        this._persistence_checkFetched("visibleAdGroups");
        return this.visibleAdGroups;
    }

    public void _persistence_set_visibleAdGroups(Set set) {
        this._persistence_checkFetchedForSet("visibleAdGroups");
        this._persistence_propertyChange("visibleAdGroups", this.visibleAdGroups, set);
        this.visibleAdGroups = set;
    }

    public AddressConfiguration _persistence_get_addressConfiguration() {
        this._persistence_checkFetched("addressConfiguration");
        return this.addressConfiguration;
    }

    public void _persistence_set_addressConfiguration(AddressConfiguration addressConfiguration) {
        this._persistence_checkFetchedForSet("addressConfiguration");
        this._persistence_propertyChange("addressConfiguration", this.addressConfiguration, addressConfiguration);
        this.addressConfiguration = addressConfiguration;
    }

    public Set _persistence_get_guestProfileFields() {
        this._persistence_checkFetched("guestProfileFields");
        return this.guestProfileFields;
    }

    public void _persistence_set_guestProfileFields(Set set) {
        this._persistence_checkFetchedForSet("guestProfileFields");
        this._persistence_propertyChange("guestProfileFields", this.guestProfileFields, set);
        this.guestProfileFields = set;
    }

    public String _persistence_get_applicationUsername() {
        this._persistence_checkFetched("applicationUsername");
        return this.applicationUsername;
    }

    public void _persistence_set_applicationUsername(String string) {
        this._persistence_checkFetchedForSet("applicationUsername");
        this._persistence_propertyChange("applicationUsername", this.applicationUsername, string);
        this.applicationUsername = string;
    }

    public TaskLoggingMode _persistence_get_tasksLoggingMode() {
        this._persistence_checkFetched("tasksLoggingMode");
        return this.tasksLoggingMode;
    }

    public void _persistence_set_tasksLoggingMode(TaskLoggingMode taskLoggingMode) {
        this._persistence_checkFetchedForSet("tasksLoggingMode");
        this._persistence_propertyChange("tasksLoggingMode", this.tasksLoggingMode, taskLoggingMode);
        this.tasksLoggingMode = taskLoggingMode;
    }

    public Integer _persistence_get_generatedUsernameLength() {
        this._persistence_checkFetched("generatedUsernameLength");
        return this.generatedUsernameLength;
    }

    public void _persistence_set_generatedUsernameLength(Integer n) {
        this._persistence_checkFetchedForSet("generatedUsernameLength");
        this._persistence_propertyChange("generatedUsernameLength", this.generatedUsernameLength, n);
        this.generatedUsernameLength = n;
    }

    public Boolean _persistence_get_allowMultipleReports() {
        this._persistence_checkFetched("allowMultipleReports");
        return this.allowMultipleReports;
    }

    public void _persistence_set_allowMultipleReports(Boolean bl) {
        this._persistence_checkFetchedForSet("allowMultipleReports");
        this._persistence_propertyChange("allowMultipleReports", this.allowMultipleReports, bl);
        this.allowMultipleReports = bl;
    }

    public Set _persistence_get_visibleAdCategories() {
        this._persistence_checkFetched("visibleAdCategories");
        return this.visibleAdCategories;
    }

    public void _persistence_set_visibleAdCategories(Set set) {
        this._persistence_checkFetchedForSet("visibleAdCategories");
        this._persistence_propertyChange("visibleAdCategories", this.visibleAdCategories, set);
        this.visibleAdCategories = set;
    }

    public Boolean _persistence_get_useMap() {
        this._persistence_checkFetched("useMap");
        return this.useMap;
    }

    public void _persistence_set_useMap(Boolean bl) {
        this._persistence_checkFetchedForSet("useMap");
        this._persistence_propertyChange("useMap", this.useMap, bl);
        this.useMap = bl;
    }

    public Boolean _persistence_get_skipTotalCount() {
        this._persistence_checkFetched("skipTotalCount");
        return this.skipTotalCount;
    }

    public void _persistence_set_skipTotalCount(Boolean bl) {
        this._persistence_checkFetchedForSet("skipTotalCount");
        this._persistence_propertyChange("skipTotalCount", this.skipTotalCount, bl);
        this.skipTotalCount = bl;
    }

    public String _persistence_get_country() {
        this._persistence_checkFetched("country");
        return this.country;
    }

    public void _persistence_set_country(String string) {
        this._persistence_checkFetchedForSet("country");
        this._persistence_propertyChange("country", this.country, string);
        this.country = string;
    }

    public Set _persistence_get_accountStatusIndicators() {
        this._persistence_checkFetched("accountStatusIndicators");
        return this.accountStatusIndicators;
    }

    public void _persistence_set_accountStatusIndicators(Set set) {
        this._persistence_checkFetchedForSet("accountStatusIndicators");
        this._persistence_propertyChange("accountStatusIndicators", this.accountStatusIndicators, set);
        this.accountStatusIndicators = set;
    }

    public ForgotPasswordMode _persistence_get_forgotPasswordMode() {
        this._persistence_checkFetched("forgotPasswordMode");
        return this.forgotPasswordMode;
    }

    public void _persistence_set_forgotPasswordMode(ForgotPasswordMode forgotPasswordMode) {
        this._persistence_checkFetchedForSet("forgotPasswordMode");
        this._persistence_propertyChange("forgotPasswordMode", this.forgotPasswordMode, forgotPasswordMode);
        this.forgotPasswordMode = forgotPasswordMode;
    }

    public Boolean _persistence_get_landLineEnableExtension() {
        this._persistence_checkFetched("landLineEnableExtension");
        return this.landLineEnableExtension;
    }

    public void _persistence_set_landLineEnableExtension(Boolean bl) {
        this._persistence_checkFetchedForSet("landLineEnableExtension");
        this._persistence_propertyChange("landLineEnableExtension", this.landLineEnableExtension, bl);
        this.landLineEnableExtension = bl;
    }

    public CustomScriptConfiguration _persistence_get_notificationConfiguration() {
        this._persistence_checkFetched("notificationConfiguration");
        return this.notificationConfiguration;
    }

    public void _persistence_set_notificationConfiguration(CustomScriptConfiguration customScriptConfiguration) {
        this._persistence_checkFetchedForSet("notificationConfiguration");
        this._persistence_propertyChange("notificationConfiguration", this.notificationConfiguration, customScriptConfiguration);
        this.notificationConfiguration = customScriptConfiguration;
    }

    public Set _persistence_get_managedSpecificConfigurationsByProducts() {
        this._persistence_checkFetched("managedSpecificConfigurationsByProducts");
        return this.managedSpecificConfigurationsByProducts;
    }

    public void _persistence_set_managedSpecificConfigurationsByProducts(Set set) {
        this._persistence_checkFetchedForSet("managedSpecificConfigurationsByProducts");
        this._persistence_propertyChange("managedSpecificConfigurationsByProducts", this.managedSpecificConfigurationsByProducts, set);
        this.managedSpecificConfigurationsByProducts = set;
    }

    public FileSize _persistence_get_maxUploadSize() {
        this._persistence_checkFetched("maxUploadSize");
        return this.maxUploadSize;
    }

    public void _persistence_set_maxUploadSize(FileSize fileSize) {
        this._persistence_checkFetchedForSet("maxUploadSize");
        this._persistence_propertyChange("maxUploadSize", this.maxUploadSize, fileSize);
        this.maxUploadSize = fileSize;
    }

    public Integer _persistence_get_maxLogEntries() {
        this._persistence_checkFetched("maxLogEntries");
        return this.maxLogEntries;
    }

    public void _persistence_set_maxLogEntries(Integer n) {
        this._persistence_checkFetchedForSet("maxLogEntries");
        this._persistence_propertyChange("maxLogEntries", this.maxLogEntries, n);
        this.maxLogEntries = n;
    }

    public Set _persistence_get_groupsForUserSearch() {
        this._persistence_checkFetched("groupsForUserSearch");
        return this.groupsForUserSearch;
    }

    public void _persistence_set_groupsForUserSearch(Set set) {
        this._persistence_checkFetchedForSet("groupsForUserSearch");
        this._persistence_propertyChange("groupsForUserSearch", this.groupsForUserSearch, set);
        this.groupsForUserSearch = set;
    }

    public Integer _persistence_get_invalidTotpAttempts() {
        this._persistence_checkFetched("invalidTotpAttempts");
        return this.invalidTotpAttempts;
    }

    public void _persistence_set_invalidTotpAttempts(Integer n) {
        this._persistence_checkFetchedForSet("invalidTotpAttempts");
        this._persistence_propertyChange("invalidTotpAttempts", this.invalidTotpAttempts, n);
        this.invalidTotpAttempts = n;
    }

    public IntegerRange _persistence_get_usernameLength() {
        this._persistence_checkFetched("usernameLength");
        return this.usernameLength;
    }

    public void _persistence_set_usernameLength(IntegerRange integerRange) {
        this._persistence_checkFetchedForSet("usernameLength");
        this._persistence_propertyChange("usernameLength", this.usernameLength, integerRange);
        this.usernameLength = integerRange;
    }

    public Set _persistence_get_visibleAdCurrencies() {
        this._persistence_checkFetched("visibleAdCurrencies");
        return this.visibleAdCurrencies;
    }

    public void _persistence_set_visibleAdCurrencies(Set set) {
        this._persistence_checkFetchedForSet("visibleAdCurrencies");
        this._persistence_propertyChange("visibleAdCurrencies", this.visibleAdCurrencies, set);
        this.visibleAdCurrencies = set;
    }

    public Boolean _persistence_get_landLineRequired() {
        this._persistence_checkFetched("landLineRequired");
        return this.landLineRequired;
    }

    public void _persistence_set_landLineRequired(Boolean bl) {
        this._persistence_checkFetchedForSet("landLineRequired");
        this._persistence_propertyChange("landLineRequired", this.landLineRequired, bl);
        this.landLineRequired = bl;
    }

    public OutboundSmsConfiguration _persistence_get_outboundSmsConfiguration() {
        this._persistence_checkFetched("outboundSmsConfiguration");
        return this.outboundSmsConfiguration;
    }

    public void _persistence_set_outboundSmsConfiguration(OutboundSmsConfiguration outboundSmsConfiguration) {
        this._persistence_checkFetchedForSet("outboundSmsConfiguration");
        this._persistence_propertyChange("outboundSmsConfiguration", this.outboundSmsConfiguration, outboundSmsConfiguration);
        this.outboundSmsConfiguration = outboundSmsConfiguration;
    }

    public Set _persistence_get_privacyControlledBasicFields() {
        this._persistence_checkFetched("privacyControlledBasicFields");
        return this.privacyControlledBasicFields;
    }

    public void _persistence_set_privacyControlledBasicFields(Set set) {
        this._persistence_checkFetchedForSet("privacyControlledBasicFields");
        this._persistence_propertyChange("privacyControlledBasicFields", this.privacyControlledBasicFields, set);
        this.privacyControlledBasicFields = set;
    }

    public Integer _persistence_get_maxResults() {
        this._persistence_checkFetched("maxResults");
        return this.maxResults;
    }

    public void _persistence_set_maxResults(Integer n) {
        this._persistence_checkFetchedForSet("maxResults");
        this._persistence_propertyChange("maxResults", this.maxResults, n);
        this.maxResults = n;
    }

    public Integer _persistence_get_maxRightBanners() {
        this._persistence_checkFetched("maxRightBanners");
        return this.maxRightBanners;
    }

    public void _persistence_set_maxRightBanners(Integer n) {
        this._persistence_checkFetchedForSet("maxRightBanners");
        this._persistence_propertyChange("maxRightBanners", this.maxRightBanners, n);
        this.maxRightBanners = n;
    }

    public Set _persistence_get_groupsForViewProfile() {
        this._persistence_checkFetched("groupsForViewProfile");
        return this.groupsForViewProfile;
    }

    public void _persistence_set_groupsForViewProfile(Set set) {
        this._persistence_checkFetchedForSet("groupsForViewProfile");
        this._persistence_propertyChange("groupsForViewProfile", this.groupsForViewProfile, set);
        this.groupsForViewProfile = set;
    }

    public Boolean _persistence_get_logServicesForGuests() {
        this._persistence_checkFetched("logServicesForGuests");
        return this.logServicesForGuests;
    }

    public void _persistence_set_logServicesForGuests(Boolean bl) {
        this._persistence_checkFetchedForSet("logServicesForGuests");
        this._persistence_propertyChange("logServicesForGuests", this.logServicesForGuests, bl);
        this.logServicesForGuests = bl;
    }

    public Set _persistence_get_lockedProperties() {
        this._persistence_checkFetched("lockedProperties");
        return this.lockedProperties;
    }

    public void _persistence_set_lockedProperties(Set set) {
        this._persistence_checkFetchedForSet("lockedProperties");
        this._persistence_propertyChange("lockedProperties", this.lockedProperties, set);
        this.lockedProperties = set;
    }

    public Boolean _persistence_get_skipProductsView() {
        this._persistence_checkFetched("skipProductsView");
        return this.skipProductsView;
    }

    public void _persistence_set_skipProductsView(Boolean bl) {
        this._persistence_checkFetchedForSet("skipProductsView");
        this._persistence_propertyChange("skipProductsView", this.skipProductsView, bl);
        this.skipProductsView = bl;
    }

    public UserFormatConfiguration _persistence_get_userFormatForManagers() {
        this._persistence_checkFetched("userFormatForManagers");
        return this.userFormatForManagers;
    }

    public void _persistence_set_userFormatForManagers(UserFormatConfiguration userFormatConfiguration) {
        this._persistence_checkFetchedForSet("userFormatForManagers");
        this._persistence_propertyChange("userFormatForManagers", this.userFormatForManagers, userFormatConfiguration);
        this.userFormatForManagers = userFormatConfiguration;
    }

    public String _persistence_get_defaultCity() {
        this._persistence_checkFetched("defaultCity");
        return this.defaultCity;
    }

    public void _persistence_set_defaultCity(String string) {
        this._persistence_checkFetchedForSet("defaultCity");
        this._persistence_propertyChange("defaultCity", this.defaultCity, string);
        this.defaultCity = string;
    }

    public Integer _persistence_get_defaultMapZoomWeb() {
        this._persistence_checkFetched("defaultMapZoomWeb");
        return this.defaultMapZoomWeb;
    }

    public void _persistence_set_defaultMapZoomWeb(Integer n) {
        this._persistence_checkFetchedForSet("defaultMapZoomWeb");
        this._persistence_propertyChange("defaultMapZoomWeb", this.defaultMapZoomWeb, n);
        this.defaultMapZoomWeb = n;
    }

    protected void _persistence_initialize_mapDirectoryField_vh() {
        if (this._persistence_mapDirectoryField_vh == null) {
            this._persistence_mapDirectoryField_vh = new ValueHolder((Object)this.mapDirectoryField);
            this._persistence_mapDirectoryField_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_mapDirectoryField_vh() {
        UserCustomField userCustomField;
        this._persistence_initialize_mapDirectoryField_vh();
        if ((this._persistence_mapDirectoryField_vh.isCoordinatedWithProperty() || this._persistence_mapDirectoryField_vh.isNewlyWeavedValueHolder()) && (userCustomField = this._persistence_get_mapDirectoryField()) != this._persistence_mapDirectoryField_vh.getValue()) {
            this._persistence_set_mapDirectoryField(userCustomField);
        }
        return this._persistence_mapDirectoryField_vh;
    }

    public void _persistence_set_mapDirectoryField_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_mapDirectoryField_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserCustomField userCustomField = this._persistence_get_mapDirectoryField();
            if (userCustomField != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_mapDirectoryField((UserCustomField)object);
            }
        } else {
            this.mapDirectoryField = null;
        }
    }

    public UserCustomField _persistence_get_mapDirectoryField() {
        this._persistence_checkFetched("mapDirectoryField");
        this._persistence_initialize_mapDirectoryField_vh();
        this.mapDirectoryField = (UserCustomField)this._persistence_mapDirectoryField_vh.getValue();
        return this.mapDirectoryField;
    }

    public void _persistence_set_mapDirectoryField(UserCustomField userCustomField) {
        this._persistence_checkFetchedForSet("mapDirectoryField");
        this._persistence_initialize_mapDirectoryField_vh();
        this.mapDirectoryField = (UserCustomField)this._persistence_mapDirectoryField_vh.getValue();
        this._persistence_propertyChange("mapDirectoryField", this.mapDirectoryField, userCustomField);
        this.mapDirectoryField = userCustomField;
        this._persistence_mapDirectoryField_vh.setValue((Object)userCustomField);
    }

    public String _persistence_get_firebasePrivateKey() {
        this._persistence_checkFetched("firebasePrivateKey");
        return this.firebasePrivateKey;
    }

    public void _persistence_set_firebasePrivateKey(String string) {
        this._persistence_checkFetchedForSet("firebasePrivateKey");
        this._persistence_propertyChange("firebasePrivateKey", this.firebasePrivateKey, string);
        this.firebasePrivateKey = string;
    }

    public FrontendLandingPage _persistence_get_frontendMobileLandingPage() {
        this._persistence_checkFetched("frontendMobileLandingPage");
        return this.frontendMobileLandingPage;
    }

    public void _persistence_set_frontendMobileLandingPage(FrontendLandingPage frontendLandingPage) {
        this._persistence_checkFetchedForSet("frontendMobileLandingPage");
        this._persistence_propertyChange("frontendMobileLandingPage", this.frontendMobileLandingPage, frontendLandingPage);
        this.frontendMobileLandingPage = frontendLandingPage;
    }

    public Integer _persistence_get_bannerRotateSeconds() {
        this._persistence_checkFetched("bannerRotateSeconds");
        return this.bannerRotateSeconds;
    }

    public void _persistence_set_bannerRotateSeconds(Integer n) {
        this._persistence_checkFetchedForSet("bannerRotateSeconds");
        this._persistence_propertyChange("bannerRotateSeconds", this.bannerRotateSeconds, n);
        this.bannerRotateSeconds = n;
    }

    public AdInitialSearchType _persistence_get_adInitialSearchType() {
        this._persistence_checkFetched("adInitialSearchType");
        return this.adInitialSearchType;
    }

    public void _persistence_set_adInitialSearchType(AdInitialSearchType adInitialSearchType) {
        this._persistence_checkFetchedForSet("adInitialSearchType");
        this._persistence_propertyChange("adInitialSearchType", this.adInitialSearchType, adInitialSearchType);
        this.adInitialSearchType = adInitialSearchType;
    }

    public AdCategoryResultType _persistence_get_adCategoriesResultType() {
        this._persistence_checkFetched("adCategoriesResultType");
        return this.adCategoriesResultType;
    }

    public void _persistence_set_adCategoriesResultType(AdCategoryResultType adCategoryResultType) {
        this._persistence_checkFetchedForSet("adCategoriesResultType");
        this._persistence_propertyChange("adCategoriesResultType", this.adCategoriesResultType, adCategoryResultType);
        this.adCategoriesResultType = adCategoryResultType;
    }

    public Boolean _persistence_get_applyDefaultUserSearchFiltersOnPayment() {
        this._persistence_checkFetched("applyDefaultUserSearchFiltersOnPayment");
        return this.applyDefaultUserSearchFiltersOnPayment;
    }

    public void _persistence_set_applyDefaultUserSearchFiltersOnPayment(Boolean bl) {
        this._persistence_checkFetchedForSet("applyDefaultUserSearchFiltersOnPayment");
        this._persistence_propertyChange("applyDefaultUserSearchFiltersOnPayment", this.applyDefaultUserSearchFiltersOnPayment, bl);
        this.applyDefaultUserSearchFiltersOnPayment = bl;
    }

    protected void _persistence_initialize_mediumScreenRegistrationWizard_vh() {
        if (this._persistence_mediumScreenRegistrationWizard_vh == null) {
            this._persistence_mediumScreenRegistrationWizard_vh = new ValueHolder((Object)this.mediumScreenRegistrationWizard);
            this._persistence_mediumScreenRegistrationWizard_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_mediumScreenRegistrationWizard_vh() {
        RegistrationWizard registrationWizard;
        this._persistence_initialize_mediumScreenRegistrationWizard_vh();
        if ((this._persistence_mediumScreenRegistrationWizard_vh.isCoordinatedWithProperty() || this._persistence_mediumScreenRegistrationWizard_vh.isNewlyWeavedValueHolder()) && (registrationWizard = this._persistence_get_mediumScreenRegistrationWizard()) != this._persistence_mediumScreenRegistrationWizard_vh.getValue()) {
            this._persistence_set_mediumScreenRegistrationWizard(registrationWizard);
        }
        return this._persistence_mediumScreenRegistrationWizard_vh;
    }

    public void _persistence_set_mediumScreenRegistrationWizard_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_mediumScreenRegistrationWizard_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            RegistrationWizard registrationWizard = this._persistence_get_mediumScreenRegistrationWizard();
            if (registrationWizard != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_mediumScreenRegistrationWizard((RegistrationWizard)object);
            }
        } else {
            this.mediumScreenRegistrationWizard = null;
        }
    }

    public RegistrationWizard _persistence_get_mediumScreenRegistrationWizard() {
        this._persistence_checkFetched("mediumScreenRegistrationWizard");
        this._persistence_initialize_mediumScreenRegistrationWizard_vh();
        this.mediumScreenRegistrationWizard = (RegistrationWizard)this._persistence_mediumScreenRegistrationWizard_vh.getValue();
        return this.mediumScreenRegistrationWizard;
    }

    public void _persistence_set_mediumScreenRegistrationWizard(RegistrationWizard registrationWizard) {
        this._persistence_checkFetchedForSet("mediumScreenRegistrationWizard");
        this._persistence_initialize_mediumScreenRegistrationWizard_vh();
        this.mediumScreenRegistrationWizard = (RegistrationWizard)this._persistence_mediumScreenRegistrationWizard_vh.getValue();
        this._persistence_propertyChange("mediumScreenRegistrationWizard", this.mediumScreenRegistrationWizard, registrationWizard);
        this.mediumScreenRegistrationWizard = registrationWizard;
        this._persistence_mediumScreenRegistrationWizard_vh.setValue((Object)registrationWizard);
    }

    public Boolean _persistence_get_logServicesWritesOnly() {
        this._persistence_checkFetched("logServicesWritesOnly");
        return this.logServicesWritesOnly;
    }

    public void _persistence_set_logServicesWritesOnly(Boolean bl) {
        this._persistence_checkFetchedForSet("logServicesWritesOnly");
        this._persistence_propertyChange("logServicesWritesOnly", this.logServicesWritesOnly, bl);
        this.logServicesWritesOnly = bl;
    }

    public String _persistence_get_applicationDescription() {
        this._persistence_checkFetched("applicationDescription");
        return this.applicationDescription;
    }

    public void _persistence_set_applicationDescription(String string) {
        this._persistence_checkFetchedForSet("applicationDescription");
        this._persistence_propertyChange("applicationDescription", this.applicationDescription, string);
        this.applicationDescription = string;
    }

    public String _persistence_get_logoutUrl() {
        this._persistence_checkFetched("logoutUrl");
        return this.logoutUrl;
    }

    public void _persistence_set_logoutUrl(String string) {
        this._persistence_checkFetchedForSet("logoutUrl");
        this._persistence_propertyChange("logoutUrl", this.logoutUrl, string);
        this.logoutUrl = string;
    }

    public Date _persistence_get_imagesLastModified() {
        this._persistence_checkFetched("imagesLastModified");
        return this.imagesLastModified;
    }

    public void _persistence_set_imagesLastModified(Date date) {
        this._persistence_checkFetchedForSet("imagesLastModified");
        this._persistence_propertyChange("imagesLastModified", this.imagesLastModified, date);
        this.imagesLastModified = date;
    }

    public String _persistence_get_appleStoreUrlMobile() {
        this._persistence_checkFetched("appleStoreUrlMobile");
        return this.appleStoreUrlMobile;
    }

    public void _persistence_set_appleStoreUrlMobile(String string) {
        this._persistence_checkFetchedForSet("appleStoreUrlMobile");
        this._persistence_propertyChange("appleStoreUrlMobile", this.appleStoreUrlMobile, string);
        this.appleStoreUrlMobile = string;
    }

    public Boolean _persistence_get_emailUnique() {
        this._persistence_checkFetched("emailUnique");
        return this.emailUnique;
    }

    public void _persistence_set_emailUnique(Boolean bl) {
        this._persistence_checkFetchedForSet("emailUnique");
        this._persistence_propertyChange("emailUnique", this.emailUnique, bl);
        this.emailUnique = bl;
    }

    public Boolean _persistence_get_allowFrontendSwitching() {
        this._persistence_checkFetched("allowFrontendSwitching");
        return this.allowFrontendSwitching;
    }

    public void _persistence_set_allowFrontendSwitching(Boolean bl) {
        this._persistence_checkFetchedForSet("allowFrontendSwitching");
        this._persistence_propertyChange("allowFrontendSwitching", this.allowFrontendSwitching, bl);
        this.allowFrontendSwitching = bl;
    }

    public FrontendDashboardAccounts _persistence_get_frontendDashboardAccounts() {
        this._persistence_checkFetched("frontendDashboardAccounts");
        return this.frontendDashboardAccounts;
    }

    public void _persistence_set_frontendDashboardAccounts(FrontendDashboardAccounts frontendDashboardAccounts) {
        this._persistence_checkFetchedForSet("frontendDashboardAccounts");
        this._persistence_propertyChange("frontendDashboardAccounts", this.frontendDashboardAccounts, frontendDashboardAccounts);
        this.frontendDashboardAccounts = frontendDashboardAccounts;
    }

    public UserFormatConfiguration _persistence_get_userFormatForOthers() {
        this._persistence_checkFetched("userFormatForOthers");
        return this.userFormatForOthers;
    }

    public void _persistence_set_userFormatForOthers(UserFormatConfiguration userFormatConfiguration) {
        this._persistence_checkFetchedForSet("userFormatForOthers");
        this._persistence_propertyChange("userFormatForOthers", this.userFormatForOthers, userFormatConfiguration);
        this.userFormatForOthers = userFormatConfiguration;
    }

    public Set _persistence_get_groupsForUserDirectory() {
        this._persistence_checkFetched("groupsForUserDirectory");
        return this.groupsForUserDirectory;
    }

    public void _persistence_set_groupsForUserDirectory(Set set) {
        this._persistence_checkFetchedForSet("groupsForUserDirectory");
        this._persistence_propertyChange("groupsForUserDirectory", this.groupsForUserDirectory, set);
        this.groupsForUserDirectory = set;
    }

    public Set _persistence_get_privacyControlledCustomFields() {
        this._persistence_checkFetched("privacyControlledCustomFields");
        return this.privacyControlledCustomFields;
    }

    public void _persistence_set_privacyControlledCustomFields(Set set) {
        this._persistence_checkFetchedForSet("privacyControlledCustomFields");
        this._persistence_propertyChange("privacyControlledCustomFields", this.privacyControlledCustomFields, set);
        this.privacyControlledCustomFields = set;
    }

    public Set _persistence_get_definedProperties() {
        this._persistence_checkFetched("definedProperties");
        return this.definedProperties;
    }

    public void _persistence_set_definedProperties(Set set) {
        this._persistence_checkFetchedForSet("definedProperties");
        this._persistence_propertyChange("definedProperties", this.definedProperties, set);
        this.definedProperties = set;
    }

    public DefaultAccountHistoryPeriod _persistence_get_defaultAccountHistoryPeriod() {
        this._persistence_checkFetched("defaultAccountHistoryPeriod");
        return this.defaultAccountHistoryPeriod;
    }

    public void _persistence_set_defaultAccountHistoryPeriod(DefaultAccountHistoryPeriod defaultAccountHistoryPeriod) {
        this._persistence_checkFetchedForSet("defaultAccountHistoryPeriod");
        this._persistence_propertyChange("defaultAccountHistoryPeriod", this.defaultAccountHistoryPeriod, defaultAccountHistoryPeriod);
        this.defaultAccountHistoryPeriod = defaultAccountHistoryPeriod;
    }

    public Integer _persistence_get_maxGuestTempImages() {
        this._persistence_checkFetched("maxGuestTempImages");
        return this.maxGuestTempImages;
    }

    public void _persistence_set_maxGuestTempImages(Integer n) {
        this._persistence_checkFetchedForSet("maxGuestTempImages");
        this._persistence_propertyChange("maxGuestTempImages", this.maxGuestTempImages, n);
        this.maxGuestTempImages = n;
    }

    public CaptchaConfiguration _persistence_get_captchaConfiguration() {
        this._persistence_checkFetched("captchaConfiguration");
        return this.captchaConfiguration;
    }

    public void _persistence_set_captchaConfiguration(CaptchaConfiguration captchaConfiguration) {
        this._persistence_checkFetchedForSet("captchaConfiguration");
        this._persistence_propertyChange("captchaConfiguration", this.captchaConfiguration, captchaConfiguration);
        this.captchaConfiguration = captchaConfiguration;
    }

    public FieldVisibility _persistence_get_defaultEmailPrivacy() {
        this._persistence_checkFetched("defaultEmailPrivacy");
        return this.defaultEmailPrivacy;
    }

    public void _persistence_set_defaultEmailPrivacy(FieldVisibility fieldVisibility) {
        this._persistence_checkFetchedForSet("defaultEmailPrivacy");
        this._persistence_propertyChange("defaultEmailPrivacy", this.defaultEmailPrivacy, fieldVisibility);
        this.defaultEmailPrivacy = fieldVisibility;
    }

    public Boolean _persistence_get_frontendDashboardAds() {
        this._persistence_checkFetched("frontendDashboardAds");
        return this.frontendDashboardAds;
    }

    public void _persistence_set_frontendDashboardAds(Boolean bl) {
        this._persistence_checkFetchedForSet("frontendDashboardAds");
        this._persistence_propertyChange("frontendDashboardAds", this.frontendDashboardAds, bl);
        this.frontendDashboardAds = bl;
    }

    public Boolean _persistence_get_allowViewUserWebShop() {
        this._persistence_checkFetched("allowViewUserWebShop");
        return this.allowViewUserWebShop;
    }

    public void _persistence_set_allowViewUserWebShop(Boolean bl) {
        this._persistence_checkFetchedForSet("allowViewUserWebShop");
        this._persistence_propertyChange("allowViewUserWebShop", this.allowViewUserWebShop, bl);
        this.allowViewUserWebShop = bl;
    }

    public boolean _persistence_get_defineRootUrl() {
        this._persistence_checkFetched("defineRootUrl");
        return this.defineRootUrl;
    }

    public void _persistence_set_defineRootUrl(boolean bl) {
        this._persistence_checkFetchedForSet("defineRootUrl");
        this._persistence_propertyChange("defineRootUrl", new Boolean(this.defineRootUrl), new Boolean(bl));
        this.defineRootUrl = bl;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Integer _persistence_get_invalidPosPayerAttempts() {
        this._persistence_checkFetched("invalidPosPayerAttempts");
        return this.invalidPosPayerAttempts;
    }

    public void _persistence_set_invalidPosPayerAttempts(Integer n) {
        this._persistence_checkFetchedForSet("invalidPosPayerAttempts");
        this._persistence_propertyChange("invalidPosPayerAttempts", this.invalidPosPayerAttempts, n);
        this.invalidPosPayerAttempts = n;
    }

    public MapPreference _persistence_get_mapPreferenceMobile() {
        this._persistence_checkFetched("mapPreferenceMobile");
        return this.mapPreferenceMobile;
    }

    public void _persistence_set_mapPreferenceMobile(MapPreference mapPreference) {
        this._persistence_checkFetchedForSet("mapPreferenceMobile");
        this._persistence_propertyChange("mapPreferenceMobile", this.mapPreferenceMobile, mapPreference);
        this.mapPreferenceMobile = mapPreference;
    }

    public Boolean _persistence_get_profileImageRequired() {
        this._persistence_checkFetched("profileImageRequired");
        return this.profileImageRequired;
    }

    public void _persistence_set_profileImageRequired(Boolean bl) {
        this._persistence_checkFetchedForSet("profileImageRequired");
        this._persistence_propertyChange("profileImageRequired", this.profileImageRequired, bl);
        this.profileImageRequired = bl;
    }

    protected void _persistence_initialize_appTheme_vh() {
        if (this._persistence_appTheme_vh == null) {
            this._persistence_appTheme_vh = new ValueHolder((Object)this.appTheme);
            this._persistence_appTheme_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_appTheme_vh() {
        Theme theme;
        this._persistence_initialize_appTheme_vh();
        if ((this._persistence_appTheme_vh.isCoordinatedWithProperty() || this._persistence_appTheme_vh.isNewlyWeavedValueHolder()) && (theme = this._persistence_get_appTheme()) != this._persistence_appTheme_vh.getValue()) {
            this._persistence_set_appTheme(theme);
        }
        return this._persistence_appTheme_vh;
    }

    public void _persistence_set_appTheme_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_appTheme_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Theme theme = this._persistence_get_appTheme();
            if (theme != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_appTheme((Theme)object);
            }
        } else {
            this.appTheme = null;
        }
    }

    public Theme _persistence_get_appTheme() {
        this._persistence_checkFetched("appTheme");
        this._persistence_initialize_appTheme_vh();
        this.appTheme = (Theme)this._persistence_appTheme_vh.getValue();
        return this.appTheme;
    }

    public void _persistence_set_appTheme(Theme theme) {
        this._persistence_checkFetchedForSet("appTheme");
        this._persistence_initialize_appTheme_vh();
        this.appTheme = (Theme)this._persistence_appTheme_vh.getValue();
        this._persistence_propertyChange("appTheme", this.appTheme, theme);
        this.appTheme = theme;
        this._persistence_appTheme_vh.setValue((Object)theme);
    }

    public NumberFormat _persistence_get_numberFormat() {
        this._persistence_checkFetched("numberFormat");
        return this.numberFormat;
    }

    public void _persistence_set_numberFormat(NumberFormat numberFormat) {
        this._persistence_checkFetchedForSet("numberFormat");
        this._persistence_propertyChange("numberFormat", this.numberFormat, numberFormat);
        this.numberFormat = numberFormat;
    }

    public Boolean _persistence_get_requiredAddress() {
        this._persistence_checkFetched("requiredAddress");
        return this.requiredAddress;
    }

    public void _persistence_set_requiredAddress(Boolean bl) {
        this._persistence_checkFetchedForSet("requiredAddress");
        this._persistence_propertyChange("requiredAddress", this.requiredAddress, bl);
        this.requiredAddress = bl;
    }

    public String _persistence_get_loginUrl() {
        this._persistence_checkFetched("loginUrl");
        return this.loginUrl;
    }

    public void _persistence_set_loginUrl(String string) {
        this._persistence_checkFetchedForSet("loginUrl");
        this._persistence_propertyChange("loginUrl", this.loginUrl, string);
        this.loginUrl = string;
    }

    public UserOrderBy _persistence_get_usersSortOrder() {
        this._persistence_checkFetched("usersSortOrder");
        return this.usersSortOrder;
    }

    public void _persistence_set_usersSortOrder(UserOrderBy userOrderBy) {
        this._persistence_checkFetchedForSet("usersSortOrder");
        this._persistence_propertyChange("usersSortOrder", this.usersSortOrder, userOrderBy);
        this.usersSortOrder = userOrderBy;
    }

    protected void _persistence_initialize_smallScreenRegistrationWizard_vh() {
        if (this._persistence_smallScreenRegistrationWizard_vh == null) {
            this._persistence_smallScreenRegistrationWizard_vh = new ValueHolder((Object)this.smallScreenRegistrationWizard);
            this._persistence_smallScreenRegistrationWizard_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_smallScreenRegistrationWizard_vh() {
        RegistrationWizard registrationWizard;
        this._persistence_initialize_smallScreenRegistrationWizard_vh();
        if ((this._persistence_smallScreenRegistrationWizard_vh.isCoordinatedWithProperty() || this._persistence_smallScreenRegistrationWizard_vh.isNewlyWeavedValueHolder()) && (registrationWizard = this._persistence_get_smallScreenRegistrationWizard()) != this._persistence_smallScreenRegistrationWizard_vh.getValue()) {
            this._persistence_set_smallScreenRegistrationWizard(registrationWizard);
        }
        return this._persistence_smallScreenRegistrationWizard_vh;
    }

    public void _persistence_set_smallScreenRegistrationWizard_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_smallScreenRegistrationWizard_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            RegistrationWizard registrationWizard = this._persistence_get_smallScreenRegistrationWizard();
            if (registrationWizard != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_smallScreenRegistrationWizard((RegistrationWizard)object);
            }
        } else {
            this.smallScreenRegistrationWizard = null;
        }
    }

    public RegistrationWizard _persistence_get_smallScreenRegistrationWizard() {
        this._persistence_checkFetched("smallScreenRegistrationWizard");
        this._persistence_initialize_smallScreenRegistrationWizard_vh();
        this.smallScreenRegistrationWizard = (RegistrationWizard)this._persistence_smallScreenRegistrationWizard_vh.getValue();
        return this.smallScreenRegistrationWizard;
    }

    public void _persistence_set_smallScreenRegistrationWizard(RegistrationWizard registrationWizard) {
        this._persistence_checkFetchedForSet("smallScreenRegistrationWizard");
        this._persistence_initialize_smallScreenRegistrationWizard_vh();
        this.smallScreenRegistrationWizard = (RegistrationWizard)this._persistence_smallScreenRegistrationWizard_vh.getValue();
        this._persistence_propertyChange("smallScreenRegistrationWizard", this.smallScreenRegistrationWizard, registrationWizard);
        this.smallScreenRegistrationWizard = registrationWizard;
        this._persistence_smallScreenRegistrationWizard_vh.setValue((Object)registrationWizard);
    }

    public Dimensions _persistence_get_maxMediumThumbDimensions() {
        this._persistence_checkFetched("maxMediumThumbDimensions");
        return this.maxMediumThumbDimensions;
    }

    public void _persistence_set_maxMediumThumbDimensions(Dimensions dimensions) {
        this._persistence_checkFetchedForSet("maxMediumThumbDimensions");
        this._persistence_propertyChange("maxMediumThumbDimensions", this.maxMediumThumbDimensions, dimensions);
        this.maxMediumThumbDimensions = dimensions;
    }

    protected void _persistence_initialize_largeScreenRegistrationWizard_vh() {
        if (this._persistence_largeScreenRegistrationWizard_vh == null) {
            this._persistence_largeScreenRegistrationWizard_vh = new ValueHolder((Object)this.largeScreenRegistrationWizard);
            this._persistence_largeScreenRegistrationWizard_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_largeScreenRegistrationWizard_vh() {
        RegistrationWizard registrationWizard;
        this._persistence_initialize_largeScreenRegistrationWizard_vh();
        if ((this._persistence_largeScreenRegistrationWizard_vh.isCoordinatedWithProperty() || this._persistence_largeScreenRegistrationWizard_vh.isNewlyWeavedValueHolder()) && (registrationWizard = this._persistence_get_largeScreenRegistrationWizard()) != this._persistence_largeScreenRegistrationWizard_vh.getValue()) {
            this._persistence_set_largeScreenRegistrationWizard(registrationWizard);
        }
        return this._persistence_largeScreenRegistrationWizard_vh;
    }

    public void _persistence_set_largeScreenRegistrationWizard_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_largeScreenRegistrationWizard_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            RegistrationWizard registrationWizard = this._persistence_get_largeScreenRegistrationWizard();
            if (registrationWizard != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_largeScreenRegistrationWizard((RegistrationWizard)object);
            }
        } else {
            this.largeScreenRegistrationWizard = null;
        }
    }

    public RegistrationWizard _persistence_get_largeScreenRegistrationWizard() {
        this._persistence_checkFetched("largeScreenRegistrationWizard");
        this._persistence_initialize_largeScreenRegistrationWizard_vh();
        this.largeScreenRegistrationWizard = (RegistrationWizard)this._persistence_largeScreenRegistrationWizard_vh.getValue();
        return this.largeScreenRegistrationWizard;
    }

    public void _persistence_set_largeScreenRegistrationWizard(RegistrationWizard registrationWizard) {
        this._persistence_checkFetchedForSet("largeScreenRegistrationWizard");
        this._persistence_initialize_largeScreenRegistrationWizard_vh();
        this.largeScreenRegistrationWizard = (RegistrationWizard)this._persistence_largeScreenRegistrationWizard_vh.getValue();
        this._persistence_propertyChange("largeScreenRegistrationWizard", this.largeScreenRegistrationWizard, registrationWizard);
        this.largeScreenRegistrationWizard = registrationWizard;
        this._persistence_largeScreenRegistrationWizard_vh.setValue((Object)registrationWizard);
    }

    public Set _persistence_get_channelConfigurations() {
        this._persistence_checkFetched("channelConfigurations");
        return this.channelConfigurations;
    }

    public void _persistence_set_channelConfigurations(Set set) {
        this._persistence_checkFetchedForSet("channelConfigurations");
        this._persistence_propertyChange("channelConfigurations", this.channelConfigurations, set);
        this.channelConfigurations = set;
    }

    public BasicProfileField _persistence_get_basicProfileFieldInAccountTitle() {
        this._persistence_checkFetched("basicProfileFieldInAccountTitle");
        return this.basicProfileFieldInAccountTitle;
    }

    public void _persistence_set_basicProfileFieldInAccountTitle(BasicProfileField basicProfileField) {
        this._persistence_checkFetchedForSet("basicProfileFieldInAccountTitle");
        this._persistence_propertyChange("basicProfileFieldInAccountTitle", this.basicProfileFieldInAccountTitle, basicProfileField);
        this.basicProfileFieldInAccountTitle = basicProfileField;
    }

    public String _persistence_get_timeZoneId() {
        this._persistence_checkFetched("timeZoneId");
        return this.timeZoneId;
    }

    public void _persistence_set_timeZoneId(String string) {
        this._persistence_checkFetchedForSet("timeZoneId");
        this._persistence_propertyChange("timeZoneId", this.timeZoneId, string);
        this.timeZoneId = string;
    }

    public String _persistence_get_defaultRegion() {
        this._persistence_checkFetched("defaultRegion");
        return this.defaultRegion;
    }

    public void _persistence_set_defaultRegion(String string) {
        this._persistence_checkFetchedForSet("defaultRegion");
        this._persistence_propertyChange("defaultRegion", this.defaultRegion, string);
        this.defaultRegion = string;
    }

    public Boolean _persistence_get_frontendMenuBar() {
        this._persistence_checkFetched("frontendMenuBar");
        return this.frontendMenuBar;
    }

    public void _persistence_set_frontendMenuBar(Boolean bl) {
        this._persistence_checkFetchedForSet("frontendMenuBar");
        this._persistence_propertyChange("frontendMenuBar", this.frontendMenuBar, bl);
        this.frontendMenuBar = bl;
    }

    public Date _persistence_get_sitemapLastModified() {
        this._persistence_checkFetched("sitemapLastModified");
        return this.sitemapLastModified;
    }

    public void _persistence_set_sitemapLastModified(Date date) {
        this._persistence_checkFetchedForSet("sitemapLastModified");
        this._persistence_propertyChange("sitemapLastModified", this.sitemapLastModified, date);
        this.sitemapLastModified = date;
    }

    public String _persistence_get_mapBrowserApiKey() {
        this._persistence_checkFetched("mapBrowserApiKey");
        return this.mapBrowserApiKey;
    }

    public void _persistence_set_mapBrowserApiKey(String string) {
        this._persistence_checkFetchedForSet("mapBrowserApiKey");
        this._persistence_propertyChange("mapBrowserApiKey", this.mapBrowserApiKey, string);
        this.mapBrowserApiKey = string;
    }

    public Set _persistence_get_possibleInitialGroups() {
        this._persistence_checkFetched("possibleInitialGroups");
        return this.possibleInitialGroups;
    }

    public void _persistence_set_possibleInitialGroups(Set set) {
        this._persistence_checkFetchedForSet("possibleInitialGroups");
        this._persistence_propertyChange("possibleInitialGroups", this.possibleInitialGroups, set);
        this.possibleInitialGroups = set;
    }

    public DefaultConfigurationType _persistence_get_defaultType() {
        this._persistence_checkFetched("defaultType");
        return this.defaultType;
    }

    public void _persistence_set_defaultType(DefaultConfigurationType defaultConfigurationType) {
        this._persistence_checkFetchedForSet("defaultType");
        this._persistence_propertyChange("defaultType", this.defaultType, defaultConfigurationType);
        this.defaultType = defaultConfigurationType;
    }

    public SmtpConfiguration _persistence_get_smtpConfiguration() {
        this._persistence_checkFetched("smtpConfiguration");
        return this.smtpConfiguration;
    }

    public void _persistence_set_smtpConfiguration(SmtpConfiguration smtpConfiguration) {
        this._persistence_checkFetchedForSet("smtpConfiguration");
        this._persistence_propertyChange("smtpConfiguration", this.smtpConfiguration, smtpConfiguration);
        this.smtpConfiguration = smtpConfiguration;
    }

    protected void _persistence_initialize_guestsTheme_vh() {
        if (this._persistence_guestsTheme_vh == null) {
            this._persistence_guestsTheme_vh = new ValueHolder((Object)this.guestsTheme);
            this._persistence_guestsTheme_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_guestsTheme_vh() {
        Theme theme;
        this._persistence_initialize_guestsTheme_vh();
        if ((this._persistence_guestsTheme_vh.isCoordinatedWithProperty() || this._persistence_guestsTheme_vh.isNewlyWeavedValueHolder()) && (theme = this._persistence_get_guestsTheme()) != this._persistence_guestsTheme_vh.getValue()) {
            this._persistence_set_guestsTheme(theme);
        }
        return this._persistence_guestsTheme_vh;
    }

    public void _persistence_set_guestsTheme_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_guestsTheme_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Theme theme = this._persistence_get_guestsTheme();
            if (theme != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_guestsTheme((Theme)object);
            }
        } else {
            this.guestsTheme = null;
        }
    }

    public Theme _persistence_get_guestsTheme() {
        this._persistence_checkFetched("guestsTheme");
        this._persistence_initialize_guestsTheme_vh();
        this.guestsTheme = (Theme)this._persistence_guestsTheme_vh.getValue();
        return this.guestsTheme;
    }

    public void _persistence_set_guestsTheme(Theme theme) {
        this._persistence_checkFetchedForSet("guestsTheme");
        this._persistence_initialize_guestsTheme_vh();
        this.guestsTheme = (Theme)this._persistence_guestsTheme_vh.getValue();
        this._persistence_propertyChange("guestsTheme", this.guestsTheme, theme);
        this.guestsTheme = theme;
        this._persistence_guestsTheme_vh.setValue((Object)theme);
    }

    public Integer _persistence_get_maxBlockedUsers() {
        this._persistence_checkFetched("maxBlockedUsers");
        return this.maxBlockedUsers;
    }

    public void _persistence_set_maxBlockedUsers(Integer n) {
        this._persistence_checkFetchedForSet("maxBlockedUsers");
        this._persistence_propertyChange("maxBlockedUsers", this.maxBlockedUsers, n);
        this.maxBlockedUsers = n;
    }

    public Date _persistence_get_apiDescriptorLastModified() {
        this._persistence_checkFetched("apiDescriptorLastModified");
        return this.apiDescriptorLastModified;
    }

    public void _persistence_set_apiDescriptorLastModified(Date date) {
        this._persistence_checkFetchedForSet("apiDescriptorLastModified");
        this._persistence_propertyChange("apiDescriptorLastModified", this.apiDescriptorLastModified, date);
        this.apiDescriptorLastModified = date;
    }

    public Set _persistence_get_allowedLanguages() {
        this._persistence_checkFetched("allowedLanguages");
        return this.allowedLanguages;
    }

    public void _persistence_set_allowedLanguages(Set set) {
        this._persistence_checkFetchedForSet("allowedLanguages");
        this._persistence_propertyChange("allowedLanguages", this.allowedLanguages, set);
        this.allowedLanguages = set;
    }

    public AccountNumberConfiguration _persistence_get_accountNumberConfiguration() {
        this._persistence_checkFetched("accountNumberConfiguration");
        return this.accountNumberConfiguration;
    }

    public void _persistence_set_accountNumberConfiguration(AccountNumberConfiguration accountNumberConfiguration) {
        this._persistence_checkFetchedForSet("accountNumberConfiguration");
        this._persistence_propertyChange("accountNumberConfiguration", this.accountNumberConfiguration, accountNumberConfiguration);
        this.accountNumberConfiguration = accountNumberConfiguration;
    }

    public TimeFormat _persistence_get_timeFormat() {
        this._persistence_checkFetched("timeFormat");
        return this.timeFormat;
    }

    public void _persistence_set_timeFormat(TimeFormat timeFormat) {
        this._persistence_checkFetchedForSet("timeFormat");
        this._persistence_propertyChange("timeFormat", this.timeFormat, timeFormat);
        this.timeFormat = timeFormat;
    }

    public Set _persistence_get_groupsForUserSearchInMenu() {
        this._persistence_checkFetched("groupsForUserSearchInMenu");
        return this.groupsForUserSearchInMenu;
    }

    public void _persistence_set_groupsForUserSearchInMenu(Set set) {
        this._persistence_checkFetchedForSet("groupsForUserSearchInMenu");
        this._persistence_propertyChange("groupsForUserSearchInMenu", this.groupsForUserSearchInMenu, set);
        this.groupsForUserSearchInMenu = set;
    }

    public CustomScriptConfiguration _persistence_get_phoneNumberHandlingConfiguration() {
        this._persistence_checkFetched("phoneNumberHandlingConfiguration");
        return this.phoneNumberHandlingConfiguration;
    }

    public void _persistence_set_phoneNumberHandlingConfiguration(CustomScriptConfiguration customScriptConfiguration) {
        this._persistence_checkFetchedForSet("phoneNumberHandlingConfiguration");
        this._persistence_propertyChange("phoneNumberHandlingConfiguration", this.phoneNumberHandlingConfiguration, customScriptConfiguration);
        this.phoneNumberHandlingConfiguration = customScriptConfiguration;
    }

    public String _persistence_get_mapServerApiKey() {
        this._persistence_checkFetched("mapServerApiKey");
        return this.mapServerApiKey;
    }

    public void _persistence_set_mapServerApiKey(String string) {
        this._persistence_checkFetchedForSet("mapServerApiKey");
        this._persistence_propertyChange("mapServerApiKey", this.mapServerApiKey, string);
        this.mapServerApiKey = string;
    }

    public IpGeolocationConfiguration _persistence_get_ipGeolocationConfiguration() {
        this._persistence_checkFetched("ipGeolocationConfiguration");
        return this.ipGeolocationConfiguration;
    }

    public void _persistence_set_ipGeolocationConfiguration(IpGeolocationConfiguration ipGeolocationConfiguration) {
        this._persistence_checkFetchedForSet("ipGeolocationConfiguration");
        this._persistence_propertyChange("ipGeolocationConfiguration", this.ipGeolocationConfiguration, ipGeolocationConfiguration);
        this.ipGeolocationConfiguration = ipGeolocationConfiguration;
    }

    public FieldVisibility _persistence_get_defaultAddressPrivacy() {
        this._persistence_checkFetched("defaultAddressPrivacy");
        return this.defaultAddressPrivacy;
    }

    public void _persistence_set_defaultAddressPrivacy(FieldVisibility fieldVisibility) {
        this._persistence_checkFetchedForSet("defaultAddressPrivacy");
        this._persistence_propertyChange("defaultAddressPrivacy", this.defaultAddressPrivacy, fieldVisibility);
        this.defaultAddressPrivacy = fieldVisibility;
    }

    public AdOrderBy _persistence_get_adsSortOrder() {
        this._persistence_checkFetched("adsSortOrder");
        return this.adsSortOrder;
    }

    public void _persistence_set_adsSortOrder(AdOrderBy adOrderBy) {
        this._persistence_checkFetchedForSet("adsSortOrder");
        this._persistence_propertyChange("adsSortOrder", this.adsSortOrder, adOrderBy);
        this.adsSortOrder = adOrderBy;
    }

    public FileSize _persistence_get_maxPngSize() {
        this._persistence_checkFetched("maxPngSize");
        return this.maxPngSize;
    }

    public void _persistence_set_maxPngSize(FileSize fileSize) {
        this._persistence_checkFetchedForSet("maxPngSize");
        this._persistence_propertyChange("maxPngSize", this.maxPngSize, fileSize);
        this.maxPngSize = fileSize;
    }

    public Frontend _persistence_get_frontend() {
        this._persistence_checkFetched("frontend");
        return this.frontend;
    }

    public void _persistence_set_frontend(Frontend frontend) {
        this._persistence_checkFetchedForSet("frontend");
        this._persistence_propertyChange("frontend", this.frontend, frontend);
        this.frontend = frontend;
    }
}

