/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationOrderableEntity;
import org.cyclos.entities.HasSvgIcon;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.system.CustomOperationAction;
import org.cyclos.entities.system.CustomOperationField;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.AppMailingBulkAction;
import org.cyclos.entities.users.MemberProductCustomOperation;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.operations.CustomOperationResultPageRowAction;
import org.cyclos.model.system.operations.CustomOperationResultType;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationShowForm;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.utils.AdminMainMenu;
import org.cyclos.model.utils.FrontendMenu;
import org.cyclos.model.utils.Location;
import org.cyclos.model.utils.ProfileManagementSection;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="custom_operations")
public class CustomOperation
extends ConfigurationOrderableEntity
implements HasSvgIcon,
DefinesNetwork,
HasContentScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="label")
    private String label;
    @Basic
    @Column(name="svg_icon")
    private String svgIcon;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Lob
    @Column(name="information_text")
    private String informationText;
    @Basic
    @Lob
    @Column(name="result_information_text")
    private String resultInformationText;
    @Basic
    @Lob
    @Column(name="confirmation_text")
    private String confirmationText;
    @Basic
    @Column(name="submit_with_qr_code_scan")
    private Boolean submitWithQrCodeScan;
    @Basic
    @Column(name="custom_submit_label")
    private String customSubmitLabel;
    @ManyToMany
    @JoinTable(name="custom_operations_channels", joinColumns={@JoinColumn(name="custom_operation_id")}, inverseJoinColumns={@JoinColumn(name="channel_id")})
    private Set<Channel> channels = new HashSet<Channel>();
    @Basic
    @Column(name="icon")
    private String icon;
    @Basic
    @Column(name="open_row_in_new_window")
    private Boolean openRowInNewWindow;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="scope")
    @ReadOnlyFromDTO(onInsert=false)
    private CustomOperationScope scope;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="script_id", nullable=false)
    private CustomScript script;
    @Basic
    @Lob
    @Column(name="script_parameters")
    private String scriptParameters;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="result_type")
    private CustomOperationResultType resultType;
    @Basic
    @Column(name="has_file_upload")
    private Boolean hasFileUpload;
    @Basic
    @Column(name="search_automatically")
    private Boolean searchAutomatically;
    @Basic
    @Column(name="allow_print")
    private Boolean allowPrint;
    @Basic
    @Column(name="allow_export")
    private Boolean allowExport;
    @Basic
    @Column(name="require_confirmation_credential")
    private Boolean requireConfirmationCredential;
    @Basic
    @Column(name="close_after_seconds")
    private Integer closeAfterSeconds;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="show_form")
    private CustomOperationShowForm showForm;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="frontend_menu")
    private FrontendMenu frontendMenu;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="admin_menu")
    private AdminMainMenu adminMenu;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="user_menu")
    private UserMainMenu userMenu;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="profile_section")
    private ProfileManagementSection profileSection;
    @Basic
    @Column(name="row_url")
    private String rowUrl;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="row_location")
    private Location rowLocation;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="row_operation_id")
    private CustomOperation rowOperation;
    @Basic
    @Column(name="row_parameters")
    private String rowParameters;
    @Basic
    @Column(name="enabled_active_users")
    private Boolean enabledForActiveUsers;
    @Basic
    @Column(name="enabled_pending_users")
    private Boolean enabledForPendingUsers;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="content_script_id")
    private CustomScript contentScript;
    @Basic
    @Lob
    @Column(name="content_script_parameters")
    private String contentScriptParameters;
    @OneToMany(mappedBy="customOperation", cascade={CascadeType.REMOVE})
    @OrderBy(value="order ASC")
    private List<CustomOperationField> formParameters = new ArrayList<CustomOperationField>();
    @OneToMany(mappedBy="customOperation", cascade={CascadeType.REMOVE})
    private Set<AppMailingBulkAction> appMailingBulkActions;
    @ManyToMany
    @JoinTable(name="custom_operations_record_types", joinColumns={@JoinColumn(name="custom_operation_id")}, inverseJoinColumns={@JoinColumn(name="record_type_id")})
    private Set<RecordType> recordTypes = new HashSet<RecordType>();
    @ManyToMany
    @JoinTable(name="custom_operations_transfer_types", joinColumns={@JoinColumn(name="custom_operation_id")}, inverseJoinColumns={@JoinColumn(name="transfer_type_id")})
    private Set<TransferType> transferTypes = new HashSet<TransferType>();
    @OneToMany(mappedBy="ownerOperation", cascade={CascadeType.REMOVE})
    private Set<CustomOperationAction> actions = new HashSet<CustomOperationAction>();
    @ManyToMany(mappedBy="systemCustomOperationsRun")
    private Set<AdminProduct> adminProducts;
    @ManyToMany(mappedBy="userCustomOperationsRun")
    private Set<UserManagementProduct> userManagementProducts;
    @OneToMany(mappedBy="customOperation", cascade={CascadeType.REMOVE})
    private Set<MemberProductCustomOperation> memberProducts;
    @OneToMany(mappedBy="actionOperation", cascade={CascadeType.REMOVE})
    private Set<CustomOperationAction> usedAsActions;
    @ManyToMany(mappedBy="runTransferCustomOperations")
    private Set<Product> productsRunTransfer;
    static final long serialVersionUID = 3101603074103292625L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_script_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_contentScript_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_rowOperation_vh;

    public Set<CustomOperationAction> getActions() {
        return this._persistence_get_actions();
    }

    public AdminMainMenu getAdminMenu() {
        return this._persistence_get_adminMenu();
    }

    public Set<Channel> getChannels() {
        return this._persistence_get_channels();
    }

    public Integer getCloseAfterSeconds() {
        return this._persistence_get_closeAfterSeconds();
    }

    public String getConfirmationText() {
        return this._persistence_get_confirmationText();
    }

    @Override
    public CustomScript getContentScript() {
        return this._persistence_get_contentScript();
    }

    @Override
    public String getContentScriptParameters() {
        return this._persistence_get_contentScriptParameters();
    }

    public String getCustomSubmitLabel() {
        return this._persistence_get_customSubmitLabel();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.CUSTOM_OPERATIONS;
    }

    public List<CustomOperationField> getFormParameters() {
        return this._persistence_get_formParameters();
    }

    public FrontendMenu getFrontendMenu() {
        return this._persistence_get_frontendMenu();
    }

    public String getIcon() {
        return this._persistence_get_icon();
    }

    public String getInformationText() {
        return this._persistence_get_informationText();
    }

    public String getLabel() {
        return this._persistence_get_label();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public ProfileManagementSection getProfileSection() {
        return this._persistence_get_profileSection();
    }

    public Set<RecordType> getRecordTypes() {
        return this._persistence_get_recordTypes();
    }

    public String getResultInformationText() {
        return this._persistence_get_resultInformationText();
    }

    public CustomOperationResultType getResultType() {
        return this._persistence_get_resultType();
    }

    public CustomOperationResultPageRowAction getRowAction() {
        if (this._persistence_get_resultType() == CustomOperationResultType.RESULT_PAGE) {
            if (this._persistence_get_rowUrl() != null) {
                return CustomOperationResultPageRowAction.URL;
            }
            if (this._persistence_get_rowLocation() != null) {
                return CustomOperationResultPageRowAction.LOCATION;
            }
            if (this._persistence_get_rowOperation() != null) {
                return CustomOperationResultPageRowAction.OPERATION;
            }
        }
        return null;
    }

    public Location getRowLocation() {
        return this._persistence_get_rowLocation();
    }

    public CustomOperation getRowOperation() {
        return this._persistence_get_rowOperation();
    }

    public List<String> getRowParameters() {
        if (StringHelper.isBlank((Object)this._persistence_get_rowParameters())) {
            return Collections.emptyList();
        }
        return StringHelper.splitTrimming((String)this._persistence_get_rowParameters(), (String)",");
    }

    public String getRowUrl() {
        return this._persistence_get_rowUrl();
    }

    public CustomOperationScope getScope() {
        return this._persistence_get_scope();
    }

    public CustomScript getScript() {
        return this._persistence_get_script();
    }

    public String getScriptParameters() {
        return this._persistence_get_scriptParameters();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.OPERATION;
    }

    public CustomOperationShowForm getShowForm() {
        return this._persistence_get_showForm();
    }

    @Override
    public String getSvgIcon() {
        return this._persistence_get_svgIcon();
    }

    public Set<TransferType> getTransferTypes() {
        return this._persistence_get_transferTypes();
    }

    public UserMainMenu getUserMenu() {
        return this._persistence_get_userMenu();
    }

    public boolean isAllowExport() {
        return Boolean.TRUE.equals(this._persistence_get_allowExport());
    }

    public boolean isAllowPrint() {
        return Boolean.TRUE.equals(this._persistence_get_allowPrint());
    }

    public boolean isEnabled() {
        return CollectionHelper.isNotEmpty((Iterable)this._persistence_get_channels());
    }

    public boolean isEnabledForActiveUsers() {
        return Boolean.TRUE.equals(this._persistence_get_enabledForActiveUsers());
    }

    public boolean isEnabledForPendingUsers() {
        return Boolean.TRUE.equals(this._persistence_get_enabledForPendingUsers());
    }

    public boolean isHasFileUpload() {
        return Boolean.TRUE.equals(this._persistence_get_hasFileUpload());
    }

    public boolean isOpenRowInNewWindow() {
        return Boolean.TRUE.equals(this._persistence_get_openRowInNewWindow());
    }

    public boolean isRequireConfirmationCredential() {
        return Boolean.TRUE.equals(this._persistence_get_requireConfirmationCredential());
    }

    public boolean isSearchAutomatically() {
        return Boolean.TRUE.equals(this._persistence_get_searchAutomatically());
    }

    public boolean isSubmitWithQrCodeScan() {
        return Boolean.TRUE.equals(this._persistence_get_submitWithQrCodeScan());
    }

    public void setActions(Set<CustomOperationAction> set) {
        this._persistence_set_actions(set);
    }

    public void setAdminMenu(AdminMainMenu adminMainMenu) {
        this._persistence_set_adminMenu(adminMainMenu);
    }

    public void setAllowExport(boolean bl) {
        this._persistence_set_allowExport(bl);
    }

    public void setAllowPrint(boolean bl) {
        this._persistence_set_allowPrint(bl);
    }

    public void setChannels(Set<Channel> set) {
        this._persistence_set_channels(set);
    }

    public void setCloseAfterSeconds(Integer n) {
        this._persistence_set_closeAfterSeconds(n);
    }

    public void setConfirmationText(String string) {
        this._persistence_set_confirmationText(string);
    }

    public void setContentScript(CustomScript customScript) {
        this._persistence_set_contentScript(customScript);
    }

    public void setContentScriptParameters(String string) {
        this._persistence_set_contentScriptParameters(string);
    }

    public void setCustomSubmitLabel(String string) {
        this._persistence_set_customSubmitLabel(string);
    }

    public void setEnabledForActiveUsers(boolean bl) {
        this._persistence_set_enabledForActiveUsers(bl);
    }

    public void setEnabledForPendingUsers(boolean bl) {
        this._persistence_set_enabledForPendingUsers(bl);
    }

    public void setFrontendMenu(FrontendMenu frontendMenu) {
        this._persistence_set_frontendMenu(frontendMenu);
    }

    public void setHasFileUpload(boolean bl) {
        this._persistence_set_hasFileUpload(bl);
    }

    public void setIcon(String string) {
        this._persistence_set_icon(string);
    }

    public void setInformationText(String string) {
        this._persistence_set_informationText(string);
    }

    public void setLabel(String string) {
        this._persistence_set_label(string);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setOpenRowInNewWindow(boolean bl) {
        this._persistence_set_openRowInNewWindow(bl);
    }

    public void setProfileSection(ProfileManagementSection profileManagementSection) {
        this._persistence_set_profileSection(profileManagementSection);
    }

    public void setRecordTypes(Set<RecordType> set) {
        this._persistence_set_recordTypes(set);
    }

    public void setRequireConfirmationCredential(boolean bl) {
        this._persistence_set_requireConfirmationCredential(bl);
    }

    public void setResultInformationText(String string) {
        this._persistence_set_resultInformationText(string);
    }

    public void setResultType(CustomOperationResultType customOperationResultType) {
        this._persistence_set_resultType(customOperationResultType);
    }

    public void setRowLocation(Location location) {
        this._persistence_set_rowLocation(location);
    }

    public void setRowOperation(CustomOperation customOperation) {
        this._persistence_set_rowOperation(customOperation);
    }

    public void setRowParameters(List<String> list) {
        if (CollectionHelper.isEmpty(list)) {
            this._persistence_set_rowParameters(null);
        } else {
            Collections.sort(list);
            this._persistence_set_rowParameters(StringHelper.joinTrimming(list, (String)","));
        }
    }

    public void setRowUrl(String string) {
        this._persistence_set_rowUrl(string);
    }

    public void setScope(CustomOperationScope customOperationScope) {
        this._persistence_set_scope(customOperationScope);
    }

    public void setScript(CustomScript customScript) {
        this._persistence_set_script(customScript);
    }

    public void setScriptParameters(String string) {
        this._persistence_set_scriptParameters(string);
    }

    public void setSearchAutomatically(boolean bl) {
        this._persistence_set_searchAutomatically(bl);
    }

    public void setShowForm(CustomOperationShowForm customOperationShowForm) {
        this._persistence_set_showForm(customOperationShowForm);
    }

    public void setSubmitWithQrCodeScan(boolean bl) {
        this._persistence_set_submitWithQrCodeScan(bl);
    }

    @Override
    public void setSvgIcon(String string) {
        this._persistence_set_svgIcon(string);
    }

    public void setTransferTypes(Set<TransferType> set) {
        this._persistence_set_transferTypes(set);
    }

    public void setUserMenu(UserMainMenu userMainMenu) {
        this._persistence_set_userMenu(userMainMenu);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_script_vh != null) {
            this._persistence_script_vh = (WeavedAttributeValueHolderInterface)this._persistence_script_vh.clone();
        }
        if (this._persistence_contentScript_vh != null) {
            this._persistence_contentScript_vh = (WeavedAttributeValueHolderInterface)this._persistence_contentScript_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_rowOperation_vh != null) {
            this._persistence_rowOperation_vh = (WeavedAttributeValueHolderInterface)this._persistence_rowOperation_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomOperation();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "adminMenu") {
            return this.adminMenu;
        }
        if (string == "closeAfterSeconds") {
            return this.closeAfterSeconds;
        }
        if (string == "frontendMenu") {
            return this.frontendMenu;
        }
        if (string == "rowLocation") {
            return this.rowLocation;
        }
        if (string == "confirmationText") {
            return this.confirmationText;
        }
        if (string == "userManagementProducts") {
            return this.userManagementProducts;
        }
        if (string == "transferTypes") {
            return this.transferTypes;
        }
        if (string == "enabledForPendingUsers") {
            return this.enabledForPendingUsers;
        }
        if (string == "resultType") {
            return this.resultType;
        }
        if (string == "formParameters") {
            return this.formParameters;
        }
        if (string == "adminProducts") {
            return this.adminProducts;
        }
        if (string == "showForm") {
            return this.showForm;
        }
        if (string == "script") {
            return this.script;
        }
        if (string == "channels") {
            return this.channels;
        }
        if (string == "usedAsActions") {
            return this.usedAsActions;
        }
        if (string == "resultInformationText") {
            return this.resultInformationText;
        }
        if (string == "contentScript") {
            return this.contentScript;
        }
        if (string == "searchAutomatically") {
            return this.searchAutomatically;
        }
        if (string == "rowParameters") {
            return this.rowParameters;
        }
        if (string == "actions") {
            return this.actions;
        }
        if (string == "submitWithQrCodeScan") {
            return this.submitWithQrCodeScan;
        }
        if (string == "enabledForActiveUsers") {
            return this.enabledForActiveUsers;
        }
        if (string == "recordTypes") {
            return this.recordTypes;
        }
        if (string == "icon") {
            return this.icon;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "userMenu") {
            return this.userMenu;
        }
        if (string == "allowPrint") {
            return this.allowPrint;
        }
        if (string == "scope") {
            return this.scope;
        }
        if (string == "memberProducts") {
            return this.memberProducts;
        }
        if (string == "rowOperation") {
            return this.rowOperation;
        }
        if (string == "productsRunTransfer") {
            return this.productsRunTransfer;
        }
        if (string == "informationText") {
            return this.informationText;
        }
        if (string == "requireConfirmationCredential") {
            return this.requireConfirmationCredential;
        }
        if (string == "allowExport") {
            return this.allowExport;
        }
        if (string == "rowUrl") {
            return this.rowUrl;
        }
        if (string == "label") {
            return this.label;
        }
        if (string == "svgIcon") {
            return this.svgIcon;
        }
        if (string == "appMailingBulkActions") {
            return this.appMailingBulkActions;
        }
        if (string == "contentScriptParameters") {
            return this.contentScriptParameters;
        }
        if (string == "customSubmitLabel") {
            return this.customSubmitLabel;
        }
        if (string == "scriptParameters") {
            return this.scriptParameters;
        }
        if (string == "profileSection") {
            return this.profileSection;
        }
        if (string == "openRowInNewWindow") {
            return this.openRowInNewWindow;
        }
        if (string == "hasFileUpload") {
            return this.hasFileUpload;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "adminMenu") {
            this.adminMenu = (AdminMainMenu)object;
            return;
        }
        if (string == "closeAfterSeconds") {
            this.closeAfterSeconds = (Integer)object;
            return;
        }
        if (string == "frontendMenu") {
            this.frontendMenu = (FrontendMenu)object;
            return;
        }
        if (string == "rowLocation") {
            this.rowLocation = (Location)object;
            return;
        }
        if (string == "confirmationText") {
            this.confirmationText = (String)object;
            return;
        }
        if (string == "userManagementProducts") {
            this.userManagementProducts = (Set)object;
            return;
        }
        if (string == "transferTypes") {
            this.transferTypes = (Set)object;
            return;
        }
        if (string == "enabledForPendingUsers") {
            this.enabledForPendingUsers = (Boolean)object;
            return;
        }
        if (string == "resultType") {
            this.resultType = (CustomOperationResultType)object;
            return;
        }
        if (string == "formParameters") {
            this.formParameters = (List)object;
            return;
        }
        if (string == "adminProducts") {
            this.adminProducts = (Set)object;
            return;
        }
        if (string == "showForm") {
            this.showForm = (CustomOperationShowForm)object;
            return;
        }
        if (string == "script") {
            this.script = (CustomScript)object;
            return;
        }
        if (string == "channels") {
            this.channels = (Set)object;
            return;
        }
        if (string == "usedAsActions") {
            this.usedAsActions = (Set)object;
            return;
        }
        if (string == "resultInformationText") {
            this.resultInformationText = (String)object;
            return;
        }
        if (string == "contentScript") {
            this.contentScript = (CustomScript)object;
            return;
        }
        if (string == "searchAutomatically") {
            this.searchAutomatically = (Boolean)object;
            return;
        }
        if (string == "rowParameters") {
            this.rowParameters = (String)object;
            return;
        }
        if (string == "actions") {
            this.actions = (Set)object;
            return;
        }
        if (string == "submitWithQrCodeScan") {
            this.submitWithQrCodeScan = (Boolean)object;
            return;
        }
        if (string == "enabledForActiveUsers") {
            this.enabledForActiveUsers = (Boolean)object;
            return;
        }
        if (string == "recordTypes") {
            this.recordTypes = (Set)object;
            return;
        }
        if (string == "icon") {
            this.icon = (String)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "userMenu") {
            this.userMenu = (UserMainMenu)object;
            return;
        }
        if (string == "allowPrint") {
            this.allowPrint = (Boolean)object;
            return;
        }
        if (string == "scope") {
            this.scope = (CustomOperationScope)object;
            return;
        }
        if (string == "memberProducts") {
            this.memberProducts = (Set)object;
            return;
        }
        if (string == "rowOperation") {
            this.rowOperation = (CustomOperation)object;
            return;
        }
        if (string == "productsRunTransfer") {
            this.productsRunTransfer = (Set)object;
            return;
        }
        if (string == "informationText") {
            this.informationText = (String)object;
            return;
        }
        if (string == "requireConfirmationCredential") {
            this.requireConfirmationCredential = (Boolean)object;
            return;
        }
        if (string == "allowExport") {
            this.allowExport = (Boolean)object;
            return;
        }
        if (string == "rowUrl") {
            this.rowUrl = (String)object;
            return;
        }
        if (string == "label") {
            this.label = (String)object;
            return;
        }
        if (string == "svgIcon") {
            this.svgIcon = (String)object;
            return;
        }
        if (string == "appMailingBulkActions") {
            this.appMailingBulkActions = (Set)object;
            return;
        }
        if (string == "contentScriptParameters") {
            this.contentScriptParameters = (String)object;
            return;
        }
        if (string == "customSubmitLabel") {
            this.customSubmitLabel = (String)object;
            return;
        }
        if (string == "scriptParameters") {
            this.scriptParameters = (String)object;
            return;
        }
        if (string == "profileSection") {
            this.profileSection = (ProfileManagementSection)object;
            return;
        }
        if (string == "openRowInNewWindow") {
            this.openRowInNewWindow = (Boolean)object;
            return;
        }
        if (string == "hasFileUpload") {
            this.hasFileUpload = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public AdminMainMenu _persistence_get_adminMenu() {
        this._persistence_checkFetched("adminMenu");
        return this.adminMenu;
    }

    public void _persistence_set_adminMenu(AdminMainMenu adminMainMenu) {
        this._persistence_checkFetchedForSet("adminMenu");
        this._persistence_propertyChange("adminMenu", this.adminMenu, adminMainMenu);
        this.adminMenu = adminMainMenu;
    }

    public Integer _persistence_get_closeAfterSeconds() {
        this._persistence_checkFetched("closeAfterSeconds");
        return this.closeAfterSeconds;
    }

    public void _persistence_set_closeAfterSeconds(Integer n) {
        this._persistence_checkFetchedForSet("closeAfterSeconds");
        this._persistence_propertyChange("closeAfterSeconds", this.closeAfterSeconds, n);
        this.closeAfterSeconds = n;
    }

    public FrontendMenu _persistence_get_frontendMenu() {
        this._persistence_checkFetched("frontendMenu");
        return this.frontendMenu;
    }

    public void _persistence_set_frontendMenu(FrontendMenu frontendMenu) {
        this._persistence_checkFetchedForSet("frontendMenu");
        this._persistence_propertyChange("frontendMenu", this.frontendMenu, frontendMenu);
        this.frontendMenu = frontendMenu;
    }

    public Location _persistence_get_rowLocation() {
        this._persistence_checkFetched("rowLocation");
        return this.rowLocation;
    }

    public void _persistence_set_rowLocation(Location location) {
        this._persistence_checkFetchedForSet("rowLocation");
        this._persistence_propertyChange("rowLocation", this.rowLocation, location);
        this.rowLocation = location;
    }

    public String _persistence_get_confirmationText() {
        this._persistence_checkFetched("confirmationText");
        return this.confirmationText;
    }

    public void _persistence_set_confirmationText(String string) {
        this._persistence_checkFetchedForSet("confirmationText");
        this._persistence_propertyChange("confirmationText", this.confirmationText, string);
        this.confirmationText = string;
    }

    public Set _persistence_get_userManagementProducts() {
        this._persistence_checkFetched("userManagementProducts");
        return this.userManagementProducts;
    }

    public void _persistence_set_userManagementProducts(Set set) {
        this._persistence_checkFetchedForSet("userManagementProducts");
        this._persistence_propertyChange("userManagementProducts", this.userManagementProducts, set);
        this.userManagementProducts = set;
    }

    public Set _persistence_get_transferTypes() {
        this._persistence_checkFetched("transferTypes");
        return this.transferTypes;
    }

    public void _persistence_set_transferTypes(Set set) {
        this._persistence_checkFetchedForSet("transferTypes");
        this._persistence_propertyChange("transferTypes", this.transferTypes, set);
        this.transferTypes = set;
    }

    public Boolean _persistence_get_enabledForPendingUsers() {
        this._persistence_checkFetched("enabledForPendingUsers");
        return this.enabledForPendingUsers;
    }

    public void _persistence_set_enabledForPendingUsers(Boolean bl) {
        this._persistence_checkFetchedForSet("enabledForPendingUsers");
        this._persistence_propertyChange("enabledForPendingUsers", this.enabledForPendingUsers, bl);
        this.enabledForPendingUsers = bl;
    }

    public CustomOperationResultType _persistence_get_resultType() {
        this._persistence_checkFetched("resultType");
        return this.resultType;
    }

    public void _persistence_set_resultType(CustomOperationResultType customOperationResultType) {
        this._persistence_checkFetchedForSet("resultType");
        this._persistence_propertyChange("resultType", this.resultType, customOperationResultType);
        this.resultType = customOperationResultType;
    }

    public List _persistence_get_formParameters() {
        this._persistence_checkFetched("formParameters");
        return this.formParameters;
    }

    public void _persistence_set_formParameters(List list) {
        this._persistence_checkFetchedForSet("formParameters");
        this._persistence_propertyChange("formParameters", this.formParameters, list);
        this.formParameters = list;
    }

    public Set _persistence_get_adminProducts() {
        this._persistence_checkFetched("adminProducts");
        return this.adminProducts;
    }

    public void _persistence_set_adminProducts(Set set) {
        this._persistence_checkFetchedForSet("adminProducts");
        this._persistence_propertyChange("adminProducts", this.adminProducts, set);
        this.adminProducts = set;
    }

    public CustomOperationShowForm _persistence_get_showForm() {
        this._persistence_checkFetched("showForm");
        return this.showForm;
    }

    public void _persistence_set_showForm(CustomOperationShowForm customOperationShowForm) {
        this._persistence_checkFetchedForSet("showForm");
        this._persistence_propertyChange("showForm", this.showForm, customOperationShowForm);
        this.showForm = customOperationShowForm;
    }

    protected void _persistence_initialize_script_vh() {
        if (this._persistence_script_vh == null) {
            this._persistence_script_vh = new ValueHolder((Object)this.script);
            this._persistence_script_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_script_vh() {
        CustomScript customScript;
        this._persistence_initialize_script_vh();
        if ((this._persistence_script_vh.isCoordinatedWithProperty() || this._persistence_script_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_script()) != this._persistence_script_vh.getValue()) {
            this._persistence_set_script(customScript);
        }
        return this._persistence_script_vh;
    }

    public void _persistence_set_script_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_script_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_script();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_script((CustomScript)object);
            }
        } else {
            this.script = null;
        }
    }

    public CustomScript _persistence_get_script() {
        this._persistence_checkFetched("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        return this.script;
    }

    public void _persistence_set_script(CustomScript customScript) {
        this._persistence_checkFetchedForSet("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        this._persistence_propertyChange("script", this.script, customScript);
        this.script = customScript;
        this._persistence_script_vh.setValue((Object)customScript);
    }

    public Set _persistence_get_channels() {
        this._persistence_checkFetched("channels");
        return this.channels;
    }

    public void _persistence_set_channels(Set set) {
        this._persistence_checkFetchedForSet("channels");
        this._persistence_propertyChange("channels", this.channels, set);
        this.channels = set;
    }

    public Set _persistence_get_usedAsActions() {
        this._persistence_checkFetched("usedAsActions");
        return this.usedAsActions;
    }

    public void _persistence_set_usedAsActions(Set set) {
        this._persistence_checkFetchedForSet("usedAsActions");
        this._persistence_propertyChange("usedAsActions", this.usedAsActions, set);
        this.usedAsActions = set;
    }

    public String _persistence_get_resultInformationText() {
        this._persistence_checkFetched("resultInformationText");
        return this.resultInformationText;
    }

    public void _persistence_set_resultInformationText(String string) {
        this._persistence_checkFetchedForSet("resultInformationText");
        this._persistence_propertyChange("resultInformationText", this.resultInformationText, string);
        this.resultInformationText = string;
    }

    protected void _persistence_initialize_contentScript_vh() {
        if (this._persistence_contentScript_vh == null) {
            this._persistence_contentScript_vh = new ValueHolder((Object)this.contentScript);
            this._persistence_contentScript_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_contentScript_vh() {
        CustomScript customScript;
        this._persistence_initialize_contentScript_vh();
        if ((this._persistence_contentScript_vh.isCoordinatedWithProperty() || this._persistence_contentScript_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_contentScript()) != this._persistence_contentScript_vh.getValue()) {
            this._persistence_set_contentScript(customScript);
        }
        return this._persistence_contentScript_vh;
    }

    public void _persistence_set_contentScript_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_contentScript_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_contentScript();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_contentScript((CustomScript)object);
            }
        } else {
            this.contentScript = null;
        }
    }

    public CustomScript _persistence_get_contentScript() {
        this._persistence_checkFetched("contentScript");
        this._persistence_initialize_contentScript_vh();
        this.contentScript = (CustomScript)this._persistence_contentScript_vh.getValue();
        return this.contentScript;
    }

    public void _persistence_set_contentScript(CustomScript customScript) {
        this._persistence_checkFetchedForSet("contentScript");
        this._persistence_initialize_contentScript_vh();
        this.contentScript = (CustomScript)this._persistence_contentScript_vh.getValue();
        this._persistence_propertyChange("contentScript", this.contentScript, customScript);
        this.contentScript = customScript;
        this._persistence_contentScript_vh.setValue((Object)customScript);
    }

    public Boolean _persistence_get_searchAutomatically() {
        this._persistence_checkFetched("searchAutomatically");
        return this.searchAutomatically;
    }

    public void _persistence_set_searchAutomatically(Boolean bl) {
        this._persistence_checkFetchedForSet("searchAutomatically");
        this._persistence_propertyChange("searchAutomatically", this.searchAutomatically, bl);
        this.searchAutomatically = bl;
    }

    public String _persistence_get_rowParameters() {
        this._persistence_checkFetched("rowParameters");
        return this.rowParameters;
    }

    public void _persistence_set_rowParameters(String string) {
        this._persistence_checkFetchedForSet("rowParameters");
        this._persistence_propertyChange("rowParameters", this.rowParameters, string);
        this.rowParameters = string;
    }

    public Set _persistence_get_actions() {
        this._persistence_checkFetched("actions");
        return this.actions;
    }

    public void _persistence_set_actions(Set set) {
        this._persistence_checkFetchedForSet("actions");
        this._persistence_propertyChange("actions", this.actions, set);
        this.actions = set;
    }

    public Boolean _persistence_get_submitWithQrCodeScan() {
        this._persistence_checkFetched("submitWithQrCodeScan");
        return this.submitWithQrCodeScan;
    }

    public void _persistence_set_submitWithQrCodeScan(Boolean bl) {
        this._persistence_checkFetchedForSet("submitWithQrCodeScan");
        this._persistence_propertyChange("submitWithQrCodeScan", this.submitWithQrCodeScan, bl);
        this.submitWithQrCodeScan = bl;
    }

    public Boolean _persistence_get_enabledForActiveUsers() {
        this._persistence_checkFetched("enabledForActiveUsers");
        return this.enabledForActiveUsers;
    }

    public void _persistence_set_enabledForActiveUsers(Boolean bl) {
        this._persistence_checkFetchedForSet("enabledForActiveUsers");
        this._persistence_propertyChange("enabledForActiveUsers", this.enabledForActiveUsers, bl);
        this.enabledForActiveUsers = bl;
    }

    public Set _persistence_get_recordTypes() {
        this._persistence_checkFetched("recordTypes");
        return this.recordTypes;
    }

    public void _persistence_set_recordTypes(Set set) {
        this._persistence_checkFetchedForSet("recordTypes");
        this._persistence_propertyChange("recordTypes", this.recordTypes, set);
        this.recordTypes = set;
    }

    public String _persistence_get_icon() {
        this._persistence_checkFetched("icon");
        return this.icon;
    }

    public void _persistence_set_icon(String string) {
        this._persistence_checkFetchedForSet("icon");
        this._persistence_propertyChange("icon", this.icon, string);
        this.icon = string;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public UserMainMenu _persistence_get_userMenu() {
        this._persistence_checkFetched("userMenu");
        return this.userMenu;
    }

    public void _persistence_set_userMenu(UserMainMenu userMainMenu) {
        this._persistence_checkFetchedForSet("userMenu");
        this._persistence_propertyChange("userMenu", this.userMenu, userMainMenu);
        this.userMenu = userMainMenu;
    }

    public Boolean _persistence_get_allowPrint() {
        this._persistence_checkFetched("allowPrint");
        return this.allowPrint;
    }

    public void _persistence_set_allowPrint(Boolean bl) {
        this._persistence_checkFetchedForSet("allowPrint");
        this._persistence_propertyChange("allowPrint", this.allowPrint, bl);
        this.allowPrint = bl;
    }

    public CustomOperationScope _persistence_get_scope() {
        this._persistence_checkFetched("scope");
        return this.scope;
    }

    public void _persistence_set_scope(CustomOperationScope customOperationScope) {
        this._persistence_checkFetchedForSet("scope");
        this._persistence_propertyChange("scope", this.scope, customOperationScope);
        this.scope = customOperationScope;
    }

    public Set _persistence_get_memberProducts() {
        this._persistence_checkFetched("memberProducts");
        return this.memberProducts;
    }

    public void _persistence_set_memberProducts(Set set) {
        this._persistence_checkFetchedForSet("memberProducts");
        this._persistence_propertyChange("memberProducts", this.memberProducts, set);
        this.memberProducts = set;
    }

    protected void _persistence_initialize_rowOperation_vh() {
        if (this._persistence_rowOperation_vh == null) {
            this._persistence_rowOperation_vh = new ValueHolder((Object)this.rowOperation);
            this._persistence_rowOperation_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_rowOperation_vh() {
        CustomOperation customOperation;
        this._persistence_initialize_rowOperation_vh();
        if ((this._persistence_rowOperation_vh.isCoordinatedWithProperty() || this._persistence_rowOperation_vh.isNewlyWeavedValueHolder()) && (customOperation = this._persistence_get_rowOperation()) != this._persistence_rowOperation_vh.getValue()) {
            this._persistence_set_rowOperation(customOperation);
        }
        return this._persistence_rowOperation_vh;
    }

    public void _persistence_set_rowOperation_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_rowOperation_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomOperation customOperation = this._persistence_get_rowOperation();
            if (customOperation != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_rowOperation((CustomOperation)object);
            }
        } else {
            this.rowOperation = null;
        }
    }

    public CustomOperation _persistence_get_rowOperation() {
        this._persistence_checkFetched("rowOperation");
        this._persistence_initialize_rowOperation_vh();
        this.rowOperation = (CustomOperation)this._persistence_rowOperation_vh.getValue();
        return this.rowOperation;
    }

    public void _persistence_set_rowOperation(CustomOperation customOperation) {
        this._persistence_checkFetchedForSet("rowOperation");
        this._persistence_initialize_rowOperation_vh();
        this.rowOperation = (CustomOperation)this._persistence_rowOperation_vh.getValue();
        this._persistence_propertyChange("rowOperation", this.rowOperation, customOperation);
        this.rowOperation = customOperation;
        this._persistence_rowOperation_vh.setValue((Object)customOperation);
    }

    public Set _persistence_get_productsRunTransfer() {
        this._persistence_checkFetched("productsRunTransfer");
        return this.productsRunTransfer;
    }

    public void _persistence_set_productsRunTransfer(Set set) {
        this._persistence_checkFetchedForSet("productsRunTransfer");
        this._persistence_propertyChange("productsRunTransfer", this.productsRunTransfer, set);
        this.productsRunTransfer = set;
    }

    public String _persistence_get_informationText() {
        this._persistence_checkFetched("informationText");
        return this.informationText;
    }

    public void _persistence_set_informationText(String string) {
        this._persistence_checkFetchedForSet("informationText");
        this._persistence_propertyChange("informationText", this.informationText, string);
        this.informationText = string;
    }

    public Boolean _persistence_get_requireConfirmationCredential() {
        this._persistence_checkFetched("requireConfirmationCredential");
        return this.requireConfirmationCredential;
    }

    public void _persistence_set_requireConfirmationCredential(Boolean bl) {
        this._persistence_checkFetchedForSet("requireConfirmationCredential");
        this._persistence_propertyChange("requireConfirmationCredential", this.requireConfirmationCredential, bl);
        this.requireConfirmationCredential = bl;
    }

    public Boolean _persistence_get_allowExport() {
        this._persistence_checkFetched("allowExport");
        return this.allowExport;
    }

    public void _persistence_set_allowExport(Boolean bl) {
        this._persistence_checkFetchedForSet("allowExport");
        this._persistence_propertyChange("allowExport", this.allowExport, bl);
        this.allowExport = bl;
    }

    public String _persistence_get_rowUrl() {
        this._persistence_checkFetched("rowUrl");
        return this.rowUrl;
    }

    public void _persistence_set_rowUrl(String string) {
        this._persistence_checkFetchedForSet("rowUrl");
        this._persistence_propertyChange("rowUrl", this.rowUrl, string);
        this.rowUrl = string;
    }

    public String _persistence_get_label() {
        this._persistence_checkFetched("label");
        return this.label;
    }

    public void _persistence_set_label(String string) {
        this._persistence_checkFetchedForSet("label");
        this._persistence_propertyChange("label", this.label, string);
        this.label = string;
    }

    public String _persistence_get_svgIcon() {
        this._persistence_checkFetched("svgIcon");
        return this.svgIcon;
    }

    public void _persistence_set_svgIcon(String string) {
        this._persistence_checkFetchedForSet("svgIcon");
        this._persistence_propertyChange("svgIcon", this.svgIcon, string);
        this.svgIcon = string;
    }

    public Set _persistence_get_appMailingBulkActions() {
        this._persistence_checkFetched("appMailingBulkActions");
        return this.appMailingBulkActions;
    }

    public void _persistence_set_appMailingBulkActions(Set set) {
        this._persistence_checkFetchedForSet("appMailingBulkActions");
        this._persistence_propertyChange("appMailingBulkActions", this.appMailingBulkActions, set);
        this.appMailingBulkActions = set;
    }

    public String _persistence_get_contentScriptParameters() {
        this._persistence_checkFetched("contentScriptParameters");
        return this.contentScriptParameters;
    }

    public void _persistence_set_contentScriptParameters(String string) {
        this._persistence_checkFetchedForSet("contentScriptParameters");
        this._persistence_propertyChange("contentScriptParameters", this.contentScriptParameters, string);
        this.contentScriptParameters = string;
    }

    public String _persistence_get_customSubmitLabel() {
        this._persistence_checkFetched("customSubmitLabel");
        return this.customSubmitLabel;
    }

    public void _persistence_set_customSubmitLabel(String string) {
        this._persistence_checkFetchedForSet("customSubmitLabel");
        this._persistence_propertyChange("customSubmitLabel", this.customSubmitLabel, string);
        this.customSubmitLabel = string;
    }

    public String _persistence_get_scriptParameters() {
        this._persistence_checkFetched("scriptParameters");
        return this.scriptParameters;
    }

    public void _persistence_set_scriptParameters(String string) {
        this._persistence_checkFetchedForSet("scriptParameters");
        this._persistence_propertyChange("scriptParameters", this.scriptParameters, string);
        this.scriptParameters = string;
    }

    public ProfileManagementSection _persistence_get_profileSection() {
        this._persistence_checkFetched("profileSection");
        return this.profileSection;
    }

    public void _persistence_set_profileSection(ProfileManagementSection profileManagementSection) {
        this._persistence_checkFetchedForSet("profileSection");
        this._persistence_propertyChange("profileSection", this.profileSection, profileManagementSection);
        this.profileSection = profileManagementSection;
    }

    public Boolean _persistence_get_openRowInNewWindow() {
        this._persistence_checkFetched("openRowInNewWindow");
        return this.openRowInNewWindow;
    }

    public void _persistence_set_openRowInNewWindow(Boolean bl) {
        this._persistence_checkFetchedForSet("openRowInNewWindow");
        this._persistence_propertyChange("openRowInNewWindow", this.openRowInNewWindow, bl);
        this.openRowInNewWindow = bl;
    }

    public Boolean _persistence_get_hasFileUpload() {
        this._persistence_checkFetched("hasFileUpload");
        return this.hasFileUpload;
    }

    public void _persistence_set_hasFileUpload(Boolean bl) {
        this._persistence_checkFetchedForSet("hasFileUpload");
        this._persistence_propertyChange("hasFileUpload", this.hasFileUpload, bl);
        this.hasFileUpload = bl;
    }
}

