/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.Network;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.UsesScript;
import org.cyclos.model.system.webservices.HttpMethod;
import org.cyclos.model.system.webservices.RunAs;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="custom_web_services")
public class CustomWebService
extends ConfigurationEntity
implements DefinesNetwork,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Lob
    @Column(name="url_mappings", nullable=false)
    private String urlMappings;
    @Basic
    @Column(name="username")
    private String username;
    @Basic
    @Column(name="password")
    private String password;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="run_as", nullable=false)
    private RunAs runAs;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="method", nullable=false)
    private HttpMethod method;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="whitelist_id")
    private InternetAddressList whitelist;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="script_id", nullable=false)
    private CustomScript script;
    @Basic
    @Lob
    @Column(name="script_parameters")
    private String scriptParameters;
    static final long serialVersionUID = -6686928108292923009L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_whitelist_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_script_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public String getIpWhitelist() {
        return this._persistence_get_whitelist() == null ? null : this._persistence_get_whitelist().getAddresses();
    }

    public HttpMethod getMethod() {
        return this._persistence_get_method();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public String getPassword() {
        return this._persistence_get_password();
    }

    public RunAs getRunAs() {
        return this._persistence_get_runAs();
    }

    public CustomScript getScript() {
        return this._persistence_get_script();
    }

    public String getScriptParameters() {
        return this._persistence_get_scriptParameters();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.WEB_SERVICE;
    }

    public String getUrlMappings() {
        return this._persistence_get_urlMappings();
    }

    public String getUsername() {
        return this._persistence_get_username();
    }

    public InternetAddressList getWhitelist() {
        return this._persistence_get_whitelist();
    }

    public boolean isEnabled() {
        return StringHelper.isNotBlank((Object)this._persistence_get_urlMappings());
    }

    public boolean isUseIpWhitelist() {
        return this._persistence_get_whitelist() != null;
    }

    public void setMethod(HttpMethod httpMethod) {
        this._persistence_set_method(httpMethod);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setPassword(String string) {
        this._persistence_set_password(string);
    }

    public void setRunAs(RunAs runAs) {
        this._persistence_set_runAs(runAs);
    }

    public void setScript(CustomScript customScript) {
        this._persistence_set_script(customScript);
    }

    public void setScriptParameters(String string) {
        this._persistence_set_scriptParameters(string);
    }

    public void setUrlMappings(String string) {
        this._persistence_set_urlMappings(string);
    }

    public void setUsername(String string) {
        this._persistence_set_username(string);
    }

    public void setWhitelist(InternetAddressList internetAddressList) {
        this._persistence_set_whitelist(internetAddressList);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_whitelist_vh != null) {
            this._persistence_whitelist_vh = (WeavedAttributeValueHolderInterface)this._persistence_whitelist_vh.clone();
        }
        if (this._persistence_script_vh != null) {
            this._persistence_script_vh = (WeavedAttributeValueHolderInterface)this._persistence_script_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomWebService();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "runAs") {
            return this.runAs;
        }
        if (string == "method") {
            return this.method;
        }
        if (string == "whitelist") {
            return this.whitelist;
        }
        if (string == "script") {
            return this.script;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "scriptParameters") {
            return this.scriptParameters;
        }
        if (string == "password") {
            return this.password;
        }
        if (string == "urlMappings") {
            return this.urlMappings;
        }
        if (string == "username") {
            return this.username;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "runAs") {
            this.runAs = (RunAs)object;
            return;
        }
        if (string == "method") {
            this.method = (HttpMethod)object;
            return;
        }
        if (string == "whitelist") {
            this.whitelist = (InternetAddressList)object;
            return;
        }
        if (string == "script") {
            this.script = (CustomScript)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "scriptParameters") {
            this.scriptParameters = (String)object;
            return;
        }
        if (string == "password") {
            this.password = (String)object;
            return;
        }
        if (string == "urlMappings") {
            this.urlMappings = (String)object;
            return;
        }
        if (string == "username") {
            this.username = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public RunAs _persistence_get_runAs() {
        this._persistence_checkFetched("runAs");
        return this.runAs;
    }

    public void _persistence_set_runAs(RunAs runAs) {
        this._persistence_checkFetchedForSet("runAs");
        this._persistence_propertyChange("runAs", this.runAs, runAs);
        this.runAs = runAs;
    }

    public HttpMethod _persistence_get_method() {
        this._persistence_checkFetched("method");
        return this.method;
    }

    public void _persistence_set_method(HttpMethod httpMethod) {
        this._persistence_checkFetchedForSet("method");
        this._persistence_propertyChange("method", this.method, httpMethod);
        this.method = httpMethod;
    }

    protected void _persistence_initialize_whitelist_vh() {
        if (this._persistence_whitelist_vh == null) {
            this._persistence_whitelist_vh = new ValueHolder((Object)this.whitelist);
            this._persistence_whitelist_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_whitelist_vh() {
        InternetAddressList internetAddressList;
        this._persistence_initialize_whitelist_vh();
        if ((this._persistence_whitelist_vh.isCoordinatedWithProperty() || this._persistence_whitelist_vh.isNewlyWeavedValueHolder()) && (internetAddressList = this._persistence_get_whitelist()) != this._persistence_whitelist_vh.getValue()) {
            this._persistence_set_whitelist(internetAddressList);
        }
        return this._persistence_whitelist_vh;
    }

    public void _persistence_set_whitelist_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_whitelist_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            InternetAddressList internetAddressList = this._persistence_get_whitelist();
            if (internetAddressList != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_whitelist((InternetAddressList)object);
            }
        } else {
            this.whitelist = null;
        }
    }

    public InternetAddressList _persistence_get_whitelist() {
        this._persistence_checkFetched("whitelist");
        this._persistence_initialize_whitelist_vh();
        this.whitelist = (InternetAddressList)this._persistence_whitelist_vh.getValue();
        return this.whitelist;
    }

    public void _persistence_set_whitelist(InternetAddressList internetAddressList) {
        this._persistence_checkFetchedForSet("whitelist");
        this._persistence_initialize_whitelist_vh();
        this.whitelist = (InternetAddressList)this._persistence_whitelist_vh.getValue();
        this._persistence_propertyChange("whitelist", this.whitelist, internetAddressList);
        this.whitelist = internetAddressList;
        this._persistence_whitelist_vh.setValue((Object)internetAddressList);
    }

    protected void _persistence_initialize_script_vh() {
        if (this._persistence_script_vh == null) {
            this._persistence_script_vh = new ValueHolder((Object)this.script);
            this._persistence_script_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_script_vh() {
        CustomScript customScript;
        this._persistence_initialize_script_vh();
        if ((this._persistence_script_vh.isCoordinatedWithProperty() || this._persistence_script_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_script()) != this._persistence_script_vh.getValue()) {
            this._persistence_set_script(customScript);
        }
        return this._persistence_script_vh;
    }

    public void _persistence_set_script_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_script_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_script();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_script((CustomScript)object);
            }
        } else {
            this.script = null;
        }
    }

    public CustomScript _persistence_get_script() {
        this._persistence_checkFetched("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        return this.script;
    }

    public void _persistence_set_script(CustomScript customScript) {
        this._persistence_checkFetchedForSet("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        this._persistence_propertyChange("script", this.script, customScript);
        this.script = customScript;
        this._persistence_script_vh.setValue((Object)customScript);
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public String _persistence_get_scriptParameters() {
        this._persistence_checkFetched("scriptParameters");
        return this.scriptParameters;
    }

    public void _persistence_set_scriptParameters(String string) {
        this._persistence_checkFetchedForSet("scriptParameters");
        this._persistence_propertyChange("scriptParameters", this.scriptParameters, string);
        this.scriptParameters = string;
    }

    public String _persistence_get_password() {
        this._persistence_checkFetched("password");
        return this.password;
    }

    public void _persistence_set_password(String string) {
        this._persistence_checkFetchedForSet("password");
        this._persistence_propertyChange("password", this.password, string);
        this.password = string;
    }

    public String _persistence_get_urlMappings() {
        this._persistence_checkFetched("urlMappings");
        return this.urlMappings;
    }

    public void _persistence_set_urlMappings(String string) {
        this._persistence_checkFetchedForSet("urlMappings");
        this._persistence_propertyChange("urlMappings", this.urlMappings, string);
        this.urlMappings = string;
    }

    public String _persistence_get_username() {
        this._persistence_checkFetched("username");
        return this.username;
    }

    public void _persistence_set_username(String string) {
        this._persistence_checkFetchedForSet("username");
        this._persistence_propertyChange("username", this.username, string);
        this.username = string;
    }
}

