/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationOrderableEntity;
import org.cyclos.entities.HasSvgIcon;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.CustomWizardStep;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AppMailingBulkAction;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.UsesScript;
import org.cyclos.model.system.wizards.CustomWizardNature;
import org.cyclos.model.system.wizards.CustomWizardResultType;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@DiscriminatorColumn(name="subclass")
@Table(name="custom_wizards")
public abstract class CustomWizard
extends ConfigurationOrderableEntity
implements HasSvgIcon,
DefinesNetwork,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="result_type", nullable=false)
    private CustomWizardResultType resultType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="script_id")
    private CustomScript script;
    @Basic
    @Lob
    @Column(name="script_parameters")
    private String scriptParameters;
    @Basic
    @Column(name="svg_icon")
    private String svgIcon;
    @Basic
    @Column(name="show_progress")
    private Boolean showProgress;
    @Basic
    @Column(name="require_confirmation_credential")
    private Boolean requireConfirmationCredential;
    @OneToMany(mappedBy="wizard", cascade={CascadeType.REMOVE})
    @OrderBy(value="order ASC")
    private List<CustomWizardStep> steps = new ArrayList<CustomWizardStep>();
    @OneToMany(mappedBy="wizard", cascade={CascadeType.REMOVE})
    @OrderBy(value="order ASC")
    private List<CustomWizardField> customFields = new ArrayList<CustomWizardField>();
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="incomplete_registration_notify_interval_amount")), @AttributeOverride(name="field", column=@Column(name="incomplete_registration_notify_interval_field"))})
    protected TimeInterval incompleteRegistrationNotifyInterval;
    @OneToMany(mappedBy="customWizard", cascade={CascadeType.REMOVE})
    private Set<AppMailingBulkAction> appMailingBulkActions;
    static final long serialVersionUID = -8391560183061837734L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_script_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public List<CustomWizardField> getCustomFields() {
        return this._persistence_get_customFields();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.CUSTOM_WIZARDS;
    }

    public abstract CustomWizardNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public CustomWizardResultType getResultType() {
        return this._persistence_get_resultType();
    }

    public CustomScript getScript() {
        return this._persistence_get_script();
    }

    public String getScriptParameters() {
        return this._persistence_get_scriptParameters();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.WIZARD;
    }

    public List<CustomWizardStep> getSteps() {
        return this._persistence_get_steps();
    }

    @Override
    public String getSvgIcon() {
        return this._persistence_get_svgIcon();
    }

    public boolean isRequireConfirmationCredential() {
        return Boolean.TRUE.equals(this._persistence_get_requireConfirmationCredential());
    }

    public boolean isShowProgress() {
        return Boolean.TRUE.equals(this._persistence_get_showProgress());
    }

    public void setCustomFields(List<CustomWizardField> list) {
        this._persistence_set_customFields(list);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setRequireConfirmationCredential(boolean bl) {
        this._persistence_set_requireConfirmationCredential(bl);
    }

    public void setResultType(CustomWizardResultType customWizardResultType) {
        this._persistence_set_resultType(customWizardResultType);
    }

    public void setScript(CustomScript customScript) {
        this._persistence_set_script(customScript);
    }

    public void setScriptParameters(String string) {
        this._persistence_set_scriptParameters(string);
    }

    public void setShowProgress(boolean bl) {
        this._persistence_set_showProgress(bl);
    }

    public void setSteps(List<CustomWizardStep> list) {
        this._persistence_set_steps(list);
    }

    @Override
    public void setSvgIcon(String string) {
        this._persistence_set_svgIcon(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_script_vh != null) {
            this._persistence_script_vh = (WeavedAttributeValueHolderInterface)this._persistence_script_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomWizard();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "requireConfirmationCredential") {
            return this.requireConfirmationCredential;
        }
        if (string == "showProgress") {
            return this.showProgress;
        }
        if (string == "customFields") {
            return this.customFields;
        }
        if (string == "incompleteRegistrationNotifyInterval") {
            return this.incompleteRegistrationNotifyInterval;
        }
        if (string == "svgIcon") {
            return this.svgIcon;
        }
        if (string == "appMailingBulkActions") {
            return this.appMailingBulkActions;
        }
        if (string == "steps") {
            return this.steps;
        }
        if (string == "script") {
            return this.script;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "scriptParameters") {
            return this.scriptParameters;
        }
        if (string == "resultType") {
            return this.resultType;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "requireConfirmationCredential") {
            this.requireConfirmationCredential = (Boolean)object;
            return;
        }
        if (string == "showProgress") {
            this.showProgress = (Boolean)object;
            return;
        }
        if (string == "customFields") {
            this.customFields = (List)object;
            return;
        }
        if (string == "incompleteRegistrationNotifyInterval") {
            this.incompleteRegistrationNotifyInterval = (TimeInterval)object;
            return;
        }
        if (string == "svgIcon") {
            this.svgIcon = (String)object;
            return;
        }
        if (string == "appMailingBulkActions") {
            this.appMailingBulkActions = (Set)object;
            return;
        }
        if (string == "steps") {
            this.steps = (List)object;
            return;
        }
        if (string == "script") {
            this.script = (CustomScript)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "scriptParameters") {
            this.scriptParameters = (String)object;
            return;
        }
        if (string == "resultType") {
            this.resultType = (CustomWizardResultType)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_requireConfirmationCredential() {
        this._persistence_checkFetched("requireConfirmationCredential");
        return this.requireConfirmationCredential;
    }

    public void _persistence_set_requireConfirmationCredential(Boolean bl) {
        this._persistence_checkFetchedForSet("requireConfirmationCredential");
        this._persistence_propertyChange("requireConfirmationCredential", this.requireConfirmationCredential, bl);
        this.requireConfirmationCredential = bl;
    }

    public Boolean _persistence_get_showProgress() {
        this._persistence_checkFetched("showProgress");
        return this.showProgress;
    }

    public void _persistence_set_showProgress(Boolean bl) {
        this._persistence_checkFetchedForSet("showProgress");
        this._persistence_propertyChange("showProgress", this.showProgress, bl);
        this.showProgress = bl;
    }

    public List _persistence_get_customFields() {
        this._persistence_checkFetched("customFields");
        return this.customFields;
    }

    public void _persistence_set_customFields(List list) {
        this._persistence_checkFetchedForSet("customFields");
        this._persistence_propertyChange("customFields", this.customFields, list);
        this.customFields = list;
    }

    public TimeInterval _persistence_get_incompleteRegistrationNotifyInterval() {
        this._persistence_checkFetched("incompleteRegistrationNotifyInterval");
        return this.incompleteRegistrationNotifyInterval;
    }

    public void _persistence_set_incompleteRegistrationNotifyInterval(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("incompleteRegistrationNotifyInterval");
        this._persistence_propertyChange("incompleteRegistrationNotifyInterval", this.incompleteRegistrationNotifyInterval, timeInterval);
        this.incompleteRegistrationNotifyInterval = timeInterval;
    }

    public String _persistence_get_svgIcon() {
        this._persistence_checkFetched("svgIcon");
        return this.svgIcon;
    }

    public void _persistence_set_svgIcon(String string) {
        this._persistence_checkFetchedForSet("svgIcon");
        this._persistence_propertyChange("svgIcon", this.svgIcon, string);
        this.svgIcon = string;
    }

    public Set _persistence_get_appMailingBulkActions() {
        this._persistence_checkFetched("appMailingBulkActions");
        return this.appMailingBulkActions;
    }

    public void _persistence_set_appMailingBulkActions(Set set) {
        this._persistence_checkFetchedForSet("appMailingBulkActions");
        this._persistence_propertyChange("appMailingBulkActions", this.appMailingBulkActions, set);
        this.appMailingBulkActions = set;
    }

    public List _persistence_get_steps() {
        this._persistence_checkFetched("steps");
        return this.steps;
    }

    public void _persistence_set_steps(List list) {
        this._persistence_checkFetchedForSet("steps");
        this._persistence_propertyChange("steps", this.steps, list);
        this.steps = list;
    }

    protected void _persistence_initialize_script_vh() {
        if (this._persistence_script_vh == null) {
            this._persistence_script_vh = new ValueHolder((Object)this.script);
            this._persistence_script_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_script_vh() {
        CustomScript customScript;
        this._persistence_initialize_script_vh();
        if ((this._persistence_script_vh.isCoordinatedWithProperty() || this._persistence_script_vh.isNewlyWeavedValueHolder()) && (customScript = this._persistence_get_script()) != this._persistence_script_vh.getValue()) {
            this._persistence_set_script(customScript);
        }
        return this._persistence_script_vh;
    }

    public void _persistence_set_script_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_script_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomScript customScript = this._persistence_get_script();
            if (customScript != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_script((CustomScript)object);
            }
        } else {
            this.script = null;
        }
    }

    public CustomScript _persistence_get_script() {
        this._persistence_checkFetched("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        return this.script;
    }

    public void _persistence_set_script(CustomScript customScript) {
        this._persistence_checkFetchedForSet("script");
        this._persistence_initialize_script_vh();
        this.script = (CustomScript)this._persistence_script_vh.getValue();
        this._persistence_propertyChange("script", this.script, customScript);
        this.script = customScript;
        this._persistence_script_vh.setValue((Object)customScript);
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public String _persistence_get_scriptParameters() {
        this._persistence_checkFetched("scriptParameters");
        return this.scriptParameters;
    }

    public void _persistence_set_scriptParameters(String string) {
        this._persistence_checkFetchedForSet("scriptParameters");
        this._persistence_propertyChange("scriptParameters", this.scriptParameters, string);
        this.scriptParameters = string;
    }

    public CustomWizardResultType _persistence_get_resultType() {
        this._persistence_checkFetched("resultType");
        return this.resultType;
    }

    public void _persistence_set_resultType(CustomWizardResultType customWizardResultType) {
        this._persistence_checkFetchedForSet("resultType");
        this._persistence_propertyChange("resultType", this.resultType, customWizardResultType);
        this.resultType = customWizardResultType;
    }
}

