/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.access.oidcclients.Scope;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Embeddable
public class DynamicOidcClientConfiguration
implements OidcClientAccessor,
Cloneable,
PersistenceWeaved,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Basic
    @Column(name="dyna_oidc_enabled")
    private Boolean enabled;
    @Basic
    @Column(name="dyna_oidc_allow_unencrypted_uris")
    private Boolean allowUnencryptedUris;
    @ElementCollection
    @Column(name="scope")
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="configurations_dyna_oidc_scopes", joinColumns={@JoinColumn(name="configuration_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"configuration_id", "scope"})})
    private Set<Scope> scopes;
    @ManyToMany
    @JoinTable(name="configurations_dyna_oidc_accounts", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="account_type_id")})
    private Set<UserAccountType> accounts;
    @ManyToMany
    @JoinTable(name="configurations_dyna_oidc_payments", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> payments;
    @ManyToMany
    @JoinTable(name="configurations_dyna_oidc_tickets", joinColumns={@JoinColumn(name="configuration_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> tickets;
    @Basic
    @Column(name="dyna_oidc_single_payment_per_consent")
    private Boolean singlePaymentPerConsent;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="dyna_oidc_acc_token_exp_amount")), @AttributeOverride(name="field", column=@Column(name="dyna_oidc_acc_token_exp_field"))})
    private TimeInterval accessTokenExpiration;
    static final long serialVersionUID = 3990915007564156768L;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public DynamicOidcClientConfiguration() {
        this.scopes = new HashSet<Scope>();
        this.accounts = new HashSet<UserAccountType>();
        this.payments = new HashSet<PaymentTransferType>();
        this.tickets = new HashSet<PaymentTransferType>();
    }

    @Override
    public TimeInterval getAccessTokenExpiration() {
        return this._persistence_get_accessTokenExpiration();
    }

    @Override
    public Set<UserAccountType> getAccounts() {
        return this._persistence_get_accounts();
    }

    @Override
    public Set<PaymentTransferType> getPayments() {
        return this._persistence_get_payments();
    }

    @Override
    public Set<Scope> getScopes() {
        return this._persistence_get_scopes();
    }

    @Override
    public Set<PaymentTransferType> getTickets() {
        return this._persistence_get_tickets();
    }

    public boolean isAllowUnencryptedUris() {
        return Boolean.TRUE.equals(this._persistence_get_allowUnencryptedUris());
    }

    @Override
    public boolean isEnabled() {
        return Boolean.TRUE.equals(this._persistence_get_enabled());
    }

    @Override
    public boolean isSinglePaymentPerConsent() {
        return Boolean.TRUE.equals(this._persistence_get_singlePaymentPerConsent());
    }

    public void setAccessTokenExpiration(TimeInterval timeInterval) {
        this._persistence_set_accessTokenExpiration(timeInterval);
    }

    public void setAccounts(Set<UserAccountType> set) {
        this._persistence_set_accounts(set);
    }

    public void setAllowUnencryptedUris(boolean bl) {
        this._persistence_set_allowUnencryptedUris(bl);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setPayments(Set<PaymentTransferType> set) {
        this._persistence_set_payments(set);
    }

    public void setScopes(Set<Scope> set) {
        this._persistence_set_scopes(set);
    }

    public void setSinglePaymentPerConsent(Boolean bl) {
        this._persistence_set_singlePaymentPerConsent(bl);
    }

    public void setTickets(Set<PaymentTransferType> set) {
        this._persistence_set_tickets(set);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DynamicOidcClientConfiguration(persistenceObject);
    }

    public DynamicOidcClientConfiguration(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "allowUnencryptedUris") {
            return this.allowUnencryptedUris;
        }
        if (string == "tickets") {
            return this.tickets;
        }
        if (string == "accessTokenExpiration") {
            return this.accessTokenExpiration;
        }
        if (string == "payments") {
            return this.payments;
        }
        if (string == "scopes") {
            return this.scopes;
        }
        if (string == "accounts") {
            return this.accounts;
        }
        if (string == "singlePaymentPerConsent") {
            return this.singlePaymentPerConsent;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "allowUnencryptedUris") {
            this.allowUnencryptedUris = (Boolean)object;
            return;
        }
        if (string == "tickets") {
            this.tickets = (Set)object;
            return;
        }
        if (string == "accessTokenExpiration") {
            this.accessTokenExpiration = (TimeInterval)object;
            return;
        }
        if (string == "payments") {
            this.payments = (Set)object;
            return;
        }
        if (string == "scopes") {
            this.scopes = (Set)object;
            return;
        }
        if (string == "accounts") {
            this.accounts = (Set)object;
            return;
        }
        if (string == "singlePaymentPerConsent") {
            this.singlePaymentPerConsent = (Boolean)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
    }

    public Boolean _persistence_get_allowUnencryptedUris() {
        this._persistence_checkFetched("allowUnencryptedUris");
        return this.allowUnencryptedUris;
    }

    public void _persistence_set_allowUnencryptedUris(Boolean bl) {
        this._persistence_checkFetchedForSet("allowUnencryptedUris");
        this._persistence_propertyChange("allowUnencryptedUris", this.allowUnencryptedUris, bl);
        this.allowUnencryptedUris = bl;
    }

    public Set _persistence_get_tickets() {
        this._persistence_checkFetched("tickets");
        return this.tickets;
    }

    public void _persistence_set_tickets(Set set) {
        this._persistence_checkFetchedForSet("tickets");
        this._persistence_propertyChange("tickets", this.tickets, set);
        this.tickets = set;
    }

    public TimeInterval _persistence_get_accessTokenExpiration() {
        this._persistence_checkFetched("accessTokenExpiration");
        return this.accessTokenExpiration;
    }

    public void _persistence_set_accessTokenExpiration(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("accessTokenExpiration");
        this._persistence_propertyChange("accessTokenExpiration", this.accessTokenExpiration, timeInterval);
        this.accessTokenExpiration = timeInterval;
    }

    public Set _persistence_get_payments() {
        this._persistence_checkFetched("payments");
        return this.payments;
    }

    public void _persistence_set_payments(Set set) {
        this._persistence_checkFetchedForSet("payments");
        this._persistence_propertyChange("payments", this.payments, set);
        this.payments = set;
    }

    public Set _persistence_get_scopes() {
        this._persistence_checkFetched("scopes");
        return this.scopes;
    }

    public void _persistence_set_scopes(Set set) {
        this._persistence_checkFetchedForSet("scopes");
        this._persistence_propertyChange("scopes", this.scopes, set);
        this.scopes = set;
    }

    public Set _persistence_get_accounts() {
        this._persistence_checkFetched("accounts");
        return this.accounts;
    }

    public void _persistence_set_accounts(Set set) {
        this._persistence_checkFetchedForSet("accounts");
        this._persistence_propertyChange("accounts", this.accounts, set);
        this.accounts = set;
    }

    public Boolean _persistence_get_singlePaymentPerConsent() {
        this._persistence_checkFetched("singlePaymentPerConsent");
        return this.singlePaymentPerConsent;
    }

    public void _persistence_set_singlePaymentPerConsent(Boolean bl) {
        this._persistence_checkFetchedForSet("singlePaymentPerConsent");
        this._persistence_propertyChange("singlePaymentPerConsent", this.singlePaymentPerConsent, bl);
        this.singlePaymentPerConsent = bl;
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

