/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.EnumSet;
import java.util.Set;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.model.Availability;
import org.cyclos.model.access.CredentialType;

public interface ICredentials {
    default public Set<CredentialType> getAllowedCredentials() {
        EnumSet<CredentialType> enumSet = EnumSet.noneOf(CredentialType.class);
        if (this.hasPassword()) {
            enumSet.add(CredentialType.PASSWORD);
        }
        if (this.isDevice()) {
            enumSet.add(CredentialType.DEVICE);
        }
        if (this.isTotp()) {
            enumSet.add(CredentialType.TOTP);
        }
        return enumSet;
    }

    default public Availability getDeviceAvailability() {
        return Availability.of((boolean)this.isDevice(), (boolean)this.isDeviceOnly());
    }

    public PasswordType getPassword();

    default public Availability getPasswordAvailability() {
        return Availability.of((boolean)this.hasPassword(), (boolean)this.isPasswordOnly());
    }

    default public Availability getTotpAvailability() {
        return Availability.of((boolean)this.isTotp(), (boolean)this.isTotpOnly());
    }

    default public boolean hasPassword() {
        return this.getPassword() != null;
    }

    default public boolean isDefined() {
        return this.isDevice() || this.isTotp() || this.hasPassword();
    }

    public boolean isDevice();

    default public boolean isDeviceOnly() {
        return this.isDevice() && !this.isTotp() && !this.hasPassword();
    }

    default public boolean isPasswordOnly() {
        return !this.isDevice() && !this.isTotp() && this.hasPassword();
    }

    public boolean isTotp();

    default public boolean isTotpOnly() {
        return !this.isDevice() && this.isTotp() && !this.hasPassword();
    }
}

