/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.GroupProductLog;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="groups")
@DiscriminatorColumn(name="subclass")
public abstract class BasicGroup
extends ConfigurationEntity
implements ProductOwner,
DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=true)
    private Network network;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private BasicGroupNature nature;
    @ManyToMany
    @JoinTable(name="groups_products", joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="product_id")})
    protected Set<Product> products = new HashSet<Product>();
    @Basic
    @Lob
    @Column(name="product_ids")
    private String productIds;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="configuration_id", nullable=false)
    private Configuration configuration;
    @Basic
    @Column(name="configuration_id", updatable=false, insertable=false, nullable=false)
    private Long configurationId;
    @Basic
    @Column(name="enabled")
    protected Boolean enabled = true;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @ReadOnlyFromDTO
    @Column(name="admin_group_type", updatable=false)
    protected AdminGroupType adminType;
    @OneToMany(mappedBy="basicGroup", cascade={CascadeType.REMOVE})
    private Set<GroupProductLog> groupLogs;
    static final long serialVersionUID = 495783129727477192L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_configuration_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    @Override
    public int compareTo(NamedEntity namedEntity) {
        if (namedEntity instanceof BasicGroup) {
            BasicGroupNature basicGroupNature = this.getNature();
            BasicGroupNature basicGroupNature2 = ((BasicGroup)namedEntity).getNature();
            if (basicGroupNature == BasicGroupNature.ADMIN_GROUP && basicGroupNature2 != BasicGroupNature.ADMIN_GROUP) {
                return -1;
            }
            if (basicGroupNature != BasicGroupNature.ADMIN_GROUP && basicGroupNature2 == BasicGroupNature.ADMIN_GROUP) {
                return 1;
            }
            String string = this.getFullName();
            String string2 = ((BasicGroup)namedEntity).getFullName();
            return string.compareTo(string2);
        }
        return super.compareTo(namedEntity);
    }

    public Configuration getConfiguration() {
        return this._persistence_get_configuration();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.GROUPS;
    }

    public String getFullName() {
        return this.getName();
    }

    public abstract BasicGroupNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    @Override
    public ProductOwner getNextLevelProductOwner() {
        return null;
    }

    @Override
    public Set<Product> getPhysicalProducts() {
        return this._persistence_get_products();
    }

    @Override
    public SortedSet<Long> getProductIds() {
        return StringHelper.toLongSet((String)this._persistence_get_productIds());
    }

    @Override
    public Set<Product> getProducts() {
        return this._persistence_get_products();
    }

    public void setConfiguration(Configuration configuration) {
        this._persistence_set_configuration(configuration);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setProducts(Set<Product> set) {
        this._persistence_set_products(set);
    }

    @Override
    public void updateProductIds(SortedSet<Long> sortedSet) {
        this._persistence_set_productIds(CollectionHelper.join(sortedSet, (String)","));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_configuration_vh != null) {
            this._persistence_configuration_vh = (WeavedAttributeValueHolderInterface)this._persistence_configuration_vh.clone();
        }
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new BasicGroup();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "adminType") {
            return this.adminType;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "configuration") {
            return this.configuration;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "products") {
            return this.products;
        }
        if (string == "productIds") {
            return this.productIds;
        }
        if (string == "groupLogs") {
            return this.groupLogs;
        }
        if (string == "configurationId") {
            return this.configurationId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "adminType") {
            this.adminType = (AdminGroupType)object;
            return;
        }
        if (string == "nature") {
            this.nature = (BasicGroupNature)object;
            return;
        }
        if (string == "configuration") {
            this.configuration = (Configuration)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "products") {
            this.products = (Set)object;
            return;
        }
        if (string == "productIds") {
            this.productIds = (String)object;
            return;
        }
        if (string == "groupLogs") {
            this.groupLogs = (Set)object;
            return;
        }
        if (string == "configurationId") {
            this.configurationId = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public AdminGroupType _persistence_get_adminType() {
        this._persistence_checkFetched("adminType");
        return this.adminType;
    }

    public void _persistence_set_adminType(AdminGroupType adminGroupType) {
        this._persistence_checkFetchedForSet("adminType");
        this._persistence_propertyChange("adminType", this.adminType, adminGroupType);
        this.adminType = adminGroupType;
    }

    public BasicGroupNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(BasicGroupNature basicGroupNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, basicGroupNature);
        this.nature = basicGroupNature;
    }

    protected void _persistence_initialize_configuration_vh() {
        if (this._persistence_configuration_vh == null) {
            this._persistence_configuration_vh = new ValueHolder((Object)this.configuration);
            this._persistence_configuration_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_configuration_vh() {
        Configuration configuration;
        this._persistence_initialize_configuration_vh();
        if ((this._persistence_configuration_vh.isCoordinatedWithProperty() || this._persistence_configuration_vh.isNewlyWeavedValueHolder()) && (configuration = this._persistence_get_configuration()) != this._persistence_configuration_vh.getValue()) {
            this._persistence_set_configuration(configuration);
        }
        return this._persistence_configuration_vh;
    }

    public void _persistence_set_configuration_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_configuration_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Configuration configuration = this._persistence_get_configuration();
            if (configuration != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_configuration((Configuration)object);
            }
        } else {
            this.configuration = null;
        }
    }

    public Configuration _persistence_get_configuration() {
        this._persistence_checkFetched("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (Configuration)this._persistence_configuration_vh.getValue();
        return this.configuration;
    }

    public void _persistence_set_configuration(Configuration configuration) {
        this._persistence_checkFetchedForSet("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (Configuration)this._persistence_configuration_vh.getValue();
        this._persistence_propertyChange("configuration", this.configuration, configuration);
        this.configuration = configuration;
        this._persistence_configuration_vh.setValue((Object)configuration);
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Set _persistence_get_products() {
        this._persistence_checkFetched("products");
        return this.products;
    }

    public void _persistence_set_products(Set set) {
        this._persistence_checkFetchedForSet("products");
        this._persistence_propertyChange("products", this.products, set);
        this.products = set;
    }

    public String _persistence_get_productIds() {
        this._persistence_checkFetched("productIds");
        return this.productIds;
    }

    public void _persistence_set_productIds(String string) {
        this._persistence_checkFetchedForSet("productIds");
        this._persistence_propertyChange("productIds", this.productIds, string);
        this.productIds = string;
    }

    public Set _persistence_get_groupLogs() {
        this._persistence_checkFetched("groupLogs");
        return this.groupLogs;
    }

    public void _persistence_set_groupLogs(Set set) {
        this._persistence_checkFetchedForSet("groupLogs");
        this._persistence_propertyChange("groupLogs", this.groupLogs, set);
        this.groupLogs = set;
    }

    public Long _persistence_get_configurationId() {
        this._persistence_checkFetched("configurationId");
        return this.configurationId;
    }

    public void _persistence_set_configurationId(Long l) {
        this._persistence_checkFetchedForSet("configurationId");
        this._persistence_propertyChange("configurationId", this.configurationId, l);
        this.configurationId = l;
    }
}

