/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.BaseContactInfo;
import org.cyclos.entities.users.ContactInfoImage;
import org.cyclos.entities.users.User;
import org.cyclos.model.users.contactinfos.IRegularContactInfo;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="REGULAR")
public class ContactInfo
extends BaseContactInfo
implements IRegularContactInfo,
ImageOwner<ContactInfo, ContactInfoImage>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToMany(mappedBy="contactInfo")
    private Set<ContactInfoImage> images;
    @Transient
    private TempImage uploadedImage;
    @Basic
    @Column(name="hidden")
    private Boolean hidden;
    static final long serialVersionUID = 9132187621174192765L;

    public ContactInfo() {
    }

    public ContactInfo(User user) {
        this.setUser(user);
    }

    @Override
    public ContactInfoImage getImage() {
        return (ContactInfoImage)CollectionHelper.first((Iterable)this._persistence_get_images());
    }

    public TempImage getUploadedImage() {
        return this.uploadedImage;
    }

    public boolean isHidden() {
        return Boolean.TRUE.equals(this._persistence_get_hidden());
    }

    public void setHidden(boolean bl) {
        this._persistence_set_hidden(bl);
    }

    @Override
    public void setImage(ContactInfoImage contactInfoImage) {
        this._persistence_set_images(CollectionHelper.asSet((Object[])new ContactInfoImage[]{contactInfoImage}));
    }

    public void setUploadedImage(TempImage tempImage) {
        this.uploadedImage = tempImage;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ContactInfo();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "images") {
            return this.images;
        }
        if (string == "hidden") {
            return this.hidden;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "images") {
            this.images = (Set)object;
            return;
        }
        if (string == "hidden") {
            this.hidden = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(Set set) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, set);
        this.images = set;
    }

    public Boolean _persistence_get_hidden() {
        this._persistence_checkFetched("hidden");
        return this.hidden;
    }

    public void _persistence_set_hidden(Boolean bl) {
        this._persistence_checkFetchedForSet("hidden");
        this._persistence_propertyChange("hidden", this.hidden, bl);
        this.hidden = bl;
    }
}

