/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.math.BigDecimal;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.OperatorGroup;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="operator_groups_payment_types", indexes={@Index(name="uk_operator_groups_payment_types", unique=true, columnList="group_id, payment_type_id")})
public class OperatorGroupPaymentType
extends NetworkedEntity
implements HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="group_id", nullable=false)
    private OperatorGroup group;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payment_type_id", nullable=false)
    private PaymentTransferType paymentType;
    @Basic
    @Column(name="enabled")
    private Boolean enabled;
    @Basic
    @Column(name="requires_authorization")
    private Boolean requiresAuthorization;
    @Basic
    @Column(name="authorize")
    private Boolean authorize;
    @Basic
    @Column(name="max_amount_per_day")
    @CurrencyScale
    private BigDecimal maxAmountPerDay;
    static final long serialVersionUID = -2973608125002528173L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_group_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_paymentType_vh;

    @Override
    public Currency getCurrency() {
        return this._persistence_get_paymentType().getCurrency();
    }

    public OperatorGroup getGroup() {
        return this._persistence_get_group();
    }

    public BigDecimal getMaxAmountPerDay() {
        return this._persistence_get_maxAmountPerDay();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_group().getNetwork();
    }

    public PaymentTransferType getPaymentType() {
        return this._persistence_get_paymentType();
    }

    public boolean isAuthorize() {
        return Boolean.TRUE.equals(this._persistence_get_authorize());
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this._persistence_get_enabled());
    }

    public boolean isRequiresAuthorization() {
        return Boolean.TRUE.equals(this._persistence_get_requiresAuthorization());
    }

    public void setAuthorize(boolean bl) {
        this._persistence_set_authorize(bl);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    public void setGroup(OperatorGroup operatorGroup) {
        this._persistence_set_group(operatorGroup);
    }

    public void setMaxAmountPerDay(BigDecimal bigDecimal) {
        this._persistence_set_maxAmountPerDay(bigDecimal);
    }

    public void setPaymentType(PaymentTransferType paymentTransferType) {
        this._persistence_set_paymentType(paymentTransferType);
    }

    public void setRequiresAuthorization(boolean bl) {
        this._persistence_set_requiresAuthorization(bl);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_group_vh != null) {
            this._persistence_group_vh = (WeavedAttributeValueHolderInterface)this._persistence_group_vh.clone();
        }
        if (this._persistence_paymentType_vh != null) {
            this._persistence_paymentType_vh = (WeavedAttributeValueHolderInterface)this._persistence_paymentType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OperatorGroupPaymentType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "authorize") {
            return this.authorize;
        }
        if (string == "maxAmountPerDay") {
            return this.maxAmountPerDay;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "requiresAuthorization") {
            return this.requiresAuthorization;
        }
        if (string == "group") {
            return this.group;
        }
        if (string == "paymentType") {
            return this.paymentType;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "authorize") {
            this.authorize = (Boolean)object;
            return;
        }
        if (string == "maxAmountPerDay") {
            this.maxAmountPerDay = (BigDecimal)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "requiresAuthorization") {
            this.requiresAuthorization = (Boolean)object;
            return;
        }
        if (string == "group") {
            this.group = (OperatorGroup)object;
            return;
        }
        if (string == "paymentType") {
            this.paymentType = (PaymentTransferType)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_authorize() {
        this._persistence_checkFetched("authorize");
        return this.authorize;
    }

    public void _persistence_set_authorize(Boolean bl) {
        this._persistence_checkFetchedForSet("authorize");
        this._persistence_propertyChange("authorize", this.authorize, bl);
        this.authorize = bl;
    }

    public BigDecimal _persistence_get_maxAmountPerDay() {
        this._persistence_checkFetched("maxAmountPerDay");
        return this.maxAmountPerDay;
    }

    public void _persistence_set_maxAmountPerDay(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("maxAmountPerDay");
        this._persistence_propertyChange("maxAmountPerDay", this.maxAmountPerDay, bigDecimal);
        this.maxAmountPerDay = bigDecimal;
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    public Boolean _persistence_get_requiresAuthorization() {
        this._persistence_checkFetched("requiresAuthorization");
        return this.requiresAuthorization;
    }

    public void _persistence_set_requiresAuthorization(Boolean bl) {
        this._persistence_checkFetchedForSet("requiresAuthorization");
        this._persistence_propertyChange("requiresAuthorization", this.requiresAuthorization, bl);
        this.requiresAuthorization = bl;
    }

    protected void _persistence_initialize_group_vh() {
        if (this._persistence_group_vh == null) {
            this._persistence_group_vh = new ValueHolder((Object)this.group);
            this._persistence_group_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_group_vh() {
        OperatorGroup operatorGroup;
        this._persistence_initialize_group_vh();
        if ((this._persistence_group_vh.isCoordinatedWithProperty() || this._persistence_group_vh.isNewlyWeavedValueHolder()) && (operatorGroup = this._persistence_get_group()) != this._persistence_group_vh.getValue()) {
            this._persistence_set_group(operatorGroup);
        }
        return this._persistence_group_vh;
    }

    public void _persistence_set_group_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_group_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            OperatorGroup operatorGroup = this._persistence_get_group();
            if (operatorGroup != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_group((OperatorGroup)object);
            }
        } else {
            this.group = null;
        }
    }

    public OperatorGroup _persistence_get_group() {
        this._persistence_checkFetched("group");
        this._persistence_initialize_group_vh();
        this.group = (OperatorGroup)this._persistence_group_vh.getValue();
        return this.group;
    }

    public void _persistence_set_group(OperatorGroup operatorGroup) {
        this._persistence_checkFetchedForSet("group");
        this._persistence_initialize_group_vh();
        this.group = (OperatorGroup)this._persistence_group_vh.getValue();
        this._persistence_propertyChange("group", this.group, operatorGroup);
        this.group = operatorGroup;
        this._persistence_group_vh.setValue((Object)operatorGroup);
    }

    protected void _persistence_initialize_paymentType_vh() {
        if (this._persistence_paymentType_vh == null) {
            this._persistence_paymentType_vh = new ValueHolder((Object)this.paymentType);
            this._persistence_paymentType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_paymentType_vh() {
        PaymentTransferType paymentTransferType;
        this._persistence_initialize_paymentType_vh();
        if ((this._persistence_paymentType_vh.isCoordinatedWithProperty() || this._persistence_paymentType_vh.isNewlyWeavedValueHolder()) && (paymentTransferType = this._persistence_get_paymentType()) != this._persistence_paymentType_vh.getValue()) {
            this._persistence_set_paymentType(paymentTransferType);
        }
        return this._persistence_paymentType_vh;
    }

    public void _persistence_set_paymentType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_paymentType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PaymentTransferType paymentTransferType = this._persistence_get_paymentType();
            if (paymentTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_paymentType((PaymentTransferType)object);
            }
        } else {
            this.paymentType = null;
        }
    }

    public PaymentTransferType _persistence_get_paymentType() {
        this._persistence_checkFetched("paymentType");
        this._persistence_initialize_paymentType_vh();
        this.paymentType = (PaymentTransferType)this._persistence_paymentType_vh.getValue();
        return this.paymentType;
    }

    public void _persistence_set_paymentType(PaymentTransferType paymentTransferType) {
        this._persistence_checkFetchedForSet("paymentType");
        this._persistence_initialize_paymentType_vh();
        this.paymentType = (PaymentTransferType)this._persistence_paymentType_vh.getValue();
        this._persistence_propertyChange("paymentType", this.paymentType, paymentTransferType);
        this.paymentType = paymentTransferType;
        this._persistence_paymentType_vh.setValue((Object)paymentTransferType);
    }
}

