/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWebService;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GroupProductLog;
import org.cyclos.entities.users.IProduct;
import org.cyclos.entities.users.MyProductPasswordAction;
import org.cyclos.entities.users.ProductManagement;
import org.cyclos.entities.users.ProductMyAccessClient;
import org.cyclos.entities.users.ProductMyContactField;
import org.cyclos.entities.users.ProductMyProfileField;
import org.cyclos.entities.users.ProductMyRecordType;
import org.cyclos.entities.users.ProductQuickAccess;
import org.cyclos.entities.users.ProductTransferStatusFlow;
import org.cyclos.entities.users.ProductUserProfileField;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserProductLog;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="products")
@DiscriminatorColumn(name="subclass")
public abstract class Product
extends ConfigurationEntity
implements DefinesNetwork,
IProduct,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="member_account_type_id", updatable=false)
    protected UserAccountType userAccount;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private ProductNature nature;
    @ElementCollection
    @CollectionTable(name="products_permissions", joinColumns={@JoinColumn(name="product_id")}, indexes={@Index(name="uk_product_id_permission", unique=true, columnList="product_id, permission")})
    @Enumerated(value=EnumType.STRING)
    @Column(name="permission", length=100)
    private Set<Permission> permissions = new HashSet<Permission>();
    @ManyToMany
    @JoinTable(name="users_products", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    private Set<BasicUser> users = new HashSet<BasicUser>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @OneToMany(mappedBy="managedProduct", cascade={CascadeType.ALL})
    private Set<ProductManagement> managedByProducts;
    @ManyToMany
    @JoinTable(name="groups_products", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groups = new HashSet<BasicGroup>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="user_group_accessibility")
    private UserGroupAccessibility userGroupAccessibility = UserGroupAccessibility.NONE;
    @ManyToMany
    @JoinTable(name="products_accessible_user_groups", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> accessibleUserGroups = new HashSet<BasicGroup>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="user_directory_on_groups")
    private UserGroupAccessibility userDirectoryOnGroups = UserGroupAccessibility.NONE;
    @ManyToMany
    @JoinTable(name="products_groups_user_directory", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<BasicGroup> groupsForUserDirectory = new HashSet<BasicGroup>();
    @OneToMany(mappedBy="product", cascade={CascadeType.REMOVE, CascadeType.PERSIST})
    private Set<ProductQuickAccess> defaultQuickAccess = new HashSet<ProductQuickAccess>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<MyProductPasswordAction> passwordActions = new HashSet<MyProductPasswordAction>();
    @ManyToMany
    @JoinTable(name="products_agreements", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="registration_agreement_id")})
    private Set<Agreement> agreements = new HashSet<Agreement>();
    @ManyToMany
    @JoinTable(name="products_document_categories_view", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="document_category_id")})
    private Set<DocumentCategory> documentCategoryView = new HashSet<DocumentCategory>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductMyRecordType> myRecordTypes = new HashSet<ProductMyRecordType>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductMyProfileField> myProfileFields = new HashSet<ProductMyProfileField>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ProductMyContactField> myContactFields = new HashSet<ProductMyContactField>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductMyAccessClient> myAccessClients = new HashSet<ProductMyAccessClient>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductTransferStatusFlow> transferStatusFlows = new HashSet<ProductTransferStatusFlow>();
    @ManyToMany
    @JoinTable(name="products_transfer_custom_operations", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="custom_operation_id")})
    private Set<CustomOperation> runTransferCustomOperations = new HashSet<CustomOperation>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductUserProfileField> userProfileFields = new HashSet<ProductUserProfileField>();
    @ElementCollection
    @CollectionTable(name="simple_user_search_basic_fields", joinColumns={@JoinColumn(name="product_id")})
    @Column(name="field")
    @Enumerated(value=EnumType.STRING)
    private Set<BasicProfileField> simpleUserSearchBasicProfileFields;
    @ManyToMany
    @JoinTable(name="simple_user_search_custom_fields", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="field_id")})
    private Set<UserCustomField> simpleUserSearchCustomProfileFields;
    @ManyToMany
    @JoinTable(name="products_transaction_fields", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="custom_field_id")})
    private Set<TransactionCustomField> visibleTransactionFields = new HashSet<TransactionCustomField>();
    @ManyToMany
    @JoinTable(name="products_voucher_fields", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="custom_field_id")})
    private Set<VoucherCustomField> visibleVoucherFields = new HashSet<VoucherCustomField>();
    @ManyToMany
    @JoinTable(name="products_channels", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="channel_id")})
    private Set<Channel> channels = new HashSet<Channel>();
    @Basic
    @Lob
    @Column(name="channel_ids")
    private String channelIds;
    @ManyToMany
    @JoinTable(name="products_principal_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="principal_type_id")})
    private Set<PrincipalType> principalTypes = new HashSet<PrincipalType>();
    @Basic
    @Lob
    @Column(name="principal_type_ids")
    private String principalTypeIds;
    @ManyToMany
    @JoinTable(name="products_custom_web_services", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="custom_web_service_id")})
    private Set<CustomWebService> runCustomWebServices = new HashSet<CustomWebService>();
    @Basic
    @Column(name="max_profile_images")
    private Integer maxProfileImages;
    @Basic
    @Column(name="max_message_recipients")
    private Integer maxMessageRecipients;
    @Basic
    @Column(name="max_invitation_recipients")
    private Integer maxInvitationRecipients;
    @Basic
    @Column(name="max_addresses")
    private Integer maxAddresses;
    @Basic
    @Column(name="max_mobile_phones")
    private Integer maxMobilePhones;
    @Basic
    @Column(name="max_sms_per_month")
    private Integer maxSmsPerMonth;
    @Basic
    @Column(name="max_landline_phones")
    private Integer maxLandlinePhones;
    @Basic
    @Column(name="max_custom_images")
    private Integer maxCustomImages;
    @ManyToMany(mappedBy="manageIndividualProducts")
    private Set<AdminProduct> managedIndividuallyOnProducts;
    @OneToMany(mappedBy="product", cascade={CascadeType.REMOVE})
    private Set<GroupProductLog> groupLogs;
    @OneToMany(mappedBy="product", cascade={CascadeType.REMOVE})
    private Set<UserProductLog> userLogs;
    static final long serialVersionUID = -4206984995224110327L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_userAccount_vh;

    public Set<BasicGroup> getAccessibleUserGroups() {
        return this._persistence_get_accessibleUserGroups();
    }

    public Set<Agreement> getAgreements() {
        return this._persistence_get_agreements();
    }

    public String getChannelIds() {
        return this._persistence_get_channelIds();
    }

    public Set<Channel> getChannels() {
        return this._persistence_get_channels();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.PRODUCTS;
    }

    public Set<ProductQuickAccess> getDefaultQuickAccess() {
        return this._persistence_get_defaultQuickAccess();
    }

    public Set<DocumentCategory> getDocumentCategoryView() {
        return this._persistence_get_documentCategoryView();
    }

    public Set<? extends BasicGroup> getGroups() {
        return this._persistence_get_groups();
    }

    public Set<BasicGroup> getGroupsForUserDirectory() {
        return this._persistence_get_groupsForUserDirectory();
    }

    public Integer getMaxAddresses() {
        return this._persistence_get_maxAddresses();
    }

    public Integer getMaxCustomImages() {
        return this._persistence_get_maxCustomImages();
    }

    public Integer getMaxInvitationRecipients() {
        return this._persistence_get_maxInvitationRecipients();
    }

    public Integer getMaxLandlinePhones() {
        return this._persistence_get_maxLandlinePhones();
    }

    public Integer getMaxMessageRecipients() {
        return this._persistence_get_maxMessageRecipients();
    }

    public Integer getMaxMobilePhones() {
        return this._persistence_get_maxMobilePhones();
    }

    public Integer getMaxProfileImages() {
        return this._persistence_get_maxProfileImages();
    }

    public Integer getMaxSmsPerMonth() {
        return this._persistence_get_maxSmsPerMonth();
    }

    public Set<ProductMyAccessClient> getMyAccessClients() {
        return this._persistence_get_myAccessClients();
    }

    public Set<ProductMyContactField> getMyContactFields() {
        return this._persistence_get_myContactFields();
    }

    public Set<ProductMyProfileField> getMyProfileFields() {
        return this._persistence_get_myProfileFields();
    }

    public Set<ProductMyRecordType> getMyRecordTypes() {
        return this._persistence_get_myRecordTypes();
    }

    public abstract ProductNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public Set<MyProductPasswordAction> getPasswordActions() {
        return this._persistence_get_passwordActions();
    }

    public Set<Permission> getPermissions() {
        return this._persistence_get_permissions();
    }

    public String getPrincipalTypeIds() {
        return this._persistence_get_principalTypeIds();
    }

    public Set<PrincipalType> getPrincipalTypes() {
        return this._persistence_get_principalTypes();
    }

    @Override
    public Role getRole() {
        return this.getNature().getRole();
    }

    public Set<CustomWebService> getRunCustomWebServices() {
        return this._persistence_get_runCustomWebServices();
    }

    public Set<CustomOperation> getRunTransferCustomOperations() {
        return this._persistence_get_runTransferCustomOperations();
    }

    public Set<ProfileField> getSimpleUserSearchProfileFields() {
        HashSet<ProfileField> hashSet = new HashSet<ProfileField>();
        if (this._persistence_get_simpleUserSearchBasicProfileFields() != null) {
            hashSet.addAll(this._persistence_get_simpleUserSearchBasicProfileFields());
        }
        if (this._persistence_get_simpleUserSearchCustomProfileFields() != null) {
            hashSet.addAll(this._persistence_get_simpleUserSearchCustomProfileFields());
        }
        return hashSet;
    }

    public Set<ProductTransferStatusFlow> getTransferStatusFlows() {
        return this._persistence_get_transferStatusFlows();
    }

    public UserGroupAccessibility getUserDirectoryOnGroups() {
        return this._persistence_get_userDirectoryOnGroups();
    }

    public UserGroupAccessibility getUserGroupAccessibility() {
        return this._persistence_get_userGroupAccessibility();
    }

    public Set<ProductUserProfileField> getUserProfileFields() {
        return this._persistence_get_userProfileFields();
    }

    public Set<TransactionCustomField> getVisibleTransactionFields() {
        return this._persistence_get_visibleTransactionFields();
    }

    public Set<VoucherCustomField> getVisibleVoucherFields() {
        return this._persistence_get_visibleVoucherFields();
    }

    public void setAccessibleUserGroups(Set<BasicGroup> set) {
        this._persistence_set_accessibleUserGroups(set);
    }

    public void setAgreements(Set<Agreement> set) {
        this._persistence_set_agreements(set);
    }

    public void setChannelIds(String string) {
        this._persistence_set_channelIds(string);
    }

    public void setChannels(Set<Channel> set) {
        this._persistence_set_channels(set);
    }

    public void setDefaultQuickAccess(Set<ProductQuickAccess> set) {
        this._persistence_set_defaultQuickAccess(set);
    }

    public void setDocumentCategoryView(Set<DocumentCategory> set) {
        this._persistence_set_documentCategoryView(set);
    }

    public void setGroups(Set<? extends BasicGroup> set) {
        this._persistence_set_groups(set);
    }

    public void setGroupsForUserDirectory(Set<BasicGroup> set) {
        this._persistence_set_groupsForUserDirectory(set);
    }

    public void setMaxAddresses(Integer n) {
        this._persistence_set_maxAddresses(n);
    }

    public void setMaxCustomImages(Integer n) {
        this._persistence_set_maxCustomImages(n);
    }

    public void setMaxInvitationRecipients(Integer n) {
        this._persistence_set_maxInvitationRecipients(n);
    }

    public void setMaxLandlinePhones(Integer n) {
        this._persistence_set_maxLandlinePhones(n);
    }

    public void setMaxMessageRecipients(Integer n) {
        this._persistence_set_maxMessageRecipients(n);
    }

    public void setMaxMobilePhones(Integer n) {
        this._persistence_set_maxMobilePhones(n);
    }

    public void setMaxProfileImages(Integer n) {
        this._persistence_set_maxProfileImages(n);
    }

    public void setMaxSmsPerMonth(Integer n) {
        this._persistence_set_maxSmsPerMonth(n);
    }

    public void setMyAccessClients(Set<ProductMyAccessClient> set) {
        this._persistence_set_myAccessClients(set);
    }

    public void setMyContactFields(Set<ProductMyContactField> set) {
        this._persistence_set_myContactFields(set);
    }

    public void setMyProfileFields(Set<ProductMyProfileField> set) {
        this._persistence_set_myProfileFields(set);
    }

    public void setMyRecordTypes(Set<ProductMyRecordType> set) {
        this._persistence_set_myRecordTypes(set);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setPasswordActions(Set<MyProductPasswordAction> set) {
        this._persistence_set_passwordActions(set);
    }

    public void setPrincipalTypeIds(String string) {
        this._persistence_set_principalTypeIds(string);
    }

    public void setPrincipalTypes(Set<PrincipalType> set) {
        this._persistence_set_principalTypes(set);
    }

    public void setRunCustomWebServices(Set<CustomWebService> set) {
        this._persistence_set_runCustomWebServices(set);
    }

    public void setRunTransferCustomOperations(Set<CustomOperation> set) {
        this._persistence_set_runTransferCustomOperations(set);
    }

    public void setSimpleUserSearchProfileFields(Set<ProfileField> set) {
        this._persistence_set_simpleUserSearchBasicProfileFields(new HashSet());
        this._persistence_set_simpleUserSearchCustomProfileFields(new HashSet());
        if (set != null) {
            for (ProfileField profileField : set) {
                if (profileField instanceof BasicProfileField) {
                    this._persistence_get_simpleUserSearchBasicProfileFields().add((BasicProfileField)profileField);
                    continue;
                }
                if (!(profileField instanceof UserCustomField)) continue;
                this._persistence_get_simpleUserSearchCustomProfileFields().add((UserCustomField)profileField);
            }
        }
    }

    public void setTransferStatusFlows(Set<ProductTransferStatusFlow> set) {
        this._persistence_set_transferStatusFlows(set);
    }

    public void setUserDirectoryOnGroups(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_set_userDirectoryOnGroups(userGroupAccessibility);
    }

    public void setUserGroupAccessibility(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_set_userGroupAccessibility(userGroupAccessibility);
    }

    public void setUserProfileFields(Set<ProductUserProfileField> set) {
        this._persistence_set_userProfileFields(set);
    }

    public void setVisibleTransactionFields(Set<TransactionCustomField> set) {
        this._persistence_set_visibleTransactionFields(set);
    }

    public void setVisibleVoucherFields(Set<VoucherCustomField> set) {
        this._persistence_set_visibleVoucherFields(set);
    }

    protected Set<PaymentTransferType> filterPaymentTypes(Collection<PaymentTransferType> collection, TransferTypeDirection transferTypeDirection) {
        HashSet<PaymentTransferType> hashSet = new HashSet<PaymentTransferType>();
        if (collection != null) {
            for (PaymentTransferType paymentTransferType : collection) {
                if (paymentTransferType.getDirection() != transferTypeDirection) continue;
                hashSet.add(paymentTransferType);
            }
        }
        return hashSet;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_userAccount_vh != null) {
            this._persistence_userAccount_vh = (WeavedAttributeValueHolderInterface)this._persistence_userAccount_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Product();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "maxCustomImages") {
            return this.maxCustomImages;
        }
        if (string == "simpleUserSearchCustomProfileFields") {
            return this.simpleUserSearchCustomProfileFields;
        }
        if (string == "userLogs") {
            return this.userLogs;
        }
        if (string == "managedByProducts") {
            return this.managedByProducts;
        }
        if (string == "myRecordTypes") {
            return this.myRecordTypes;
        }
        if (string == "managedIndividuallyOnProducts") {
            return this.managedIndividuallyOnProducts;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "documentCategoryView") {
            return this.documentCategoryView;
        }
        if (string == "defaultQuickAccess") {
            return this.defaultQuickAccess;
        }
        if (string == "transferStatusFlows") {
            return this.transferStatusFlows;
        }
        if (string == "maxInvitationRecipients") {
            return this.maxInvitationRecipients;
        }
        if (string == "runTransferCustomOperations") {
            return this.runTransferCustomOperations;
        }
        if (string == "maxAddresses") {
            return this.maxAddresses;
        }
        if (string == "permissions") {
            return this.permissions;
        }
        if (string == "visibleVoucherFields") {
            return this.visibleVoucherFields;
        }
        if (string == "userGroupAccessibility") {
            return this.userGroupAccessibility;
        }
        if (string == "groupLogs") {
            return this.groupLogs;
        }
        if (string == "channelIds") {
            return this.channelIds;
        }
        if (string == "runCustomWebServices") {
            return this.runCustomWebServices;
        }
        if (string == "passwordActions") {
            return this.passwordActions;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "maxMobilePhones") {
            return this.maxMobilePhones;
        }
        if (string == "maxLandlinePhones") {
            return this.maxLandlinePhones;
        }
        if (string == "principalTypeIds") {
            return this.principalTypeIds;
        }
        if (string == "maxProfileImages") {
            return this.maxProfileImages;
        }
        if (string == "groups") {
            return this.groups;
        }
        if (string == "agreements") {
            return this.agreements;
        }
        if (string == "users") {
            return this.users;
        }
        if (string == "myContactFields") {
            return this.myContactFields;
        }
        if (string == "visibleTransactionFields") {
            return this.visibleTransactionFields;
        }
        if (string == "simpleUserSearchBasicProfileFields") {
            return this.simpleUserSearchBasicProfileFields;
        }
        if (string == "userDirectoryOnGroups") {
            return this.userDirectoryOnGroups;
        }
        if (string == "channels") {
            return this.channels;
        }
        if (string == "myAccessClients") {
            return this.myAccessClients;
        }
        if (string == "maxMessageRecipients") {
            return this.maxMessageRecipients;
        }
        if (string == "principalTypes") {
            return this.principalTypes;
        }
        if (string == "maxSmsPerMonth") {
            return this.maxSmsPerMonth;
        }
        if (string == "userAccount") {
            return this.userAccount;
        }
        if (string == "accessibleUserGroups") {
            return this.accessibleUserGroups;
        }
        if (string == "groupsForUserDirectory") {
            return this.groupsForUserDirectory;
        }
        if (string == "myProfileFields") {
            return this.myProfileFields;
        }
        if (string == "userProfileFields") {
            return this.userProfileFields;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "maxCustomImages") {
            this.maxCustomImages = (Integer)object;
            return;
        }
        if (string == "simpleUserSearchCustomProfileFields") {
            this.simpleUserSearchCustomProfileFields = (Set)object;
            return;
        }
        if (string == "userLogs") {
            this.userLogs = (Set)object;
            return;
        }
        if (string == "managedByProducts") {
            this.managedByProducts = (Set)object;
            return;
        }
        if (string == "myRecordTypes") {
            this.myRecordTypes = (Set)object;
            return;
        }
        if (string == "managedIndividuallyOnProducts") {
            this.managedIndividuallyOnProducts = (Set)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "documentCategoryView") {
            this.documentCategoryView = (Set)object;
            return;
        }
        if (string == "defaultQuickAccess") {
            this.defaultQuickAccess = (Set)object;
            return;
        }
        if (string == "transferStatusFlows") {
            this.transferStatusFlows = (Set)object;
            return;
        }
        if (string == "maxInvitationRecipients") {
            this.maxInvitationRecipients = (Integer)object;
            return;
        }
        if (string == "runTransferCustomOperations") {
            this.runTransferCustomOperations = (Set)object;
            return;
        }
        if (string == "maxAddresses") {
            this.maxAddresses = (Integer)object;
            return;
        }
        if (string == "permissions") {
            this.permissions = (Set)object;
            return;
        }
        if (string == "visibleVoucherFields") {
            this.visibleVoucherFields = (Set)object;
            return;
        }
        if (string == "userGroupAccessibility") {
            this.userGroupAccessibility = (UserGroupAccessibility)object;
            return;
        }
        if (string == "groupLogs") {
            this.groupLogs = (Set)object;
            return;
        }
        if (string == "channelIds") {
            this.channelIds = (String)object;
            return;
        }
        if (string == "runCustomWebServices") {
            this.runCustomWebServices = (Set)object;
            return;
        }
        if (string == "passwordActions") {
            this.passwordActions = (Set)object;
            return;
        }
        if (string == "nature") {
            this.nature = (ProductNature)object;
            return;
        }
        if (string == "maxMobilePhones") {
            this.maxMobilePhones = (Integer)object;
            return;
        }
        if (string == "maxLandlinePhones") {
            this.maxLandlinePhones = (Integer)object;
            return;
        }
        if (string == "principalTypeIds") {
            this.principalTypeIds = (String)object;
            return;
        }
        if (string == "maxProfileImages") {
            this.maxProfileImages = (Integer)object;
            return;
        }
        if (string == "groups") {
            this.groups = (Set)object;
            return;
        }
        if (string == "agreements") {
            this.agreements = (Set)object;
            return;
        }
        if (string == "users") {
            this.users = (Set)object;
            return;
        }
        if (string == "myContactFields") {
            this.myContactFields = (Set)object;
            return;
        }
        if (string == "visibleTransactionFields") {
            this.visibleTransactionFields = (Set)object;
            return;
        }
        if (string == "simpleUserSearchBasicProfileFields") {
            this.simpleUserSearchBasicProfileFields = (Set)object;
            return;
        }
        if (string == "userDirectoryOnGroups") {
            this.userDirectoryOnGroups = (UserGroupAccessibility)object;
            return;
        }
        if (string == "channels") {
            this.channels = (Set)object;
            return;
        }
        if (string == "myAccessClients") {
            this.myAccessClients = (Set)object;
            return;
        }
        if (string == "maxMessageRecipients") {
            this.maxMessageRecipients = (Integer)object;
            return;
        }
        if (string == "principalTypes") {
            this.principalTypes = (Set)object;
            return;
        }
        if (string == "maxSmsPerMonth") {
            this.maxSmsPerMonth = (Integer)object;
            return;
        }
        if (string == "userAccount") {
            this.userAccount = (UserAccountType)object;
            return;
        }
        if (string == "accessibleUserGroups") {
            this.accessibleUserGroups = (Set)object;
            return;
        }
        if (string == "groupsForUserDirectory") {
            this.groupsForUserDirectory = (Set)object;
            return;
        }
        if (string == "myProfileFields") {
            this.myProfileFields = (Set)object;
            return;
        }
        if (string == "userProfileFields") {
            this.userProfileFields = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Integer _persistence_get_maxCustomImages() {
        this._persistence_checkFetched("maxCustomImages");
        return this.maxCustomImages;
    }

    public void _persistence_set_maxCustomImages(Integer n) {
        this._persistence_checkFetchedForSet("maxCustomImages");
        this._persistence_propertyChange("maxCustomImages", this.maxCustomImages, n);
        this.maxCustomImages = n;
    }

    public Set _persistence_get_simpleUserSearchCustomProfileFields() {
        this._persistence_checkFetched("simpleUserSearchCustomProfileFields");
        return this.simpleUserSearchCustomProfileFields;
    }

    public void _persistence_set_simpleUserSearchCustomProfileFields(Set set) {
        this._persistence_checkFetchedForSet("simpleUserSearchCustomProfileFields");
        this._persistence_propertyChange("simpleUserSearchCustomProfileFields", this.simpleUserSearchCustomProfileFields, set);
        this.simpleUserSearchCustomProfileFields = set;
    }

    public Set _persistence_get_userLogs() {
        this._persistence_checkFetched("userLogs");
        return this.userLogs;
    }

    public void _persistence_set_userLogs(Set set) {
        this._persistence_checkFetchedForSet("userLogs");
        this._persistence_propertyChange("userLogs", this.userLogs, set);
        this.userLogs = set;
    }

    public Set _persistence_get_managedByProducts() {
        this._persistence_checkFetched("managedByProducts");
        return this.managedByProducts;
    }

    public void _persistence_set_managedByProducts(Set set) {
        this._persistence_checkFetchedForSet("managedByProducts");
        this._persistence_propertyChange("managedByProducts", this.managedByProducts, set);
        this.managedByProducts = set;
    }

    public Set _persistence_get_myRecordTypes() {
        this._persistence_checkFetched("myRecordTypes");
        return this.myRecordTypes;
    }

    public void _persistence_set_myRecordTypes(Set set) {
        this._persistence_checkFetchedForSet("myRecordTypes");
        this._persistence_propertyChange("myRecordTypes", this.myRecordTypes, set);
        this.myRecordTypes = set;
    }

    public Set _persistence_get_managedIndividuallyOnProducts() {
        this._persistence_checkFetched("managedIndividuallyOnProducts");
        return this.managedIndividuallyOnProducts;
    }

    public void _persistence_set_managedIndividuallyOnProducts(Set set) {
        this._persistence_checkFetchedForSet("managedIndividuallyOnProducts");
        this._persistence_propertyChange("managedIndividuallyOnProducts", this.managedIndividuallyOnProducts, set);
        this.managedIndividuallyOnProducts = set;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Set _persistence_get_documentCategoryView() {
        this._persistence_checkFetched("documentCategoryView");
        return this.documentCategoryView;
    }

    public void _persistence_set_documentCategoryView(Set set) {
        this._persistence_checkFetchedForSet("documentCategoryView");
        this._persistence_propertyChange("documentCategoryView", this.documentCategoryView, set);
        this.documentCategoryView = set;
    }

    public Set _persistence_get_defaultQuickAccess() {
        this._persistence_checkFetched("defaultQuickAccess");
        return this.defaultQuickAccess;
    }

    public void _persistence_set_defaultQuickAccess(Set set) {
        this._persistence_checkFetchedForSet("defaultQuickAccess");
        this._persistence_propertyChange("defaultQuickAccess", this.defaultQuickAccess, set);
        this.defaultQuickAccess = set;
    }

    public Set _persistence_get_transferStatusFlows() {
        this._persistence_checkFetched("transferStatusFlows");
        return this.transferStatusFlows;
    }

    public void _persistence_set_transferStatusFlows(Set set) {
        this._persistence_checkFetchedForSet("transferStatusFlows");
        this._persistence_propertyChange("transferStatusFlows", this.transferStatusFlows, set);
        this.transferStatusFlows = set;
    }

    public Integer _persistence_get_maxInvitationRecipients() {
        this._persistence_checkFetched("maxInvitationRecipients");
        return this.maxInvitationRecipients;
    }

    public void _persistence_set_maxInvitationRecipients(Integer n) {
        this._persistence_checkFetchedForSet("maxInvitationRecipients");
        this._persistence_propertyChange("maxInvitationRecipients", this.maxInvitationRecipients, n);
        this.maxInvitationRecipients = n;
    }

    public Set _persistence_get_runTransferCustomOperations() {
        this._persistence_checkFetched("runTransferCustomOperations");
        return this.runTransferCustomOperations;
    }

    public void _persistence_set_runTransferCustomOperations(Set set) {
        this._persistence_checkFetchedForSet("runTransferCustomOperations");
        this._persistence_propertyChange("runTransferCustomOperations", this.runTransferCustomOperations, set);
        this.runTransferCustomOperations = set;
    }

    public Integer _persistence_get_maxAddresses() {
        this._persistence_checkFetched("maxAddresses");
        return this.maxAddresses;
    }

    public void _persistence_set_maxAddresses(Integer n) {
        this._persistence_checkFetchedForSet("maxAddresses");
        this._persistence_propertyChange("maxAddresses", this.maxAddresses, n);
        this.maxAddresses = n;
    }

    public Set _persistence_get_permissions() {
        this._persistence_checkFetched("permissions");
        return this.permissions;
    }

    public void _persistence_set_permissions(Set set) {
        this._persistence_checkFetchedForSet("permissions");
        this._persistence_propertyChange("permissions", this.permissions, set);
        this.permissions = set;
    }

    public Set _persistence_get_visibleVoucherFields() {
        this._persistence_checkFetched("visibleVoucherFields");
        return this.visibleVoucherFields;
    }

    public void _persistence_set_visibleVoucherFields(Set set) {
        this._persistence_checkFetchedForSet("visibleVoucherFields");
        this._persistence_propertyChange("visibleVoucherFields", this.visibleVoucherFields, set);
        this.visibleVoucherFields = set;
    }

    public UserGroupAccessibility _persistence_get_userGroupAccessibility() {
        this._persistence_checkFetched("userGroupAccessibility");
        return this.userGroupAccessibility;
    }

    public void _persistence_set_userGroupAccessibility(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_checkFetchedForSet("userGroupAccessibility");
        this._persistence_propertyChange("userGroupAccessibility", this.userGroupAccessibility, userGroupAccessibility);
        this.userGroupAccessibility = userGroupAccessibility;
    }

    public Set _persistence_get_groupLogs() {
        this._persistence_checkFetched("groupLogs");
        return this.groupLogs;
    }

    public void _persistence_set_groupLogs(Set set) {
        this._persistence_checkFetchedForSet("groupLogs");
        this._persistence_propertyChange("groupLogs", this.groupLogs, set);
        this.groupLogs = set;
    }

    public String _persistence_get_channelIds() {
        this._persistence_checkFetched("channelIds");
        return this.channelIds;
    }

    public void _persistence_set_channelIds(String string) {
        this._persistence_checkFetchedForSet("channelIds");
        this._persistence_propertyChange("channelIds", this.channelIds, string);
        this.channelIds = string;
    }

    public Set _persistence_get_runCustomWebServices() {
        this._persistence_checkFetched("runCustomWebServices");
        return this.runCustomWebServices;
    }

    public void _persistence_set_runCustomWebServices(Set set) {
        this._persistence_checkFetchedForSet("runCustomWebServices");
        this._persistence_propertyChange("runCustomWebServices", this.runCustomWebServices, set);
        this.runCustomWebServices = set;
    }

    public Set _persistence_get_passwordActions() {
        this._persistence_checkFetched("passwordActions");
        return this.passwordActions;
    }

    public void _persistence_set_passwordActions(Set set) {
        this._persistence_checkFetchedForSet("passwordActions");
        this._persistence_propertyChange("passwordActions", this.passwordActions, set);
        this.passwordActions = set;
    }

    public ProductNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(ProductNature productNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, productNature);
        this.nature = productNature;
    }

    public Integer _persistence_get_maxMobilePhones() {
        this._persistence_checkFetched("maxMobilePhones");
        return this.maxMobilePhones;
    }

    public void _persistence_set_maxMobilePhones(Integer n) {
        this._persistence_checkFetchedForSet("maxMobilePhones");
        this._persistence_propertyChange("maxMobilePhones", this.maxMobilePhones, n);
        this.maxMobilePhones = n;
    }

    public Integer _persistence_get_maxLandlinePhones() {
        this._persistence_checkFetched("maxLandlinePhones");
        return this.maxLandlinePhones;
    }

    public void _persistence_set_maxLandlinePhones(Integer n) {
        this._persistence_checkFetchedForSet("maxLandlinePhones");
        this._persistence_propertyChange("maxLandlinePhones", this.maxLandlinePhones, n);
        this.maxLandlinePhones = n;
    }

    public String _persistence_get_principalTypeIds() {
        this._persistence_checkFetched("principalTypeIds");
        return this.principalTypeIds;
    }

    public void _persistence_set_principalTypeIds(String string) {
        this._persistence_checkFetchedForSet("principalTypeIds");
        this._persistence_propertyChange("principalTypeIds", this.principalTypeIds, string);
        this.principalTypeIds = string;
    }

    public Integer _persistence_get_maxProfileImages() {
        this._persistence_checkFetched("maxProfileImages");
        return this.maxProfileImages;
    }

    public void _persistence_set_maxProfileImages(Integer n) {
        this._persistence_checkFetchedForSet("maxProfileImages");
        this._persistence_propertyChange("maxProfileImages", this.maxProfileImages, n);
        this.maxProfileImages = n;
    }

    public Set _persistence_get_groups() {
        this._persistence_checkFetched("groups");
        return this.groups;
    }

    public void _persistence_set_groups(Set set) {
        this._persistence_checkFetchedForSet("groups");
        this._persistence_propertyChange("groups", this.groups, set);
        this.groups = set;
    }

    public Set _persistence_get_agreements() {
        this._persistence_checkFetched("agreements");
        return this.agreements;
    }

    public void _persistence_set_agreements(Set set) {
        this._persistence_checkFetchedForSet("agreements");
        this._persistence_propertyChange("agreements", this.agreements, set);
        this.agreements = set;
    }

    public Set _persistence_get_users() {
        this._persistence_checkFetched("users");
        return this.users;
    }

    public void _persistence_set_users(Set set) {
        this._persistence_checkFetchedForSet("users");
        this._persistence_propertyChange("users", this.users, set);
        this.users = set;
    }

    public Set _persistence_get_myContactFields() {
        this._persistence_checkFetched("myContactFields");
        return this.myContactFields;
    }

    public void _persistence_set_myContactFields(Set set) {
        this._persistence_checkFetchedForSet("myContactFields");
        this._persistence_propertyChange("myContactFields", this.myContactFields, set);
        this.myContactFields = set;
    }

    public Set _persistence_get_visibleTransactionFields() {
        this._persistence_checkFetched("visibleTransactionFields");
        return this.visibleTransactionFields;
    }

    public void _persistence_set_visibleTransactionFields(Set set) {
        this._persistence_checkFetchedForSet("visibleTransactionFields");
        this._persistence_propertyChange("visibleTransactionFields", this.visibleTransactionFields, set);
        this.visibleTransactionFields = set;
    }

    public Set _persistence_get_simpleUserSearchBasicProfileFields() {
        this._persistence_checkFetched("simpleUserSearchBasicProfileFields");
        return this.simpleUserSearchBasicProfileFields;
    }

    public void _persistence_set_simpleUserSearchBasicProfileFields(Set set) {
        this._persistence_checkFetchedForSet("simpleUserSearchBasicProfileFields");
        this._persistence_propertyChange("simpleUserSearchBasicProfileFields", this.simpleUserSearchBasicProfileFields, set);
        this.simpleUserSearchBasicProfileFields = set;
    }

    public UserGroupAccessibility _persistence_get_userDirectoryOnGroups() {
        this._persistence_checkFetched("userDirectoryOnGroups");
        return this.userDirectoryOnGroups;
    }

    public void _persistence_set_userDirectoryOnGroups(UserGroupAccessibility userGroupAccessibility) {
        this._persistence_checkFetchedForSet("userDirectoryOnGroups");
        this._persistence_propertyChange("userDirectoryOnGroups", this.userDirectoryOnGroups, userGroupAccessibility);
        this.userDirectoryOnGroups = userGroupAccessibility;
    }

    public Set _persistence_get_channels() {
        this._persistence_checkFetched("channels");
        return this.channels;
    }

    public void _persistence_set_channels(Set set) {
        this._persistence_checkFetchedForSet("channels");
        this._persistence_propertyChange("channels", this.channels, set);
        this.channels = set;
    }

    public Set _persistence_get_myAccessClients() {
        this._persistence_checkFetched("myAccessClients");
        return this.myAccessClients;
    }

    public void _persistence_set_myAccessClients(Set set) {
        this._persistence_checkFetchedForSet("myAccessClients");
        this._persistence_propertyChange("myAccessClients", this.myAccessClients, set);
        this.myAccessClients = set;
    }

    public Integer _persistence_get_maxMessageRecipients() {
        this._persistence_checkFetched("maxMessageRecipients");
        return this.maxMessageRecipients;
    }

    public void _persistence_set_maxMessageRecipients(Integer n) {
        this._persistence_checkFetchedForSet("maxMessageRecipients");
        this._persistence_propertyChange("maxMessageRecipients", this.maxMessageRecipients, n);
        this.maxMessageRecipients = n;
    }

    public Set _persistence_get_principalTypes() {
        this._persistence_checkFetched("principalTypes");
        return this.principalTypes;
    }

    public void _persistence_set_principalTypes(Set set) {
        this._persistence_checkFetchedForSet("principalTypes");
        this._persistence_propertyChange("principalTypes", this.principalTypes, set);
        this.principalTypes = set;
    }

    public Integer _persistence_get_maxSmsPerMonth() {
        this._persistence_checkFetched("maxSmsPerMonth");
        return this.maxSmsPerMonth;
    }

    public void _persistence_set_maxSmsPerMonth(Integer n) {
        this._persistence_checkFetchedForSet("maxSmsPerMonth");
        this._persistence_propertyChange("maxSmsPerMonth", this.maxSmsPerMonth, n);
        this.maxSmsPerMonth = n;
    }

    protected void _persistence_initialize_userAccount_vh() {
        if (this._persistence_userAccount_vh == null) {
            this._persistence_userAccount_vh = new ValueHolder((Object)this.userAccount);
            this._persistence_userAccount_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_userAccount_vh() {
        UserAccountType userAccountType;
        this._persistence_initialize_userAccount_vh();
        if ((this._persistence_userAccount_vh.isCoordinatedWithProperty() || this._persistence_userAccount_vh.isNewlyWeavedValueHolder()) && (userAccountType = this._persistence_get_userAccount()) != this._persistence_userAccount_vh.getValue()) {
            this._persistence_set_userAccount(userAccountType);
        }
        return this._persistence_userAccount_vh;
    }

    public void _persistence_set_userAccount_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_userAccount_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserAccountType userAccountType = this._persistence_get_userAccount();
            if (userAccountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_userAccount((UserAccountType)object);
            }
        } else {
            this.userAccount = null;
        }
    }

    public UserAccountType _persistence_get_userAccount() {
        this._persistence_checkFetched("userAccount");
        this._persistence_initialize_userAccount_vh();
        this.userAccount = (UserAccountType)this._persistence_userAccount_vh.getValue();
        return this.userAccount;
    }

    public void _persistence_set_userAccount(UserAccountType userAccountType) {
        this._persistence_checkFetchedForSet("userAccount");
        this._persistence_initialize_userAccount_vh();
        this.userAccount = (UserAccountType)this._persistence_userAccount_vh.getValue();
        this._persistence_propertyChange("userAccount", this.userAccount, userAccountType);
        this.userAccount = userAccountType;
        this._persistence_userAccount_vh.setValue((Object)userAccountType);
    }

    public Set _persistence_get_accessibleUserGroups() {
        this._persistence_checkFetched("accessibleUserGroups");
        return this.accessibleUserGroups;
    }

    public void _persistence_set_accessibleUserGroups(Set set) {
        this._persistence_checkFetchedForSet("accessibleUserGroups");
        this._persistence_propertyChange("accessibleUserGroups", this.accessibleUserGroups, set);
        this.accessibleUserGroups = set;
    }

    public Set _persistence_get_groupsForUserDirectory() {
        this._persistence_checkFetched("groupsForUserDirectory");
        return this.groupsForUserDirectory;
    }

    public void _persistence_set_groupsForUserDirectory(Set set) {
        this._persistence_checkFetchedForSet("groupsForUserDirectory");
        this._persistence_propertyChange("groupsForUserDirectory", this.groupsForUserDirectory, set);
        this.groupsForUserDirectory = set;
    }

    public Set _persistence_get_myProfileFields() {
        this._persistence_checkFetched("myProfileFields");
        return this.myProfileFields;
    }

    public void _persistence_set_myProfileFields(Set set) {
        this._persistence_checkFetchedForSet("myProfileFields");
        this._persistence_propertyChange("myProfileFields", this.myProfileFields, set);
        this.myProfileFields = set;
    }

    public Set _persistence_get_userProfileFields() {
        this._persistence_checkFetched("userProfileFields");
        return this.userProfileFields;
    }

    public void _persistence_set_userProfileFields(Set set) {
        this._persistence_checkFetchedForSet("userProfileFields");
        this._persistence_propertyChange("userProfileFields", this.userProfileFields, set);
        this.userProfileFields = set;
    }
}

