/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Set;
import java.util.SortedSet;
import org.cyclos.entities.HasNetwork;
import org.cyclos.entities.users.Product;
import org.cyclos.model.IEntity;

public interface ProductOwner
extends IEntity,
HasNetwork {
    private void adjustIds(Product product, boolean bl) {
        SortedSet<Long> sortedSet = this.getProductIds();
        Long l = product.getId();
        if (bl) {
            sortedSet.add(l);
        } else {
            sortedSet.remove(l);
        }
        this.updateProductIds(sortedSet);
    }

    default public boolean addProduct(Product product) {
        this.adjustIds(product, true);
        return this.getPhysicalProducts().add(product);
    }

    default public SortedSet<Long> getAllProductIds() {
        SortedSet<Long> sortedSet = this.getProductIds();
        ProductOwner productOwner = this.getNextLevelProductOwner();
        if (productOwner != null) {
            sortedSet.addAll(productOwner.getAllProductIds());
        }
        return sortedSet;
    }

    public ProductOwner getNextLevelProductOwner();

    public Set<Product> getPhysicalProducts();

    public SortedSet<Long> getProductIds();

    public Set<Product> getProducts();

    default public boolean removeProduct(Product product) {
        this.adjustIds(product, false);
        return this.getPhysicalProducts().remove(product);
    }

    public void updateProductIds(SortedSet<Long> var1);
}

