/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.Comparator;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.users.RecordType;
import org.cyclos.model.IEntity;
import org.cyclos.model.users.dashboard.QuickAccessType;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@MappedSuperclass
public abstract class QuickAccess
extends NetworkedEntity
implements Comparable<QuickAccess>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    public static final Comparator<QuickAccess> COMPARATOR = Comparator.comparing(QuickAccess::getType).thenComparing(Comparator.comparing(QuickAccess::getEntity, Comparator.nullsLast(Comparator.naturalOrder())));
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    private QuickAccessType type;
    @Basic
    @Column(name="entity_id", nullable=false)
    private String entityId = "";
    @ManyToOne
    @JoinColumn(name="custom_operation_id")
    private CustomOperation customOperation;
    @ManyToOne
    @JoinColumn(name="custom_wizard_id")
    private CustomWizard customWizard;
    @ManyToOne
    @JoinColumn(name="record_type_id")
    private RecordType recordType;
    @ManyToOne
    @JoinColumn(name="token_type_id")
    private TokenPrincipalType tokenType;
    static final long serialVersionUID = -4908718632617980464L;

    public QuickAccess() {
    }

    public QuickAccess(QuickAccessType quickAccessType) {
        this.type = quickAccessType;
    }

    public QuickAccess(QuickAccessType quickAccessType, ConfigurationEntity configurationEntity) {
        this(quickAccessType);
        this.setEntity(configurationEntity);
    }

    @Override
    public int compareTo(QuickAccess quickAccess) {
        return COMPARATOR.compare(this, quickAccess);
    }

    public ConfigurationEntity getEntity() {
        return (ConfigurationEntity)ObjectHelper.coalesce((Object[])new ConfigurationEntity[]{this._persistence_get_customOperation(), this._persistence_get_customWizard(), this._persistence_get_recordType(), this._persistence_get_tokenType()});
    }

    public QuickAccessType getType() {
        return this._persistence_get_type();
    }

    public boolean matches(IEntity iEntity) {
        if (iEntity instanceof QuickAccess) {
            QuickAccess quickAccess = (QuickAccess)iEntity;
            return this.matches(quickAccess.getType(), quickAccess.getEntity());
        }
        return super.matches(iEntity);
    }

    public boolean matches(QuickAccessType quickAccessType, ConfigurationEntity configurationEntity) {
        return Objects.equals(this.getType(), quickAccessType) && Objects.equals(this.getEntity(), configurationEntity);
    }

    public void setEntity(ConfigurationEntity configurationEntity) {
        this._persistence_set_customOperation((CustomOperation)ObjectHelper.ifType((Object)configurationEntity, CustomOperation.class));
        this._persistence_set_customWizard((CustomWizard)ObjectHelper.ifType((Object)configurationEntity, CustomWizard.class));
        this._persistence_set_recordType((RecordType)ObjectHelper.ifType((Object)configurationEntity, RecordType.class));
        this._persistence_set_tokenType((TokenPrincipalType)ObjectHelper.ifType((Object)configurationEntity, TokenPrincipalType.class));
        Long l = QuickAccess.id(this.getEntity());
        this._persistence_set_entityId(l == null ? "" : l.toString());
    }

    public void setType(QuickAccessType quickAccessType) {
        this._persistence_set_type(quickAccessType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new QuickAccess();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "customWizard") {
            return this.customWizard;
        }
        if (string == "recordType") {
            return this.recordType;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "customOperation") {
            return this.customOperation;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "tokenType") {
            return this.tokenType;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "customWizard") {
            this.customWizard = (CustomWizard)object;
            return;
        }
        if (string == "recordType") {
            this.recordType = (RecordType)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "customOperation") {
            this.customOperation = (CustomOperation)object;
            return;
        }
        if (string == "type") {
            this.type = (QuickAccessType)object;
            return;
        }
        if (string == "tokenType") {
            this.tokenType = (TokenPrincipalType)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public CustomWizard _persistence_get_customWizard() {
        this._persistence_checkFetched("customWizard");
        return this.customWizard;
    }

    public void _persistence_set_customWizard(CustomWizard customWizard) {
        this._persistence_checkFetchedForSet("customWizard");
        this._persistence_propertyChange("customWizard", this.customWizard, customWizard);
        this.customWizard = customWizard;
    }

    public RecordType _persistence_get_recordType() {
        this._persistence_checkFetched("recordType");
        return this.recordType;
    }

    public void _persistence_set_recordType(RecordType recordType) {
        this._persistence_checkFetchedForSet("recordType");
        this._persistence_propertyChange("recordType", this.recordType, recordType);
        this.recordType = recordType;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public CustomOperation _persistence_get_customOperation() {
        this._persistence_checkFetched("customOperation");
        return this.customOperation;
    }

    public void _persistence_set_customOperation(CustomOperation customOperation) {
        this._persistence_checkFetchedForSet("customOperation");
        this._persistence_propertyChange("customOperation", this.customOperation, customOperation);
        this.customOperation = customOperation;
    }

    public QuickAccessType _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(QuickAccessType quickAccessType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_propertyChange("type", this.type, quickAccessType);
        this.type = quickAccessType;
    }

    public TokenPrincipalType _persistence_get_tokenType() {
        this._persistence_checkFetched("tokenType");
        return this.tokenType;
    }

    public void _persistence_set_tokenType(TokenPrincipalType tokenPrincipalType) {
        this._persistence_checkFetchedForSet("tokenType");
        this._persistence_propertyChange("tokenType", this.tokenType, tokenPrincipalType);
        this.tokenType = tokenPrincipalType;
    }
}

