/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.HasSvgIcon;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordSection;
import org.cyclos.entities.users.RecordTypeSharedRecordField;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.users.recordtypes.RecordTypeNature;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="record_types")
@DiscriminatorColumn(name="subclass")
public abstract class RecordType
extends ConfigurationEntity
implements HasSvgIcon,
DefinesNetwork,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="subclass", insertable=false, updatable=false)
    private RecordTypeNature nature;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id", nullable=false)
    private Network network;
    @Basic
    @Column(name="plural_name", nullable=false)
    private String pluralName;
    @Basic
    @Column(name="svg_icon")
    private String svgIcon;
    @Basic
    @Column(name="display_template")
    private String displayTemplate;
    @Basic
    @Lob
    @Column(name="information_text")
    private String informationText;
    @Basic
    @Column(name="field_columns")
    private Integer fieldColumns;
    @Basic
    @Column(name="use_view_page")
    private Boolean useViewPage;
    @Basic
    @Column(name="nowrap_labels")
    private Boolean nowrapLabels;
    @Basic
    @Column(name="hide_date_on_list")
    private Boolean hideDateOnList;
    @Basic
    @Column(name="require_confirmation_for_manage")
    private Boolean requireConfirmationForManage;
    @Basic
    @Column(name="icon")
    private String icon;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="sort_field_id")
    private RecordCustomField sortField;
    @OneToMany(mappedBy="recordType", cascade={CascadeType.REMOVE})
    @OrderBy(value="order ASC")
    private List<RecordSection> sections = new ArrayList<RecordSection>();
    @OneToMany(mappedBy="recordType", cascade={CascadeType.REMOVE})
    @OrderBy(value="order ASC")
    private List<RecordCustomField> fields = new ArrayList<RecordCustomField>();
    @OneToMany(mappedBy="recordType", cascade={CascadeType.ALL})
    @OrderBy(value="order ASC")
    private List<RecordTypeSharedRecordField> sharedFields = new ArrayList<RecordTypeSharedRecordField>();
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="results_layout", nullable=false)
    private RecordTypeResultsLayout resultsLayout = RecordTypeResultsLayout.LIST;
    static final long serialVersionUID = 5925358721100492507L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_sortField_vh;

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.RECORD_TYPES;
    }

    public String getDisplayTemplate() {
        return this._persistence_get_displayTemplate();
    }

    public int getFieldColumns() {
        return this._persistence_get_fieldColumns() == null ? 1 : this._persistence_get_fieldColumns();
    }

    public List<RecordCustomField> getFields() {
        return this._persistence_get_fields();
    }

    public String getIcon() {
        return this._persistence_get_icon();
    }

    public String getInformationText() {
        return this._persistence_get_informationText();
    }

    public abstract RecordTypeNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public Integer getOrder(RecordCustomField recordCustomField) {
        if (recordCustomField.getRecordType() == null) {
            RecordTypeSharedRecordField recordTypeSharedRecordField = this.getRecordTypeSharedField(recordCustomField);
            return recordTypeSharedRecordField == null ? null : recordTypeSharedRecordField.getOrder();
        }
        if (this.equals(recordCustomField.getRecordType())) {
            return recordCustomField.getOrder();
        }
        return null;
    }

    public String getPluralName() {
        return this._persistence_get_pluralName();
    }

    public RecordTypeSharedRecordField getRecordTypeSharedField(RecordCustomField recordCustomField) {
        return this._persistence_get_sharedFields().stream().filter(recordTypeSharedRecordField -> recordTypeSharedRecordField.getRecordField().equals(recordCustomField)).findFirst().orElse(null);
    }

    public RecordTypeResultsLayout getResultsLayout() {
        return this._persistence_get_resultsLayout();
    }

    public RecordSection getSection(RecordCustomField recordCustomField) {
        if (recordCustomField.getRecordType() == null) {
            RecordTypeSharedRecordField recordTypeSharedRecordField = this.getRecordTypeSharedField(recordCustomField);
            return recordTypeSharedRecordField == null ? null : recordTypeSharedRecordField.getSection();
        }
        if (this.equals(recordCustomField.getRecordType())) {
            return recordCustomField.getSection();
        }
        return null;
    }

    public List<RecordSection> getSections() {
        return this._persistence_get_sections();
    }

    public List<RecordTypeSharedRecordField> getSharedFields() {
        return this._persistence_get_sharedFields();
    }

    public RecordCustomField getSortField() {
        return this._persistence_get_sortField();
    }

    @Override
    public String getSvgIcon() {
        return this._persistence_get_svgIcon();
    }

    public boolean isHideDateOnList() {
        return Boolean.TRUE.equals(this._persistence_get_hideDateOnList());
    }

    public boolean isNowrapLabels() {
        return Boolean.TRUE.equals(this._persistence_get_nowrapLabels());
    }

    public boolean isRequireConfirmationForManage() {
        return Boolean.TRUE.equals(this._persistence_get_requireConfirmationForManage());
    }

    public boolean isUseViewPage() {
        return Boolean.TRUE.equals(this._persistence_get_useViewPage());
    }

    public void setDisplayTemplate(String string) {
        this._persistence_set_displayTemplate(string);
    }

    public void setFieldColumns(int n) {
        this._persistence_set_fieldColumns(n);
    }

    public void setFields(List<RecordCustomField> list) {
        this._persistence_set_fields(list);
    }

    public void setHideDateOnList(boolean bl) {
        this._persistence_set_hideDateOnList(bl);
    }

    public void setIcon(String string) {
        this._persistence_set_icon(string);
    }

    public void setInformationText(String string) {
        this._persistence_set_informationText(string);
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setNowrapLabels(boolean bl) {
        this._persistence_set_nowrapLabels(bl);
    }

    public void setOrder(RecordCustomField recordCustomField, Integer n) {
        if (recordCustomField.getRecordType() == null) {
            this.getRecordTypeSharedField(recordCustomField).setOrder(n);
        } else {
            recordCustomField.setOrder(n);
        }
    }

    public void setPluralName(String string) {
        this._persistence_set_pluralName(string);
    }

    public void setRequireConfirmationForManage(boolean bl) {
        this._persistence_set_requireConfirmationForManage(bl);
    }

    public void setResultsLayout(RecordTypeResultsLayout recordTypeResultsLayout) {
        this._persistence_set_resultsLayout(recordTypeResultsLayout);
    }

    public void setSections(List<RecordSection> list) {
        this._persistence_set_sections(list);
    }

    public void setSharedFields(List<RecordTypeSharedRecordField> list) {
        this._persistence_set_sharedFields(list);
    }

    public void setSortField(RecordCustomField recordCustomField) {
        this._persistence_set_sortField(recordCustomField);
    }

    @Override
    public void setSvgIcon(String string) {
        this._persistence_set_svgIcon(string);
    }

    public void setUseViewPage(boolean bl) {
        this._persistence_set_useViewPage(bl);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        if (this._persistence_sortField_vh != null) {
            this._persistence_sortField_vh = (WeavedAttributeValueHolderInterface)this._persistence_sortField_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RecordType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "pluralName") {
            return this.pluralName;
        }
        if (string == "displayTemplate") {
            return this.displayTemplate;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "requireConfirmationForManage") {
            return this.requireConfirmationForManage;
        }
        if (string == "hideDateOnList") {
            return this.hideDateOnList;
        }
        if (string == "icon") {
            return this.icon;
        }
        if (string == "svgIcon") {
            return this.svgIcon;
        }
        if (string == "sharedFields") {
            return this.sharedFields;
        }
        if (string == "sections") {
            return this.sections;
        }
        if (string == "resultsLayout") {
            return this.resultsLayout;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "fieldColumns") {
            return this.fieldColumns;
        }
        if (string == "nowrapLabels") {
            return this.nowrapLabels;
        }
        if (string == "sortField") {
            return this.sortField;
        }
        if (string == "useViewPage") {
            return this.useViewPage;
        }
        if (string == "fields") {
            return this.fields;
        }
        if (string == "informationText") {
            return this.informationText;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "pluralName") {
            this.pluralName = (String)object;
            return;
        }
        if (string == "displayTemplate") {
            this.displayTemplate = (String)object;
            return;
        }
        if (string == "nature") {
            this.nature = (RecordTypeNature)object;
            return;
        }
        if (string == "requireConfirmationForManage") {
            this.requireConfirmationForManage = (Boolean)object;
            return;
        }
        if (string == "hideDateOnList") {
            this.hideDateOnList = (Boolean)object;
            return;
        }
        if (string == "icon") {
            this.icon = (String)object;
            return;
        }
        if (string == "svgIcon") {
            this.svgIcon = (String)object;
            return;
        }
        if (string == "sharedFields") {
            this.sharedFields = (List)object;
            return;
        }
        if (string == "sections") {
            this.sections = (List)object;
            return;
        }
        if (string == "resultsLayout") {
            this.resultsLayout = (RecordTypeResultsLayout)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "fieldColumns") {
            this.fieldColumns = (Integer)object;
            return;
        }
        if (string == "nowrapLabels") {
            this.nowrapLabels = (Boolean)object;
            return;
        }
        if (string == "sortField") {
            this.sortField = (RecordCustomField)object;
            return;
        }
        if (string == "useViewPage") {
            this.useViewPage = (Boolean)object;
            return;
        }
        if (string == "fields") {
            this.fields = (List)object;
            return;
        }
        if (string == "informationText") {
            this.informationText = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_pluralName() {
        this._persistence_checkFetched("pluralName");
        return this.pluralName;
    }

    public void _persistence_set_pluralName(String string) {
        this._persistence_checkFetchedForSet("pluralName");
        this._persistence_propertyChange("pluralName", this.pluralName, string);
        this.pluralName = string;
    }

    public String _persistence_get_displayTemplate() {
        this._persistence_checkFetched("displayTemplate");
        return this.displayTemplate;
    }

    public void _persistence_set_displayTemplate(String string) {
        this._persistence_checkFetchedForSet("displayTemplate");
        this._persistence_propertyChange("displayTemplate", this.displayTemplate, string);
        this.displayTemplate = string;
    }

    public RecordTypeNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(RecordTypeNature recordTypeNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, recordTypeNature);
        this.nature = recordTypeNature;
    }

    public Boolean _persistence_get_requireConfirmationForManage() {
        this._persistence_checkFetched("requireConfirmationForManage");
        return this.requireConfirmationForManage;
    }

    public void _persistence_set_requireConfirmationForManage(Boolean bl) {
        this._persistence_checkFetchedForSet("requireConfirmationForManage");
        this._persistence_propertyChange("requireConfirmationForManage", this.requireConfirmationForManage, bl);
        this.requireConfirmationForManage = bl;
    }

    public Boolean _persistence_get_hideDateOnList() {
        this._persistence_checkFetched("hideDateOnList");
        return this.hideDateOnList;
    }

    public void _persistence_set_hideDateOnList(Boolean bl) {
        this._persistence_checkFetchedForSet("hideDateOnList");
        this._persistence_propertyChange("hideDateOnList", this.hideDateOnList, bl);
        this.hideDateOnList = bl;
    }

    public String _persistence_get_icon() {
        this._persistence_checkFetched("icon");
        return this.icon;
    }

    public void _persistence_set_icon(String string) {
        this._persistence_checkFetchedForSet("icon");
        this._persistence_propertyChange("icon", this.icon, string);
        this.icon = string;
    }

    public String _persistence_get_svgIcon() {
        this._persistence_checkFetched("svgIcon");
        return this.svgIcon;
    }

    public void _persistence_set_svgIcon(String string) {
        this._persistence_checkFetchedForSet("svgIcon");
        this._persistence_propertyChange("svgIcon", this.svgIcon, string);
        this.svgIcon = string;
    }

    public List _persistence_get_sharedFields() {
        this._persistence_checkFetched("sharedFields");
        return this.sharedFields;
    }

    public void _persistence_set_sharedFields(List list) {
        this._persistence_checkFetchedForSet("sharedFields");
        this._persistence_propertyChange("sharedFields", this.sharedFields, list);
        this.sharedFields = list;
    }

    public List _persistence_get_sections() {
        this._persistence_checkFetched("sections");
        return this.sections;
    }

    public void _persistence_set_sections(List list) {
        this._persistence_checkFetchedForSet("sections");
        this._persistence_propertyChange("sections", this.sections, list);
        this.sections = list;
    }

    public RecordTypeResultsLayout _persistence_get_resultsLayout() {
        this._persistence_checkFetched("resultsLayout");
        return this.resultsLayout;
    }

    public void _persistence_set_resultsLayout(RecordTypeResultsLayout recordTypeResultsLayout) {
        this._persistence_checkFetchedForSet("resultsLayout");
        this._persistence_propertyChange("resultsLayout", this.resultsLayout, recordTypeResultsLayout);
        this.resultsLayout = recordTypeResultsLayout;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Integer _persistence_get_fieldColumns() {
        this._persistence_checkFetched("fieldColumns");
        return this.fieldColumns;
    }

    public void _persistence_set_fieldColumns(Integer n) {
        this._persistence_checkFetchedForSet("fieldColumns");
        this._persistence_propertyChange("fieldColumns", this.fieldColumns, n);
        this.fieldColumns = n;
    }

    public Boolean _persistence_get_nowrapLabels() {
        this._persistence_checkFetched("nowrapLabels");
        return this.nowrapLabels;
    }

    public void _persistence_set_nowrapLabels(Boolean bl) {
        this._persistence_checkFetchedForSet("nowrapLabels");
        this._persistence_propertyChange("nowrapLabels", this.nowrapLabels, bl);
        this.nowrapLabels = bl;
    }

    protected void _persistence_initialize_sortField_vh() {
        if (this._persistence_sortField_vh == null) {
            this._persistence_sortField_vh = new ValueHolder((Object)this.sortField);
            this._persistence_sortField_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_sortField_vh() {
        RecordCustomField recordCustomField;
        this._persistence_initialize_sortField_vh();
        if ((this._persistence_sortField_vh.isCoordinatedWithProperty() || this._persistence_sortField_vh.isNewlyWeavedValueHolder()) && (recordCustomField = this._persistence_get_sortField()) != this._persistence_sortField_vh.getValue()) {
            this._persistence_set_sortField(recordCustomField);
        }
        return this._persistence_sortField_vh;
    }

    public void _persistence_set_sortField_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_sortField_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            RecordCustomField recordCustomField = this._persistence_get_sortField();
            if (recordCustomField != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_sortField((RecordCustomField)object);
            }
        } else {
            this.sortField = null;
        }
    }

    public RecordCustomField _persistence_get_sortField() {
        this._persistence_checkFetched("sortField");
        this._persistence_initialize_sortField_vh();
        this.sortField = (RecordCustomField)this._persistence_sortField_vh.getValue();
        return this.sortField;
    }

    public void _persistence_set_sortField(RecordCustomField recordCustomField) {
        this._persistence_checkFetchedForSet("sortField");
        this._persistence_initialize_sortField_vh();
        this.sortField = (RecordCustomField)this._persistence_sortField_vh.getValue();
        this._persistence_propertyChange("sortField", this.sortField, recordCustomField);
        this.sortField = recordCustomField;
        this._persistence_sortField_vh.setValue((Object)recordCustomField);
    }

    public Boolean _persistence_get_useViewPage() {
        this._persistence_checkFetched("useViewPage");
        return this.useViewPage;
    }

    public void _persistence_set_useViewPage(Boolean bl) {
        this._persistence_checkFetchedForSet("useViewPage");
        this._persistence_propertyChange("useViewPage", this.useViewPage, bl);
        this.useViewPage = bl;
    }

    public List _persistence_get_fields() {
        this._persistence_checkFetched("fields");
        return this.fields;
    }

    public void _persistence_set_fields(List list) {
        this._persistence_checkFetchedForSet("fields");
        this._persistence_propertyChange("fields", this.fields, list);
        this.fields = list;
    }

    public String _persistence_get_informationText() {
        this._persistence_checkFetched("informationText");
        return this.informationText;
    }

    public void _persistence_set_informationText(String string) {
        this._persistence_checkFetchedForSet("informationText");
        this._persistence_propertyChange("informationText", this.informationText, string);
        this.informationText = string;
    }
}

