/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.AgreementLog;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.PendingUserAccount;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountFeeLog;
import org.cyclos.entities.marketplace.AdQuestion;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.messaging.Notification;
import org.cyclos.entities.messaging.UserAlert;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BrokerGroup;
import org.cyclos.entities.users.Brokering;
import org.cyclos.entities.users.BrokeringLog;
import org.cyclos.entities.users.BulkActionUser;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.PrivacyControl;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.entities.users.Reference;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.entities.users.UserChannel;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserGroupLog;
import org.cyclos.entities.users.UserImage;
import org.cyclos.entities.users.UserQuickAccess;
import org.cyclos.model.access.Role;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.users.UserNature;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorValue(value="USER")
public class User
extends BasicUser
implements ProductOwner,
ImageOwner<User, UserImage>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="invited_by_id")
    private BasicUser invitedBy;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_group_id")
    private Group group;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserGroupLog> groupHistory = new HashSet<UserGroupLog>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserQuickAccess> dashboardActions = new HashSet<UserQuickAccess>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserAddress> addresses = new HashSet<UserAddress>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserAccount> accounts = new HashSet<UserAccount>();
    @Basic
    @Column(name="user_activation_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date activationDate;
    @Basic
    @Column(name="user_hide_email")
    private boolean hideEmail;
    @OneToMany(mappedBy="user")
    @OrderBy(value="order")
    private List<UserImage> images = new ArrayList<UserImage>();
    @OneToMany(mappedBy="owner", cascade={CascadeType.REMOVE})
    private Set<BasicAd> ads = new HashSet<BasicAd>();
    @ManyToMany
    @JoinTable(name="users_brokers", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="broker_id")})
    private Set<User> brokers = new HashSet<User>();
    @ManyToMany
    @JoinTable(name="users_brokers", joinColumns={@JoinColumn(name="broker_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    private Set<User> brokeredUsers = new HashSet<User>();
    @ManyToMany
    @JoinTable(name="user_main_broker", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="broker_id")})
    private Set<User> mainBrokers;
    @Basic
    @Column(name="enable_privacy_control")
    private Boolean enablePrivacyControl;
    @OneToMany(mappedBy="broker", cascade={CascadeType.REMOVE})
    private Set<Brokering> brokerings = new HashSet<Brokering>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Brokering> brokeringsAsUser = new HashSet<Brokering>();
    @OneToMany(mappedBy="from")
    private Set<Reference> referencesFrom = new HashSet<Reference>();
    @OneToMany(mappedBy="to")
    private Set<Reference> referencesTo = new HashSet<Reference>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserAlert> alerts = new HashSet<UserAlert>();
    @ManyToMany
    @JoinTable(name="users_privacy_controls", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="control_id")})
    private Set<PrivacyControl> privacyControls = new HashSet<PrivacyControl>();
    @ManyToMany
    @JoinTable(name="users_ignore_feedbacks", joinColumns={@JoinColumn(name="owner_id")}, inverseJoinColumns={@JoinColumn(name="user_id")})
    private Set<User> ignoreFeedback = new HashSet<User>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserChannel> channels = new HashSet<UserChannel>();
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    private Set<AgreementLog> agreementLogs = new HashSet<AgreementLog>();
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    private Set<BrokeringLog> brokeringLogs = new HashSet<BrokeringLog>();
    @OneToMany(mappedBy="owner", cascade={CascadeType.REMOVE})
    private Set<AdQuestion> questions = new HashSet<AdQuestion>();
    @ManyToMany
    @JoinTable(name="accepted_agreements", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="agreement_id")})
    private Set<Agreement> acceptedAgreements = new HashSet<Agreement>();
    @Basic
    @Lob
    @Column(name="accepted_agreement_ids")
    private String acceptedAgreementIds;
    @Basic
    @Lob
    @Column(name="product_ids")
    private String productIds;
    @Transient
    private List<TempImage> uploadedImages;
    @Transient
    private String inviteToken;
    @Transient
    private ExternalPayment externalPayment;
    @Transient
    private boolean physicallyRemoving;
    @ManyToMany
    @JoinTable(name="users_products", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="product_id")})
    private Set<Product> products = new HashSet<Product>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<BulkActionUser> bulkActionUsers = new HashSet<BulkActionUser>();
    @OneToMany(mappedBy="relatedUser", cascade={CascadeType.REMOVE})
    private Set<Notification> relatedUserNotifications = new HashSet<Notification>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<Operator> operators = new HashSet<Operator>();
    @OneToMany(mappedBy="owner", cascade={CascadeType.REMOVE})
    private Set<Contact> contacts = new HashSet<Contact>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<UserAccountFeeLog> accountFeeLogs;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<ContactInfo> contactInfos = new HashSet<ContactInfo>();
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Set<PendingUserAccount> pendingAccounts = new HashSet<PendingUserAccount>();
    @Column(name="image_id", updatable=false, insertable=false)
    private Long imageId;
    static final long serialVersionUID = 3200036630901051177L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_group_vh;

    @Deprecated
    public User() {
    }

    public User(Group group) {
        this.setGroup(group);
        if (group != null) {
            this.setNetwork(group.getNetwork());
        }
    }

    public void addAgreementLog(AgreementLog agreementLog) {
        agreementLog.setUser(this);
        this._persistence_get_agreementLogs().add(agreementLog);
    }

    public Set<Product> doGetProducts() {
        return this._persistence_get_products();
    }

    public String getAcceptedAgreementIds() {
        return this._persistence_get_acceptedAgreementIds();
    }

    public Set<Agreement> getAcceptedAgreements() {
        return this._persistence_get_acceptedAgreements();
    }

    public Date getActivationDate() {
        return this._persistence_get_activationDate();
    }

    public Set<UserAddress> getAddresses() {
        return this._persistence_get_addresses();
    }

    public Set<BasicAd> getAds() {
        return this._persistence_get_ads();
    }

    public Set<AgreementLog> getAgreementLogs() {
        return this._persistence_get_agreementLogs();
    }

    public Set<UserAlert> getAlerts() {
        return this._persistence_get_alerts();
    }

    public Set<User> getBrokeredUsers() {
        return this._persistence_get_brokeredUsers();
    }

    public Set<Long> getBrokerIds() {
        return StringHelper.toLongSet((String)this._persistence_get_brokerIds());
    }

    public Set<BrokeringLog> getBrokeringLogs() {
        return this._persistence_get_brokeringLogs();
    }

    public Set<Brokering> getBrokerings() {
        return this._persistence_get_brokerings();
    }

    public Set<Brokering> getBrokeringsAsUser() {
        return this._persistence_get_brokeringsAsUser();
    }

    public Set<User> getBrokers() {
        return this._persistence_get_brokers();
    }

    public UserChannel getChannel(Channel channel) {
        return this._persistence_get_channels() == null ? null : (UserChannel)this._persistence_get_channels().stream().filter(userChannel -> userChannel.getChannel().equals(channel)).findFirst().orElse(null);
    }

    public Set<UserChannel> getChannels() {
        return this._persistence_get_channels();
    }

    public Set<ContactInfo> getContactInfos() {
        return this._persistence_get_contactInfos();
    }

    public Set<UserQuickAccess> getDashboardActions() {
        return this._persistence_get_dashboardActions();
    }

    public UserAddress getDefaultAddress() {
        return CollectionHelper.isEmpty((Iterable)this._persistence_get_addresses()) ? null : (UserAddress)this._persistence_get_addresses().stream().filter(UserAddress::isDefaultAddress).findFirst().orElse(null);
    }

    public ExternalPayment getExternalPayment() {
        return this.externalPayment;
    }

    public Group getGroup() {
        return this._persistence_get_group();
    }

    public Set<UserGroupLog> getGroupHistory() {
        return this._persistence_get_groupHistory();
    }

    public GroupSet getGroupSet() {
        if (this._persistence_get_group() instanceof UserGroup) {
            return ((UserGroup)this._persistence_get_group()).getGroupSet();
        }
        return null;
    }

    public Set<User> getIgnoreFeedback() {
        return this._persistence_get_ignoreFeedback();
    }

    @Override
    public UserImage getImage() {
        return this._persistence_get_image();
    }

    public Long getImageId() {
        return this._persistence_get_imageId();
    }

    @Override
    public List<UserImage> getImages() {
        return this._persistence_get_images();
    }

    public String getIndividualProductIds() {
        return this._persistence_get_productIds();
    }

    public BasicUser getInvitedBy() {
        return this._persistence_get_invitedBy();
    }

    public String getInviteToken() {
        return this.inviteToken;
    }

    public User getMainBroker() {
        return (User)CollectionHelper.first((Iterable)this._persistence_get_mainBrokers());
    }

    @Override
    public Role getMainRole() {
        return this._persistence_get_group().getRole();
    }

    @Override
    public UserNature getNature() {
        return UserNature.USER;
    }

    @Override
    public ProductOwner getNextLevelProductOwner() {
        return this._persistence_get_group();
    }

    @Override
    public Set<Product> getPhysicalProducts() {
        return this._persistence_get_products();
    }

    public Set<PrivacyControl> getPrivacyControls() {
        return this._persistence_get_privacyControls();
    }

    @Override
    public SortedSet<Long> getProductIds() {
        return StringHelper.toLongSet((String)this._persistence_get_productIds());
    }

    @Override
    public Set<Product> getProducts() {
        return this._persistence_get_products();
    }

    public Set<AdQuestion> getQuestions() {
        return this._persistence_get_questions();
    }

    public Set<Reference> getReferencesFrom() {
        return this._persistence_get_referencesFrom();
    }

    public Set<Reference> getReferencesTo() {
        return this._persistence_get_referencesTo();
    }

    public List<TempImage> getUploadedImages() {
        return this.uploadedImages;
    }

    @Override
    public User getUser() {
        return this;
    }

    @Override
    public boolean isAdmin() {
        return this._persistence_get_group() instanceof AdminGroup;
    }

    @Override
    public boolean isBroker() {
        return this._persistence_get_group() instanceof BrokerGroup;
    }

    public boolean isEnablePrivacyControl() {
        return Boolean.TRUE.equals(this._persistence_get_enablePrivacyControl());
    }

    @Override
    public boolean isGlobalAdmin() {
        return this._persistence_get_group() instanceof AdminGroup && ((AdminGroup)this._persistence_get_group()).getAdminType() == AdminGroupType.GLOBAL;
    }

    public boolean isHideEmail() {
        return this._persistence_get_hideEmail();
    }

    @Override
    public boolean isMember() {
        return this._persistence_get_group() instanceof UserGroup;
    }

    @Override
    public boolean isNetworkAdmin() {
        return this._persistence_get_group() instanceof AdminGroup && ((AdminGroup)this._persistence_get_group()).getAdminType() == AdminGroupType.NETWORK;
    }

    public boolean isPhysicallyRemoving() {
        return this.physicallyRemoving;
    }

    public void setAcceptedAgreements(Set<Agreement> set) {
        this._persistence_set_acceptedAgreements(set);
        if (CollectionHelper.isEmpty(set)) {
            this._persistence_set_acceptedAgreementIds(null);
        } else {
            this._persistence_set_acceptedAgreementIds(set.stream().map(SimpleEntity::getId).sorted().map(l -> l.toString()).collect(Collectors.joining(",")));
        }
    }

    public void setActivationDate(Date date) {
        this._persistence_set_activationDate(date);
    }

    public void setAddresses(Set<UserAddress> set) {
        this._persistence_set_addresses(set);
    }

    public void setAds(Set<BasicAd> set) {
        this._persistence_set_ads(set);
    }

    public void setAgreementLogs(Set<AgreementLog> set) {
        this._persistence_set_agreementLogs(set);
    }

    public void setAlerts(Set<UserAlert> set) {
        this._persistence_set_alerts(set);
    }

    public void setBrokeredUsers(Set<User> set) {
        this._persistence_set_brokeredUsers(set);
    }

    public void setBrokerIds(Set<Long> set) {
        this._persistence_set_brokerIds(StringHelper.trimToNull((Object)CollectionHelper.join((Iterable)CollectionHelper.sort(set), (String)",")));
    }

    public void setBrokeringLogs(Set<BrokeringLog> set) {
        this._persistence_set_brokeringLogs(set);
    }

    public void setBrokers(Set<User> set) {
        this._persistence_set_brokers(set);
    }

    public void setChannels(Set<UserChannel> set) {
        this._persistence_set_channels(set);
    }

    public void setContactInfos(Set<ContactInfo> set) {
        this._persistence_set_contactInfos(set);
    }

    public void setDashboardActions(Set<UserQuickAccess> set) {
        this._persistence_set_dashboardActions(set);
    }

    public void setEnablePrivacyControl(boolean bl) {
        this._persistence_set_enablePrivacyControl(bl);
    }

    public void setExternalPayment(ExternalPayment externalPayment) {
        this.externalPayment = externalPayment;
    }

    public void setGroup(Group group) {
        this._persistence_set_group(group);
    }

    public void setGroupHistory(Set<UserGroupLog> set) {
        this._persistence_set_groupHistory(set);
    }

    public void setHideEmail(boolean bl) {
        this._persistence_set_hideEmail(bl);
    }

    public void setIgnoreFeedback(Set<User> set) {
        this._persistence_set_ignoreFeedback(set);
    }

    @Override
    public void setImage(UserImage userImage) {
        this._persistence_set_image(userImage);
    }

    @Override
    public void setImages(List<UserImage> list) {
        this._persistence_set_images(list);
    }

    public void setInvitedBy(BasicUser basicUser) {
        this._persistence_set_invitedBy(basicUser);
    }

    public void setInviteToken(String string) {
        this.inviteToken = string;
    }

    public void setPhysicallyRemoving(boolean bl) {
        this.physicallyRemoving = bl;
    }

    public void setPrivacyControls(Set<PrivacyControl> set) {
        this._persistence_set_privacyControls(set);
    }

    public void setQuestions(Set<AdQuestion> set) {
        this._persistence_set_questions(set);
    }

    public void setReferencesFrom(Set<Reference> set) {
        this._persistence_set_referencesFrom(set);
    }

    public void setReferencesTo(Set<Reference> set) {
        this._persistence_set_referencesTo(set);
    }

    public void setUploadedImages(List<TempImage> list) {
        this.uploadedImages = list;
    }

    @Override
    public void updateProductIds(SortedSet<Long> sortedSet) {
        this._persistence_set_productIds(CollectionHelper.join(sortedSet, (String)","));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_group_vh != null) {
            this._persistence_group_vh = (WeavedAttributeValueHolderInterface)this._persistence_group_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new User();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "addresses") {
            return this.addresses;
        }
        if (string == "invitedBy") {
            return this.invitedBy;
        }
        if (string == "brokers") {
            return this.brokers;
        }
        if (string == "privacyControls") {
            return this.privacyControls;
        }
        if (string == "questions") {
            return this.questions;
        }
        if (string == "hideEmail") {
            return this.hideEmail;
        }
        if (string == "acceptedAgreementIds") {
            return this.acceptedAgreementIds;
        }
        if (string == "products") {
            return this.products;
        }
        if (string == "pendingAccounts") {
            return this.pendingAccounts;
        }
        if (string == "operators") {
            return this.operators;
        }
        if (string == "relatedUserNotifications") {
            return this.relatedUserNotifications;
        }
        if (string == "enablePrivacyControl") {
            return this.enablePrivacyControl;
        }
        if (string == "referencesFrom") {
            return this.referencesFrom;
        }
        if (string == "group") {
            return this.group;
        }
        if (string == "brokeringLogs") {
            return this.brokeringLogs;
        }
        if (string == "images") {
            return this.images;
        }
        if (string == "imageId") {
            return this.imageId;
        }
        if (string == "bulkActionUsers") {
            return this.bulkActionUsers;
        }
        if (string == "ignoreFeedback") {
            return this.ignoreFeedback;
        }
        if (string == "acceptedAgreements") {
            return this.acceptedAgreements;
        }
        if (string == "dashboardActions") {
            return this.dashboardActions;
        }
        if (string == "brokerings") {
            return this.brokerings;
        }
        if (string == "referencesTo") {
            return this.referencesTo;
        }
        if (string == "alerts") {
            return this.alerts;
        }
        if (string == "ads") {
            return this.ads;
        }
        if (string == "brokeredUsers") {
            return this.brokeredUsers;
        }
        if (string == "channels") {
            return this.channels;
        }
        if (string == "productIds") {
            return this.productIds;
        }
        if (string == "contactInfos") {
            return this.contactInfos;
        }
        if (string == "agreementLogs") {
            return this.agreementLogs;
        }
        if (string == "mainBrokers") {
            return this.mainBrokers;
        }
        if (string == "groupHistory") {
            return this.groupHistory;
        }
        if (string == "accounts") {
            return this.accounts;
        }
        if (string == "brokeringsAsUser") {
            return this.brokeringsAsUser;
        }
        if (string == "accountFeeLogs") {
            return this.accountFeeLogs;
        }
        if (string == "activationDate") {
            return this.activationDate;
        }
        if (string == "contacts") {
            return this.contacts;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "addresses") {
            this.addresses = (Set)object;
            return;
        }
        if (string == "invitedBy") {
            this.invitedBy = (BasicUser)object;
            return;
        }
        if (string == "brokers") {
            this.brokers = (Set)object;
            return;
        }
        if (string == "privacyControls") {
            this.privacyControls = (Set)object;
            return;
        }
        if (string == "questions") {
            this.questions = (Set)object;
            return;
        }
        if (string == "hideEmail") {
            this.hideEmail = (Boolean)object;
            return;
        }
        if (string == "acceptedAgreementIds") {
            this.acceptedAgreementIds = (String)object;
            return;
        }
        if (string == "products") {
            this.products = (Set)object;
            return;
        }
        if (string == "pendingAccounts") {
            this.pendingAccounts = (Set)object;
            return;
        }
        if (string == "operators") {
            this.operators = (Set)object;
            return;
        }
        if (string == "relatedUserNotifications") {
            this.relatedUserNotifications = (Set)object;
            return;
        }
        if (string == "enablePrivacyControl") {
            this.enablePrivacyControl = (Boolean)object;
            return;
        }
        if (string == "referencesFrom") {
            this.referencesFrom = (Set)object;
            return;
        }
        if (string == "group") {
            this.group = (Group)object;
            return;
        }
        if (string == "brokeringLogs") {
            this.brokeringLogs = (Set)object;
            return;
        }
        if (string == "images") {
            this.images = (List)object;
            return;
        }
        if (string == "imageId") {
            this.imageId = (Long)object;
            return;
        }
        if (string == "bulkActionUsers") {
            this.bulkActionUsers = (Set)object;
            return;
        }
        if (string == "ignoreFeedback") {
            this.ignoreFeedback = (Set)object;
            return;
        }
        if (string == "acceptedAgreements") {
            this.acceptedAgreements = (Set)object;
            return;
        }
        if (string == "dashboardActions") {
            this.dashboardActions = (Set)object;
            return;
        }
        if (string == "brokerings") {
            this.brokerings = (Set)object;
            return;
        }
        if (string == "referencesTo") {
            this.referencesTo = (Set)object;
            return;
        }
        if (string == "alerts") {
            this.alerts = (Set)object;
            return;
        }
        if (string == "ads") {
            this.ads = (Set)object;
            return;
        }
        if (string == "brokeredUsers") {
            this.brokeredUsers = (Set)object;
            return;
        }
        if (string == "channels") {
            this.channels = (Set)object;
            return;
        }
        if (string == "productIds") {
            this.productIds = (String)object;
            return;
        }
        if (string == "contactInfos") {
            this.contactInfos = (Set)object;
            return;
        }
        if (string == "agreementLogs") {
            this.agreementLogs = (Set)object;
            return;
        }
        if (string == "mainBrokers") {
            this.mainBrokers = (Set)object;
            return;
        }
        if (string == "groupHistory") {
            this.groupHistory = (Set)object;
            return;
        }
        if (string == "accounts") {
            this.accounts = (Set)object;
            return;
        }
        if (string == "brokeringsAsUser") {
            this.brokeringsAsUser = (Set)object;
            return;
        }
        if (string == "accountFeeLogs") {
            this.accountFeeLogs = (Set)object;
            return;
        }
        if (string == "activationDate") {
            this.activationDate = (Date)object;
            return;
        }
        if (string == "contacts") {
            this.contacts = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_addresses() {
        this._persistence_checkFetched("addresses");
        return this.addresses;
    }

    public void _persistence_set_addresses(Set set) {
        this._persistence_checkFetchedForSet("addresses");
        this._persistence_propertyChange("addresses", this.addresses, set);
        this.addresses = set;
    }

    public BasicUser _persistence_get_invitedBy() {
        this._persistence_checkFetched("invitedBy");
        return this.invitedBy;
    }

    public void _persistence_set_invitedBy(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("invitedBy");
        this._persistence_propertyChange("invitedBy", this.invitedBy, basicUser);
        this.invitedBy = basicUser;
    }

    public Set _persistence_get_brokers() {
        this._persistence_checkFetched("brokers");
        return this.brokers;
    }

    public void _persistence_set_brokers(Set set) {
        this._persistence_checkFetchedForSet("brokers");
        this._persistence_propertyChange("brokers", this.brokers, set);
        this.brokers = set;
    }

    public Set _persistence_get_privacyControls() {
        this._persistence_checkFetched("privacyControls");
        return this.privacyControls;
    }

    public void _persistence_set_privacyControls(Set set) {
        this._persistence_checkFetchedForSet("privacyControls");
        this._persistence_propertyChange("privacyControls", this.privacyControls, set);
        this.privacyControls = set;
    }

    public Set _persistence_get_questions() {
        this._persistence_checkFetched("questions");
        return this.questions;
    }

    public void _persistence_set_questions(Set set) {
        this._persistence_checkFetchedForSet("questions");
        this._persistence_propertyChange("questions", this.questions, set);
        this.questions = set;
    }

    public boolean _persistence_get_hideEmail() {
        this._persistence_checkFetched("hideEmail");
        return this.hideEmail;
    }

    public void _persistence_set_hideEmail(boolean bl) {
        this._persistence_checkFetchedForSet("hideEmail");
        this._persistence_propertyChange("hideEmail", new Boolean(this.hideEmail), new Boolean(bl));
        this.hideEmail = bl;
    }

    public String _persistence_get_acceptedAgreementIds() {
        this._persistence_checkFetched("acceptedAgreementIds");
        return this.acceptedAgreementIds;
    }

    public void _persistence_set_acceptedAgreementIds(String string) {
        this._persistence_checkFetchedForSet("acceptedAgreementIds");
        this._persistence_propertyChange("acceptedAgreementIds", this.acceptedAgreementIds, string);
        this.acceptedAgreementIds = string;
    }

    public Set _persistence_get_products() {
        this._persistence_checkFetched("products");
        return this.products;
    }

    public void _persistence_set_products(Set set) {
        this._persistence_checkFetchedForSet("products");
        this._persistence_propertyChange("products", this.products, set);
        this.products = set;
    }

    public Set _persistence_get_pendingAccounts() {
        this._persistence_checkFetched("pendingAccounts");
        return this.pendingAccounts;
    }

    public void _persistence_set_pendingAccounts(Set set) {
        this._persistence_checkFetchedForSet("pendingAccounts");
        this._persistence_propertyChange("pendingAccounts", this.pendingAccounts, set);
        this.pendingAccounts = set;
    }

    public Set _persistence_get_operators() {
        this._persistence_checkFetched("operators");
        return this.operators;
    }

    public void _persistence_set_operators(Set set) {
        this._persistence_checkFetchedForSet("operators");
        this._persistence_propertyChange("operators", this.operators, set);
        this.operators = set;
    }

    public Set _persistence_get_relatedUserNotifications() {
        this._persistence_checkFetched("relatedUserNotifications");
        return this.relatedUserNotifications;
    }

    public void _persistence_set_relatedUserNotifications(Set set) {
        this._persistence_checkFetchedForSet("relatedUserNotifications");
        this._persistence_propertyChange("relatedUserNotifications", this.relatedUserNotifications, set);
        this.relatedUserNotifications = set;
    }

    public Boolean _persistence_get_enablePrivacyControl() {
        this._persistence_checkFetched("enablePrivacyControl");
        return this.enablePrivacyControl;
    }

    public void _persistence_set_enablePrivacyControl(Boolean bl) {
        this._persistence_checkFetchedForSet("enablePrivacyControl");
        this._persistence_propertyChange("enablePrivacyControl", this.enablePrivacyControl, bl);
        this.enablePrivacyControl = bl;
    }

    public Set _persistence_get_referencesFrom() {
        this._persistence_checkFetched("referencesFrom");
        return this.referencesFrom;
    }

    public void _persistence_set_referencesFrom(Set set) {
        this._persistence_checkFetchedForSet("referencesFrom");
        this._persistence_propertyChange("referencesFrom", this.referencesFrom, set);
        this.referencesFrom = set;
    }

    protected void _persistence_initialize_group_vh() {
        if (this._persistence_group_vh == null) {
            this._persistence_group_vh = new ValueHolder((Object)this.group);
            this._persistence_group_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_group_vh() {
        Group group;
        this._persistence_initialize_group_vh();
        if ((this._persistence_group_vh.isCoordinatedWithProperty() || this._persistence_group_vh.isNewlyWeavedValueHolder()) && (group = this._persistence_get_group()) != this._persistence_group_vh.getValue()) {
            this._persistence_set_group(group);
        }
        return this._persistence_group_vh;
    }

    public void _persistence_set_group_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_group_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Group group = this._persistence_get_group();
            if (group != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_group((Group)object);
            }
        } else {
            this.group = null;
        }
    }

    public Group _persistence_get_group() {
        this._persistence_checkFetched("group");
        this._persistence_initialize_group_vh();
        this.group = (Group)this._persistence_group_vh.getValue();
        return this.group;
    }

    public void _persistence_set_group(Group group) {
        this._persistence_checkFetchedForSet("group");
        this._persistence_initialize_group_vh();
        this.group = (Group)this._persistence_group_vh.getValue();
        this._persistence_propertyChange("group", this.group, group);
        this.group = group;
        this._persistence_group_vh.setValue((Object)group);
    }

    public Set _persistence_get_brokeringLogs() {
        this._persistence_checkFetched("brokeringLogs");
        return this.brokeringLogs;
    }

    public void _persistence_set_brokeringLogs(Set set) {
        this._persistence_checkFetchedForSet("brokeringLogs");
        this._persistence_propertyChange("brokeringLogs", this.brokeringLogs, set);
        this.brokeringLogs = set;
    }

    public List _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(List list) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, list);
        this.images = list;
    }

    public Long _persistence_get_imageId() {
        this._persistence_checkFetched("imageId");
        return this.imageId;
    }

    public void _persistence_set_imageId(Long l) {
        this._persistence_checkFetchedForSet("imageId");
        this._persistence_propertyChange("imageId", this.imageId, l);
        this.imageId = l;
    }

    public Set _persistence_get_bulkActionUsers() {
        this._persistence_checkFetched("bulkActionUsers");
        return this.bulkActionUsers;
    }

    public void _persistence_set_bulkActionUsers(Set set) {
        this._persistence_checkFetchedForSet("bulkActionUsers");
        this._persistence_propertyChange("bulkActionUsers", this.bulkActionUsers, set);
        this.bulkActionUsers = set;
    }

    public Set _persistence_get_ignoreFeedback() {
        this._persistence_checkFetched("ignoreFeedback");
        return this.ignoreFeedback;
    }

    public void _persistence_set_ignoreFeedback(Set set) {
        this._persistence_checkFetchedForSet("ignoreFeedback");
        this._persistence_propertyChange("ignoreFeedback", this.ignoreFeedback, set);
        this.ignoreFeedback = set;
    }

    public Set _persistence_get_acceptedAgreements() {
        this._persistence_checkFetched("acceptedAgreements");
        return this.acceptedAgreements;
    }

    public void _persistence_set_acceptedAgreements(Set set) {
        this._persistence_checkFetchedForSet("acceptedAgreements");
        this._persistence_propertyChange("acceptedAgreements", this.acceptedAgreements, set);
        this.acceptedAgreements = set;
    }

    public Set _persistence_get_dashboardActions() {
        this._persistence_checkFetched("dashboardActions");
        return this.dashboardActions;
    }

    public void _persistence_set_dashboardActions(Set set) {
        this._persistence_checkFetchedForSet("dashboardActions");
        this._persistence_propertyChange("dashboardActions", this.dashboardActions, set);
        this.dashboardActions = set;
    }

    public Set _persistence_get_brokerings() {
        this._persistence_checkFetched("brokerings");
        return this.brokerings;
    }

    public void _persistence_set_brokerings(Set set) {
        this._persistence_checkFetchedForSet("brokerings");
        this._persistence_propertyChange("brokerings", this.brokerings, set);
        this.brokerings = set;
    }

    public Set _persistence_get_referencesTo() {
        this._persistence_checkFetched("referencesTo");
        return this.referencesTo;
    }

    public void _persistence_set_referencesTo(Set set) {
        this._persistence_checkFetchedForSet("referencesTo");
        this._persistence_propertyChange("referencesTo", this.referencesTo, set);
        this.referencesTo = set;
    }

    public Set _persistence_get_alerts() {
        this._persistence_checkFetched("alerts");
        return this.alerts;
    }

    public void _persistence_set_alerts(Set set) {
        this._persistence_checkFetchedForSet("alerts");
        this._persistence_propertyChange("alerts", this.alerts, set);
        this.alerts = set;
    }

    public Set _persistence_get_ads() {
        this._persistence_checkFetched("ads");
        return this.ads;
    }

    public void _persistence_set_ads(Set set) {
        this._persistence_checkFetchedForSet("ads");
        this._persistence_propertyChange("ads", this.ads, set);
        this.ads = set;
    }

    public Set _persistence_get_brokeredUsers() {
        this._persistence_checkFetched("brokeredUsers");
        return this.brokeredUsers;
    }

    public void _persistence_set_brokeredUsers(Set set) {
        this._persistence_checkFetchedForSet("brokeredUsers");
        this._persistence_propertyChange("brokeredUsers", this.brokeredUsers, set);
        this.brokeredUsers = set;
    }

    public Set _persistence_get_channels() {
        this._persistence_checkFetched("channels");
        return this.channels;
    }

    public void _persistence_set_channels(Set set) {
        this._persistence_checkFetchedForSet("channels");
        this._persistence_propertyChange("channels", this.channels, set);
        this.channels = set;
    }

    public String _persistence_get_productIds() {
        this._persistence_checkFetched("productIds");
        return this.productIds;
    }

    public void _persistence_set_productIds(String string) {
        this._persistence_checkFetchedForSet("productIds");
        this._persistence_propertyChange("productIds", this.productIds, string);
        this.productIds = string;
    }

    public Set _persistence_get_contactInfos() {
        this._persistence_checkFetched("contactInfos");
        return this.contactInfos;
    }

    public void _persistence_set_contactInfos(Set set) {
        this._persistence_checkFetchedForSet("contactInfos");
        this._persistence_propertyChange("contactInfos", this.contactInfos, set);
        this.contactInfos = set;
    }

    public Set _persistence_get_agreementLogs() {
        this._persistence_checkFetched("agreementLogs");
        return this.agreementLogs;
    }

    public void _persistence_set_agreementLogs(Set set) {
        this._persistence_checkFetchedForSet("agreementLogs");
        this._persistence_propertyChange("agreementLogs", this.agreementLogs, set);
        this.agreementLogs = set;
    }

    public Set _persistence_get_mainBrokers() {
        this._persistence_checkFetched("mainBrokers");
        return this.mainBrokers;
    }

    public void _persistence_set_mainBrokers(Set set) {
        this._persistence_checkFetchedForSet("mainBrokers");
        this._persistence_propertyChange("mainBrokers", this.mainBrokers, set);
        this.mainBrokers = set;
    }

    public Set _persistence_get_groupHistory() {
        this._persistence_checkFetched("groupHistory");
        return this.groupHistory;
    }

    public void _persistence_set_groupHistory(Set set) {
        this._persistence_checkFetchedForSet("groupHistory");
        this._persistence_propertyChange("groupHistory", this.groupHistory, set);
        this.groupHistory = set;
    }

    public Set _persistence_get_accounts() {
        this._persistence_checkFetched("accounts");
        return this.accounts;
    }

    public void _persistence_set_accounts(Set set) {
        this._persistence_checkFetchedForSet("accounts");
        this._persistence_propertyChange("accounts", this.accounts, set);
        this.accounts = set;
    }

    public Set _persistence_get_brokeringsAsUser() {
        this._persistence_checkFetched("brokeringsAsUser");
        return this.brokeringsAsUser;
    }

    public void _persistence_set_brokeringsAsUser(Set set) {
        this._persistence_checkFetchedForSet("brokeringsAsUser");
        this._persistence_propertyChange("brokeringsAsUser", this.brokeringsAsUser, set);
        this.brokeringsAsUser = set;
    }

    public Set _persistence_get_accountFeeLogs() {
        this._persistence_checkFetched("accountFeeLogs");
        return this.accountFeeLogs;
    }

    public void _persistence_set_accountFeeLogs(Set set) {
        this._persistence_checkFetchedForSet("accountFeeLogs");
        this._persistence_propertyChange("accountFeeLogs", this.accountFeeLogs, set);
        this.accountFeeLogs = set;
    }

    public Date _persistence_get_activationDate() {
        this._persistence_checkFetched("activationDate");
        return this.activationDate;
    }

    public void _persistence_set_activationDate(Date date) {
        this._persistence_checkFetchedForSet("activationDate");
        this._persistence_propertyChange("activationDate", this.activationDate, date);
        this.activationDate = date;
    }

    public Set _persistence_get_contacts() {
        this._persistence_checkFetched("contacts");
        return this.contacts;
    }

    public void _persistence_set_contacts(Set set) {
        this._persistence_checkFetchedForSet("contacts");
        this._persistence_propertyChange("contacts", this.contacts, set);
        this.contacts = set;
    }
}

