/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.BeanWrapperImpl;

public class ClassHelper {
    public static <T> T convert(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        T t = ClassHelper.instantiate(clazz);
        Map<String, Object> map = ClassHelper.describe(object);
        ClassHelper.fill(t, map);
        return t;
    }

    public static Map<String, Object> describe(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (object != null) {
            BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
            for (PropertyDescriptor object2 : beanWrapperImpl.getPropertyDescriptors()) {
                if (object2.getReadMethod() == null || object2.getWriteMethod() == null) continue;
                String string = object2.getName();
                try {
                    hashMap.put(string, beanWrapperImpl.getPropertyValue(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Field field : object.getClass().getFields()) {
                if (!ClassHelper.use(field)) continue;
                try {
                    hashMap.put(field.getName(), field.get(object));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return hashMap;
    }

    public static void fill(Object object, Map<String, Object> map) {
        if (object == null) {
            return;
        }
        if (object instanceof Bean) {
            Bean bean = (Bean)object;
            Map map2 = bean.propertyMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Property property = (Property)map2.get(entry.getKey());
                if (property == null) continue;
                Object object2 = CoercionHelper.coerce((Class)property.getType(), (Object)entry.getValue());
                bean.set(property, object2);
            }
        } else if (object instanceof Map) {
            ((Map)object).putAll(map);
        } else {
            BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object3;
                String string = entry.getKey();
                Object object4 = entry.getValue();
                if (beanWrapperImpl.isWritableProperty(string)) {
                    try {
                        object3 = CoercionHelper.coerce((Class)beanWrapperImpl.getPropertyType(string), (Object)object4);
                        beanWrapperImpl.setPropertyValue(string, object3);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    object3 = object.getClass().getField(string);
                    if (!ClassHelper.use((Field)object3)) continue;
                    Object object5 = CoercionHelper.coerce(((Field)object3).getType(), (Object)object4);
                    ((Field)object3).set(object, object5);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Class<?> forName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not resolve class with name " + string, exception);
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not instantiate bean of class " + clazz.getName(), exception);
        }
    }

    public static <T> T instantiate(Class<T> clazz, Supplier<T> supplier) {
        try {
            return ClassHelper.instantiate(clazz);
        }
        catch (Exception exception) {
            return supplier.get();
        }
    }

    public static <T, D extends T> T instantiateDynamic(Class<T> clazz, String string, Class<D> clazz2) throws Exception {
        String string2 = StringHelper.trimToNull((Object)System.getenv(string));
        if (string2 == null) {
            string2 = StringHelper.trimToNull((Object)System.getProperty(string));
        }
        if (string2 == null) {
            string2 = clazz2.getName();
        }
        return (T)ClassHelper.instantiate(Class.forName(string2));
    }

    private static boolean use(Field field) {
        return Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers());
    }
}

