/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cyclos.utils.coercion.CoercionHelper;

public class FieldHelper {
    public static <T, E extends T> void copyFields(T t, E e) {
        if (t == null || e == null) {
            return;
        }
        try {
            for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                    Object object = FieldUtils.readField((Field)field, t, (boolean)true);
                    FieldUtils.writeField((Field)field, e, (Object)object, (boolean)true);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Error copying fields: " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    public static <T> T get(Class<?> clazz, String string) {
        try {
            return (T)FieldHelper.getField(clazz, string).get(null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error getting field " + clazz.getName() + "." + string, exception);
        }
    }

    public static <T> T get(Object object, String string) {
        if (object == null) {
            return null;
        }
        try {
            return (T)FieldHelper.getField(object.getClass(), string).get(object);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error getting field " + String.valueOf(object) + "." + string, exception);
        }
    }

    public static Field getAnnotatedField(Class<? extends Object> clazz, Class<? extends Annotation> clazz2) {
        try {
            for (Field field : FieldUtils.getAllFieldsList(clazz)) {
                if (field.getAnnotation(clazz2) == null) continue;
                return field;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<? extends Object> clazz, String string, Class<T> clazz2) {
        Field field = FieldHelper.getField(clazz, string);
        return field == null ? null : (T)field.getAnnotation(clazz2);
    }

    public static Field getField(Class<? extends Object> clazz, Class<? extends Object> clazz2) {
        try {
            return FieldUtils.getAllFieldsList(clazz).stream().filter(field -> field.getType() == clazz2).findAny().orElse(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getField(Class<? extends Object> clazz, String string) {
        try {
            return FieldUtils.getField(clazz, (String)string, (boolean)true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean hasAnnotation(Class<? extends Object> clazz, String string, Class<? extends Annotation> clazz2) {
        return FieldHelper.getAnnotation(clazz, string, clazz2) != null;
    }

    public static Map<Field, Object> readFields(Object object) {
        if (object == null) {
            return Collections.emptyMap();
        }
        HashMap<Field, Object> hashMap = new HashMap<Field, Object>();
        try {
            for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    Object object2 = FieldUtils.readField((Field)field, (Object)object, (boolean)true);
                    hashMap.put(field, object2);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Error copying fields: " + illegalAccessException.getMessage(), illegalAccessException);
        }
        return hashMap;
    }

    public static void set(Class<?> clazz, String string, Object object) {
        try {
            Field field = FieldHelper.getField(clazz, string);
            object = CoercionHelper.coerce(field.getType(), (Object)object);
            field.set(null, object);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error setting field " + clazz.getName() + "." + string + " to " + String.valueOf(object), exception);
        }
    }

    public static void set(Object object, String string, Object object2) {
        try {
            Field field = FieldHelper.getField(object.getClass(), string);
            object2 = CoercionHelper.coerce(field.getType(), (Object)object2);
            field.set(object, object2);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error setting field " + String.valueOf(object) + "." + string + " to " + String.valueOf(object2), exception);
        }
    }
}

