/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.IteratorUtils;
import org.cyclos.model.Bean;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.PasswordContainer;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.utils.CountryVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.PeriodPreselectorOptionData;
import org.cyclos.model.utils.PeriodPreselectorOptionType;
import org.cyclos.model.utils.TimeZoneVO;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.PrefixedEnum;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JsonConverter {
    public static final List<String> BLACKLISTED_ERROR_PROPERTIES = ImmutableList.of((Object)"internationalized");
    private static final int MAX_STRING_LENGTH = 10240;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    private ObjectMapper objectMapper;

    public static Object mask(Object object, String string, Object object2) {
        if (object2 instanceof CharSequence && (object instanceof PasswordContainer || PropertyHelper.isSecretProperty(string))) {
            return "****";
        }
        return object2;
    }

    public boolean beanIsSimpleLogNode(Bean bean) {
        return bean instanceof EntityVO || bean instanceof CountryVO || bean instanceof TimeZoneVO || bean instanceof PeriodPreselectorOptionData && ((PeriodPreselectorOptionData)bean).getType() == PeriodPreselectorOptionType.CUSTOM;
    }

    public ObjectNode errorToLogNode(Throwable throwable) throws JsonProcessingException {
        ObjectNode objectNode;
        block5: {
            block4: {
                objectNode = this.objectMapper.createObjectNode();
                String string = StringHelper.transformCase((String)StringHelper.removeEnd((String)throwable.getClass().getSimpleName(), (String)"Exception"), (boolean)true, (char)'_');
                objectNode.set("errorCode", (JsonNode)new TextNode(string));
                if (!(throwable instanceof ValidationException)) break block4;
                ValidationResult validationResult = ((ValidationException)throwable).getValidation();
                if (validationResult == null) break block5;
                if (CollectionHelper.isNotEmpty((Iterable)validationResult.getGeneralErrors())) {
                    objectNode.set("generalErrors", this.toLogNode(validationResult.getGeneralErrors(), false));
                }
                if (CollectionHelper.isNotEmpty((Map)validationResult.getPropertyErrors())) {
                    objectNode.set("propertyErrors", this.toLogNode(validationResult.getPropertyErrors(), false));
                }
                if (!CollectionHelper.isNotEmpty((Map)validationResult.getCustomFieldErrors())) break block5;
                objectNode.set("customFieldErrors", this.toLogNode(validationResult.getCustomFieldErrors(), false));
                break block5;
            }
            if (throwable instanceof CyclosException) {
                BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl((Object)throwable);
                for (PropertyDescriptor propertyDescriptor : beanWrapperImpl.getPropertyDescriptors()) {
                    Object object;
                    String string;
                    Method method = propertyDescriptor.getReadMethod();
                    if (method == null || propertyDescriptor.getWriteMethod() == null || !CyclosException.class.isAssignableFrom(method.getDeclaringClass()) || BLACKLISTED_ERROR_PROPERTIES.contains(string = propertyDescriptor.getName()) || (object = beanWrapperImpl.getPropertyValue(string)) == null) continue;
                    objectNode.set(string, this.toLogNode(object, false));
                }
            }
        }
        return objectNode;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @PostConstruct
    public void intialize() {
        this.objectMapper = this.jacksonConfiguration.getObjectMapper();
    }

    public Object nodeValue(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            return null;
        }
        if (jsonNode.isTextual()) {
            return jsonNode.textValue();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.booleanValue();
        }
        if (jsonNode.isInt()) {
            return jsonNode.intValue();
        }
        if (jsonNode.isLong()) {
            return jsonNode.longValue();
        }
        if (jsonNode.isDouble()) {
            return jsonNode.doubleValue();
        }
        if (jsonNode.isBigDecimal()) {
            return jsonNode.decimalValue();
        }
        if (jsonNode.isArray()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(jsonNode.size());
            for (int i = 0; i < jsonNode.size(); ++i) {
                arrayList.add(this.nodeValue(jsonNode.get(i)));
            }
            return arrayList;
        }
        if (jsonNode.isObject()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : CollectionHelper.iterable((Iterator)jsonNode.fieldNames())) {
                hashMap.put(string, this.nodeValue(jsonNode.get(string)));
            }
            return hashMap;
        }
        return null;
    }

    public JsonNode readTree(byte[] byArray) throws JsonProcessingException {
        try {
            return byArray == null ? NullNode.getInstance() : this.objectMapper.readTree(byArray);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public JsonNode readTree(File file) throws IOException, JsonProcessingException {
        return file == null ? NullNode.getInstance() : this.objectMapper.readTree(file);
    }

    public JsonNode readTree(InputStream inputStream) throws IOException, JsonProcessingException {
        return inputStream == null ? NullNode.getInstance() : this.objectMapper.readTree(inputStream);
    }

    public JsonNode readTree(Reader reader) throws IOException, JsonProcessingException {
        return reader == null ? NullNode.getInstance() : this.objectMapper.readTree(reader);
    }

    public JsonNode readTree(String string) throws JsonProcessingException {
        try {
            return string == null ? NullNode.getInstance() : this.objectMapper.readTree(string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) throws JsonParseException, JsonMappingException {
        try {
            return (T)(byArray == null ? null : this.objectMapper.readValue(byArray, clazz));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public <T> T readValue(File file, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)(file == null ? null : this.objectMapper.readValue(file, clazz));
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)(inputStream == null ? null : this.objectMapper.readValue(inputStream, clazz));
    }

    public <T> T readValue(Reader reader, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)(reader == null ? null : this.objectMapper.readValue(reader, clazz));
    }

    public <T> T readValue(String string, Class<T> clazz) throws JsonParseException, JsonMappingException {
        try {
            return (T)(string == null ? null : this.objectMapper.readValue(string, clazz));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public <T> T readValue(URL uRL, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)(uRL == null ? null : this.objectMapper.readValue(uRL, clazz));
    }

    public JsonNode toLogNode(Object object2, boolean bl) {
        if (object2 == null) {
            return NullNode.getInstance();
        }
        if (object2 instanceof CharSequence || object2 instanceof BigInteger || object2 instanceof DateTime || object2 instanceof Temporal) {
            Object object3 = StringHelper.trimToNull((Object)object2);
            if (object3 == null) {
                return NullNode.getInstance();
            }
            if (((String)object3).length() > 10240) {
                object3 = ((String)object3).substring(0, 10240) + "\u2026";
            }
            return new TextNode((String)object3);
        }
        if (object2 instanceof Date) {
            return this.toLogNode(((Date)object2).toInstant(), bl);
        }
        if (object2 instanceof PrefixedEnum) {
            PrefixedEnum prefixedEnum = (PrefixedEnum)object2;
            return new TextNode(prefixedEnum.prefix() + "." + prefixedEnum.name());
        }
        if (object2 instanceof Enum) {
            return new TextNode(((Enum)object2).name());
        }
        if (object2 instanceof Boolean) {
            return BooleanNode.valueOf((boolean)Boolean.TRUE.equals(object2));
        }
        if (object2 instanceof Integer) {
            return new IntNode(((Integer)object2).intValue());
        }
        if (object2 instanceof Long) {
            return new LongNode(((Long)object2).longValue());
        }
        if (object2 instanceof BigDecimal) {
            return new TextNode(((BigDecimal)object2).toPlainString());
        }
        if (object2 instanceof Number) {
            return new DoubleNode(((Number)object2).doubleValue());
        }
        if (object2 instanceof Object[] || object2 instanceof Iterable) {
            ArrayNode arrayNode = this.getObjectMapper().createArrayNode();
            IteratorUtils.getIterator((Object)object2).forEachRemaining(object -> arrayNode.add(this.toLogNode(object, bl)));
            return arrayNode;
        }
        if (object2 instanceof CountryVO) {
            String string = StringHelper.trimToNull((Object)((CountryVO)object2).getCode());
            return string == null ? NullNode.getInstance() : new TextNode(string);
        }
        if (object2 instanceof TimeZoneVO) {
            String string = StringHelper.trimToNull((Object)((TimeZoneVO)object2).getId());
            return string == null ? NullNode.getInstance() : new TextNode(string);
        }
        if (object2 instanceof SystemAccountOwner) {
            return new TextNode("SYSTEM");
        }
        if (object2 instanceof ExternalAccountOwner) {
            return new TextNode("EXTERNAL");
        }
        if (object2 instanceof EntityVO) {
            EntityVO entityVO = (EntityVO)object2;
            if (bl) {
                if (entityVO.getId() != null) {
                    return this.toLogNode(entityVO.getId(), bl);
                }
                return this.toLogNode(ModelHelper.stringFromVO((EntityVO)entityVO), bl);
            }
            String string = ModelHelper.stringOrIdFromVO((EntityVO)entityVO, (boolean)false, (boolean)false);
            return this.toLogNode(string, bl);
        }
        if (object2 instanceof PeriodPreselectorOptionData) {
            PeriodPreselectorOptionData periodPreselectorOptionData = (PeriodPreselectorOptionData)object2;
            if (periodPreselectorOptionData.getType() == PeriodPreselectorOptionType.CUSTOM) {
                return new TextNode(PeriodPreselectorOptionType.CUSTOM.name());
            }
            return this.toLogNode(periodPreselectorOptionData.getPeriod(), bl);
        }
        if (object2 instanceof Bean) {
            Bean bean = (Bean)object2;
            ObjectNode objectNode = this.getObjectMapper().createObjectNode();
            for (Property property : bean.properties()) {
                Object object4 = JsonConverter.mask(bean, property.getName(), bean.get(property));
                String string = property.getName();
                JsonNode jsonNode = this.toLogNode(object4, bl);
                if (!this.useLogJsonAsProperty(jsonNode, property.getType())) continue;
                objectNode.set(string, jsonNode);
            }
            return objectNode;
        }
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            ObjectNode objectNode = this.getObjectMapper().createObjectNode();
            for (Map.Entry entry : map.entrySet()) {
                String string = entry.getKey().toString();
                Object object5 = JsonConverter.mask(map, string, entry.getValue());
                JsonNode jsonNode = this.toLogNode(object5, bl);
                if (!this.useLogJsonAsProperty(jsonNode, Object.class)) continue;
                objectNode.set(string, jsonNode);
            }
            return objectNode;
        }
        if (object2 instanceof IEntity) {
            Long l = ((IEntity)object2).getId();
            return l == null ? NullNode.getInstance() : new LongNode(l.longValue());
        }
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object2);
        ObjectNode objectNode = this.getObjectMapper().createObjectNode();
        for (PropertyDescriptor propertyDescriptor : beanWrapperImpl.getPropertyDescriptors()) {
            String string;
            Object object6;
            JsonNode jsonNode;
            if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null || !this.useLogJsonAsProperty(jsonNode = this.toLogNode(object6 = JsonConverter.mask(object2, string = propertyDescriptor.getName(), beanWrapperImpl.getPropertyValue(string)), bl), propertyDescriptor.getPropertyType())) continue;
            objectNode.set(string, jsonNode);
        }
        return objectNode;
    }

    public boolean useLogJsonAsProperty(JsonNode jsonNode, Class<?> clazz) {
        if (jsonNode == null || jsonNode.isNull() || jsonNode.isArray() && jsonNode.size() == 0) {
            return false;
        }
        if (Integer.TYPE.equals(clazz) && jsonNode.isInt() && jsonNode.asInt() == 0) {
            return false;
        }
        return !Boolean.TYPE.equals(clazz) || !jsonNode.isBoolean() || jsonNode.asBoolean();
    }

    public void writeValue(File file, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this.objectMapper.writeValue(file, object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this.objectMapper.writeValue(outputStream, object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this.objectMapper.writeValue(writer, object);
    }

    public byte[] writeValueAsBytes(Object object) throws IOException, JsonGenerationException, JsonMappingException {
        try {
            return this.objectMapper.writeValueAsBytes(object);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public String writeValueAsString(Object object) throws JsonGenerationException, JsonMappingException {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

