/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.utils.StringHelper;

public class LocaleHelper {
    private static BidiMap<BuiltinLanguage, Locale> LOCALES = new DualHashBidiMap();
    private static List<Locale> LOCALES_LIST;
    private static List<String> LOCALES_STR_LIST;

    public static List<Locale> locales() {
        return LOCALES_LIST;
    }

    public static List<String> localesStr() {
        return LOCALES_STR_LIST;
    }

    public static Locale mapLocale(BuiltinLanguage builtinLanguage) {
        Locale locale = (Locale)LOCALES.get((Object)builtinLanguage);
        if (locale == null) {
            locale = Locale.US;
        }
        return locale;
    }

    public static BuiltinLanguage mapLocale(Locale locale) {
        BuiltinLanguage builtinLanguage = (BuiltinLanguage)LOCALES.getKey((Object)locale);
        if (builtinLanguage != null) {
            return builtinLanguage;
        }
        builtinLanguage = (BuiltinLanguage)LOCALES.getKey((Object)new Locale(locale.getLanguage()));
        return builtinLanguage;
    }

    public static Locale toLocale(String string) {
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return null;
        }
        String[] stringArray = string.split("\\_");
        String string2 = stringArray[0];
        String string3 = stringArray.length <= 1 ? "" : stringArray[1];
        String string4 = stringArray.length <= 2 ? "" : stringArray[2];
        return new Locale(string2, string3, string4);
    }

    public static List<Locale> toLocales(Collection<String> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>(collection.size());
        for (String string : collection) {
            Locale locale = LocaleHelper.toLocale(string);
            if (locale == null) continue;
            arrayList.add(locale);
        }
        return arrayList;
    }

    static {
        for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
            String string = builtinLanguage.getIsoLanguage();
            String string2 = builtinLanguage.getIsoCountry();
            Locale locale = new Locale(StringHelper.trim((Object)string), StringHelper.trim((Object)string2));
            LOCALES.put((Object)builtinLanguage, (Object)locale);
        }
        LOCALES_LIST = Collections.unmodifiableList(new ArrayList(LOCALES.values()));
        LOCALES_STR_LIST = LOCALES_LIST.stream().map(Object::toString).collect(Collectors.toUnmodifiableList());
    }
}

