/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.Property;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;

public class PropertyHelper {
    public static boolean contains(Object object, Object ... objectArray) {
        if (object == null || CollectionHelper.isEmpty((Object[])objectArray)) {
            return false;
        }
        String string = PropertyHelper.getPropertyName(object);
        if (string == null) {
            return false;
        }
        for (Object object2 : objectArray) {
            String string2 = PropertyHelper.getPropertyName(object2);
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsName(String string, Property<?, ?> ... propertyArray) {
        if (CollectionHelper.isEmpty((Object[])propertyArray)) {
            return false;
        }
        for (Property<?, ?> property : propertyArray) {
            if (!property.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Method getGetter(Class<?> clazz, String string) {
        if (clazz == null || string == null) {
            return null;
        }
        try {
            return clazz.getMethod("get" + Character.toUpperCase(string.charAt(0)) + string.substring(1), new Class[0]);
        }
        catch (Exception exception) {
            try {
                Method method = clazz.getMethod("is" + Character.toUpperCase(string.charAt(0)) + string.substring(1), new Class[0]);
                if (method.getReturnType() == Boolean.TYPE) {
                    return method;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    public static String getGetterName(Path<?> path) {
        String string = PropertyHelper.getPropertyName(path);
        if (path instanceof BooleanPath) {
            return "is" + StringHelper.capitalizeFirst((String)string);
        }
        return "get" + StringHelper.capitalizeFirst((String)string);
    }

    public static List<String> getGetterNames(Path<?> ... pathArray) {
        return Stream.of(pathArray).map(PropertyHelper::getGetterName).collect(Collectors.toList());
    }

    public static String getPropertyName(Method method) {
        String string;
        String string2 = method.getName();
        if (string2.length() > 3 && string2.startsWith("get") || string2.startsWith("set") && Character.isUpperCase(string2.charAt(3))) {
            string = string2.substring(3);
        } else if (string2.length() > 2 && string2.startsWith("is") && Character.isUpperCase(string2.charAt(2))) {
            string = string2.substring(2);
        } else {
            throw new IllegalArgumentException("The given method is neither a getter nor a setter: " + String.valueOf(method));
        }
        return Character.toLowerCase(string.charAt(0)) + (string.length() == 1 ? "" : string.substring(1));
    }

    public static String getPropertyName(Object object) {
        if (object instanceof Property) {
            return ((Property)object).getName();
        }
        if (object instanceof Path) {
            return PropertyHelper.getPropertyName((Path)object);
        }
        if (object instanceof Method) {
            return PropertyHelper.getPropertyName((Method)object);
        }
        if (object instanceof PropertyDescriptor) {
            return ((PropertyDescriptor)object).getName();
        }
        return object.toString();
    }

    public static String getPropertyName(Path<?> path) {
        String string = path.toString();
        return string.substring(string.indexOf(46) + 1);
    }

    public static boolean isSecretProperty(String string) {
        return StringHelper.isNotBlank((Object)string) && (StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"password") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"pin") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"credential") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"secret") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"privatekey") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"accesskey") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"apikey"));
    }
}

