/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.model.access.RequestData;
import org.cyclos.server.utils.ReservedUris;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;

public class RequestEntry {
    private final long startTime = System.currentTimeMillis();
    private final String remoteAddress;
    private final HttpServletRequest request;
    private final String uri;
    private final String protocol;
    private final boolean proxy;
    private final String staticUri;
    private RequestData requestData;
    private long id;

    public RequestEntry(String string, HttpServletRequest httpServletRequest, String string2, String string3, boolean bl) {
        this.remoteAddress = string;
        this.request = httpServletRequest;
        this.uri = string2;
        this.protocol = string3;
        this.proxy = bl;
        String[] stringArray = StringHelper.removeStart((String)string2, (String)"/").split("/");
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ReservedUris.isStatic(stringArray[i])) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            List<String> list = Arrays.asList(stringArray).subList(n, stringArray.length);
            this.staticUri = "/" + CollectionHelper.join(list, (String)"/");
        } else {
            this.staticUri = null;
        }
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long getId() {
        return this.id;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public RequestData getRequestData() {
        return this.requestData;
    }

    public Date getStartTime() {
        return new Date(this.startTime);
    }

    public String getStaticUri() {
        return this.staticUri;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isStatic() {
        return this.staticUri != null;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setRequestData(RequestData requestData) {
        this.requestData = requestData;
    }
}

