/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.cyclos.server.utils.RequestEntry;
import org.cyclos.server.utils.RequestMetrics;
import org.cyclos.server.utils.RequestMetricsHandler;
import org.cyclos.server.utils.RequestMetricsImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RequestMetricsHandlerImpl
implements RequestMetricsHandler {
    private AtomicLong id = new AtomicLong();
    private ConcurrentHashMap<Long, RequestEntry> requests = new ConcurrentHashMap(100);
    private AtomicInteger _activeRequests;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void finished(long l) {
        this.requests.remove(l);
        if (this._activeRequests != null) {
            this._activeRequests.decrementAndGet();
        }
    }

    @Override
    public RequestMetrics getMetrics() {
        ArrayList<RequestEntry> arrayList = new ArrayList<RequestEntry>(this.requests.values());
        arrayList.sort(Comparator.comparingLong(RequestEntry::getId));
        return new RequestMetricsImpl(arrayList);
    }

    @Override
    public int getRequestCount() {
        return this.requests.size();
    }

    @Override
    public long started(RequestEntry requestEntry) {
        long l = this.id.incrementAndGet();
        requestEntry.setId(l);
        this.requests.put(l, requestEntry);
        if (this._activeRequests != null) {
            this._activeRequests.incrementAndGet();
        }
        return l;
    }

    @PostConstruct
    private void initialize() {
        if (this.applicationContext.containsBean("activeRequests")) {
            this._activeRequests = (AtomicInteger)this.applicationContext.getBean("activeRequests", AtomicInteger.class);
        }
    }
}

