/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.server.utils.IOHelper;

public class ResourceHelper {
    public static String getFullName(String string, String string2) {
        if (string == null || string2 == null) {
            return string2;
        }
        if (string.endsWith("/")) {
            return string + string2;
        }
        return string + "/" + string2;
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = ResourceHelper.getSeparator(string);
        int n = (string = StringUtils.removeEnd((String)string, (String)string2)).lastIndexOf(string2);
        return n < 0 ? string : string.substring(n + 1);
    }

    public static String getParentName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = ResourceHelper.getSeparator(string);
        int n = (string = StringUtils.removeEnd((String)string, (String)string2)).lastIndexOf(string2);
        return n < 0 ? "" : string.substring(0, n);
    }

    public static URL getResource(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalStateException(malformedURLException);
            }
        }
        return ResourceHelper.class.getResource(string);
    }

    public static long getSize(String string) {
        URL uRL = ResourceHelper.getResource(string);
        if (uRL == null) {
            return -1L;
        }
        String string2 = uRL.getProtocol();
        if (string2.equals("file") || uRL.getProtocol().equals("vfs")) {
            if (uRL.getProtocol().equals("vfs")) {
                try {
                    uRL = new URL("file", uRL.getHost(), uRL.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalStateException(malformedURLException);
                }
            }
            return FileUtils.toFile((URL)uRL).length();
        }
        if (string2.equals("jar")) {
            JarFile jarFile = ResourceHelper.openJarFile(uRL);
            ZipEntry zipEntry = jarFile.getEntry(string);
            return zipEntry == null ? -1L : zipEntry.getSize();
        }
        throw new IllegalStateException("Unsupported URL protocol: " + String.valueOf(uRL));
    }

    public static List<String> listResources(String string) {
        URL uRL = ResourceHelper.getResource(string);
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.getProtocol();
        if (string2.equals("file") || uRL.getProtocol().equals("vfs")) {
            File[] fileArray;
            if (uRL.getProtocol().equals("vfs")) {
                try {
                    uRL = new URL("file", uRL.getHost(), uRL.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalStateException(malformedURLException);
                }
            }
            if ((fileArray = FileUtils.toFile((URL)uRL).listFiles()) == null) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
            for (File file : fileArray) {
                String string3 = file.getAbsolutePath();
                if (File.separatorChar != '/') {
                    string3 = string3.replace(File.separatorChar, '/');
                }
                arrayList.add(string3);
            }
            return arrayList;
        }
        if (string2.equals("jar")) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            String string4 = string + "/";
            JarFile jarFile = ResourceHelper.openJarFile(uRL);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                int n;
                int n2;
                String string5 = enumeration.nextElement().getName();
                if (!string5.startsWith(string) || string5.equals(string) || string5.equals(string4) || (n2 = string5.indexOf(47, string.length())) >= 0 && (n = string5.indexOf(47, n2 + 1)) >= 0 && n + 1 != string5.length()) continue;
                arrayList.add("/" + string5);
            }
            return arrayList;
        }
        throw new IllegalStateException("Unsupported URL protocol: " + String.valueOf(uRL));
    }

    public static Reader openReader(String string) throws IOException {
        InputStream inputStream = ResourceHelper.openStream(string);
        return inputStream == null ? null : new InputStreamReader(inputStream, StandardCharsets.UTF_8);
    }

    public static InputStream openStream(String string) throws IOException {
        URL uRL = ResourceHelper.getResource(string);
        return uRL == null ? null : uRL.openStream();
    }

    public static byte[] readBytes(String string) throws IOException {
        InputStream inputStream = ResourceHelper.openStream(string);
        return inputStream == null ? null : IOHelper.readBytesAndClose(inputStream);
    }

    public static String readContent(String string) throws IOException {
        Reader reader = ResourceHelper.openReader(string);
        return reader == null ? null : IOHelper.readContentAndClose(reader);
    }

    private static String getSeparator(String string) {
        if (string.matches("\\w\\:\\\\.*") || string.startsWith("file:/") && File.separatorChar == '\\') {
            return "\\";
        }
        return "/";
    }

    private static JarFile openJarFile(URL uRL) {
        JarFile jarFile;
        String string = uRL.getPath().substring(5, uRL.getPath().indexOf("!"));
        try {
            jarFile = new JarFile(URLDecoder.decode(string, "UTF-8"));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error opening jar file", exception);
        }
        return jarFile;
    }
}

