/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.server.utils.ServiceMetadata;
import org.cyclos.services.Service;
import org.cyclos.utils.ServiceHelper;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class ServiceMetadataHelper {
    private static List<ServiceMetadata> metadata;

    public static List<ServiceMetadata> get() {
        if (metadata == null) {
            try {
                metadata = ServiceMetadataHelper.readMetadata();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        return metadata;
    }

    private static ServiceMetadata getMetadata(MetadataReader metadataReader) {
        ClassMetadata classMetadata = metadataReader.getClassMetadata();
        if (classMetadata.isInterface()) {
            Class<?> clazz;
            String string = classMetadata.getClassName();
            try {
                clazz = Class.forName(string);
                if (!ServiceHelper.isInstantiable(clazz)) {
                    return null;
                }
            }
            catch (Exception exception) {
                return null;
            }
            String string2 = StringUtils.uncapitalize((String)clazz.getSimpleName());
            List<String> list = Stream.of(clazz.getMethods()).filter(method -> Service.class.isAssignableFrom(method.getDeclaringClass())).map(Method::getName).sorted().collect(Collectors.toList());
            return new ServiceMetadata(string2, clazz, list);
        }
        return null;
    }

    private static List<ServiceMetadata> readMetadata() throws IOException {
        String string = "org.cyclos.services";
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory cachingMetadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)pathMatchingResourcePatternResolver);
        String string2 = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)string)) + "/**/*.class";
        Resource[] resourceArray = pathMatchingResourcePatternResolver.getResources(string2);
        ArrayList<ServiceMetadata> arrayList = new ArrayList<ServiceMetadata>();
        for (Resource resource : resourceArray) {
            MetadataReader metadataReader;
            ServiceMetadata serviceMetadata;
            if (!resource.isReadable() || (serviceMetadata = ServiceMetadataHelper.getMetadata(metadataReader = cachingMetadataReaderFactory.getMetadataReader(resource))) == null) continue;
            arrayList.add(serviceMetadata);
        }
        return arrayList;
    }
}

