/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Properties;
import javax.sql.DataSource;
import org.cyclos.bootstrap.DataSourceProvider;

public abstract class BaseDataSourceProvider
implements DataSourceProvider {
    private DataSource dataSource;
    private Driver loadedDriver;

    @Override
    public final void destroy() throws Exception {
        if (this.dataSource == null) {
            return;
        }
        this.doDestroy(this.dataSource);
        this.dataSource = null;
        if (this.loadedDriver != null) {
            DriverManager.deregisterDriver(this.loadedDriver);
            this.loadedDriver = null;
        }
    }

    @Override
    public DataSource get() {
        return this.dataSource;
    }

    @Override
    public final void initialize(Properties properties) throws Exception {
        if (this.dataSource != null) {
            return;
        }
        HashSet hashSet = new HashSet();
        DriverManager.getDrivers().asIterator().forEachRemaining(hashSet::add);
        this.dataSource = this.doInitialize(properties);
        DriverManager.getDrivers().asIterator().forEachRemaining(driver -> {
            if (!hashSet.contains(driver)) {
                this.loadedDriver = driver;
            }
        });
    }

    protected abstract void doDestroy(DataSource var1) throws Exception;

    protected abstract DataSource doInitialize(Properties var1) throws Exception;
}

