/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.model.CyclosException;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.services.Service;
import org.cyclos.utils.Pair;
import org.cyclos.utils.RunInChannel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class ServiceBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private InvokerHandler _invokerHandler;
    private ApplicationContext applicationContext;

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object postProcessAfterInitialization(Object object, String string) throws BeansException {
        return object;
    }

    public Object postProcessBeforeInitialization(Object object, String string) throws BeansException {
        Map<Method, BuiltInChannel> map = this.getMethodChannels(object.getClass());
        if (!map.isEmpty()) {
            try {
                return this.createProxy((Service)object, map);
            }
            catch (Exception exception) {
                throw new BeanCreationException("Error creating proxy for service: " + object.getClass().getName() + ". " + exception.getMessage(), (Throwable)exception);
            }
        }
        return object;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Object createProxy(Service service, Map<Method, BuiltInChannel> map) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setFilter(method -> map.containsKey(method));
        proxyFactory.setSuperclass(service.getClass());
        Class clazz = proxyFactory.createClass();
        Object object2 = ClassHelper.instantiate((Class)clazz);
        FieldHelper.copyFields((Object)service, (Object)((Service)object2));
        ((Proxy)object2).setHandler((object, method, method2, objectArray) -> this.invokeInChannel(object, method2, objectArray, (BuiltInChannel)map.get(method)));
        return object2;
    }

    private InvokerHandler getInvokerHandler() {
        if (this._invokerHandler == null) {
            this._invokerHandler = (InvokerHandler)this.applicationContext.getBean(InvokerHandler.class);
        }
        return this._invokerHandler;
    }

    private Map<Method, BuiltInChannel> getMethodChannels(Class<? extends Object> clazz) {
        if (!Service.class.isAssignableFrom(clazz)) {
            return Collections.emptyMap();
        }
        return Stream.of(clazz.getMethods()).map(method -> Pair.create((Object)method, (Object)((RunInChannel)AnnotationUtils.findAnnotation((Method)method, RunInChannel.class)))).filter(pair -> pair.getSecond() != null).collect(Collectors.toMap(Pair::getFirst, pair -> ((RunInChannel)pair.getSecond()).value()));
    }

    private Object invokeInChannel(Object object, Method method, Object[] objectArray, BuiltInChannel builtInChannel) throws Throwable {
        try {
            return this.getInvokerHandler().runAs(SessionDataFactory.inChannel((String)builtInChannel.getInternalName()), () -> method.invoke(object, objectArray));
        }
        catch (Exception exception) {
            ExceptionHelper.throwWithType((Throwable)exception, CyclosException.class);
            return null;
        }
    }
}

