/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.db.VersionScript;
import org.cyclos.db.VersionScripts;

public class DatabaseHistory {
    private static final int[] MIN_VERSION = new int[]{4, 0};
    private static final int HANDLED_PARTS = 2;
    public static final String DIRECTORY = "/versions";
    private LinkedList<VersionScripts> versions = new LinkedList();

    public static void main(String[] stringArray) throws Exception {
        DatabaseHistory databaseHistory = new DatabaseHistory();
        try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File("/tmp/versions")));){
            for (String string : databaseHistory.getApplicationVersions()) {
                printWriter.println("Scripts for version " + string + ":");
                SortedMap<Integer, VersionScript> sortedMap = databaseHistory.getScripts(string);
                for (VersionScript versionScript : sortedMap.values()) {
                    printWriter.println(versionScript);
                    printWriter.println("----------------");
                }
                printWriter.println();
                printWriter.println("===========================================");
                printWriter.println();
            }
        }
    }

    public DatabaseHistory() {
        VersionScripts versionScripts;
        SortedMap<Integer, VersionScript> sortedMap;
        String string;
        int[] nArray = new int[2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = CyclosVersion.getPart((int)i);
        }
        int[] nArray2 = new int[2];
        System.arraycopy(MIN_VERSION, 0, nArray2, 0, nArray2.length);
        int n = nArray2.length - 1;
        do {
            string = this.versionName(nArray2);
            try {
                sortedMap = VersionScript.readScripts(this.openFile(string));
                versionScripts = new VersionScripts(string, sortedMap);
                this.versions.addFirst(versionScripts);
                if (Arrays.equals(nArray2, nArray)) continue;
                int n2 = n;
                nArray2[n2] = nArray2[n2] + 1;
            }
            catch (IOException iOException) {
                nArray2[n] = 0;
                int n3 = n - 1;
                nArray2[n3] = nArray2[n3] + 1;
                if (nArray2[0] == 4) continue;
                throw new IllegalStateException("Couldn't read the database versions file");
            }
        } while (!Arrays.equals(nArray2, nArray));
        string = this.versionName(nArray);
        try {
            sortedMap = VersionScript.readScripts(this.openFile(string));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't read version file for the current version: " + string, iOException);
        }
        versionScripts = new VersionScripts(string, sortedMap);
        this.versions.addFirst(versionScripts);
    }

    public boolean exists(String string) {
        return this.getVersionScripts(string) != null;
    }

    public List<String> getApplicationVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VersionScripts versionScripts : this.versions) {
            arrayList.add(versionScripts.getAppVersion());
        }
        return arrayList;
    }

    public List<String> getApplicationVersionsToUpgrade(String string) {
        List<String> list = this.getApplicationVersions();
        String string2 = this.normalizeVersion(string);
        int n = list.indexOf(string2);
        ArrayList<String> arrayList = new ArrayList<String>(list.subList(0, n + 1));
        Collections.reverse(arrayList);
        return arrayList;
    }

    public List<Integer> getDbVersions(String string) {
        for (VersionScripts versionScripts : this.versions) {
            if (!versionScripts.getAppVersion().equals(string)) continue;
            return new ArrayList<Integer>(versionScripts.getScripts().keySet());
        }
        throw new IllegalArgumentException("Unknown application version: " + string);
    }

    public int getLastDbVersion(String string) {
        VersionScripts versionScripts = this.getVersionScripts(string);
        return versionScripts == null ? -1 : versionScripts.getLastDbVersion();
    }

    public SortedMap<Integer, VersionScript> getScripts(String string) {
        VersionScripts versionScripts = this.getVersionScripts(string);
        return versionScripts == null ? Collections.emptySortedMap() : versionScripts.getScripts();
    }

    public String normalizeVersion(String string) {
        String string2 = StringUtils.substringBefore((String)string, (String)"-");
        String[] stringArray = string2.split("\\.");
        if (stringArray.length < 2) {
            return null;
        }
        Object[] objectArray = new String[2];
        System.arraycopy(stringArray, 0, objectArray, 0, 2);
        String string3 = StringUtils.join((Object[])objectArray, (char)'.');
        return string3;
    }

    private VersionScripts getVersionScripts(String string) {
        String string2 = this.normalizeVersion(string);
        if (string2 == null) {
            return null;
        }
        VersionScripts versionScripts2 = (VersionScripts)IteratorUtils.find(this.versions.iterator(), versionScripts -> string2.equals(versionScripts.getAppVersion()));
        return versionScripts2;
    }

    private InputStream openFile(String string) throws FileNotFoundException {
        InputStream inputStream = DatabaseHistory.class.getResourceAsStream("/versions/database_" + string);
        if (inputStream == null) {
            throw new FileNotFoundException("No database version file for application version " + string);
        }
        return inputStream;
    }

    private String versionName(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(10);
        for (int n : nArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }
}

