/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_13;

import java.io.InputStream;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.access.principaltypes.PrincipalTypeDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.StringHelper;

public class ExportFormatsMigration
extends BaseMigration {
    @Override
    public int run() {
        Object object;
        HashMap<BuiltinLanguage, Properties> hashMap = new HashMap<BuiltinLanguage, Properties>();
        for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
            Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage);
            object = "/translations/translation-GENERAL";
            if (builtinLanguage != BuiltinLanguage.EN) {
                object = (String)object + "_" + String.valueOf(locale);
            }
            object = (String)object + ".properties";
            BuiltinLanguage[] builtinLanguageArray = this.getClass().getResourceAsStream((String)object);
            if (builtinLanguageArray == null) continue;
            hashMap.put(builtinLanguage, PropertiesHelper.from((InputStream)builtinLanguageArray));
        }
        int n = 0;
        for (BuiltInExportFormat builtInExportFormat : BuiltInExportFormat.values()) {
            object = (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into export_formats (version, enabled, internal_name, name, content_type, file_extension, is_binary, encoding) values (0, true, ?, ?, ?, ?, ?, ?)", 1), preparedStatement -> {
                preparedStatement.setString(1, builtInExportFormat.getInternalName());
                preparedStatement.setString(2, builtInExportFormat.getDisplayName());
                preparedStatement.setString(3, builtInExportFormat.getContentType());
                preparedStatement.setString(4, builtInExportFormat.getFileExtension());
                preparedStatement.setBoolean(5, builtInExportFormat.isBinary());
                if (builtInExportFormat.isBinary()) {
                    preparedStatement.setNull(6, 12);
                } else {
                    preparedStatement.setString(6, "UTF-8");
                }
                preparedStatement.execute();
                try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                    resultSet.next();
                    Long l = resultSet.getLong(1);
                    return l;
                }
            });
            for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
                String string;
                Properties properties = (Properties)hashMap.get(builtinLanguage);
                if (properties == null || !StringHelper.isNotBlank((Object)(string = properties.getProperty("INITIAL_DATA.exportFormat." + builtInExportFormat.name())))) continue;
                this.jdbcTemplate.update("insert into data_translations (version, language_id, type, property_name, entity_id, value)  select 0, id, ?, ?, ?, ? from languages where template = ?", new Object[]{DataTranslationType.EXPORT_FORMAT.name(), PrincipalTypeDTO.NAME.getName(), object, string, builtinLanguage.name()});
            }
            ++n;
        }
        return n;
    }
}

