/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_14;

import org.cyclos.db.BaseMigration;

public class ReindexTsvectorsMigration
extends BaseMigration {
    @Override
    public int run() throws Exception {
        this.jdbcTemplate.execute("drop trigger if exists tg_index_user_update on users;");
        this.jdbcTemplate.execute("create trigger tg_index_user_update\nbefore update on users\nfor each row when (\nold.name is distinct from new.name\n)\nexecute procedure fn_index_user();");
        if (this.cyclosProperties.isUsingOpenSearch()) {
            return 0;
        }
        int n = this.jdbcTemplate.update("update users set name_tsvector = setweight(to_tsvector('unaccent', name), 'B') where name is not null;");
        n += this.jdbcTemplate.update("update ads set name_tsvector = setweight(to_tsvector('unaccent'::regconfig, name), 'A'), description_tsvector = setweight(to_tsvector('unaccent'::regconfig, description), 'B') where name is not null or description is not null;");
        n += this.jdbcTemplate.update("update user_custom_field_values set value_tsvector = to_tsvector('unaccent', coalesce(string_value, text_value, strip_html_tags(rich_text_value), '')) where string_value is not null or text_value is not null or rich_text_value is not null;");
        n += this.jdbcTemplate.update("update contact_custom_field_values set value_tsvector = to_tsvector('unaccent', coalesce(string_value, text_value, strip_html_tags(rich_text_value), '')) where string_value is not null or text_value is not null or rich_text_value is not null;");
        n += this.jdbcTemplate.update("update record_custom_field_values set value_tsvector = to_tsvector('unaccent', coalesce(string_value, text_value, strip_html_tags(rich_text_value), '')) where string_value is not null or text_value is not null or rich_text_value is not null;");
        n += this.jdbcTemplate.update("update ad_custom_field_values set value_tsvector=to_tsvector('unaccent', coalesce(string_value, text_value, strip_html_tags(rich_text_value), '')) where string_value is not null or text_value is not null or rich_text_value is not null;");
        return n += this.jdbcTemplate.update("update addresses set full_tsvector = to_tsvector('unaccent'::regconfig, concat(address_line_1, ' ', address_line_2, ' ', street, ' ', building_number, ' ', complement, ' ', city, ' ', neighborhood, ' ', po_box, ' ', region, ' ', zip)),address_tsvector = to_tsvector('unaccent'::regconfig, concat(address_line_1, ' ', address_line_2, ' ', street, ' ', building_number, ' ', complement)),neighborhood_tsvector = to_tsvector('unaccent'::regconfig, neighborhood),city_tsvector = to_tsvector('unaccent'::regconfig, city),region_tsvector = to_tsvector('unaccent'::regconfig, region);");
    }
}

