/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_15;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.db.BaseMigration;
import org.cyclos.utils.Module;
import org.cyclos.utils.StringHelper;
import org.springframework.jdbc.core.RowCallbackHandler;

public class SetCustomTranslationSourceValueMigration
extends BaseMigration {
    private static final String TRANSLATION_FILENAME_TEMPLATE_4_14 = "cyclos-4.14-i18n-{0}.properties";
    private static final String APP_TRANSLATION_FILENAME_4_14 = "cyclos-4.14-i18n-APP.json";
    private Map<Module, Map<?, ?>> translations4_14 = new HashMap();

    @Override
    public int run() throws Exception {
        return this.processTranslations();
    }

    private Map<?, ?> loadSources4_14(Module module) {
        Map<Object, Object> map = this.translations4_14.get(module);
        if (map == null) {
            String string = "/versions/v4_15/" + (module == Module.APP ? APP_TRANSLATION_FILENAME_4_14 : TRANSLATION_FILENAME_TEMPLATE_4_14.replace("{0}", module.name()));
            try (InputStream inputStream = SetCustomTranslationSourceValueMigration.class.getResourceAsStream(string);){
                if (module == Module.APP) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    map = (Map)objectMapper.readValue(inputStream, Map.class);
                } else {
                    map = new Properties();
                    map.load(inputStream);
                }
                this.translations4_14.put(module, map);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        return map;
    }

    private int processTranslations() {
        MyRowCallbackHandler myRowCallbackHandler = new MyRowCallbackHandler();
        String string = "SELECT id, msg_key FROM translation_messages";
        this.jdbcTemplate.query(string, (RowCallbackHandler)myRowCallbackHandler);
        myRowCallbackHandler.deleteRemovedKeys();
        return myRowCallbackHandler.affected;
    }

    private Module toModule(String string) {
        try {
            return Module.valueOf((String)StringUtils.substringBefore((String)string, (int)46));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class MyRowCallbackHandler
    implements RowCallbackHandler {
        private Set<Long> toDelete = new HashSet<Long>();
        private int affected;

        private MyRowCallbackHandler() {
        }

        public void processRow(ResultSet resultSet) throws SQLException {
            long l = resultSet.getLong(1);
            String string = resultSet.getString(2);
            Module module = SetCustomTranslationSourceValueMigration.this.toModule(string);
            if (module == null) {
                this.toDelete.add(l);
                return;
            }
            Map<?, ?> map = SetCustomTranslationSourceValueMigration.this.loadSources4_14(module);
            String string2 = this.getSource(map, module, string);
            if (string2 == null) {
                string2 = "_UNKNOWN_";
            }
            String string3 = string2;
            this.affected += SetCustomTranslationSourceValueMigration.this.jdbcTemplate.update(connection -> {
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE translation_messages SET source_value=? WHERE id=?");
                preparedStatement.setString(1, string3);
                preparedStatement.setLong(2, l);
                return preparedStatement;
            });
        }

        private void deleteRemovedKeys() {
            if (this.toDelete.isEmpty()) {
                return;
            }
            this.affected += SetCustomTranslationSourceValueMigration.this.jdbcTemplate.update("DELETE FROM translation_messages WHERE id IN " + SetCustomTranslationSourceValueMigration.inPlaceholders(this.toDelete), this.toDelete.toArray());
        }

        private String getSource(Map<?, ?> map, Module module, String string) {
            if (module == Module.APP) {
                String string2 = StringUtils.substringAfter((String)string, (String)"APP.TRANSLATIONS.");
                String[] stringArray = StringUtils.split((String)string2, (char)'-');
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    if ((map = (Map)map.get(stringArray[i])) != null) continue;
                    return null;
                }
                return (String)map.get(stringArray[stringArray.length - 1]);
            }
            return (String)map.get(StringHelper.removeStart((String)string, (String)(module.name() + ".")));
        }
    }
}

