/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_16;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.messaging.alerts.AlertNature;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;

public class TransferFeeWrongConfigurationAlertMigration
extends BaseMigration {
    @Override
    public int run() throws Exception {
        List list = this.jdbcTemplate.queryForList(" select c.network_id as network_id, tf.name as name from transfer_fees tf inner join transfer_types tt on tt.id=tf.original_transfer_type_id   inner join transfer_types gtt on gtt.id=tf.generated_transfer_type_id  inner join account_types at on at.id=tt.from_account_type_id  inner join currencies c on c.id=at.currency_id where gtt.direction='USER_TO_SELF' and      not(       (tf.payer != 'SYSTEM' and tf.payer=tf.receiver and         (tf.payer != 'FIXED_MEMBER' or tf.payer_user_id=tf.receiver_user_id)       ) or        (tt.direction='USER_TO_SELF' and         (tf.payer='SOURCE' and tf.receiver='DESTINATION'           or          tf.payer='SOURCE_BROKER' and tf.receiver='DESTINATION_BROKER'        )       )      )");
        HashMap<Long, List> hashMap = new HashMap<Long, List>();
        for (Map map : list) {
            String string = (String)CoercionHelper.coerce(String.class, map.get("name"));
            Long l = (Long)CoercionHelper.coerce(Long.class, map.get("network_id"));
            List list2 = (List)ObjectHelper.defaultValue((Object)((List)hashMap.get(l)), new ArrayList());
            list2.add(string);
            hashMap.put(l, list2);
        }
        hashMap.forEach(this::createCustomAlert);
        return 0;
    }

    private void createCustomAlert(Long l, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder().append("The following transfer fees have been configured with an invalid generated transfer type (it can not be a type used for self-payments): ").append(StringHelper.join(list, (String)", ")).append(".\nIf those fees are not fixed the associated payments will fail.");
        this.jdbcTemplate.update("insert into alerts (date, subclass, system_type, network_id, arg0) values (now(), ?, ?, ?, ?)", new Object[]{AlertNature.SYSTEM.name(), SystemAlertType.CUSTOM.name(), l, stringBuilder});
    }
}

