/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_3;

import java.io.InputStream;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.StringHelper;

public class PrincipalTypesMigration
extends BaseMigration {
    @Override
    public int run() {
        Object object;
        HashMap<BuiltinLanguage, Properties> hashMap = new HashMap<BuiltinLanguage, Properties>();
        for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
            Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage);
            object = "/translations/translation-GENERAL";
            if (builtinLanguage != BuiltinLanguage.EN) {
                object = (String)object + "_" + String.valueOf(locale);
            }
            object = (String)object + ".properties";
            BuiltinLanguage[] builtinLanguageArray = this.getClass().getResourceAsStream((String)object);
            if (builtinLanguageArray == null) continue;
            hashMap.put(builtinLanguage, PropertiesHelper.from((InputStream)builtinLanguageArray));
        }
        int n = 0;
        for (ExistingBuiltInPrincipalType existingBuiltInPrincipalType : ExistingBuiltInPrincipalType.values()) {
            object = (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into principal_types (version, subclass, internal_name, name) values (0, ?, ?, ?)", 1), preparedStatement -> {
                preparedStatement.setString(1, PrincipalTypeNature.BUILT_IN.name());
                preparedStatement.setString(2, existingBuiltInPrincipalType.getInternalName());
                preparedStatement.setString(3, existingBuiltInPrincipalType.getDisplayName());
                preparedStatement.execute();
                try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                    resultSet.next();
                    Long l = resultSet.getLong(1);
                    return l;
                }
            });
            for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
                String string;
                Properties properties = (Properties)hashMap.get(builtinLanguage);
                if (properties == null || !StringHelper.isNotBlank((Object)(string = properties.getProperty("INITIAL_DATA.principalType." + existingBuiltInPrincipalType.name())))) continue;
                this.jdbcTemplate.update("insert into data_translations (version, type, language, property_name, entity_id, value) values (0, ?, ?, ?, ?, ?)", new Object[]{DataTranslationType.PRINCIPAL_TYPE.name(), builtinLanguage.name(), PrincipalTypeDTO.NAME.getName(), object, string});
            }
            ++n;
        }
        return n;
    }
}

