/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_5;

import java.io.InputStream;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.mutable.MutableLong;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.channels.ChannelDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.dao.EmptyResultDataAccessException;

public class BuiltInChannelsMigration
extends BaseMigration {
    @Override
    public int run() {
        try {
            this.jdbcTemplate.queryForObject("select id from channels where internal_name=?", Long.class, new Object[]{BuiltInChannel.MOBILE.getInternalName()});
            return 0;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            Object object;
            Object object2;
            HashMap<BuiltinLanguage, Properties> hashMap = new HashMap<BuiltinLanguage, Properties>();
            for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
                Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)builtinLanguage);
                object2 = "/translations/translation-GENERAL";
                if (builtinLanguage != BuiltinLanguage.EN) {
                    object2 = (String)object2 + "_" + String.valueOf(locale);
                }
                object2 = (String)object2 + ".properties";
                object = this.getClass().getResourceAsStream((String)object2);
                if (object == null) continue;
                hashMap.put(builtinLanguage, PropertiesHelper.from((InputStream)object));
            }
            Long l = (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into channels (version, internal_name, name) values (0, ?, ?)", 1), preparedStatement -> {
                preparedStatement.setString(1, BuiltInChannel.MOBILE.getInternalName());
                preparedStatement.setString(2, BuiltInChannel.MOBILE.getDisplayName());
                preparedStatement.execute();
                try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                    resultSet.next();
                    Long l = resultSet.getLong(1);
                    return l;
                }
            });
            for (BuiltinLanguage builtinLanguage : BuiltinLanguage.values()) {
                object2 = (Properties)hashMap.get(builtinLanguage);
                if (object2 == null || !StringHelper.isNotBlank((Object)(object = ((Properties)object2).getProperty("INITIAL_DATA.channel.MOBILE")))) continue;
                this.jdbcTemplate.update("insert into data_translations (version, type, language_id, property_name, entity_id, value) select 0, ?, id, ?, ?, ? from languages where template=? and parent_id is null", new Object[]{DataTranslationType.CHANNEL.name(), ChannelDTO.NAME.getName(), l, object, builtinLanguage.name()});
            }
            long l2 = (Long)this.jdbcTemplate.queryForObject("select id from channels where internal_name=?", Long.class, new Object[]{"accessClient"});
            long l3 = (Long)this.jdbcTemplate.queryForObject("select id from channels where internal_name=?", Long.class, new Object[]{BuiltInChannel.WEB_SERVICES.getInternalName()});
            object2 = "select chc.id, whitelist_id, configuration_id from channel_configurations chc, channels ch where chc.channel_id=ch.id and ch.internal_name=?";
            object = this.jdbcTemplate.queryForList((String)object2, new Object[]{BuiltInChannel.WEB_SERVICES.getInternalName()});
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                long l4 = (Long)map.get("id");
                long l5 = (Long)map.get("configuration_id");
                Map<String, Object> map2 = this.getReceivePaymentChannelConfiguration(l2, l5);
                long l6 = this.copyChannelConfiguration(l4, (Long)map.get("whitelist_id"), l, map2);
                this.jdbcTemplate.update("insert into channels_payment_principal_types (channel_configuration_id, principal_type_id) select ?, principal_type_id from channels_payment_principal_types where channel_configuration_id=?", new Object[]{l6, l4});
                long l7 = map2 != null ? (Long)map2.get("id") : l4;
                this.jdbcTemplate.update("insert into channels_receive_principal_types (channel_configuration_id, principal_type_id) select ?, principal_type_id from channels_receive_principal_types where channel_configuration_id=?", new Object[]{l6, l7});
                this.jdbcTemplate.update("insert into channels_principal_types (channel_configuration_id, principal_type_id) select ?, principal_type_id from channels_principal_types where channel_configuration_id=?", new Object[]{l6, l4});
            }
            int n = object.size();
            n += this.jdbcTemplate.update("delete from channels_payment_principal_types where channel_configuration_id in (select id from channel_configurations where channel_id=?)", new Object[]{l2});
            n += this.jdbcTemplate.update("delete from channels_principal_types where channel_configuration_id in (select id from channel_configurations where channel_id=?)", new Object[]{l2});
            n += this.jdbcTemplate.update("delete from channels_receive_principal_types where channel_configuration_id in (select id from channel_configurations where channel_id=?)", new Object[]{l2});
            n += this.jdbcTemplate.update("delete from channel_configurations where channel_id=?", new Object[]{l2});
            n += this.jdbcTemplate.update("update imported_files set channel_id=? where channel_id=?", new Object[]{l3, l2});
            n += this.jdbcTemplate.update("delete from payment_transfer_types_channels where channel_id=?", new Object[]{l2});
            n += this.jdbcTemplate.update("delete from products_channels where channel_id=?", new Object[]{l2});
            n += this.jdbcTemplate.update("update transactions set channel_id=? where channel_id=?", new Object[]{l3, l2});
            n += this.jdbcTemplate.update("delete from user_channels where channel_id=?", new Object[]{l2});
            return n += this.jdbcTemplate.update("delete from channels where id=?", new Object[]{l2});
        }
    }

    private long copyChannelConfiguration(long l, Long l2, long l3, Map<String, Object> map) {
        MutableLong mutableLong = new MutableLong();
        if (l2 != null) {
            mutableLong.setValue(this.copyWhiteList(l2));
        }
        long l4 = (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into channel_configurations (subclass, autocomplete_on_payment, autocomplete_on_receive_payment, confirmation_password_once_per_session, contacts_on_payment, contacts_on_receive_payment, def_pmt_id_method, def_rec_pmt_id_method, defined, enabled, locked, user_access, session_timeout_amount, session_timeout_field, access_password_id, configuration_id, confirmation_password_id, default_payment_principal_type_id, default_principal_type_id, default_receive_principal_type_id, channel_id, version, whitelist_id) select 'DEFAULT', autocomplete_on_payment, autocomplete_on_receive_payment, confirmation_password_once_per_session, contacts_on_payment, contacts_on_receive_payment, def_pmt_id_method, def_rec_pmt_id_method, defined, enabled, locked, user_access, session_timeout_amount, session_timeout_field, access_password_id, configuration_id, confirmation_password_id, default_payment_principal_type_id, default_principal_type_id, default_receive_principal_type_id, ?, 1, ? from channel_configurations where id=?", 1), preparedStatement -> {
            preparedStatement.setLong(1, l3);
            if (l2 != null) {
                preparedStatement.setLong(2, mutableLong.getValue());
            } else {
                preparedStatement.setNull(2, -5);
            }
            preparedStatement.setLong(3, l);
            preparedStatement.execute();
            try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                resultSet.next();
                Long l4 = resultSet.getLong(1);
                return l4;
            }
        });
        if (map != null) {
            Boolean bl = (Boolean)map.get("autocomplete_on_receive_payment");
            Boolean bl2 = (Boolean)map.get("contacts_on_receive_payment");
            String string = (String)map.get("def_rec_pmt_id_method");
            Long l5 = (Long)map.get("default_receive_principal_type_id");
            this.jdbcTemplate.update("update channel_configurations set autocomplete_on_receive_payment=?, contacts_on_receive_payment=?, def_rec_pmt_id_method=?, default_receive_principal_type_id=? where id=?", new Object[]{bl, bl2, string, l5, l4});
        }
        return l4;
    }

    private long copyWhiteList(long l) {
        return (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into internet_address_lists (addresses, last_resolution_date) select addresses, null from internet_address_lists where id=?", 1), preparedStatement -> {
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
            try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                resultSet.next();
                Long l2 = resultSet.getLong(1);
                return l2;
            }
        });
    }

    private Map<String, Object> getReceivePaymentChannelConfiguration(long l, long l2) {
        try {
            return this.jdbcTemplate.queryForMap("select id, autocomplete_on_receive_payment, contacts_on_receive_payment, def_rec_pmt_id_method, default_receive_principal_type_id from channel_configurations chc where chc.configuration_id=? and chc.channel_id=?", new Object[]{l2, l});
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }
}

