/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.querydsl.core.types.dsl.StringPath;
import java.util.Date;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.AbstractServerComponent;
import org.cyclos.impl.access.AuthHandler;
import org.cyclos.impl.access.PermissionCheck;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.users.GroupsHandler;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.utils.RestBeanPropertyMapping;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.validation.ValidationHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractNetworkedServerComponent
extends AbstractServerComponent {
    @Autowired
    protected EntityManagerHandler entityManagerHandler;
    @Autowired
    protected ProductsHandler productsHandler;
    @Autowired
    protected GroupsHandler groupsHandler;
    @Autowired
    protected UserLocatorHandler userLocatorHandler;
    @Autowired
    protected ConversionHandler conversionHandler;
    @Autowired
    protected CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    protected AuthHandler authHandler;
    @Autowired
    protected RestBeanPropertyMapping restBeanPropertyMapping;
    @Autowired
    protected ValidationHandler validationHandler;

    protected void checkValue(Permission permission, Object ... objectArray) throws PermissionDeniedException {
        if (!this.hasValue(permission, objectArray)) {
            throw new PermissionDeniedException();
        }
    }

    protected EntityManagerHandler getBaseEntityManagerHandler() {
        return this.entityManagerHandler;
    }

    protected ConfigurationAccessor getConfiguration() {
        return this.getSessionData().getConfiguration();
    }

    protected BasicUser getLoggedBasicUser() {
        return this.getSessionData().getLoggedBasicUser();
    }

    protected User getLoggedUser() {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null) {
            return null;
        }
        return basicUser.getUser();
    }

    protected ProductsAccessor getProducts() {
        return this.getSessionData().getProducts();
    }

    protected String getTranslatedName(NamedEntity namedEntity) {
        return this.dataTranslationHandler.getName(namedEntity);
    }

    protected String getTranslatedValue(BaseEntity baseEntity, StringPath stringPath) {
        return this.dataTranslationHandler.getValue(baseEntity, stringPath);
    }

    protected boolean hasPermission(Permission ... permissionArray) {
        return this.getSessionData().hasPermission(permissionArray);
    }

    protected boolean hasValue(Permission permission, Object ... objectArray) {
        return this.authHandler.hasValue(permission, objectArray);
    }

    protected boolean isAdmin() {
        return this.getSessionData().isAdmin();
    }

    protected boolean isBroker() {
        return this.getSessionData().isBroker();
    }

    protected boolean isGlobalAdmin() {
        return this.getSessionData().isGlobalAdmin();
    }

    protected boolean isGlobalAdminInNetwork() {
        return this.getSessionData().isGlobalAdminInNetwork();
    }

    protected boolean isGuest() {
        return this.getSessionData().isGuest();
    }

    protected boolean isLoggedIn() {
        return this.getSessionData().isLoggedIn();
    }

    protected boolean isManagerOf(BasicUser basicUser) {
        return this.getSessionData().isManagerOf(basicUser);
    }

    protected boolean isMember() {
        return this.getSessionData().isMember();
    }

    protected boolean isMemberOnly() {
        return this.getSessionData().isMemberOnly();
    }

    protected boolean isNetworkAdmin() {
        return this.getSessionData().isNetworkAdmin();
    }

    protected boolean isOperator() {
        return this.getSessionData().isOperator();
    }

    protected boolean isSystem() {
        return this.getSessionData().isSystem();
    }

    protected boolean isUserManager() {
        return this.getSessionData().isUserManager();
    }

    protected String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(messageFormat, messageKey, objectArray);
    }

    protected String message(MessageKey messageKey, Object ... objectArray) {
        return this.translationHandler.message(MessageFormat.NEW_LINE_TO_BR, messageKey, objectArray);
    }

    protected UserPermissionCheck permission(BasicUser basicUser) {
        return this.authHandler.permission(basicUser);
    }

    protected PermissionCheck permission(Permission permission) {
        return this.authHandler.permission(permission);
    }

    protected PermissionCheck permissionOptionalValue(Permission permission) {
        return this.authHandler.permissionOptionalValue(permission);
    }

    protected UserPermissionCheck permissionOptionalValue(User user) {
        return this.authHandler.permissionOptionalValue((BasicUser)user);
    }

    protected Date toDate(DateTime dateTime) {
        return this.conversionHandler.toDate((IDate)dateTime);
    }

    protected DateTime toDateTime(Date date) {
        return this.conversionHandler.toDateTime(date);
    }

    protected void validate(Validator validator, Object object, String string) {
        this.validationHandler.validate(validator, object, string);
    }
}

