/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.security.SecureRandom;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javassist.util.proxy.ProxyObject;
import javax.annotation.PostConstruct;
import org.apache.commons.text.StringEscapeUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.bootstrap.DatabaseManager;
import org.cyclos.db.DatabaseHistory;
import org.cyclos.db.DatabasePopulator;
import org.cyclos.entities.Application;
import org.cyclos.entities.IdCipherRound;
import org.cyclos.entities.QApplication;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.utils.QBackgroundTaskExecution;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.ApplicationInitializationListener;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.ArchiveHandler;
import org.cyclos.impl.BaseApplicationInitializationListener;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.system.InlineScriptBackgroundTask;
import org.cyclos.impl.system.LicenseHandlerImplementor;
import org.cyclos.impl.utils.IdMask;
import org.cyclos.impl.utils.cache.CacheHandlerImplementor;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.notifications.MailProcessingBackgroundTask;
import org.cyclos.impl.utils.persistence.CacheFlusher;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.license.core.CipherHelper;
import org.cyclos.model.BeanDataAccessorFactory;
import org.cyclos.model.DataAccessException;
import org.cyclos.model.IEntity;
import org.cyclos.model.MapBeanDataAccessorFactory;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.stereotype.Component;

@Component
public class ApplicationHandlerImpl
extends BaseGlobalHandlerImpl
implements ApplicationHandler {
    private static final Object ID_MASK_MUTEX = new Object();
    private static final int MAX_ARCHIVING_FAILURES = 5;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private DatabaseHistory databaseHistory;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private LicenseHandlerImplementor licenseHandler;
    @Autowired
    private DatabaseManager databaseManager;
    @Autowired
    private ArchiveHandler archiveService;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    private volatile IdMask idMask;
    private boolean initialized;
    private boolean shuttingDown;

    public static byte[] deriveKey(byte[] byArray, byte[] byArray2) {
        if (byArray2 != null) {
            byte[] byArray3 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byte by = i < byArray2.length ? byArray2[i] : (byte)0;
                byArray3[i] = (byte)(byArray[i] ^ by);
            }
            byArray = byArray3;
        }
        return byArray;
    }

    public String decrypt(byte[] byArray, byte[] byArray2) throws DataAccessException {
        return CipherHelper.decrypt((byte[])this.deriveKey(byArray2), (byte[])byArray);
    }

    public String decrypt(String string, byte[] byArray) {
        byte[] byArray2 = Base64.getDecoder().decode(string);
        return this.decrypt(byArray2, byArray);
    }

    public byte[] encrypt(String string, byte[] byArray) throws DataAccessException {
        return CipherHelper.encrypt((byte[])this.deriveKey(byArray), (String)string);
    }

    public String encryptAsString(String string, byte[] byArray) {
        byte[] byArray2 = this.encrypt(string, byArray);
        return Base64.getEncoder().encodeToString(byArray2);
    }

    public void finishArchiving(int n) {
        Application application = this.getApplication();
        Date date = application.getArchivingDate();
        if (date == null) {
            return;
        }
        if (n == 0) {
            QAccount qAccount = QAccount.account;
            boolean bl = ((DBQuery)this.from(new EntityPath[]{qAccount}).where(new Predicate[]{qAccount.creationDate.before((Comparable)date), qAccount.archivingDate.isNull().or((Predicate)qAccount.archivingDate.before((Comparable)date))})).hasResults();
            if (bl) {
                this.getLogger().error("Archiving cannot proceed because there are accounts whose archived balances weren't propertly calculated for {}", (Object)OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC));
                return;
            }
            application.setArchivingFinished(true);
        } else if (n + 1 == 5) {
            this.invokerHandler.submitAsInParallelTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.alertService.create(SystemAlertType.ARCHIVING_FAILED, new Object[]{5}));
            return;
        }
        InvocationContext.ensure().addCommitListener(true, () -> this.invokerHandler.getExecutorService().submit(() -> {
            try {
                this.archiveService.archive();
            }
            catch (Exception exception) {
                this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                    String string = "applicationHandler.finishArchiving(" + (n + 1) + ")";
                    this.backgroundTaskHandler.schedule((BackgroundTaskScheduling)InlineScriptBackgroundTask.scheduling(string).startAfter(DateHelper.add((Date)new Date(), (TimeField)TimeField.MINUTES, (int)10)));
                    return null;
                });
            }
        }));
    }

    public Application getApplication() {
        QApplication qApplication = QApplication.application;
        Application application = (Application)this.from(new EntityPath[]{qApplication}).singleResult((Expression)qApplication);
        return application;
    }

    public CyclosProperties getCyclosProperties() {
        return this.cyclosProperties;
    }

    public IdMask getIdMask() {
        if (this.idMask == null) {
            this.initializeIdMask();
        }
        return this.idMask;
    }

    @PostConstruct
    public void initialize() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
            configurableApplicationContext.addApplicationListener(this::doInitialize);
            configurableApplicationContext.addApplicationListener(this::shutdown);
            configurableApplicationContext.addApplicationListener(applicationEvent -> {
                if (applicationEvent instanceof ContextRefreshedEvent) {
                    ((ClusterHandler)applicationContext.getBean(ClusterHandler.class)).checkConsistency();
                }
            });
        }
        if (this.cyclosProperties.isDebuggableEnv()) {
            BeanDataAccessorFactory.Instance.init((BeanDataAccessorFactory)new MapBeanDataAccessorFactory(){

                protected Map<String, Object> newMap() {
                    return new TreeMap<String, Object>();
                }
            });
        }
        StringHelper.HTML_ENTITIES_REMOVER = string -> string == null ? null : StringEscapeUtils.unescapeHtml4((String)string);
        StringHelper.random = new SecureRandom();
        SimpleEntity.register(simpleEntity -> {
            CacheFlusher cacheFlusher = InvocationContext.getCurrentCacheFlusher();
            if (cacheFlusher != null && !(simpleEntity instanceof ProxyObject)) {
                cacheFlusher.addLoaded(simpleEntity);
            }
        });
    }

    public boolean isArchivingEnabled() {
        return this.cyclosProperties.getArchivingMonths() > 0 || this.getApplication().getArchivingDate() != null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    private boolean applicationExists() {
        return (Boolean)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            QApplication qApplication = QApplication.application;
            return this.from(new EntityPath[]{qApplication}).hasResults();
        });
    }

    private void cleanGeneratedDataAfterPopulate() {
        QBackgroundTaskExecution qBackgroundTaskExecution = QBackgroundTaskExecution.backgroundTaskExecution;
        this.delete((EntityPath<?>)qBackgroundTaskExecution).where(new Predicate[]{qBackgroundTaskExecution.className.eq((Object)MailProcessingBackgroundTask.class.getName())}).execute();
    }

    private byte[] deriveKey(byte[] byArray) {
        byte[] byArray2 = this.licenseHandler.getEncryptionKey();
        return ApplicationHandlerImpl.deriveKey(byArray2, byArray);
    }

    private synchronized void doInitialize(ApplicationEvent applicationEvent) {
        if (!(applicationEvent instanceof ContextRefreshedEvent) && !(applicationEvent instanceof ContextStartedEvent) || this.initialized) {
            return;
        }
        SerializableInputStream.setTempFileSupplier(() -> {
            SessionData sessionData;
            InvocationContext invocationContext = InvocationContext.get();
            SessionData sessionData2 = sessionData = invocationContext == null ? null : invocationContext.sessionData();
            if (sessionData != null) {
                String string = sessionData.getLoggedBasicUser() == null ? (sessionData.isSystem() ? "system" : "guest") : sessionData.getLoggedBasicUser().getUsername();
                String string2 = sessionData.getNetwork() == null ? "global" : sessionData.getNetwork().getInternalName();
                RequestData requestData = sessionData.getRequestData();
                String string3 = requestData == null ? null : requestData.getUri();
                String string4 = string3 == null ? String.format("%s_%s_", string2, string) : String.format("%s_%s_%s_", string2, string, string3.replaceAll("[^a-zA-Z0-9\\-]", "~"));
                return this.cyclosProperties.newTempFile(string4, ".stream");
            }
            return this.cyclosProperties.newTempFile("temp", ".stream");
        });
        this.databaseManager.doWithCyclosInstanceLock(this::ensureDatabaseIsPopulated);
        Application application = (Application)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> this.getApplication());
        ClusterHandler clusterHandler = (ClusterHandler)this.getApplicationContext().getBean(ClusterHandler.class);
        if (!this.cyclosProperties.isSkipInitializations()) {
            List list = this.getApplicationContext().getBeansOfType(ApplicationInitializationListener.class).values().stream().sorted(Comparator.comparing(BaseApplicationInitializationListener::applicationInitializationPriority).thenComparing(BaseApplicationInitializationListener::getInitializationId)).collect(Collectors.toList());
            for (Object object : list) {
                clusterHandler.runInitialization((ApplicationInitializationListener)object);
            }
            String string = application.getLastCommitId();
            if (this.cyclosProperties.isDevelopment() || !CyclosVersion.getCommitId().equals(string)) {
                Object object;
                object = this.getApplicationContext().getBeansOfType(ApplicationUpgradeInitializationListener.class).values().stream().sorted(Comparator.comparing(BaseApplicationInitializationListener::applicationInitializationPriority).thenComparing(BaseApplicationInitializationListener::getInitializationId)).collect(Collectors.toList());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ApplicationUpgradeInitializationListener applicationUpgradeInitializationListener = (ApplicationUpgradeInitializationListener)iterator.next();
                    clusterHandler.runUpgradeInitialization(applicationUpgradeInitializationListener);
                }
            }
        }
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.update((EntityPath<?>)QApplication.application).set((Path)QApplication.application.lastCommitId, (Object)CyclosVersion.getCommitId()).execute());
        this.invokerHandler.submitAsInParallelTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.alertService.create(SystemAlertType.APPLICATION_RESTARTED, new Object[0]));
        clusterHandler.starTaskTimers();
        this.initialized = true;
    }

    private void ensureDatabaseIsPopulated() {
        boolean bl;
        boolean bl2 = bl = !this.applicationExists();
        if (bl) {
            this.populateDatabase();
        } else {
            this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
                this.initializeIdMask();
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIdMask() {
        if (this.idMask == null) {
            Object object = ID_MASK_MUTEX;
            synchronized (object) {
                if (this.idMask == null) {
                    this.idMask = (IdMask)this.beanHandler.getBean(IdMask.class, this.cyclosProperties.getIdMaskClass());
                }
            }
        }
    }

    private void populateDatabase() {
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            Object object;
            String string = this.databaseHistory.normalizeVersion(CyclosVersion.get());
            int n = this.databaseHistory.getLastDbVersion(string);
            Application application = new Application();
            application.setApplicationVersion(string);
            application.setDatabaseVersion(n);
            application.setLastCommitId(CyclosVersion.getCommitId());
            this.persist((IEntity)application);
            SecureRandom secureRandom = new SecureRandom();
            for (int i = 0; i < 8; ++i) {
                object = new IdCipherRound();
                object.setOrder(i);
                object.setMask(secureRandom.nextLong());
                object.setRotateBits(secureRandom.nextInt(62) + 1);
                this.persist((IEntity)object);
            }
            this.initializeIdMask();
            CacheHandlerImplementor cacheHandlerImplementor = (CacheHandlerImplementor)this.getApplicationContext().getBean(CacheHandlerImplementor.class);
            object = null;
            try {
                cacheHandlerImplementor.setSkipCache(true);
                object = (DatabasePopulator)this.beanHandler.customBean(DatabasePopulator.class, this.cyclosProperties.getDbPopulatorClass());
                this.getLogger().info("Filling the database with " + object.getDisplayName());
                object.populate();
                this.cleanGeneratedDataAfterPopulate();
                this.getLogger().info("Database was successfully filled");
            }
            catch (ValidationException validationException) {
                ValidationResult validationResult = validationException.getValidation();
                List list = CollectionHelper.orEmpty((List)(validationResult == null ? null : validationResult.getAllErrors()));
                this.getLogger().error("Validation error while populating the database:\n" + CollectionHelper.join((Iterable)list, (String)"\n"), (Throwable)validationException);
                throw validationException;
            }
            catch (Throwable throwable) {
                this.getLogger().error("Error populating the database", throwable);
                throw throwable;
            }
            finally {
                cacheHandlerImplementor.setSkipCache(false);
                if (object != null) {
                    this.beanHandler.destroy(object);
                }
            }
            return null;
        });
    }

    private synchronized void shutdown(ApplicationEvent applicationEvent) {
        if (!(applicationEvent instanceof ContextStoppedEvent) && !(applicationEvent instanceof ContextClosedEvent) || !this.initialized) {
            return;
        }
        this.shuttingDown = true;
        this.initialized = false;
    }
}

