/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.persistence.Embedded;
import javax.persistence.Transient;
import org.cyclos.entities.BigDecimalScaleListener;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.FixedScale;
import org.cyclos.entities.MaxScale;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.BigDecimalScaleHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.stereotype.Component;

@Component
public class BigDecimalScaleHandlerImpl
extends BaseGlobalHandlerImpl
implements BigDecimalScaleHandler {
    private static final Object MUTEX = new Object();
    private final CurrencyScaleResolver CURRENCY = new CurrencyScaleResolver();
    private final FixedScaleResolver[] FIXED = new FixedScaleResolver[BigDecimalHelper.MAX_SCALE];
    private Map<Class<?>, ResolverMetaData> scaleResolverMapping = new ConcurrentHashMap();

    public void adjustScale(Object object) {
        this.process(object);
    }

    public BigDecimal adjustScale(Object object, Object object2, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        String string = PropertyHelper.getPropertyName((Object)object2);
        int n = this.getScale(object, string);
        return BigDecimalHelper.round((BigDecimal)bigDecimal, (int)n);
    }

    public void adjustScale(Object object, Object object2, DecimalRange decimalRange) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = decimalRange == null ? null : decimalRange.getMin();
        BigDecimal bigDecimal3 = bigDecimal = decimalRange == null ? null : decimalRange.getMax();
        if (bigDecimal2 != null || bigDecimal != null) {
            String string = PropertyHelper.getPropertyName((Object)object2);
            int n = this.getScale(object, string);
            decimalRange.setMin(BigDecimalHelper.round((BigDecimal)bigDecimal2, (int)n));
            decimalRange.setMax(BigDecimalHelper.round((BigDecimal)bigDecimal, (int)n));
        }
    }

    public int getScale(Object object, Object object2) {
        ScaleResolver scaleResolver;
        block7: {
            if (object == null) {
                return -1;
            }
            String string = PropertyHelper.getPropertyName((Object)object2);
            ResolverMetaData resolverMetaData = this.map(object.getClass());
            scaleResolver = resolverMetaData.resolversByName.get(string);
            if (scaleResolver == null) {
                try {
                    Method method = new BeanWrapperImpl(object).getPropertyDescriptor(string).getReadMethod();
                    if (method != null) {
                        scaleResolver = this.getScaleResolver(method);
                        try {
                            resolverMetaData.resolversByName.put(string, scaleResolver);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            resolverMetaData.resolversByName = new HashMap<String, ScaleResolver>(resolverMetaData.resolversByName);
                            resolverMetaData.resolversByName.put(string, scaleResolver);
                        }
                        break block7;
                    }
                    throw new IllegalArgumentException(String.format("Can't get scale of property %s.%s: read method not found. Check if the property is annotated with some of the available scale annotation", object.getClass().getName(), string));
                }
                catch (InvalidPropertyException invalidPropertyException) {
                    throw new IllegalArgumentException(String.format("Can't get scale of property %s.%s", object.getClass().getName(), string), invalidPropertyException);
                }
            }
        }
        return scaleResolver.resolveScale(object);
    }

    public BigDecimal getWithAdjustedScale(Object object, Object object2) {
        String string = PropertyHelper.getPropertyName((Object)object2);
        BigDecimal bigDecimal = (BigDecimal)InvocationContext.wrap((Object)object).getPropertyValue(string);
        return this.adjustScale(object, (Object)string, bigDecimal);
    }

    @PostConstruct
    public void initialize() {
        BigDecimalScaleListener.initialize(this::adjustScale);
    }

    private FixedScaleResolver fixed(int n) {
        if (n > BigDecimalHelper.MAX_SCALE) {
            throw new IllegalArgumentException("The maximum scale is " + BigDecimalHelper.MAX_SCALE + ", got " + n);
        }
        int n2 = n - 1;
        if (this.FIXED[n2] == null) {
            this.FIXED[n2] = new FixedScaleResolver(n);
        }
        return this.FIXED[n2];
    }

    private <E extends AnnotatedElement & Member> ScaleResolver getScaleResolver(E e) {
        FixedScale fixedScale = e.getAnnotation(FixedScale.class);
        if (fixedScale != null) {
            return this.fixed(fixedScale.value());
        }
        if (e.isAnnotationPresent(MaxScale.class)) {
            return this.fixed(BigDecimalHelper.MAX_SCALE);
        }
        if (e.isAnnotationPresent(CurrencyScale.class)) {
            if (!HasCurrency.class.isAssignableFrom(((Member)e).getDeclaringClass())) {
                throw new IllegalStateException("Element " + String.valueOf(e) + " has @" + CurrencyScale.class.getSimpleName() + " but its class doesn't implement " + String.valueOf(HasCurrency.class));
            }
            return this.CURRENCY;
        }
        throw new IllegalStateException("Element " + String.valueOf(e) + " has no scale annotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ResolverMetaData map(Class<?> clazz) {
        ResolverMetaData resolverMetaData = this.scaleResolverMapping.get(clazz);
        if (resolverMetaData == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (resolverMetaData == null) {
                    void var6_8;
                    ArrayList<Field> arrayList = new ArrayList<Field>();
                    for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                        for (Field field : clazz2.getDeclaredFields()) {
                            if (!field.getType().equals(BigDecimal.class) && !field.isAnnotationPresent(Embedded.class) || field.isAnnotationPresent(Transient.class)) continue;
                            field.setAccessible(true);
                            arrayList.add(field);
                        }
                    }
                    Object var6_7 = null;
                    ArrayList<Field> arrayList2 = null;
                    for (Field field : arrayList) {
                        if (field.isAnnotationPresent(Embedded.class) && !DecimalRange.class.isAssignableFrom(field.getType())) {
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<Field>();
                            }
                            arrayList2.add(field);
                            continue;
                        }
                        ScaleResolver scaleResolver = this.getScaleResolver(field);
                        if (var6_8 == null) {
                            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                        }
                        var6_8.put(field, scaleResolver);
                    }
                    resolverMetaData = new ResolverMetaData((Map<Field, ScaleResolver>)var6_8, arrayList2);
                    this.scaleResolverMapping.put(clazz, resolverMetaData);
                }
            }
        }
        return resolverMetaData;
    }

    private void process(Object object) {
        Object object2;
        if (object == null) {
            return;
        }
        ResolverMetaData resolverMetaData = this.map(object.getClass());
        for (Map.Entry<Field, ScaleResolver> object3 : resolverMetaData.resolversByField.entrySet()) {
            object2 = object3.getKey();
            ScaleResolver scaleResolver = object3.getValue();
            if (scaleResolver == null) continue;
            try {
                BigDecimal bigDecimal;
                Object object4 = ((Field)object2).get(object);
                if (object4 == null) continue;
                int n = scaleResolver.resolveScale(object);
                if (object4 instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)object4;
                    if (bigDecimal.scale() == n) continue;
                    bigDecimal = BigDecimalHelper.round((BigDecimal)bigDecimal, (int)n);
                    ((Field)object2).set(object, bigDecimal);
                    continue;
                }
                if (object4 instanceof DecimalRange) {
                    bigDecimal = (DecimalRange)object4;
                    bigDecimal.setMin(BigDecimalHelper.round((BigDecimal)bigDecimal.getMin(), (int)n));
                    bigDecimal.setMax(BigDecimalHelper.round((BigDecimal)bigDecimal.getMax(), (int)n));
                    continue;
                }
                throw new IllegalStateException("A BigDecimal scale annotation was found in field " + String.valueOf(object2) + ", but it should be either a BigDecimal or a DecimalRange, and was: " + String.valueOf(object4));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
            }
        }
        for (Field field : resolverMetaData.embeddables) {
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                continue;
            }
            this.process(object2);
        }
    }

    private class CurrencyScaleResolver
    implements ScaleResolver {
        private CurrencyScaleResolver() {
        }

        @Override
        public int resolveScale(Object object) {
            Currency currency = null;
            try {
                currency = ((HasCurrency)object).getCurrency();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return currency == null ? BigDecimalHelper.MAX_SCALE : currency.getPrecision();
        }
    }

    private class FixedScaleResolver
    implements ScaleResolver {
        private final int scale;

        private FixedScaleResolver(int n) {
            this.scale = n;
        }

        @Override
        public int resolveScale(Object object) {
            return this.scale;
        }
    }

    private class ResolverMetaData {
        private Map<Field, ScaleResolver> resolversByField;
        private Map<String, ScaleResolver> resolversByName;
        private List<Field> embeddables;

        private ResolverMetaData(Map<Field, ScaleResolver> map, List<Field> list) {
            this.resolversByField = map == null ? Collections.emptyMap() : map;
            this.resolversByName = this.resolversByField.isEmpty() ? Collections.emptyMap() : new HashMap();
            for (Map.Entry<Field, ScaleResolver> entry : this.resolversByField.entrySet()) {
                this.resolversByName.put(entry.getKey().getName(), entry.getValue());
            }
            this.embeddables = list == null ? Collections.emptyList() : list;
        }
    }

    private static interface ScaleResolver {
        public int resolveScale(Object var1);
    }
}

