/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.HasOrder;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.QConfigurationEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.contentmanagement.DataTranslationEntityMapping;
import org.cyclos.impl.contentmanagement.DataTranslationMapping;
import org.cyclos.impl.contentmanagement.DataTranslationPropertyMapping;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.EntityLogHandler;
import org.cyclos.impl.system.EntityLogRegistry;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.ConfigurationEntityDTO;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.DataAccessException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityData;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.NamedEntityDTO;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.contentmanagement.HasContentData;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.IEntityLogType;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.MethodHelper;
import org.cyclos.services.CRUDWithConfirmationPasswordService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class CRUDServiceImpl<E extends SimpleEntity, A extends EntityPath<E>, DTO extends EntityDTO, D extends EntityData<DTO>, DP>
extends BaseServiceImpl
implements CRUDServiceLocal<E, DTO, D, DP>,
CRUDWithConfirmationPasswordService<DTO, D, DP> {
    public static final String ATTR_CURRENT_COPY = "currentCopy";
    private static String VALIDATION_KEY = "CRUDServiceImplValidation";
    protected final A $;
    protected final boolean withConfirmationPassword;
    @Autowired
    protected ExtensionPointServiceLocal extensionPointService;
    @Autowired
    protected PasswordHandler passwordHandler;
    @Autowired
    protected CacheHandler cacheHandler;
    @Autowired
    protected RichTextHandler richTextHandler;
    @Autowired
    private EntityLogServiceLocal entityLogService;
    @Autowired
    private EntityLogRegistry entityLogRegistry;
    private ConcurrentMap<Class<? extends E>, EntityMetadata> subClassMetadataMapping = new ConcurrentHashMap<Class<? extends E>, EntityMetadata>();
    protected EntityMetadata entityMetadata;
    @Autowired
    @Lazy
    protected CustomScriptServiceLocal customScriptService;

    private static boolean withConfirmationPassword(Class<?> clazz) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (!ArrayUtils.contains((Object[])clazz2.getInterfaces(), CRUDWithConfirmationPasswordService.class) && !CRUDServiceImpl.withConfirmationPassword(clazz2)) continue;
            return true;
        }
        return false;
    }

    public CRUDServiceImpl(Class<E> clazz, A a, Class<DTO> clazz2) {
        this.$ = a;
        this.withConfirmationPassword = CRUDServiceImpl.withConfirmationPassword(this.getClass());
        this.entityMetadata = this.createEntityMetadata(clazz, clazz2);
    }

    public final E find(Long l) throws EntityNotFoundException {
        return (E)((SimpleEntity)this.find(this.getEntityClass(), l));
    }

    public final <T extends E> Set<T> findAll(Iterable<Long> iterable) throws EntityNotFoundException {
        if (iterable == null) {
            return null;
        }
        HashSet<E> hashSet = new HashSet<E>();
        for (Long l : iterable) {
            hashSet.add(this.find(l));
        }
        return hashSet;
    }

    public final CredentialInputDTO getConfirmationPasswordInputForRemove(Long l) throws FrameworkException {
        E e = this.find(l);
        return this.getConfirmationPasswordInput(e, CRUDOperation.DELETE);
    }

    public final D getData(Long l) throws FrameworkException {
        DataTranslationType dataTranslationType;
        CredentialInputDTO credentialInputDTO;
        E e = this.find(l);
        D d = this.getData(e);
        this.fillHasContentData(e, d);
        if (d.getConfirmationPasswordInput() == null) {
            credentialInputDTO = this.getConfirmationPasswordInput(e, CRUDOperation.UPDATE);
            d.setConfirmationPasswordInput((ICredentialInputDTO)credentialInputDTO);
        }
        if (e instanceof BaseEntity && (dataTranslationType = (credentialInputDTO = (BaseEntity)e).getDataTranslationType()) != null) {
            DataTranslationEntityMapping dataTranslationEntityMapping = DataTranslationMapping.get(dataTranslationType);
            d.setTranslatedPropertyTypes(dataTranslationEntityMapping.getPropertyTypes());
            Language language = this.getConfiguration().getLanguage();
            Map<String, String> map = dataTranslationEntityMapping.getProperties().stream().map(arg_0 -> this.lambda$getData$0(language, (BaseEntity)credentialInputDTO, arg_0)).filter(pair -> pair.getSecond() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            d.setTranslatedValues(map);
        }
        d.setLogType((IEntityLogType)((credentialInputDTO = this.entityLogRegistry.getHandler(e.getClass())) == null ? null : credentialInputDTO.getType()));
        return d;
    }

    public final D getDataForNew(DP DP) throws FrameworkException {
        E e = this.newEntity(DP);
        if (e instanceof DefinesNetwork) {
            ((DefinesNetwork)e).setNetwork(this.getSessionData().getNetwork());
        }
        D d = this.getData(e);
        this.fillHasContentData(e, d);
        CredentialInputDTO credentialInputDTO = this.getConfirmationPasswordInput(e, CRUDOperation.CREATE);
        d.setConfirmationPasswordInput((ICredentialInputDTO)credentialInputDTO);
        EntityLogHandler entityLogHandler = this.entityLogRegistry.getHandler(e.getClass());
        d.setLogType((IEntityLogType)(entityLogHandler == null ? null : entityLogHandler.getType()));
        return d;
    }

    public Class<E> getEntityClass() {
        return this.entityMetadata.entityClass;
    }

    public final DTO load(Long l) throws EntityNotFoundException {
        return this.toDTO(this.find(l));
    }

    public abstract E newEntity(DP var1);

    public final void remove(E e) {
        this.remove(e, true);
    }

    public final void remove(Long l) throws EntityNotFoundException, DataAccessException, ValidationException {
        this.removeWithConfirmationPassword(l, null);
    }

    public final void removeAll(Collection<Long> collection) throws EntityNotFoundException, DataAccessException, ValidationException {
        this.removeAllWithConfirmationPassword(collection, null);
    }

    public final void removeAll(Iterable<E> iterable) {
        if (CollectionHelper.isEmpty(iterable)) {
            return;
        }
        try {
            for (SimpleEntity simpleEntity : iterable) {
                this.remove(simpleEntity, false);
            }
            this.entityManagerHandler.flush();
        }
        catch (Exception exception) {
            throw new ConstraintViolatedOnRemoveException();
        }
    }

    public void removeAllWithConfirmationPassword(Collection<Long> collection, String string) throws FrameworkException {
        for (SimpleEntity simpleEntity : this.findAll(collection)) {
            this.checkConfirmationPassword(null, simpleEntity, CRUDOperation.DELETE, string);
            this.remove(simpleEntity);
        }
    }

    public void removeWithConfirmationPassword(Long l, String string) throws FrameworkException {
        this.removeAllWithConfirmationPassword(Collections.singleton(l), string);
    }

    public final Long save(DTO DTO) throws FrameworkException {
        return this.doSave(DTO, null, false);
    }

    public void saveOrder(List<Long> list) {
        int n = 0;
        Network network = this.getSessionData().getNetwork();
        for (Long l : list) {
            Network network2;
            E e = this.find(l);
            if (e instanceof NetworkedEntity && !Objects.equals(network, network2 = ((NetworkedEntity)e).getNetwork()) || !(e instanceof HasOrder)) continue;
            ((HasOrder)e).setOrder(Integer.valueOf(n++));
        }
    }

    public Long saveSkippingEntityLog(DTO DTO) {
        return this.doSave(DTO, null, true);
    }

    public Long saveWithConfirmationPassword(DTO DTO, String string) throws FrameworkException {
        return this.doSave(DTO, string, false);
    }

    public DTO toDTO(E e) {
        if (e == null) {
            return null;
        }
        Class<DTO> clazz = this.resolveDTOType(e);
        Object[] objectArray = this.getExcludedPropertiesToDTO(e);
        if (CollectionHelper.isEmpty((Object[])objectArray)) {
            return (DTO)((EntityDTO)this.conversionHandler.convert(clazz, e));
        }
        return (DTO)((EntityDTO)this.conversionHandler.convertExcluding(clazz, e, objectArray));
    }

    public E toEntity(DTO DTO) {
        if (DTO == null) {
            return null;
        }
        Class<E> clazz = this.resolveEntityType(DTO);
        Object[] objectArray = this.getExcludedPropertiesToEntity(DTO);
        SimpleEntity simpleEntity = CollectionHelper.isEmpty((Object[])objectArray) ? (SimpleEntity)this.conversionHandler.convert(clazz, DTO) : (SimpleEntity)this.conversionHandler.convertExcluding(clazz, DTO, objectArray);
        if (simpleEntity.isTransient() && simpleEntity instanceof DefinesNetwork) {
            ((DefinesNetwork)simpleEntity).setNetwork(this.getSessionData().getNetwork());
        }
        return (E)simpleEntity;
    }

    public final void validate(DTO DTO) throws ValidationException {
        if (this.validationHandler.isAlreadyValidated(DTO, VALIDATION_KEY)) {
            return;
        }
        Validator validator = this.resolveValidator(DTO);
        this.addNameValidations(validator, DTO);
        this.addInternalNameValidations(validator, DTO);
        if (validator != null) {
            this.validate(validator, DTO, VALIDATION_KEY);
        }
    }

    protected void addCustomInternalNameValidations(Property property, DTO DTO) {
    }

    protected void addCustomNameValidations(Property property, DTO DTO) {
    }

    protected void addParametersToHasContentData(E e, HasContentData hasContentData) {
        hasContentData.setParameters(this.profileFieldHandler.getUserVariables());
    }

    protected final void checkConfirmationPassword(DTO DTO, E e, CRUDOperation cRUDOperation, String string) {
        if (this.shouldCheckConfirmationPassword(e, cRUDOperation)) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(string, this.getDeviceConfirmationParams(DTO, e, cRUDOperation));
        }
    }

    protected void doRemove(E e, boolean bl) {
        this.entityManagerHandler.remove(e, bl);
    }

    protected EntityMetadata ensureEntityMetadata(Class<? extends E> clazz) {
        if (this.subClassMappings() == null) {
            return this.entityMetadata;
        }
        return this.ensureEntityMetadata(clazz, this.resolveDTOType(clazz));
    }

    protected EntityMetadata ensureEntityMetadata(DTO DTO) {
        if (this.subClassMappings() == null) {
            return this.entityMetadata;
        }
        return this.ensureEntityMetadata(this.resolveEntityType(DTO), DTO.getClass());
    }

    protected EntityMetadata ensureEntityMetadata(E e) {
        if (this.subClassMappings() == null) {
            return this.entityMetadata;
        }
        return this.ensureEntityMetadata(e.getClass(), this.resolveDTOType(e));
    }

    protected DBQuery<?> from() {
        return this.from(new EntityPath[]{this.$});
    }

    protected boolean generateLogOnRemove() {
        return true;
    }

    protected final CredentialInputDTO getConfirmationPasswordInput(E e, CRUDOperation cRUDOperation) {
        if (this.shouldCheckConfirmationPassword(e, cRUDOperation)) {
            return this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput();
        }
        return null;
    }

    protected abstract D getData(E var1);

    protected CreateDeviceConfirmationParams getDeviceConfirmationParams(DTO DTO, E e, CRUDOperation cRUDOperation) {
        return null;
    }

    protected MessageKey getEntityInternalNameKey(DTO DTO) {
        return GeneralKeys.Ui.INTERNAL_NAME;
    }

    protected Object[] getExcludedPropertiesToDTO(E e) {
        return null;
    }

    protected Object[] getExcludedPropertiesToEntity(DTO DTO) {
        return null;
    }

    protected EntityMetadata getMetadataForInternalNameValidations(DTO DTO) {
        return this.entityMetadata;
    }

    protected EntityMetadata getMetadataForNameValidations(DTO DTO) {
        return this.entityMetadata;
    }

    protected String getNameLabel(DTO DTO) {
        return this.message(GeneralKeys.Ui.NAME, new Object[0]);
    }

    protected Pair<DBQuery<?>, String> getUniqueInternalNameQuery(DTO DTO) {
        EntityMetadata entityMetadata = this.getMetadataForInternalNameValidations(DTO);
        return this.getUniqueQuery(DTO, entityMetadata, entityMetadata.internalNamePath, ((IInternalNamedEntity)DTO).getInternalName());
    }

    protected Pair<DBQuery<?>, String> getUniqueNameQuery(DTO DTO) {
        EntityMetadata entityMetadata = this.getMetadataForNameValidations(DTO);
        return this.getUniqueQuery(DTO, entityMetadata, entityMetadata.namePath, ((INamedEntity)DTO).getName());
    }

    protected boolean isEntityInternalNameRequired(DTO DTO) {
        return false;
    }

    protected boolean isNameRequired(DTO DTO) {
        return true;
    }

    protected void logEntity(E e, E e2) {
        SimpleEntity simpleEntity = (SimpleEntity)ObjectHelper.defaultValue(e2, e);
        EntityMetadata entityMetadata = this.ensureEntityMetadata((E)simpleEntity);
        this.entityLogService.logEntity(e, e2, () -> entityMetadata.ownerEntityPropertyName);
    }

    protected void onAfterRemove(E e) {
    }

    protected void onAfterSave(E e, E e2, Object object) {
    }

    protected void onBeforeRemove(E e) {
    }

    protected Object onBeforeSave(E e, E e2) {
        return null;
    }

    protected void preProcessCurrentCopy(DTO DTO, E e) {
    }

    protected Class<? extends DTO> resolveDTOType(E e) {
        Class<?> clazz = e.getClass();
        return this.resolveDTOType(clazz);
    }

    protected Class<? extends E> resolveEntityType(DTO DTO) {
        Class<?> clazz = DTO.getClass();
        Class<E> clazz2 = this.getEntityClass();
        BidiMap<Class<E>, Class<DTO>> bidiMap = this.subClassMappings();
        if (bidiMap != null) {
            Class<?> clazz3;
            Class clazz4 = null;
            while (clazz != null && (clazz4 = (Class)bidiMap.getKey(clazz)) == null && EntityDTO.class.isAssignableFrom(clazz3 = clazz.getSuperclass())) {
                clazz = clazz3;
            }
            if (clazz4 != null) {
                clazz2 = clazz4;
            }
        }
        return clazz2;
    }

    protected ExtensionPointAccessor resolveExtensionPointAccessor(CRUDOperation cRUDOperation, E e) {
        return null;
    }

    protected abstract Validator resolveValidator(DTO var1);

    protected boolean shouldCheckConfirmationPassword(E e, CRUDOperation cRUDOperation) {
        return this.withConfirmationPassword;
    }

    protected BidiMap<Class<? extends E>, Class<? extends DTO>> subClassMappings() {
        return null;
    }

    private final void addInternalNameValidations(Validator validator, DTO DTO) {
        EntityMetadata entityMetadata = this.getMetadataForInternalNameValidations(DTO);
        if (entityMetadata != null && entityMetadata.internalNamePath != null) {
            if (validator == null) {
                throw new IllegalStateException(String.format("Can't resolve to a null validator for internal named DTO: %s (%s). If you don't have any validations to be checked you must define an empty validator.", entityMetadata.entityClass.getName(), ConfigurationEntityDTO.INTERNAL_NAME.getName()));
            }
            StringPath stringPath = QConfigurationEntity.configurationEntity.internalName;
            if (validator.hasValidationFor((Path)stringPath)) {
                throw new IllegalArgumentException(String.format("Invalid validator configuration. All %s.%s validations must be added in the addCustomInternalNameValidations(...) method instead of in the resolveValidator()", entityMetadata.dtoClass.getName(), ConfigurationEntityDTO.INTERNAL_NAME.getName()));
            }
            Property property = validator.property((Path)stringPath, this.getEntityInternalNameKey(DTO));
            property.internalName(this.isEntityInternalNameRequired(DTO));
            this.addCustomInternalNameValidations(property, DTO);
            Pair<DBQuery<?>, String> pair = null;
            String string = StringHelper.trimToNull((Object)((IInternalNamedEntity)DTO).getInternalName());
            if (string != null && (pair = this.getUniqueInternalNameQuery(DTO)) != null) {
                String string2 = entityMetadata.entityClass.getSimpleName() + "_internalName_" + (String)(StringHelper.isBlank((Object)pair.getSecond()) ? "" : (String)pair.getSecond() + "_") + SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork());
                property.unique(string2 + "_" + string, (AbstractJPAQuery)pair.getFirst());
            }
        }
    }

    private final void addNameValidations(Validator validator, DTO DTO) {
        EntityMetadata entityMetadata = this.getMetadataForNameValidations(DTO);
        if (entityMetadata != null && entityMetadata.namePath != null) {
            if (validator == null) {
                throw new IllegalStateException(String.format("Can't resolve to a null validator for named DTO: %s (%s). If you don't have any validations to be checked you must define an empty validator.", entityMetadata.entityClass.getName(), NamedEntityDTO.NAME.getName()));
            }
            if (validator.hasValidationFor(NamedEntityDTO.NAME)) {
                throw new IllegalArgumentException(String.format("Invalid validator configuration. All %s.%s validations must be added in the addCustomNameValidations(...) method instead of in the resolveValidator()", entityMetadata.dtoClass.getName(), NamedEntityDTO.NAME.getName()));
            }
            Property property = validator.property(NamedEntityDTO.NAME, this.getNameLabel(DTO));
            property.name();
            if (this.isNameRequired(DTO)) {
                property.required();
            }
            this.addCustomNameValidations(property, DTO);
            Pair<DBQuery<?>, String> pair = null;
            String string = StringHelper.trimToNull((Object)((INamedEntity)DTO).getName());
            if (string != null && (pair = this.getUniqueNameQuery(DTO)) != null) {
                String string2 = entityMetadata.entityClass.getSimpleName() + "_name_" + (String)(StringHelper.isBlank((Object)pair.getSecond()) ? "" : (String)pair.getSecond() + "_") + SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork());
                property.unique(string2 + "_" + string, (AbstractJPAQuery)pair.getFirst());
            }
        }
    }

    private <S extends E> EntityMetadata createEntityMetadata(Class<S> clazz, Class<? extends DTO> clazz2) {
        EntityPathBase entityPathBase;
        Object object;
        EntityMetadata entityMetadata = new EntityMetadata();
        entityMetadata.entityClass = clazz;
        entityMetadata.dtoClass = clazz2;
        String string = clazz.getPackageName() + ".Q" + clazz.getSimpleName();
        try {
            Class<?> clazz3 = Class.forName(string);
            object = clazz.getSimpleName().substring(0, 1).toLowerCase() + clazz.getSimpleName().substring(1);
            entityPathBase = (EntityPathBase)clazz3.getDeclaredConstructor(String.class).newInstance(object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.format("Can't create a new instance of class %s", string), exception);
        }
        entityMetadata.entityPath = entityPathBase;
        entityMetadata.idPath = (NumberPath)FieldHelper.get((Object)entityPathBase, (String)EntityModel.ID.getName());
        object = FieldHelper.getAnnotatedField(clazz, OwnerEntity.class);
        entityMetadata.ownerEntityPropertyName = object == null ? null : ((Field)object).getName();
        Pair pair = this.getOwnerEntityAndIdPaths((EntityPath<? extends E>)entityPathBase, entityMetadata.ownerEntityPropertyName);
        entityMetadata.ownerEntityPath = (EntityPathBase)pair.getFirst();
        entityMetadata.ownerEntityIdPath = (NumberPath)pair.getSecond();
        entityMetadata.namePath = this.getPath(INamedEntity.class, (Class<? extends E>)clazz, (EntityPath<? extends E>)entityPathBase, clazz2, NamedEntityDTO.NAME.getName());
        entityMetadata.internalNamePath = this.getPath(IInternalNamedEntity.class, (Class<? extends E>)clazz, (EntityPath<? extends E>)entityPathBase, clazz2, ConfigurationEntityDTO.INTERNAL_NAME.getName());
        return entityMetadata;
    }

    private Long doSave(DTO DTO, String string, boolean bl) {
        ExtensionPointAccessor extensionPointAccessor;
        Object object;
        E e;
        this.validate(DTO);
        E e2 = null;
        Long l = DTO.getId();
        if (l == null) {
            e = this.toEntity(DTO);
            this.checkConfirmationPassword(DTO, e, CRUDOperation.CREATE, string);
            object = this.onBeforeSave(e, null);
            extensionPointAccessor = this.resolveExtensionPointAccessor(CRUDOperation.CREATE, e);
            if (extensionPointAccessor != null) {
                extensionPointAccessor.fireValidated();
            }
            try {
                this.persist((IEntity)e);
            }
            catch (Exception exception) {
                throw new UnexpectedDataAccessException((Throwable)exception);
            }
        } else {
            BaseEntity baseEntity;
            e2 = this.find(DTO.getId());
            if (e2 instanceof BaseEntity) {
                baseEntity = (BaseEntity)e2;
                if (!Objects.equals(DTO.getVersion(), baseEntity.getVersion())) {
                    throw new StaleEntityException();
                }
            }
            this.checkConfirmationPassword(DTO, e2, CRUDOperation.UPDATE, string);
            this.preProcessCurrentCopy(DTO, e2);
            baseEntity = this.entityManagerHandler;
            baseEntity.flush();
            baseEntity.clear();
            e = this.toEntity(DTO);
            object = this.onBeforeSave(e, e2);
            extensionPointAccessor = this.resolveExtensionPointAccessor(CRUDOperation.UPDATE, e);
            if (extensionPointAccessor != null) {
                extensionPointAccessor.attribute(ATTR_CURRENT_COPY, e2).fireValidated();
            }
            this.flush();
        }
        this.onAfterSave(e, e2, object);
        if (!bl) {
            this.logEntity(e2, e);
        }
        if (extensionPointAccessor != null) {
            extensionPointAccessor.fireSaved();
        }
        return e.getId();
    }

    private EntityMetadata ensureEntityMetadata(Class<? extends E> clazz, Class<? extends DTO> clazz2) {
        return this.subClassMetadataMapping.computeIfAbsent(clazz, clazz3 -> this.createEntityMetadata(clazz, clazz2));
    }

    private void fillHasContentData(E e, D d) {
        if (d instanceof HasContentData) {
            HasContentData hasContentData = (HasContentData)d;
            this.addParametersToHasContentData(e, hasContentData);
            hasContentData.setContentScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.CONTENT_HELPER)));
        }
    }

    private <EP extends EntityPath<?>> Pair<EP, NumberPath<Long>> getOwnerEntityAndIdPaths(EntityPath<? extends E> entityPath, String string) {
        if (string == null) {
            return Pair.create(null, null);
        }
        EntityPath entityPath2 = (EntityPath)MethodHelper.invoke(entityPath, (String)string, (Object[])new Object[0]);
        NumberPath numberPath = (NumberPath)FieldHelper.get((Object)entityPath2, (String)EntityModel.ID.getName());
        return Pair.create((Object)entityPath2, (Object)numberPath);
    }

    private StringPath getPath(Class<?> clazz, Class<? extends E> clazz2, EntityPath<? extends E> entityPath, Class<? extends DTO> clazz3, String string) {
        if (clazz.isAssignableFrom(clazz2)) {
            if (!clazz.isAssignableFrom(clazz3)) {
                throw new IllegalArgumentException(String.format("Invalid dto class: %s. It must implement %s like the corresponding entity (%s)", clazz3, clazz, clazz2));
            }
            return (StringPath)FieldHelper.get(entityPath, (String)string);
        }
        return null;
    }

    private Pair<DBQuery<?>, String> getUniqueQuery(DTO DTO, EntityMetadata entityMetadata, StringPath stringPath, String string) {
        DBQuery<?> dBQuery;
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        booleanBuilder.and((Predicate)stringPath.equalsIgnoreCase(string));
        IEntity iEntity = null;
        if (entityMetadata.ownerEntityIdPath != null) {
            dBQuery = (DBQuery<?>)DTO.propertyMap().get(entityMetadata.ownerEntityPropertyName);
            EntityModel entityModel = (EntityModel)DTO.get((org.cyclos.model.Property)dBQuery);
            iEntity = (IEntity)this.conversionHandler.convert(entityMetadata.ownerEntityPath.getType(), (Object)entityModel);
            if (iEntity == null) {
                booleanBuilder.and((Predicate)entityMetadata.ownerEntityPath.isNull());
            } else {
                booleanBuilder.and((Predicate)entityMetadata.ownerEntityIdPath.eq((Object)iEntity.getId()));
            }
        }
        if (DTO.isPersistent()) {
            booleanBuilder.and((Predicate)entityMetadata.idPath.ne((Object)DTO.getId()));
        }
        dBQuery = this.from(entityMetadata.entityPath);
        dBQuery.where((Predicate)booleanBuilder);
        return Pair.create(dBQuery, iEntity == null ? null : iEntity.getId().toString());
    }

    private void remove(E e, boolean bl) {
        if (this.entityLogRegistry.isLogEnabled(e)) {
            this.preProcessCurrentCopy(null, e);
        }
        this.onBeforeRemove(e);
        ExtensionPointAccessor extensionPointAccessor = this.resolveExtensionPointAccessor(CRUDOperation.DELETE, e);
        if (extensionPointAccessor != null) {
            extensionPointAccessor.fireValidated();
        }
        this.doRemove(e, bl);
        this.onAfterRemove(e);
        if (this.generateLogOnRemove()) {
            this.logEntity(e, null);
        }
        if (extensionPointAccessor != null) {
            extensionPointAccessor.fireSaved();
        }
    }

    private Class<? extends DTO> resolveDTOType(Class<? extends E> clazz) {
        Class<?> clazz2 = this.entityMetadata.dtoClass;
        BidiMap<Class<E>, Class<DTO>> bidiMap = this.subClassMappings();
        if (bidiMap != null) {
            Class<E> clazz3;
            Class clazz4 = null;
            while (clazz != null && (clazz4 = (Class)bidiMap.get(clazz)) == null && SimpleEntity.class.isAssignableFrom(clazz3 = clazz.getSuperclass())) {
                clazz = clazz3;
            }
            if (clazz4 != null) {
                clazz2 = clazz4;
            }
        }
        return clazz2;
    }

    private /* synthetic */ Pair lambda$getData$0(Language language, BaseEntity baseEntity, DataTranslationPropertyMapping dataTranslationPropertyMapping) {
        String string = this.dataTranslationHandler.getValue(language, baseEntity, dataTranslationPropertyMapping.getName(), false);
        return Pair.create((Object)dataTranslationPropertyMapping.getName(), (Object)string);
    }

    public static class EntityMetadata {
        private Class<?> entityClass;
        private Class<?> dtoClass;
        private EntityPath<?> entityPath;
        private NumberPath<Long> idPath;
        private StringPath namePath;
        private StringPath internalNamePath;
        private NumberPath<Long> ownerEntityIdPath;
        private EntityPathBase<?> ownerEntityPath;
        private String ownerEntityPropertyName;

        public Class<?> getDtoClass() {
            return this.dtoClass;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public EntityPath<?> getEntityPath() {
            return this.entityPath;
        }

        public NumberPath<Long> getIdPath() {
            return this.idPath;
        }

        public StringPath getInternalNamePath() {
            return this.internalNamePath;
        }

        public StringPath getNamePath() {
            return this.namePath;
        }

        public NumberPath<Long> getOwnerEntityIdPath() {
            return this.ownerEntityIdPath;
        }

        public EntityPathBase<?> getOwnerEntityPath() {
            return this.ownerEntityPath;
        }

        public String getOwnerEntityPropertyName() {
            return this.ownerEntityPropertyName;
        }
    }
}

