/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class CyclosThreadFactory
implements ThreadFactory {
    private int priority;
    private ThreadGroup group;
    private AtomicLong number;

    private CyclosThreadFactory(CyclosThreadGroup cyclosThreadGroup) {
        this.group = new ThreadGroup("cy." + cyclosThreadGroup.name().toLowerCase());
        this.priority = cyclosThreadGroup.priority;
        this.number = new AtomicLong();
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.group.getName() + "-" + this.number.incrementAndGet());
        thread.setPriority(this.priority);
        return thread;
    }

    public static enum CyclosThreadGroup {
        EXECUTOR,
        RECURRING_TASK,
        BACKGROUND_TASK,
        LOG(1);

        private static Map<CyclosThreadGroup, CyclosThreadFactory> CACHE;
        private final int priority;

        public static CyclosThreadFactory of(CyclosThreadGroup cyclosThreadGroup2) {
            return CACHE.computeIfAbsent(cyclosThreadGroup2, cyclosThreadGroup -> new CyclosThreadFactory((CyclosThreadGroup)((Object)cyclosThreadGroup)));
        }

        private CyclosThreadGroup() {
            this(5);
        }

        private CyclosThreadGroup(int n2) {
            this.priority = n2;
        }

        public CyclosThreadFactory factory() {
            return CyclosThreadGroup.of(this);
        }

        static {
            CACHE = new ConcurrentHashMap<CyclosThreadGroup, CyclosThreadFactory>();
        }
    }
}

