/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.AccessClientLog;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.access.QAccessClient;
import org.cyclos.entities.access.QAccessClientLog;
import org.cyclos.entities.access.QAccessClientPrincipalType;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.QProductMyAccessClient;
import org.cyclos.entities.users.QProductUserAccessClient;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.access.AccessClientServiceLocal;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.ActionWithConfirmationPassword;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidAccessClientException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.UnauthorizedAddressException;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.clients.AccessClientAction;
import org.cyclos.model.access.clients.AccessClientActionConfirmationField;
import org.cyclos.model.access.clients.AccessClientActionParams;
import org.cyclos.model.access.clients.AccessClientDTO;
import org.cyclos.model.access.clients.AccessClientData;
import org.cyclos.model.access.clients.AccessClientDataParams;
import org.cyclos.model.access.clients.AccessClientDetailedVO;
import org.cyclos.model.access.clients.AccessClientLocatorVO;
import org.cyclos.model.access.clients.AccessClientLogVO;
import org.cyclos.model.access.clients.AccessClientQuery;
import org.cyclos.model.access.clients.AccessClientStatus;
import org.cyclos.model.access.clients.AccessClientTypeData;
import org.cyclos.model.access.clients.AccessClientVO;
import org.cyclos.model.access.clients.AccessClientsActivationData;
import org.cyclos.model.access.clients.AccessClientsListData;
import org.cyclos.model.access.clients.AccessClientsSearchData;
import org.cyclos.model.access.clients.ActivateAccessClientDTO;
import org.cyclos.model.access.clients.CreateAccessClientParams;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.access.passwords.SendOtpParams;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.server.utils.UserAgentHandler;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessClientServiceImpl
extends CRUDServiceImpl<AccessClient, QAccessClient, AccessClientDTO, AccessClientData, AccessClientDataParams>
implements AccessClientServiceLocal {
    private static final int MAX_TOKEN_PREFIX_LENGTH = 150;
    private static final int MAX_ATTEMPTS_TO_ACTIVATE_ACCESS_CLIENT = 10;
    @Autowired
    private UserAgentHandler userAgentHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private InternetAddressListHandler internetAddressListHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeServiceLocal;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private OtpHandler otpHandler;

    public AccessClientServiceImpl() {
        super(AccessClient.class, QAccessClient.accessClient, AccessClientDTO.class);
    }

    public ActivateAccessClientDTO activate(String string, String string2) throws FrameworkException {
        return this.doActivate(string2, () -> {
            SessionData sessionData = this.getSessionData();
            User user = sessionData.getLoggedUser();
            AccessClient accessClient = (AccessClient)((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)user), ((QAccessClient)this.$).activationCode.eq((Object)string)})).requiredUniqueResult((Expression)this.$);
            if (accessClient.getStatus() != AccessClientStatus.UNASSIGNED) {
                throw new IllegalActionException();
            }
            this.ensureIpAddressIsWhitelisted(sessionData.getRemoteAddress(), accessClient);
            return accessClient;
        });
    }

    public void block(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        AccessClient accessClient = this.checkPasswordAndGet(AccessClientAction.BLOCK, accessClientActionParams);
        if (accessClient.getStatus() != AccessClientStatus.ACTIVE) {
            throw new IllegalActionException();
        }
        accessClient.setStatus(AccessClientStatus.BLOCKED);
        this.generateLog(accessClient);
    }

    public boolean canActivateAccessClient(AccessClientPrincipalType accessClientPrincipalType, User user) {
        boolean bl = ((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)user), ((QAccessClient)this.$).type().eq((Object)accessClientPrincipalType), ((QAccessClient)this.$).status.eq((Object)AccessClientStatus.UNASSIGNED)})).hasResults();
        if (bl) {
            return true;
        }
        try {
            this.ensureMaxClients(accessClientPrincipalType, user);
            return true;
        }
        catch (MaxItemsException maxItemsException) {
            return false;
        }
    }

    public ActivateAccessClientDTO createAndActivate(CreateAccessClientParams createAccessClientParams) {
        return this.doActivate(createAccessClientParams.getPrefix(), () -> {
            AccessClient accessClient;
            AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)createAccessClientParams.getType());
            SessionData sessionData = this.getSessionData();
            User user = sessionData.getLoggedUser();
            try {
                this.otpHandler.verify(OtpType.ACCESS_CLIENT_ACTIVATION, (OtpOwner)user, createAccessClientParams.getCode());
            }
            catch (ValidationException validationException) {
                this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_ACCESS_CLIENT_ACTIVATION, this.getLoggedBasicUser(), Integer.valueOf(10), UserAlertType.MAX_ACCESS_CLIENT_ACTIVATION_ATTEMPTS_REACHED);
                throw validationException;
            }
            this.ensureMaxClients(accessClientPrincipalType, user);
            String string = StringHelper.trimToNull((Object)createAccessClientParams.getName());
            if (string == null) {
                accessClient = this.userAgentHandler.parse(sessionData.getRequestData().getRequestInfo());
                string = accessClient.getDevice();
            }
            accessClient = this.newEntity(user, accessClientPrincipalType);
            accessClient.setName(this.getUniqueClientName(user, string));
            this.persist((IEntity)accessClient);
            return accessClient;
        });
    }

    public AccessClient findByToken(Network network, String string) throws FrameworkException {
        RequestContext.addSensitiveQueryParamValue((Object)string);
        return (AccessClient)((DBQuery)this.from().where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).token.eq((Object)string), network == null ? ((QAccessClient)this.$).user().network().isNull() : ((QAccessClient)this.$).user().network().eq((Object)network)})).singleResult((Expression)this.$);
    }

    public AccessClient findForAccess(Network network, String string, String string2) throws FrameworkException {
        AccessClient accessClient = null;
        if (string2 != null) {
            RequestContext.addSensitiveQueryParamValue((Object)string2);
            accessClient = (AccessClient)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).token.eq((Object)string2), network == null ? ((QAccessClient)this.$).user().network().isNull() : ((QAccessClient)this.$).user().network().eq((Object)network), ((QAccessClient)this.$).user().status.eq((Object)UserStatus.ACTIVE)})).singleResult((Expression)this.$);
            if (accessClient != null && !this.isEnabled(accessClient.getUser(), accessClient.getType())) {
                accessClient = null;
            }
        }
        if (accessClient == null) {
            TimeInterval timeInterval;
            UserLocatorVO userLocatorVO = new UserLocatorVO((Property)UserLocatorVO.PRINCIPAL, (Object)string2);
            ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
            Integer n = configurationAccessor.getInvalidUsernameAttempts();
            boolean bl = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_PRINCIPAL, string, userLocatorVO, n, timeInterval = configurationAccessor.getRemoteAddressBlockTime());
            if (bl) {
                throw new RemoteAddressBlockedException();
            }
            throw new InvalidAccessClientException();
        }
        if (AccessClientStatus.ACTIVE != accessClient.getStatus()) {
            throw new InvalidAccessClientException((AccessClientVO)this.conversionHandler.convert(AccessClientVO.class, accessClient));
        }
        this.ensureIpAddressIsWhitelisted(string, accessClient);
        return accessClient;
    }

    public AccessClient findForActivation(User user, String string) throws FrameworkException {
        if (user == null || StringHelper.isBlank((Object)string)) {
            throw new EntityNotFoundException(AccessClient.class);
        }
        return (AccessClient)((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)user), ((QAccessClient)this.$).status.eq((Object)AccessClientStatus.UNASSIGNED), ((QAccessClient)this.$).activationCode.eq((Object)string)})).requiredUniqueResult((Expression)this.$);
    }

    public String getActivationCode(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        AccessClient accessClient = this.checkPasswordAndGet(AccessClientAction.GET_ACTIVATION_CODE, accessClientActionParams);
        if (accessClient.getStatus() != AccessClientStatus.UNASSIGNED) {
            throw new IllegalActionException();
        }
        if (StringHelper.isBlank((Object)accessClient.getActivationCode())) {
            String string = null;
            while (string == null || this.activationCodeExists(accessClient, string)) {
                string = StringHelper.randomNumeric((int)4);
            }
            accessClient.setActivationCode(string);
        }
        return accessClient.getActivationCode();
    }

    public AccessClientsActivationData getActivationData(ChannelVO channelVO) throws FrameworkException {
        AccessClientsActivationData accessClientsActivationData = new AccessClientsActivationData();
        accessClientsActivationData.setAccessClientsTypeData(this.doGetTypeData(this.getLoggedUser(), channelVO));
        accessClientsActivationData.setSendOtpData(CollectionHelper.isEmpty((Iterable)accessClientsActivationData.getAccessClientsTypeData()) ? null : this.otpHandler.getSendOtpData());
        return accessClientsActivationData;
    }

    public AccessClientsListData getListData(PrincipalTypeVO principalTypeVO, UserLocatorVO userLocatorVO) throws FrameworkException {
        AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)principalTypeVO);
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        AccessClientsListData accessClientsListData = new AccessClientsListData();
        accessClientsListData.setType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)accessClientPrincipalType));
        accessClientsListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        accessClientsListData.setInformationMessage(this.getTranslatedValue((BaseEntity)accessClientPrincipalType, QAccessClientPrincipalType.accessClientPrincipalType.informationMessage));
        AccessClientQuery accessClientQuery = new AccessClientQuery();
        accessClientQuery.setType(accessClientsListData.getType());
        accessClientQuery.setUser(accessClientsListData.getUser());
        accessClientQuery.setUnlimited();
        accessClientsListData.setAccessClients(this.doSearch(AccessClientVO.class, accessClientQuery).getPageItems());
        this.setCanCreateNew((AccessClientTypeData)accessClientsListData, accessClientPrincipalType, user);
        accessClientsListData.setCanManage(true);
        accessClientsListData.setHasUnassigned(accessClientsListData.getAccessClients().stream().filter(accessClientVO -> accessClientVO.getStatus() == AccessClientStatus.UNASSIGNED).findFirst().isPresent());
        return accessClientsListData;
    }

    public AccessClientsSearchData getSearchData() throws FrameworkException {
        UserManagementProductAccessor userManagementProductAccessor = this.getSessionData().getProducts().userManagement();
        QProductUserAccessClient qProductUserAccessClient = QProductUserAccessClient.productUserAccessClient;
        List list = CollectionHelper.sort((Collection)userManagementProductAccessor.getUserAccessClients().keysSet((Path)qProductUserAccessClient.view));
        List list2 = CollectionHelper.sort((Collection)userManagementProductAccessor.getUserAccessClients().keysSet((Path)qProductUserAccessClient.manage));
        AccessClientsSearchData accessClientsSearchData = new AccessClientsSearchData();
        accessClientsSearchData.setVisibleTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)list));
        accessClientsSearchData.setManagedTypes(this.conversionHandler.convertList(PrincipalTypeVO.class, (Iterable)list2));
        AccessClientQuery accessClientQuery = (AccessClientQuery)QueryHelper.newQuery(AccessClientQuery.class);
        if (accessClientsSearchData.getVisibleTypes().size() == 1) {
            accessClientQuery.setType((PrincipalTypeVO)CollectionHelper.first((Iterable)accessClientsSearchData.getVisibleTypes()));
        }
        accessClientsSearchData.setQuery((QueryParameters)accessClientQuery);
        return accessClientsSearchData;
    }

    public List<AccessClientTypeData> getTypeData(UserLocatorVO userLocatorVO, ChannelVO channelVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        return this.doGetTypeData(user, channelVO);
    }

    public boolean isVisible(AccessClient accessClient) throws FrameworkException {
        User user = accessClient.getUser();
        if (!this.getSessionData().manages((BasicUser)user)) {
            return false;
        }
        List list = this.principalTypeServiceLocal.listVisibleAccessClients(user);
        return list.contains(accessClient.getType());
    }

    public List<AccessClient> listVisible(User user, AccessClientStatus ... accessClientStatusArray) throws FrameworkException {
        List list = this.principalTypeServiceLocal.listVisibleAccessClients(user);
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return Collections.emptyList();
        }
        return ((DBQuery)((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)user), ((QAccessClient)this.$).type().in((Collection)list), CollectionHelper.isNotEmpty((Object[])accessClientStatusArray) ? ((QAccessClient)this.$).status.in((Object[])accessClientStatusArray) : ((QAccessClient)this.$).id.isNotNull()})).orderBy(new OrderSpecifier[]{((QAccessClient)this.$).type().name.asc(), ((QAccessClient)this.$).name.asc()})).list((Expression)this.$);
    }

    public AccessClientVO locate(AccessClientLocatorVO accessClientLocatorVO) throws FrameworkException {
        return (AccessClientVO)this.conversionHandler.convert(AccessClientVO.class, (Object)this.locateAccessClient(accessClientLocatorVO));
    }

    public AccessClient locateAccessClient(AccessClientLocatorVO accessClientLocatorVO) throws FrameworkException {
        AccessClient accessClient = null;
        if (accessClientLocatorVO != null && (accessClient = (AccessClient)accessClientLocatorVO.getAttribute("accessClient")) == null) {
            if (accessClientLocatorVO.getId() != null) {
                accessClient = (AccessClient)this.find(accessClientLocatorVO.getId());
            } else if ("self".equals(accessClientLocatorVO.getToken())) {
                accessClient = this.getSessionData().getAccessClient();
            } else if (StringHelper.isNotBlank((Object)accessClientLocatorVO.getToken())) {
                RequestContext.addSensitiveQueryParamValue((Object)accessClientLocatorVO.getToken());
                accessClient = (AccessClient)((DBQuery)this.from().where((com.querydsl.core.types.Predicate)((QAccessClient)this.$).token.eq((Object)accessClientLocatorVO.getToken()))).requiredUniqueResult((Expression)this.$);
                this.entityManagerHandler.checkAccess((IEntity)accessClient);
            }
        }
        if (accessClient == null) {
            throw new EntityNotFoundException(AccessClient.class);
        }
        accessClientLocatorVO.setAttribute("accessClient", (Object)accessClient);
        return accessClient;
    }

    @Override
    public AccessClient newEntity(AccessClientDataParams accessClientDataParams) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)accessClientDataParams.getUser());
        AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)accessClientDataParams.getType());
        return this.newEntity(user, accessClientPrincipalType);
    }

    public void removeAll(User user) {
        try (CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)user), ((QAccessClient)this.$).status.ne((Object)AccessClientStatus.REMOVED)})).iterate((Expression)this.$);){
            closeableIterator.forEachRemaining(accessClient -> this.doRemove((AccessClient)accessClient, false));
        }
    }

    public OtpResult requestActivationCode(@NotNull SendOtpParams sendOtpParams) throws FrameworkException {
        MobilePhone mobilePhone = null;
        if (sendOtpParams.getMedium() == SendMedium.SMS) {
            if (sendOtpParams.getMobilePhone() == null) {
                throw new ValidationException(this.message(GeneralKeys.Errors.REQUIRED, UsersKeys.Phones.TYPE_MOBILE));
            }
            mobilePhone = (MobilePhone)this.conversionHandler.convert(MobilePhone.class, (Object)sendOtpParams.getMobilePhone());
            if (mobilePhone == null) {
                throw new EntityNotFoundException(MobilePhone.class);
            }
        }
        return (OtpResult)this.conversionHandler.convert(OtpResult.class, (Object)this.otpHandler.sendForAccessClientActivation(this.getLoggedUser(), mobilePhone));
    }

    public Page<AccessClientDetailedVO> search(AccessClientQuery accessClientQuery) throws FrameworkException {
        return this.doSearch(AccessClientDetailedVO.class, accessClientQuery);
    }

    @Override
    public AccessClient toEntity(AccessClientDTO accessClientDTO) {
        AccessClient accessClient = (AccessClient)super.toEntity(accessClientDTO);
        String string = accessClientDTO.isUseIpWhitelist() ? accessClientDTO.getIpWhitelist() : null;
        this.internetAddressListHandler.setInternetAddressList((SimpleEntity)accessClient, (Path)((QAccessClient)this.$).whitelist(), string);
        return accessClient;
    }

    public void unassign(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        AccessClient accessClient = this.checkPasswordAndGet(AccessClientAction.UNASSIGN, accessClientActionParams);
        this.doUnassign(accessClient);
    }

    public boolean unassignCurrent(ActionWithConfirmationPassword actionWithConfirmationPassword) throws FrameworkException {
        AccessClient accessClient = this.getSessionData().getAccessClient();
        if (accessClient != null) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(actionWithConfirmationPassword == null ? null : actionWithConfirmationPassword.getConfirmationPassword(), AccessClientActionConfirmationField.confirmation((AccessClientLocatorVO)new AccessClientLocatorVO(accessClient.getId()), (AccessClientAction)AccessClientAction.UNASSIGN));
            this.doUnassign(accessClient);
            if (this.getSessionData().getSession() != null) {
                this.sessionHandler.invalidate(this.getSessionData().getRemoteAddress(), this.getSessionData().getSession().getSessionToken());
            }
            return true;
        }
        return false;
    }

    public void unblock(AccessClientActionParams accessClientActionParams) throws FrameworkException {
        AccessClient accessClient = this.checkPasswordAndGet(AccessClientAction.UNBLOCK, accessClientActionParams);
        if (accessClient.getStatus() != AccessClientStatus.BLOCKED) {
            throw new IllegalActionException();
        }
        accessClient.setStatus(AccessClientStatus.ACTIVE);
        this.generateLog(accessClient);
    }

    @Override
    protected void doRemove(AccessClient accessClient, boolean bl) {
        if (((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).eq((Object)accessClient), ((QAccessClient)this.$).transactions.isEmpty()})).hasResults()) {
            super.doRemove(accessClient, bl);
        } else {
            accessClient.setStatus(AccessClientStatus.REMOVED);
            accessClient.setAccessClientToken(null);
            accessClient.setActivationCode(null);
            this.generateLog(accessClient);
            if (bl) {
                this.flush();
            }
        }
    }

    protected <VO> Page<VO> doSearch(Class<VO> clazz, AccessClientQuery accessClientQuery) {
        User user;
        DBQuery<?> dBQuery = this.from(this.$);
        AccessClientPrincipalType accessClientPrincipalType = (AccessClientPrincipalType)this.conversionHandler.convert(AccessClientPrincipalType.class, (Object)accessClientQuery.getType());
        if (accessClientPrincipalType != null) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QAccessClient)this.$).type().eq((Object)accessClientPrincipalType));
        }
        if ((user = (User)this.conversionHandler.convert(User.class, (Object)accessClientQuery.getUser())) != null) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QAccessClient)this.$).user().eq((Object)user));
        } else {
            SessionData sessionData = this.getSessionData();
            if (sessionData.isAdmin()) {
                Set set = this.groupsHandler.accessibles().groups().items();
                dBQuery.where((com.querydsl.core.types.Predicate)((QAccessClient)this.$).user().group().in((Collection)set));
            } else if (sessionData.isBroker()) {
                dBQuery.where((com.querydsl.core.types.Predicate)((QAccessClient)this.$).user().brokers.contains((Object)sessionData.getLoggedUser()));
            } else if (!sessionData.isSystem()) {
                dBQuery.where((com.querydsl.core.types.Predicate)((QAccessClient)this.$).user().eq((Object)sessionData.getLoggedUser()));
            }
        }
        if (QueryHelper.useParameter((Object)accessClientQuery.getStatus())) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QAccessClient)this.$).status.in((Collection)accessClientQuery.getStatus()));
        }
        dBQuery.orderBy(((QAccessClient)this.$).name.asc());
        return dBQuery.page(clazz, (QueryParameters)accessClientQuery, (Expression)this.$);
    }

    @Override
    protected AccessClientData getData(AccessClient accessClient) {
        AccessClientData accessClientData = new AccessClientData();
        AccessClientPrincipalType accessClientPrincipalType = accessClient.getType();
        accessClientData.setDto((EntityDTO)((AccessClientDTO)this.toDTO(accessClient)));
        accessClientData.setAllowIpWhitelist(accessClient.getType().isAllowIpWhitelist());
        if (accessClient.isPersistent()) {
            AccessClientStatus accessClientStatus = accessClient.getStatus();
            List<AccessClientLog> list = this.getLogs(accessClient);
            accessClientData.setLogs(this.conversionHandler.convertList(AccessClientLogVO.class, list));
            accessClientData.setCanBlock(accessClientStatus == AccessClientStatus.ACTIVE);
            accessClientData.setCanUnblock(accessClientStatus == AccessClientStatus.BLOCKED);
            accessClientData.setCanGetActivationCode(accessClientPrincipalType.isAllowManualCreation() && accessClientStatus == AccessClientStatus.UNASSIGNED);
            accessClientData.setCanUnassign(accessClientPrincipalType.isAllowManualCreation() && (accessClientStatus == AccessClientStatus.ACTIVE || accessClientStatus == AccessClientStatus.BLOCKED));
            accessClientData.setConfirmationPasswordInput((ICredentialInputDTO)this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        }
        return accessClientData;
    }

    @Override
    protected void onAfterSave(AccessClient accessClient, AccessClient accessClient2, Object object) {
        if (accessClient2 == null) {
            this.generateLog(accessClient);
        }
    }

    @Override
    protected Object onBeforeSave(AccessClient accessClient, AccessClient accessClient2) {
        if (accessClient2 == null) {
            this.ensureMaxClients(accessClient.getType(), accessClient.getUser());
            accessClient.setStatus(AccessClientStatus.UNASSIGNED);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QAccessClient.accessClient.user().network());
    }

    @Override
    protected Validator resolveValidator(AccessClientDTO accessClientDTO) {
        Validator validator = new Validator();
        validator.property((Property)AccessClientDTO.TYPE, AccessKeys.Clients.TYPE).required();
        validator.property((Property)AccessClientDTO.IP_WHITELIST, AccessKeys.Clients.IP_WHITELIST).internetAddressList();
        return validator;
    }

    private boolean activationCodeExists(AccessClient accessClient, String string) {
        return ((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)accessClient.getUser()), ((QAccessClient)this.$).activationCode.eq((Object)string)})).hasResults();
    }

    private AccessClient checkPasswordAndGet(AccessClientAction accessClientAction, AccessClientActionParams accessClientActionParams) {
        AccessClient accessClient = this.locateAccessClient(accessClientActionParams.getAccessClient());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(accessClientActionParams.getConfirmationPassword(), AccessClientActionConfirmationField.confirmation((AccessClientLocatorVO)new AccessClientLocatorVO(accessClient.getId()), (AccessClientAction)accessClientAction));
        return accessClient;
    }

    private ActivateAccessClientDTO doActivate(AccessClient accessClient, String string) {
        Pair<String, String> pair = this.generateToken(string);
        String string2 = (String)pair.getFirst();
        String string3 = (String)pair.getSecond();
        accessClient.setAccessClientToken(string3);
        accessClient.setActivationDate(new Date());
        accessClient.setActivationCode(null);
        accessClient.setStatus(AccessClientStatus.ACTIVE);
        this.generateLog(accessClient);
        ActivateAccessClientDTO activateAccessClientDTO = new ActivateAccessClientDTO();
        activateAccessClientDTO.setToken(string2);
        activateAccessClientDTO.setType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)accessClient.getType()));
        activateAccessClientDTO.setAccessClient((AccessClientVO)this.conversionHandler.convert(AccessClientVO.class, (Object)accessClient));
        return activateAccessClientDTO;
    }

    private ActivateAccessClientDTO doActivate(String string, Supplier<AccessClient> supplier) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        if (user == null) {
            throw new EntityNotFoundException();
        }
        this.validatePrefix(string);
        AccessClient accessClient = supplier.get();
        return this.doActivate(accessClient, string);
    }

    private List<AccessClientTypeData> doGetTypeData(User user, ChannelVO channelVO) throws FrameworkException {
        Object object;
        if (user == null) {
            throw new ValidationException();
        }
        Channel channel = (Channel)this.conversionHandler.convert(Channel.class, (Object)channelVO);
        SessionData sessionData = this.getSessionData();
        QProductMyAccessClient qProductMyAccessClient = QProductMyAccessClient.productMyAccessClient;
        Set set = this.productsHandler.getAccessor((BasicUser)user).member().getMyAccessClients().keysSet((Path)qProductMyAccessClient.enable);
        if (!set.isEmpty()) {
            if (user.equals((Object)sessionData.getLoggedUser())) {
                object = sessionData.getProducts().product().getMyAccessClients().keysSet((Path)qProductMyAccessClient.view);
            } else {
                BooleanPropertiesHolder booleanPropertiesHolder = sessionData.getProducts().userManagement().getUserAccessClients();
                object = booleanPropertiesHolder.keysSet((Path)qProductMyAccessClient.view);
            }
            set.retainAll((Collection<?>)object);
        }
        if (channel != null) {
            object = sessionData.getConfiguration().getChannelConfiguration(channel);
            if (object == null || !object.isEnabled()) {
                set.clear();
            } else {
                set.removeIf(arg_0 -> AccessClientServiceImpl.lambda$doGetTypeData$4((ChannelConfiguration)object, arg_0));
            }
        }
        return CollectionHelper.sort((Collection)set).stream().map(accessClientPrincipalType -> this.toAccessClientTypeData((AccessClientPrincipalType)accessClientPrincipalType, user)).collect(Collectors.toList());
    }

    private void doUnassign(AccessClient accessClient) {
        if (accessClient.getStatus() != AccessClientStatus.ACTIVE && accessClient.getStatus() != AccessClientStatus.BLOCKED) {
            throw new IllegalActionException();
        }
        accessClient.setStatus(AccessClientStatus.UNASSIGNED);
        accessClient.setActivationDate(null);
        accessClient.setActivationCode(null);
        accessClient.setAccessClientToken(null);
        this.generateLog(accessClient);
    }

    private void ensureIpAddressIsWhitelisted(String string, AccessClient accessClient) {
        if (accessClient.getType().isAllowIpWhitelist() && !this.internetAddressListHandler.isWhitelisted(accessClient.getWhitelist(), string)) {
            throw new UnauthorizedAddressException();
        }
    }

    private void ensureMaxClients(AccessClientPrincipalType accessClientPrincipalType, User user) {
        long l;
        int n = accessClientPrincipalType.getMaximumPerUser();
        if (n > 0 && (l = (long)((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)user), ((QAccessClient)this.$).type().eq((Object)accessClientPrincipalType), ((QAccessClient)this.$).status.ne((Object)AccessClientStatus.REMOVED)})).count(((QAccessClient)this.$).id)) >= (long)n) {
            throw new MaxItemsException(n);
        }
    }

    private AccessClientLog generateLog(AccessClient accessClient) {
        AccessClientLog accessClientLog = new AccessClientLog();
        accessClientLog.setAccessClient(accessClient);
        accessClientLog.setBy(this.getLoggedBasicUser());
        accessClientLog.setDate(new Date());
        accessClientLog.setStatus(accessClient.getStatus());
        this.persist((IEntity)accessClientLog);
        accessClient.getLogs().add(0, accessClientLog);
        return accessClientLog;
    }

    private Pair<String, String> generateToken(String string) {
        String string2 = SecureRandomHelper.randomAlphanumeric((int)64);
        Object object = string2;
        if (string != null) {
            object = string + string2;
        }
        return Pair.create((Object)string2, (Object)object);
    }

    private List<AccessClientLog> getLogs(AccessClient accessClient) {
        QAccessClientLog qAccessClientLog = QAccessClientLog.accessClientLog;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qAccessClientLog}).where((com.querydsl.core.types.Predicate)qAccessClientLog.accessClient().eq((Object)accessClient))).orderBy(qAccessClientLog.date.desc())).list((Expression)qAccessClientLog);
    }

    private String getUniqueClientName(User user, String object) {
        Predicate<String> predicate = string -> ((DBQuery)this.from(this.$).where(new com.querydsl.core.types.Predicate[]{((QAccessClient)this.$).user().eq((Object)user), ((QAccessClient)this.$).name.eq(string)})).hasResults();
        int n = 1;
        while (predicate.test((String)object)) {
            int n2 = ((String)object).lastIndexOf("_");
            if (n2 != -1) {
                object = ((String)object).substring(0, n2 + 1) + n++;
                continue;
            }
            object = (String)object + "_" + n++;
        }
        return object;
    }

    private boolean isEnabled(User user, AccessClientPrincipalType accessClientPrincipalType) {
        return user == null ? false : this.productsHandler.getAccessor((BasicUser)user).product().getMyAccessClients().isSet((Object)accessClientPrincipalType, (Path)QProductMyAccessClient.productMyAccessClient.enable);
    }

    private AccessClient newEntity(User user, AccessClientPrincipalType accessClientPrincipalType) {
        AccessClient accessClient = new AccessClient();
        accessClient.setUser(user);
        accessClient.setType(accessClientPrincipalType);
        accessClient.setStatus(AccessClientStatus.UNASSIGNED);
        return accessClient;
    }

    private void setCanCreateNew(AccessClientTypeData accessClientTypeData, AccessClientPrincipalType accessClientPrincipalType, User user) {
        try {
            this.ensureMaxClients(accessClientPrincipalType, user);
            accessClientTypeData.setCanCreateNew(accessClientPrincipalType.isAllowManualCreation());
            accessClientTypeData.setCanActivateNew(true);
        }
        catch (MaxItemsException maxItemsException) {
            // empty catch block
        }
    }

    private AccessClientTypeData toAccessClientTypeData(AccessClientPrincipalType accessClientPrincipalType, User user) {
        AccessClientTypeData accessClientTypeData = new AccessClientTypeData();
        accessClientTypeData.setType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)accessClientPrincipalType));
        AccessClientQuery accessClientQuery = new AccessClientQuery();
        accessClientQuery.setType(accessClientTypeData.getType());
        accessClientQuery.setUser(new UserVO(user.getId()));
        accessClientQuery.setStatus(Collections.singleton(AccessClientStatus.UNASSIGNED));
        accessClientQuery.setCountOnly();
        boolean bl = CollectionHelper.getTotalCount(this.doSearch(AccessClientVO.class, accessClientQuery)) > 0;
        accessClientTypeData.setHasUnassigned(bl);
        this.setCanCreateNew(accessClientTypeData, accessClientPrincipalType, user);
        accessClientTypeData.setCanManage(true);
        return accessClientTypeData;
    }

    private void validatePrefix(String string) {
        if (string != null && string.length() > 150) {
            throw new ValidationException(this.message(GeneralKeys.Errors.MAX_LENGTH, "prefix", 150));
        }
    }

    private static /* synthetic */ boolean lambda$doGetTypeData$4(ChannelConfiguration channelConfiguration, AccessClientPrincipalType accessClientPrincipalType) {
        return !channelConfiguration.getPrincipalTypes().contains(accessClientPrincipalType);
    }
}

