/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.AgreementContent;
import org.cyclos.entities.access.AgreementLog;
import org.cyclos.entities.access.QAgreementContent;
import org.cyclos.entities.access.QAgreementLog;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.agreementlogs.AgreementLogVO;
import org.cyclos.model.access.agreements.AcceptedAgreementVO;
import org.cyclos.model.access.agreements.AgreementVO;
import org.cyclos.model.access.agreements.UserAgreementsData;
import org.cyclos.model.access.agreements.UserOptionalAgreementsDTO;
import org.cyclos.model.system.extensionpoints.AgreementExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgreementLogServiceImpl
extends BaseServiceImpl
implements AgreementLogServiceLocal {
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;

    public AgreementLog accept(Agreement agreement, User user) {
        return this.doAccept(agreement, user, false);
    }

    public void acceptPending(Set<AgreementVO> set) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        List<Agreement> list = this.getUserPendingAgreements(user);
        if (list.isEmpty()) {
            return;
        }
        Validator validator = new Validator();
        this.appendValidations(validator, list, set);
        PublicRegistrationDTO publicRegistrationDTO = new PublicRegistrationDTO();
        publicRegistrationDTO.setAgreements(set);
        this.validate(validator, publicRegistrationDTO, "acceptPending");
        for (AgreementVO agreementVO : set) {
            Agreement agreement = (Agreement)this.conversionHandler.convert(Agreement.class, (Object)agreementVO);
            if (!list.contains(agreement)) continue;
            this.doAccept(agreement, user, true);
        }
    }

    public void appendValidations(Validator validator, List<Agreement> list, Collection<AgreementVO> collection) {
        Set set = this.conversionHandler.convertSet(Agreement.class, collection);
        HashSet<Agreement> hashSet = new HashSet<Agreement>(list);
        hashSet.removeIf(agreement -> !agreement.isRequired());
        hashSet.removeAll(set);
        if (!hashSet.isEmpty()) {
            validator.property((Property)PublicRegistrationDTO.AGREEMENTS, UsersKeys.Users.PUBLIC_REGISTRATION_AGREEMENT).add((object, object2, object3) -> {
                if (hashSet.isEmpty()) {
                    return null;
                }
                return new ValidationError(AccessKeys.Agreements.ERROR_MISSING, new Object[]{this.getFormatter().format((Collection)CollectionHelper.sort((Collection)hashSet))});
            });
        }
    }

    public UserAgreementsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        Agreement agreement2;
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        List list = this.productsHandler.getAccessor((BasicUser)user).product().getAgreements();
        List<AgreementLog> list2 = this.getLog(user, null);
        HashMap hashMap = new HashMap();
        for (Agreement agreement2 : user.getAcceptedAgreements()) {
            list2.stream().filter(agreementLog -> agreement2.equals((Object)agreementLog.getAgreement())).findFirst().ifPresent(agreementLog -> {
                if (agreementLog.isAccepted()) {
                    hashMap.put(agreement2, agreementLog);
                }
            });
        }
        Set set = list.stream().filter(Agreement::isRequired).collect(Collectors.toSet());
        set.removeAll(hashMap.keySet());
        agreement2 = new UserAgreementsData();
        agreement2.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        agreement2.setAgreements(this.conversionHandler.convertList(AgreementVO.class, (Iterable)list));
        agreement2.setAccepted(hashMap.values().stream().map(this::toAcceptedAgreementVO).collect(Collectors.toSet()));
        agreement2.setPending(this.conversionHandler.convertSet(AgreementVO.class, (Iterable)set));
        agreement2.setLog(this.conversionHandler.convertList(AgreementLogVO.class, list2));
        return agreement2;
    }

    public List<Agreement> getUserPendingAgreements(User user) {
        List list = this.productsHandler.getAccessor((BasicUser)user).product().getAgreements();
        list.removeIf(agreement -> !agreement.isRequired() || this.isAgreementAccepted((Agreement)agreement, user));
        return list;
    }

    public boolean hasPendingAgreements(User user) {
        return this.hasPendingAgreements(user, this.productsHandler.getAccessor((BasicUser)user));
    }

    public boolean hasPendingAgreements(User user, ProductsAccessor productsAccessor) {
        return productsAccessor.product().getAgreements().stream().filter(Agreement::isRequired).filter(agreement -> !this.isAgreementAccepted((Agreement)agreement, user)).findAny().isPresent();
    }

    public boolean isAgreementAccepted(Agreement agreement, User user) {
        String string = user.getAcceptedAgreementIds();
        if (StringHelper.isBlank((Object)string)) {
            return false;
        }
        return ("," + string + ",").contains("," + String.valueOf(agreement.getId()) + ",");
    }

    public boolean isAnyAgreementAccepted(User user) {
        QAgreementLog qAgreementLog = QAgreementLog.agreementLog;
        return ((DBQuery)this.from(new EntityPath[]{qAgreementLog}).where((Predicate)qAgreementLog.user().eq((Object)user))).hasResults();
    }

    public AgreementLogVO load(Long l) throws EntityNotFoundException {
        return (AgreementLogVO)this.conversionHandler.convert(AgreementLogVO.class, (Object)this.find(AgreementLog.class, l));
    }

    public void saveOptional(@NotNull UserOptionalAgreementsDTO userOptionalAgreementsDTO) throws FrameworkException {
        ExtensionPointAccessor extensionPointAccessor;
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        List list = this.productsHandler.getAccessor((BasicUser)user).product().getAgreements().stream().filter(agreement -> !agreement.isRequired()).collect(Collectors.toList());
        Set set = CollectionHelper.orEmpty((Set)user.getAcceptedAgreements());
        Set set2 = this.conversionHandler.convertSet(Agreement.class, (Iterable)userOptionalAgreementsDTO.getAgreements());
        set2.retainAll(list);
        HashSet<Agreement> hashSet = new HashSet<Agreement>(set);
        ArrayList<ExtensionPointAccessor> arrayList = new ArrayList<ExtensionPointAccessor>();
        for (Agreement agreement2 : set) {
            if (agreement2.isRequired() || set2.contains(agreement2)) continue;
            extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)AgreementExtensionPointEvent.REJECT, new ExtensionPointFilter(user.getGroup(), agreement2)).attribute("agreement", (Object)agreement2).attribute("user", (Object)user);
            extensionPointAccessor.fireValidated();
            arrayList.add(extensionPointAccessor);
            hashSet.remove(agreement2);
            this.createLog(agreement2, user, false);
        }
        for (Agreement agreement2 : set2) {
            if (agreement2.isRequired() || set.contains(agreement2)) continue;
            extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)AgreementExtensionPointEvent.ACCEPT, new ExtensionPointFilter(user.getGroup(), agreement2)).attribute("agreement", (Object)agreement2).attribute("user", (Object)user);
            extensionPointAccessor.fireValidated();
            arrayList.add(extensionPointAccessor);
            hashSet.add(agreement2);
            this.createLog(agreement2, user, true);
        }
        user.setAcceptedAgreements(hashSet);
        this.userSearchHandler.index((NetworkedEntity)user);
        arrayList.forEach(ExtensionPointAccessor::fireSaved);
    }

    public void triggerActivatedExtensionPoints(User user) {
        for (Agreement agreement : user.getAcceptedAgreements()) {
            ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)AgreementExtensionPointEvent.ACCEPT, new ExtensionPointFilter(user.getGroup(), agreement)).attribute("agreement", (Object)agreement).attribute("user", (Object)user);
            extensionPointAccessor.fireValidated();
            extensionPointAccessor.fireSaved();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QAgreementLog.agreementLog.agreementContent().agreement().network());
    }

    private AgreementLog createLog(Agreement agreement, User user, boolean bl) {
        AgreementLog agreementLog = new AgreementLog();
        agreementLog.setDate(DateHelper.now());
        agreementLog.setAgreementContent(this.currentContent(agreement));
        user.addAgreementLog(agreementLog);
        agreementLog.setAccepted(bl);
        agreementLog.setBy(this.getLoggedBasicUser());
        agreementLog.setRemoteAddress(this.getRemoteAddress());
        this.persist((IEntity)agreementLog);
        return agreementLog;
    }

    private AgreementContent currentContent(Agreement agreement) {
        QAgreementContent qAgreementContent = QAgreementContent.agreementContent;
        Supplier<AgreementContent> supplier = () -> (AgreementContent)((DBQuery)((DBQuery)this.from(new EntityPath[]{qAgreementContent}).where(new Predicate[]{qAgreementContent.agreement().eq((Object)agreement), qAgreementContent.content.eq((Object)agreement.getContent())})).orderBy(qAgreementContent.agreementVersion.desc())).singleResult((Expression)qAgreementContent);
        AgreementContent agreementContent = supplier.get();
        if (agreementContent == null) {
            this.lockHandler.lock(LockType.AGREEMENT.key(agreement.getId()));
            agreementContent = supplier.get();
            if (agreementContent == null) {
                Integer n = (Integer)((DBQuery)this.from(new EntityPath[]{qAgreementContent}).where((Predicate)qAgreementContent.agreement().eq((Object)agreement))).singleResult((Expression)qAgreementContent.agreementVersion.max());
                agreementContent = new AgreementContent();
                agreementContent.setContent(agreement.getContent());
                agreementContent.setAgreement(agreement);
                agreementContent.setAgreementVersion(Integer.valueOf((n != null ? n : 0) + 1));
                this.persist((IEntity)agreementContent);
            }
        }
        return agreementContent;
    }

    private AgreementLog doAccept(Agreement agreement, User user, boolean bl) {
        if (!this.productsHandler.getAccessor((BasicUser)user).product().getAgreements().contains(agreement)) {
            throw new IllegalActionException("Agreement " + String.valueOf(agreement) + " isn't enabled for " + String.valueOf(user));
        }
        ExtensionPointAccessor extensionPointAccessor = null;
        if (bl) {
            extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)AgreementExtensionPointEvent.ACCEPT, new ExtensionPointFilter(user.getGroup(), agreement)).attribute("agreement", (Object)agreement).attribute("user", (Object)user);
            extensionPointAccessor.fireValidated();
        }
        HashSet<Agreement> hashSet = new HashSet<Agreement>(CollectionHelper.orEmpty((Set)user.getAcceptedAgreements()));
        hashSet.add(agreement);
        user.setAcceptedAgreements(hashSet);
        this.userSearchHandler.index((NetworkedEntity)user);
        AgreementLog agreementLog = this.createLog(agreement, user, true);
        if (extensionPointAccessor != null) {
            extensionPointAccessor.fireSaved();
        }
        return agreementLog;
    }

    private List<AgreementLog> getLog(User user, Collection<Agreement> collection) {
        if (collection != null && collection.isEmpty()) {
            return Collections.emptyList();
        }
        QAgreementLog qAgreementLog = QAgreementLog.agreementLog;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qAgreementLog}).where((Predicate)qAgreementLog.user().eq((Object)user));
        if (collection != null) {
            dBQuery.where((Predicate)qAgreementLog.agreementContent().agreement().in(collection));
        }
        return ((DBQuery)dBQuery.orderBy(qAgreementLog.date.desc())).list((Expression)qAgreementLog);
    }

    private AcceptedAgreementVO toAcceptedAgreementVO(AgreementLog agreementLog) {
        AcceptedAgreementVO acceptedAgreementVO = new AcceptedAgreementVO();
        acceptedAgreementVO.setAgreement((AgreementVO)this.conversionHandler.convert(AgreementVO.class, (Object)agreementLog.getAgreement()));
        acceptedAgreementVO.setAcceptedVersion(agreementLog.getAgreementContent().getAgreementVersion().intValue());
        acceptedAgreementVO.setDate(this.conversionHandler.toDateTime(agreementLog.getDate()));
        return acceptedAgreementVO;
    }
}

