/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.QChannel;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QChannelConfiguration;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.ChannelsComparator;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.channels.ChannelDTO;
import org.cyclos.model.access.channels.ChannelData;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelServiceImpl
extends CRUDServiceImpl<Channel, QChannel, ChannelDTO, ChannelData, Void>
implements ChannelServiceLocal {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public ChannelServiceImpl() {
        super(Channel.class, QChannel.channel, ChannelDTO.class);
    }

    public Channel find(String string, Network network) throws FrameworkException {
        return (Channel)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where((Predicate)((QChannel)this.$).internalName.eq((Object)string).and((Predicate)(network == null ? ((QChannel)this.$).network().isNull() : ((QChannel)this.$).network().isNull().or((Predicate)((QChannel)this.$).network().eq((Object)network)))))).requiredUniqueResult((Expression)this.$);
    }

    public Channel getEasyInvoice() {
        return this.find(BuiltInChannel.EASY_INVOICE);
    }

    public Channel getMain() {
        return this.find(BuiltInChannel.MAIN);
    }

    public Channel getMobile() throws FrameworkException {
        return this.find(BuiltInChannel.MOBILE);
    }

    public ChannelVO getMobileVO() throws FrameworkException {
        return (ChannelVO)this.conversionHandler.convert(ChannelVO.class, (Object)this.getMobile());
    }

    public Channel getOidc() {
        return this.find(BuiltInChannel.OIDC);
    }

    public Channel getPos() {
        return this.find(BuiltInChannel.POS);
    }

    public Channel getSms() throws FrameworkException {
        return this.find(BuiltInChannel.SMS);
    }

    public Channel getTicket() {
        return this.find(BuiltInChannel.TICKET);
    }

    public Channel getWebServices() throws FrameworkException {
        return this.find(BuiltInChannel.WEB_SERVICES);
    }

    public List<ChannelVO> list() {
        return this.conversionHandler.convertList(ChannelVO.class, this.listAll());
    }

    public List<Channel> listAll() throws FrameworkException {
        ArrayList<Channel> arrayList = new ArrayList<Channel>(this.from().list((Expression)this.$));
        Collections.sort(arrayList, ChannelsComparator.getInstance());
        return arrayList;
    }

    public Channel load(String string) {
        SessionData sessionData = this.getSessionData();
        return this.find(string, sessionData.getNetwork());
    }

    @Override
    public Channel newEntity(Void void_) {
        return new Channel();
    }

    @Override
    protected void addCustomInternalNameValidations(Property property, ChannelDTO channelDTO) {
        Channel channel;
        Channel channel2 = channel = channelDTO.isPersistent() ? (Channel)this.find(channelDTO.getId()) : null;
        if (this.isBuiltIn(channel) && !channel.getInternalName().equals(channelDTO.getInternalName())) {
            property.invalid();
        }
    }

    @Override
    protected ChannelData getData(Channel channel) {
        ChannelData channelData = new ChannelData();
        channelData.setDto((EntityDTO)((ChannelDTO)this.toDTO(channel)));
        channelData.setBuiltIn(this.isBuiltIn(channel));
        return channelData;
    }

    @Override
    protected boolean isEntityInternalNameRequired(ChannelDTO channelDTO) {
        return true;
    }

    @Override
    protected void onAfterSave(Channel channel, Channel channel2, Object object) {
        if (channel2 == null) {
            Configuration configuration = this.configurationHandler.getDefault();
            ChannelConfiguration channelConfiguration = new ChannelConfiguration();
            channelConfiguration.setChannel(channel);
            channelConfiguration.setConfiguration(configuration);
            channelConfiguration.setDefined(true);
            channelConfiguration.setEnabled(false);
            this.persist((IEntity)channelConfiguration);
            configuration.getChannelConfigurations().add(channelConfiguration);
        }
    }

    @Override
    protected void onBeforeRemove(Channel channel) {
        QChannelConfiguration qChannelConfiguration = QChannelConfiguration.channelConfiguration;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qChannelConfiguration});
        List list = ((DBQuery)dBQuery.where((Predicate)qChannelConfiguration.channel().eq((Object)channel).and((Predicate)qChannelConfiguration.enabled.eq(Boolean.valueOf(true))))).list((Expression)qChannelConfiguration.configuration().name);
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            throw new ValidationException(new ValidationResult(this.message(AccessKeys.Channels.ERROR_CHANNEL_CANNOT_BE_REMOVED, StringUtils.join((Iterable)list, (String)", "))));
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QChannel)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(ChannelDTO channelDTO) {
        Channel channel;
        Validator validator = new Validator();
        if (channelDTO.isPersistent() && !(channel = (Channel)this.find(channelDTO.getId())).isCustom() && !channel.getInternalName().equals(channelDTO.getInternalName())) {
            validator.property(ChannelDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).invalid();
        }
        return validator;
    }

    private Channel find(BuiltInChannel builtInChannel) {
        return this.find(builtInChannel.getInternalName(), null);
    }

    private boolean isBuiltIn(Channel channel) {
        if (channel == null) {
            return false;
        }
        return BuiltInChannel.getByInternalName((String)channel.getInternalName()) != null;
    }
}

