/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.cyclos.entities.access.FailedAccessClientActivationLog;
import org.cyclos.entities.access.FailedActionLog;
import org.cyclos.entities.access.FailedBlockedUserLog;
import org.cyclos.entities.access.FailedDeviceActivationLog;
import org.cyclos.entities.access.FailedDeviceConfirmationLog;
import org.cyclos.entities.access.FailedDevicePinLog;
import org.cyclos.entities.access.FailedEmailVerificationAsGuestLog;
import org.cyclos.entities.access.FailedPasswordLog;
import org.cyclos.entities.access.FailedPhoneVerificationAsGuestLog;
import org.cyclos.entities.access.FailedPhoneVerificationLog;
import org.cyclos.entities.access.FailedPrincipalLog;
import org.cyclos.entities.access.FailedSecurityAnswerLog;
import org.cyclos.entities.access.FailedTokenActivationLog;
import org.cyclos.entities.access.FailedTotpActivationLog;
import org.cyclos.entities.access.FailedTotpLog;
import org.cyclos.entities.access.FailedUserLocationLog;
import org.cyclos.entities.access.FailedVoucherInfoLog;
import org.cyclos.entities.access.FailedVoucherPinLog;
import org.cyclos.entities.access.FailedVoucherRedeemingLog;
import org.cyclos.entities.access.ForgotPasswordRequestLog;
import org.cyclos.entities.access.GuestFailedActionLog;
import org.cyclos.entities.access.Password;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.QFailedActionLog;
import org.cyclos.entities.access.QFailedDevicePinLog;
import org.cyclos.entities.access.QFailedPasswordLog;
import org.cyclos.entities.access.QFailedVoucherPinLog;
import org.cyclos.entities.access.QGuestFailedActionLog;
import org.cyclos.entities.access.QUserFailedActionLog;
import org.cyclos.entities.access.UserFailedActionLog;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.system.IpAddress;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.system.IpAddressServiceLocal;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.system.ipaddresses.IpAddressStatus;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ChangeUserStatusParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.DateHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FailedActionHandlerImpl
extends BaseNetworkedHandlerImpl
implements FailedActionHandler {
    @Autowired
    private IpAddressServiceLocal ipAddressService;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private UserStatusServiceLocal userStatusService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    private Map<FailedAction, Class<? extends FailedActionLog>> mappings;

    public void clearGuestFailures(FailedAction failedAction, String string) {
        this.runInReadWriteOrSubmit(() -> {
            QGuestFailedActionLog qGuestFailedActionLog = QGuestFailedActionLog.guestFailedActionLog;
            Class<? extends FailedActionLog> clazz = this.mappings.get(failedAction);
            this.delete((EntityPath<?>)qGuestFailedActionLog).where(new Predicate[]{qGuestFailedActionLog.remoteAddress.eq((Object)string), qGuestFailedActionLog.instanceOf(clazz)}).execute();
        });
    }

    public void clearPasswordFailures(BasicUser basicUser, PasswordType passwordType, boolean bl) {
        this.runInReadWriteOrSubmit(() -> {
            QFailedPasswordLog qFailedPasswordLog = QFailedPasswordLog.failedPasswordLog;
            this.delete((EntityPath<?>)qFailedPasswordLog).where(new Predicate[]{qFailedPasswordLog.user().eq((Object)basicUser), qFailedPasswordLog.passwordType().eq((Object)passwordType), bl ? qFailedPasswordLog.forgot.isTrue() : qFailedPasswordLog.forgot.isNull().or((Predicate)qFailedPasswordLog.forgot.isFalse())}).execute();
        });
    }

    public void clearPinFailures(Pin pin) {
        this.runInReadWriteOrSubmit(() -> {
            QFailedDevicePinLog qFailedDevicePinLog = QFailedDevicePinLog.failedDevicePinLog;
            this.delete((EntityPath<?>)qFailedDevicePinLog).where(new Predicate[]{qFailedDevicePinLog.pin().eq((Object)pin)}).execute();
        });
    }

    public void clearUserFailures(FailedAction failedAction, BasicUser basicUser) {
        BasicUser basicUser2 = basicUser == null ? this.getLoggedBasicUser() : basicUser;
        this.runInReadWriteOrSubmit(() -> {
            QUserFailedActionLog qUserFailedActionLog = QUserFailedActionLog.userFailedActionLog;
            Class<? extends FailedActionLog> clazz = this.mappings.get(failedAction);
            this.delete((EntityPath<?>)qUserFailedActionLog).where(new Predicate[]{qUserFailedActionLog.user().eq((Object)basicUser2), qUserFailedActionLog.instanceOf(clazz)}).execute();
        });
    }

    public void clearVoucherPinFailures(Voucher voucher) {
        this.runInReadWriteOrSubmit(() -> {
            QFailedVoucherPinLog qFailedVoucherPinLog = QFailedVoucherPinLog.failedVoucherPinLog;
            this.delete((EntityPath<?>)qFailedVoucherPinLog).where(new Predicate[]{qFailedVoucherPinLog.voucher().eq((Object)voucher)}).execute();
        });
    }

    public int countGuestFailures(FailedAction failedAction, String string) {
        QFailedActionLog qFailedActionLog = QFailedActionLog.failedActionLog;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qFailedActionLog}).where(new Predicate[]{qFailedActionLog.remoteAddress.eq((Object)string), qFailedActionLog.instanceOf(this.mappings.get(failedAction))});
        Date date = DateHelper.subtract((Date)new Date(), (ITimeInterval)failedAction.countInterval());
        dBQuery.where((Predicate)qFailedActionLog.date.after((Comparable)date));
        return dBQuery.count(qFailedActionLog.id);
    }

    public int countPasswordFailures(BasicUser basicUser, PasswordType passwordType, boolean bl) {
        Date date = DateHelper.subtract((Date)DateHelper.now(), (ITimeInterval)TimeInterval.ONE_DAY);
        QFailedPasswordLog qFailedPasswordLog = QFailedPasswordLog.failedPasswordLog;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qFailedPasswordLog}).where(new Predicate[]{qFailedPasswordLog.user().eq((Object)basicUser), qFailedPasswordLog.passwordType().eq((Object)passwordType), bl ? qFailedPasswordLog.forgot.isTrue() : qFailedPasswordLog.forgot.isNull().or((Predicate)qFailedPasswordLog.forgot.isFalse())});
        if (QueryHelper.useParameter((Object)date)) {
            dBQuery.where((Predicate)qFailedPasswordLog.date.goe((Comparable)date));
        }
        return dBQuery.count(qFailedPasswordLog.id);
    }

    public int countPinFailures(Pin pin) {
        QFailedDevicePinLog qFailedDevicePinLog = QFailedDevicePinLog.failedDevicePinLog;
        Date date = DateHelper.subtract((Date)new Date(), (ITimeInterval)TimeInterval.ONE_DAY);
        return ((DBQuery)this.from(new EntityPath[]{qFailedDevicePinLog}).where(new Predicate[]{qFailedDevicePinLog.pin().eq((Object)pin), qFailedDevicePinLog.date.after((Comparable)date)})).count(qFailedDevicePinLog.id);
    }

    public int countUserFailures(FailedAction failedAction, BasicUser basicUser) {
        QUserFailedActionLog qUserFailedActionLog = QUserFailedActionLog.userFailedActionLog;
        Class<? extends FailedActionLog> clazz = this.mappings.get(failedAction);
        Date date = DateHelper.subtract((Date)new Date(), (ITimeInterval)failedAction.countInterval());
        return ((DBQuery)this.from(new EntityPath[]{qUserFailedActionLog}).where(new Predicate[]{qUserFailedActionLog.user().eq((Object)basicUser), qUserFailedActionLog.instanceOf(clazz), qUserFailedActionLog.date.after((Comparable)date)})).count(qUserFailedActionLog.id);
    }

    public int countVoucherPinFailures(Voucher voucher) throws FrameworkException {
        QFailedVoucherPinLog qFailedVoucherPinLog = QFailedVoucherPinLog.failedVoucherPinLog;
        return ((DBQuery)this.from(new EntityPath[]{qFailedVoucherPinLog}).where((Predicate)qFailedVoucherPinLog.voucher().eq((Object)voucher))).count(qFailedVoucherPinLog.id);
    }

    @PostConstruct
    public void initialize() {
        this.mappings = new HashMap<FailedAction, Class<? extends FailedActionLog>>();
        this.mappings.put(FailedAction.BLOCKED_USER, FailedBlockedUserLog.class);
        this.mappings.put(FailedAction.FAILED_EMAIL_VERIFICATION_AS_GUEST, FailedEmailVerificationAsGuestLog.class);
        this.mappings.put(FailedAction.FAILED_PHONE_VERIFICATION_AS_GUEST, FailedPhoneVerificationAsGuestLog.class);
        this.mappings.put(FailedAction.FAILED_PRINCIPAL, FailedPrincipalLog.class);
        this.mappings.put(FailedAction.FAILED_VOUCHER_INFO, FailedVoucherInfoLog.class);
        this.mappings.put(FailedAction.FORGOT_PASSWORD_REQUEST, ForgotPasswordRequestLog.class);
        this.mappings.put(FailedAction.FAILED_SECURITY_ANSWER, FailedSecurityAnswerLog.class);
        this.mappings.put(FailedAction.FAILED_TOKEN_ACTIVATION, FailedTokenActivationLog.class);
        this.mappings.put(FailedAction.FAILED_ACCESS_CLIENT_ACTIVATION, FailedAccessClientActivationLog.class);
        this.mappings.put(FailedAction.FAILED_VOUCHER_REDEEM, FailedVoucherRedeemingLog.class);
        this.mappings.put(FailedAction.FAILED_VOUCHER_PIN, FailedVoucherPinLog.class);
        this.mappings.put(FailedAction.FAILED_USER_LOCATION, FailedUserLocationLog.class);
        this.mappings.put(FailedAction.FAILED_DEVICE_CONFIRMATION, FailedDeviceConfirmationLog.class);
        this.mappings.put(FailedAction.FAILED_DEVICE_ACTIVATION, FailedDeviceActivationLog.class);
        this.mappings.put(FailedAction.FAILED_PHONE_VERIFICATION, FailedPhoneVerificationLog.class);
        this.mappings.put(FailedAction.FAILED_TOTP_ACTIVATION, FailedTotpActivationLog.class);
        this.mappings.put(FailedAction.FAILED_TOTP, FailedTotpLog.class);
        if (this.mappings.size() != FailedAction.values().length) {
            throw new IllegalStateException("Not all failed actions were mapped");
        }
        this.mappings.forEach((failedAction, clazz) -> {
            if (failedAction.isForGuest() ^ GuestFailedActionLog.class.isAssignableFrom((Class<?>)clazz)) {
                throw new IllegalStateException(String.format("The guest failed action %s is not a subclass of %s", failedAction, GuestFailedActionLog.class));
            }
        });
    }

    public boolean recordAndBlockUserIfMaxReached(FailedAction failedAction, BasicUser basicUser, Integer n, UserAlertType userAlertType) {
        BasicUser basicUser2 = basicUser == null ? this.getLoggedBasicUser() : basicUser;
        return this.recordUserFailure(failedAction, basicUser2, n, () -> {
            BasicUser basicUser2 = (BasicUser)this.rawEntityManagerHandler.find(BasicUser.class, basicUser2.getId());
            ChangeUserStatusParams changeUserStatusParams = new ChangeUserStatusParams();
            changeUserStatusParams.setUser((BasicUserVO)new UserVO(basicUser2.getId()));
            changeUserStatusParams.setStatus(UserStatus.BLOCKED);
            this.userStatusService.changeStatus(changeUserStatusParams);
            this.alertService.create(basicUser2.getUser(), userAlertType, new Object[0]);
        });
    }

    public boolean recordBlockedUserFailedAction(UserLocatorVO userLocatorVO) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.getLoggedBasicUser() != null) {
            throw new IllegalActionException();
        }
        Integer n = sessionData.getConfiguration().getMaxBlockedUsers();
        TimeInterval timeInterval = sessionData.getConfiguration().getRemoteAddressBlockTimeByBlockedUsers();
        boolean bl = this.recordGuestFailure(FailedAction.BLOCKED_USER, this.getRemoteAddress(), userLocatorVO, n, timeInterval);
        return bl;
    }

    public boolean recordGuestFailure(FailedAction failedAction, String string, UserLocatorVO userLocatorVO, Integer n, TimeInterval timeInterval) {
        if (n == null || n == 0 || !ITimeInterval.isValid((ITimeInterval)timeInterval)) {
            return false;
        }
        try {
            IpAddress ipAddress = this.ipAddressService.findByAddress(string);
            if (ipAddress.getStatus().isFixed()) {
                return ipAddress.getStatus() == IpAddressStatus.DENIED;
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        int n2 = this.countGuestFailures(failedAction, string) + 1;
        boolean bl = n2 >= n;
        IpBlockRunnable ipBlockRunnable = !bl ? null : new IpBlockRunnable(failedAction.alertType(), string, timeInterval, n);
        InvocationContext invocationContext = InvocationContext.get();
        invocationContext.addTransactionEndListener(true, bl2 -> this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            if (bl) {
                this.clearGuestFailures(failedAction, string);
                ipBlockRunnable.run();
            } else {
                GuestFailedActionLog guestFailedActionLog = (GuestFailedActionLog)this.newFailedActionLogInstance(failedAction);
                guestFailedActionLog.setDate(DateHelper.now());
                guestFailedActionLog.setRemoteAddress(string);
                guestFailedActionLog.setPrincipal(UserLocatorHandler.asString((UserLocatorVO)userLocatorVO));
                this.persist((IEntity)guestFailedActionLog);
            }
            return null;
        }));
        return bl;
    }

    public boolean recordPasswordFailure(BasicUser basicUser, PasswordType passwordType, boolean bl) {
        Integer n = passwordType.getInvalidAttempts();
        if (n == null || n == 0 || passwordType.getPasswordMode() == PasswordMode.SCRIPT) {
            return false;
        }
        int n2 = this.countPasswordFailures(basicUser, passwordType, bl) + 1;
        boolean bl2 = n2 >= n;
        String string = this.getRemoteAddress();
        InvocationContext invocationContext = InvocationContext.get();
        invocationContext.addTransactionEndListener(true, bl3 -> this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            if (bl2) {
                this.clearPasswordFailures(basicUser, passwordType, bl);
                PasswordServiceLocal passwordServiceLocal = (PasswordServiceLocal)invocationContext.applicationContext().getBean(PasswordServiceLocal.class);
                Password password = (Password)passwordServiceLocal.getPasswordAndStatus(basicUser, passwordType).getFirst();
                if (password != null) {
                    if (passwordType.getPasswordMode() == PasswordMode.OTP) {
                        this.remove((IEntity)password);
                    } else {
                        passwordServiceLocal.blockByTries(password);
                    }
                }
            } else {
                FailedPasswordLog failedPasswordLog = new FailedPasswordLog();
                failedPasswordLog.setDate(DateHelper.now());
                failedPasswordLog.setUser(basicUser);
                failedPasswordLog.setRemoteAddress(string);
                failedPasswordLog.setPasswordType(passwordType);
                failedPasswordLog.setForgot(bl);
                this.persist((IEntity)failedPasswordLog);
            }
            return null;
        }));
        return bl2;
    }

    public boolean recordPinFailure(Pin pin, Integer n, Runnable runnable) {
        if (n == null || n == 0) {
            return false;
        }
        int n2 = this.countPinFailures(pin) + 1;
        boolean bl = n2 >= n;
        InvocationContext invocationContext = InvocationContext.get();
        invocationContext.addTransactionEndListener(true, bl2 -> this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            if (bl) {
                this.clearPinFailures(pin);
                if (runnable != null) {
                    runnable.run();
                }
            } else {
                FailedDevicePinLog failedDevicePinLog = new FailedDevicePinLog();
                failedDevicePinLog.setDate(DateHelper.now());
                failedDevicePinLog.setPin(pin);
                failedDevicePinLog.setRemoteAddress(this.getSessionData().getRemoteAddress());
                this.persist((IEntity)failedDevicePinLog);
            }
            return null;
        }));
        return bl;
    }

    public boolean recordUserFailure(FailedAction failedAction, BasicUser basicUser, Integer n, Runnable runnable) {
        if (n == null || n == 0) {
            return false;
        }
        int n2 = this.countUserFailures(failedAction, basicUser) + 1;
        boolean bl = n2 >= n;
        InvocationContext invocationContext = InvocationContext.get();
        invocationContext.addTransactionEndListener(true, bl2 -> this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            if (bl) {
                this.clearUserFailures(failedAction, basicUser);
                if (runnable != null) {
                    runnable.run();
                }
            } else {
                UserFailedActionLog userFailedActionLog = (UserFailedActionLog)this.newFailedActionLogInstance(failedAction);
                userFailedActionLog.setDate(DateHelper.now());
                userFailedActionLog.setUser(basicUser);
                userFailedActionLog.setRemoteAddress(this.getSessionData().getRemoteAddress());
                this.persist((IEntity)userFailedActionLog);
            }
            return null;
        }));
        return bl;
    }

    public boolean recordVoucherPinFailure(Voucher voucher, Integer n, Runnable runnable) {
        if (n == null || n == 0) {
            return false;
        }
        int n2 = this.countVoucherPinFailures(voucher) + 1;
        boolean bl = n2 >= n;
        InvocationContext invocationContext = InvocationContext.get();
        invocationContext.addTransactionEndListener(true, bl2 -> this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            if (bl) {
                this.clearVoucherPinFailures(voucher);
                if (runnable != null) {
                    runnable.run();
                }
            } else {
                FailedVoucherPinLog failedVoucherPinLog = new FailedVoucherPinLog();
                failedVoucherPinLog.setDate(DateHelper.now());
                failedVoucherPinLog.setVoucher(voucher);
                failedVoucherPinLog.setRemoteAddress(this.getSessionData().getRemoteAddress());
                this.persist((IEntity)failedVoucherPinLog);
            }
            return null;
        }));
        return bl;
    }

    private <T extends FailedActionLog> T newFailedActionLogInstance(FailedAction failedAction) {
        return (T)((FailedActionLog)ClassHelper.instantiate(this.mappings.get(failedAction)));
    }

    private void runInReadWriteOrSubmit(Runnable runnable) {
        InvocationContext invocationContext = InvocationContext.ensure();
        if (invocationContext.getTransactionLevel() == TransactionLevel.READ_WRITE) {
            runnable.run();
        } else {
            this.invokerHandler.submitAsInParallelTransaction(invocationContext.sessionData(), TransactionLevel.READ_WRITE, transactionStatus -> runnable.run());
        }
    }

    private class IpBlockRunnable
    implements Runnable {
        private SystemAlertType alertType;
        private String remoteAddress;
        private TimeInterval blockTime;
        private int failures;

        public IpBlockRunnable(SystemAlertType systemAlertType, String string, TimeInterval timeInterval, int n) {
            this.alertType = systemAlertType;
            this.remoteAddress = string;
            this.blockTime = timeInterval;
            this.failures = n;
        }

        @Override
        public void run() {
            FailedActionHandlerImpl.this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
                if (this.alertType != null) {
                    FailedActionHandlerImpl.this.alertService.create(this.alertType, new Object[]{this.failures, this.remoteAddress});
                }
                FailedActionHandlerImpl.this.ipAddressService.block(this.remoteAddress, this.blockTime);
                return null;
            });
        }
    }
}

