/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.IdentityProviderClient;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.LocalStorage;
import org.cyclos.impl.utils.MapSessionStore;
import org.cyclos.impl.utils.RequestInfoWebContext;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.LocalStorageType;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackStatus;
import org.cyclos.model.access.identityproviders.IdentityProviderRequestType;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequest;
import org.cyclos.services.access.CallbackResult;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.CommonProfile;
import org.springframework.beans.factory.annotation.Autowired;

public class IdentityProviderContext {
    private String requestId;
    private IdentityProviderRequest request;
    private IdentityProvider idp;
    private UserGroup group;
    private CustomWizardExecution wizardExecution;
    private Channel channel;
    private RequestData requestData;
    private Session session;
    private Configuration configuration;
    private boolean valid;
    private boolean requestDestroyed;
    private SharedStorage<String, HashMap<String, Object>> requests;
    private LocalStorage<IdentityProviderClient, IndirectClient> clients;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private ClusterHandler clusterHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private TranslationHandler translationHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private CustomWizardServiceLocal customWizardService;

    public IdentityProviderContext(String string) {
        this.requestId = string;
    }

    public IndirectClient client(RequestInfo requestInfo) {
        String string = this.linkGeneratorHandler.identityProviderCallback(this.idp);
        boolean bl = this.request.getType().isFullProfile();
        IdentityProviderClient identityProviderClient = new IdentityProviderClient(this.idp, string, bl);
        return (IndirectClient)this.clients.get((Object)identityProviderClient, () -> ((IdentityProviderClient)identityProviderClient).newClient());
    }

    public IdentityProviderContext destroyRequest() {
        if (this.requestId != null) {
            this.requestDestroyed = true;
            this.requests.remove((Object)this.requestId);
        }
        return this;
    }

    public CallbackResult error(MessageKey messageKey, Consumer<IdentityProviderCallbackResult> consumer, Object ... objectArray) {
        CallbackResult callbackResult = this.result(IdentityProviderCallbackStatus.ERROR);
        callbackResult.getResult().setErrorMessage(this.translationHandler.message(messageKey, objectArray));
        return callbackResult;
    }

    public CallbackResult error(MessageKey messageKey, Object ... objectArray) {
        return this.error(messageKey, null, objectArray);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public UserGroup getGroup() {
        return this.group;
    }

    public IdentityProvider getIdentityProvider() {
        return this.idp;
    }

    public IdentityProviderVO getIdentityProviderVO() {
        return (IdentityProviderVO)this.conversionHandler.convert(IdentityProviderVO.class, (Object)this.idp);
    }

    public Network getNetwork() {
        return this.configuration == null ? null : this.configuration.getNetwork();
    }

    public CommonProfile getProfile() {
        HashMap<String, Object> hashMap = this.getStorage();
        return hashMap == null ? null : (CommonProfile)hashMap.get("profile");
    }

    public IdentityProviderRequest getRequest() {
        return this.request;
    }

    public RequestData getRequestData() {
        return this.requestData;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Session getSession() {
        return this.session;
    }

    public SessionStore getSessionStore() {
        Function<String, Object> function = string -> {
            HashMap<String, Object> hashMap = this.getStorage();
            return hashMap == null ? null : hashMap.get(string);
        };
        BiConsumer<String, Object> biConsumer = (string, object) -> {
            HashMap<String, Object> hashMap = this.getStorage();
            if (hashMap != null) {
                hashMap.put((String)string, object);
                this.setStorage(hashMap);
            }
        };
        return new MapSessionStore(this.requestId, function, biConsumer, this::destroyRequest);
    }

    public IdentityProviderRequestType getType() {
        return this.request == null ? null : this.request.getType();
    }

    public WebContext getWebContext(RequestData requestData, RequestInfo requestInfo, ResponseInfo responseInfo) {
        return new RequestInfoWebContext(requestData, requestInfo, responseInfo);
    }

    public CustomWizardExecution getWizardExecution() {
        return this.wizardExecution;
    }

    @PostConstruct
    public void initialize() {
        this.requests = this.clusterHandler.getSharedStorage(SharedStorageType.IDP_REQUESTS);
        HashMap<String, Object> hashMap = this.getStorage();
        if (hashMap != null) {
            this.request = (IdentityProviderRequest)hashMap.get("request");
            this.channel = (Channel)this.conversionHandler.convert(Channel.class, hashMap.get("channel"));
            this.requestData = (RequestData)hashMap.get("requestData");
            SessionData sessionData = this.requestData == null ? SessionDataFactory.system() : SessionDataFactory.system((RequestData)this.requestData);
            this.invokerHandler.runAs(sessionData, () -> {
                if (this.request != null) {
                    this.idp = (IdentityProvider)this.conversionHandler.convert(IdentityProvider.class, (Object)this.request.getIdentityProvider());
                    this.group = (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)this.request.getGroup());
                    if (this.request.getWizardExecution() != null) {
                        this.wizardExecution = this.customWizardService.findExecution(this.request.getWizardExecution());
                    }
                }
                this.valid = this.idp != null;
                String string = (String)hashMap.get("sessionToken");
                if (string != null) {
                    this.session = this.sessionHandler.getIfValid(this.requestData == null ? null : this.requestData.getRemoteAddress(), string);
                    if (this.session == null) {
                        this.valid = false;
                    }
                    this.configuration = this.session.getUser().getUser().getGroup().getConfiguration();
                } else if (this.requestData != null && this.requestData.getConfigurationId() != null) {
                    this.configuration = (Configuration)this.rawEntityManagerHandler.find(Configuration.class, this.requestData.getConfigurationId());
                } else {
                    this.valid = false;
                }
                if (this.valid) {
                    this.clients = this.clusterHandler.getLocalStorage(LocalStorageType.PAC4J_CLIENTS);
                }
                return null;
            });
        }
    }

    public boolean isRequestDestroyed() {
        return this.requestDestroyed;
    }

    public CallbackResult result(IdentityProviderCallbackStatus identityProviderCallbackStatus) {
        return this.result(identityProviderCallbackStatus, null);
    }

    public CallbackResult result(IdentityProviderCallbackStatus identityProviderCallbackStatus, Consumer<IdentityProviderCallbackResult> consumer) {
        boolean bl;
        IdentityProviderCallbackResult identityProviderCallbackResult = new IdentityProviderCallbackResult();
        identityProviderCallbackResult.setIdentityProvider(this.getIdentityProviderVO());
        identityProviderCallbackResult.setStatus(identityProviderCallbackStatus);
        identityProviderCallbackResult.setRequestId(this.requestId);
        if (consumer != null) {
            consumer.accept(identityProviderCallbackResult);
        }
        CallbackResult callbackResult = new CallbackResult(identityProviderCallbackResult, this.requestDestroyed);
        boolean bl2 = bl = this.channel != null && BuiltInChannel.MOBILE.getInternalName().equals(this.channel.getInternalName());
        if (bl) {
            callbackResult.setRedirectUrl(this.linkGeneratorHandler.mobile("identityProvider" + StringHelper.capitalize((String)this.getType().name())));
        }
        return callbackResult;
    }

    public void storeProfile(CommonProfile commonProfile) {
        HashMap<String, Object> hashMap = this.getStorage();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(hashMap);
        hashMap2.put("profile", commonProfile);
        this.setStorage(hashMap2);
    }

    public boolean valid() {
        return this.valid;
    }

    private HashMap<String, Object> getStorage() {
        return this.requestId == null ? null : (HashMap)this.requests.get((Object)this.requestId);
    }

    private void setStorage(HashMap<String, Object> hashMap) {
        if (this.requestId != null) {
            this.requests.set((Object)this.requestId, hashMap);
        }
    }
}

