/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.QUserAgent;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.SessionProperties;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.access.UserAgent;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.AccessLog;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QProductAdminVoucher;
import org.cyclos.entities.users.QProductMemberVoucher;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductPasswordAction;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.RoleContainer;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.DirectUserSessionData;
import org.cyclos.impl.access.IdentityProviderServiceLocal;
import org.cyclos.impl.access.InternalAuthServiceLocal;
import org.cyclos.impl.access.InternalIdentityProviderServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PerformLoginResult;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.SessionTimeoutHandler;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.UserAccountVisibilitySettingsServiceLocal;
import org.cyclos.impl.banking.VoucherConfigurationServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.IpAddressServiceLocal;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.users.ContactCustomFieldServiceLocal;
import org.cyclos.impl.users.FcmTokenServiceLocal;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.InvalidDeviceConfirmationException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.clients.AccessClientVO;
import org.cyclos.model.access.identityproviders.IdentityProviderNotLinkReason;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPermissionsVO;
import org.cyclos.model.banking.accounts.AccountPermissionsData;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.voucherconfigurations.VoucherConfigurationVO;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryVO;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.security.system.ImportServiceSecurity;
import org.cyclos.server.model.access.login.AccountPermissionsVO;
import org.cyclos.server.model.access.login.AgreementsPermissionsVO;
import org.cyclos.server.model.access.login.AuthVO;
import org.cyclos.server.model.access.login.BankingPermissionsVO;
import org.cyclos.server.model.access.login.ConnectedUsersPermissionsVO;
import org.cyclos.server.model.access.login.ContactsPermissionsVO;
import org.cyclos.server.model.access.login.DocumentsPermissionsVO;
import org.cyclos.server.model.access.login.ExternalPaymentsPermissionsVO;
import org.cyclos.server.model.access.login.IdentityProvidersPermissionsVO;
import org.cyclos.server.model.access.login.ImagesPermissionsVO;
import org.cyclos.server.model.access.login.ImportsPermissionsVO;
import org.cyclos.server.model.access.login.InvitePermissionsVO;
import org.cyclos.server.model.access.login.MarketplacePermissionsVO;
import org.cyclos.server.model.access.login.MessagesPermissionsVO;
import org.cyclos.server.model.access.login.MyMessagesPermissionsVO;
import org.cyclos.server.model.access.login.NotificationSettingsPermissionsVO;
import org.cyclos.server.model.access.login.NotificationsPermissionsVO;
import org.cyclos.server.model.access.login.OperationPermissionsVO;
import org.cyclos.server.model.access.login.OperationsPermissionsVO;
import org.cyclos.server.model.access.login.OperatorsPermissionsVO;
import org.cyclos.server.model.access.login.PasswordPermissionsVO;
import org.cyclos.server.model.access.login.PasswordsPermissionsVO;
import org.cyclos.server.model.access.login.PaymentRequestsPermissionsVO;
import org.cyclos.server.model.access.login.PaymentsPermissionsVO;
import org.cyclos.server.model.access.login.PermissionsVO;
import org.cyclos.server.model.access.login.PrivacySettingsPermissionsVO;
import org.cyclos.server.model.access.login.ProfilePermissionsVO;
import org.cyclos.server.model.access.login.RecordPermissionsVO;
import org.cyclos.server.model.access.login.RecordsPermissionsVO;
import org.cyclos.server.model.access.login.ReferencesPermissionsVO;
import org.cyclos.server.model.access.login.ScheduledPaymentsPermissionsVO;
import org.cyclos.server.model.access.login.SessionPropertiesVO;
import org.cyclos.server.model.access.login.SetSessionPropertiesDTO;
import org.cyclos.server.model.access.login.SystemMessagesPermissionsVO;
import org.cyclos.server.model.access.login.TicketsPermissionsVO;
import org.cyclos.server.model.access.login.TokensPermissionsVO;
import org.cyclos.server.model.access.login.TransactionAuthorizationsPermissionsVO;
import org.cyclos.server.model.access.login.UserAlertsPermissionsVO;
import org.cyclos.server.model.access.login.UsersPermissionsVO;
import org.cyclos.server.model.access.login.VoucherPermissionsVO;
import org.cyclos.server.model.access.login.VouchersPermissionsVO;
import org.cyclos.server.model.access.login.WizardPermissionsVO;
import org.cyclos.server.model.access.login.WizardsPermissionsVO;
import org.cyclos.server.utils.UserAgentHandler;
import org.cyclos.services.access.LoginDTO;
import org.cyclos.services.access.LoginUserDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternalAuthServiceImpl
extends BaseServiceImpl
implements InternalAuthServiceLocal {
    private static final String PERMISSIONS = "permissions";
    private static final QUserAgent ua = QUserAgent.userAgent;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private UserAccountVisibilitySettingsServiceLocal accountVisibilitySettingsServiceLocal;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private RecordServiceLocal recordService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private ContactCustomFieldServiceLocal contactCustomFieldService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private VoucherConfigurationServiceLocal voucherConfigurationService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private IdentityProviderServiceLocal identityProviderService;
    @Autowired
    private AgreementLogServiceLocal agreementLogService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private SessionTimeoutHandler sessionTimeoutHandler;
    @Autowired
    private InternetAddressListHandler internetAddressListHandler;
    @Autowired
    private IpAddressServiceLocal ipAddressService;
    @Autowired
    private InternalIdentityProviderServiceLocal internalIdentityProviderService;
    @Autowired
    private FcmTokenServiceLocal fcmTokenService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private UserAgentHandler userAgentHandler;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private ImportServiceSecurity importServiceSecurity;
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;

    public UserAgent findUserAgent(BasicUser basicUser, String string) {
        return (UserAgent)((DBQuery)this.rawEntityManagerHandler.selectFrom((EntityPath)ua).where(new Predicate[]{ua.user().eq((Object)basicUser), InternalAuthServiceImpl.ua.agentId.eq((Object)string)})).fetchFirst();
    }

    public AuthVO getCurrentAuth() throws FrameworkException {
        return this.getAuthVO();
    }

    public SessionPropertiesVO getSessionProperties() throws FrameworkException {
        Long l;
        Session session = this.getSessionData().getSession();
        Long l2 = l = session == null ? null : this.sessionTimeoutHandler.getExpiration(session.getSessionToken());
        if (session == null || l == null) {
            return null;
        }
        SessionPropertiesVO sessionPropertiesVO = (SessionPropertiesVO)this.conversionHandler.convert(SessionPropertiesVO.class, (Object)session.getProperties());
        sessionPropertiesVO.setCreatedAt(this.conversionHandler.toDateTime(session.getCreationDate()));
        sessionPropertiesVO.setExpirationInterval((TimeIntervalDTO)this.conversionHandler.convert(TimeIntervalDTO.class, (Object)this.sessionHandler.getSessionTimeout(session)));
        sessionPropertiesVO.setExpiresAt(this.conversionHandler.toDateTime(new Date(l)));
        return sessionPropertiesVO;
    }

    public AuthVO login(LoginDTO loginDTO) throws FrameworkException, LoginException, RemoteAddressBlockedException {
        SessionData sessionData = this.getSessionData();
        if (!this.ipAddressService.isAllowed(sessionData.getRemoteAddress())) {
            throw new RemoteAddressBlockedException();
        }
        PerformLoginResult performLoginResult = this.performLogin(loginDTO);
        Session session = performLoginResult.getSession();
        AuthVO authVO = this.getAuthVO(session);
        authVO.setIdentityProviderNotLinkReason(performLoginResult.getIdpNotLinkReason());
        authVO.setPinCreationToken(this.sessionHandler.getPinCreationToken(session));
        return authVO;
    }

    public AuthVO loginUser(LoginUserDTO loginUserDTO) throws FrameworkException, LoginException, RemoteAddressBlockedException {
        AuthVO authVO;
        boolean bl;
        if (loginUserDTO == null || loginUserDTO.getUser() == null || StringHelper.isBlank((Object)loginUserDTO.getUser().getPrincipal()) || StringHelper.isBlank((Object)loginUserDTO.getPassword())) {
            throw new ValidationException();
        }
        if (StringHelper.isNotBlank((Object)loginUserDTO.getRemoteAddress()) && !this.ipAddressService.isAllowed(loginUserDTO.getRemoteAddress())) {
            throw new RemoteAddressBlockedException();
        }
        SessionData sessionData = this.getSessionData();
        String string = (String)ObjectHelper.defaultValue((Object)loginUserDTO.getChannel(), (Object)BuiltInChannel.MAIN.getInternalName());
        String string2 = (String)ObjectHelper.defaultValue((Object)loginUserDTO.getRemoteAddress(), (Object)sessionData.getRemoteAddress());
        TimeInterval timeInterval = (TimeInterval)this.conversionHandler.convert(TimeInterval.class, (Object)loginUserDTO.getSessionTimeout());
        Set set = this.groupsHandler.accessibles().groups().items();
        Session session = this.sessionHandler.login(string, string2, timeInterval, loginUserDTO.getUser(), loginUserDTO.getPassword(), set);
        this.afterLogin(session, loginUserDTO.getUserAgentId(), null);
        Set set2 = sessionData.getProducts().admin().getUserProfileFields().keysSet((Path)QProductUserProfileField.productUserProfileField.visible);
        boolean bl2 = bl = !set2.isEmpty();
        if (bl) {
            authVO = this.getAuthVO(session);
        } else {
            authVO = new AuthVO();
            this.fill(authVO, SessionDataFactory.stateful((Session)session, (RequestData)sessionData.getRequestData()));
        }
        return authVO;
    }

    public void logout() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        Session session = sessionData.getSession();
        if (session != null) {
            this.sessionHandler.invalidate(sessionData.getRemoteAddress(), session.getSessionToken());
        }
    }

    public PerformLoginResult performLogin(LoginDTO loginDTO) {
        PerformLoginResult performLoginResult;
        if (loginDTO == null) {
            loginDTO = new LoginDTO();
        }
        TimeInterval timeInterval = (TimeInterval)this.conversionHandler.convert(TimeInterval.class, (Object)loginDTO.getCustomSessionTimeout());
        String string = loginDTO.getDeviceConfirmationId();
        Long l = loginDTO.getDeviceId();
        String string2 = loginDTO.getHmac();
        String string3 = loginDTO.getIdentityProviderRequestId();
        String string4 = loginDTO.getFcmDeviceToken();
        Supplier<PerformLoginResult> supplier = () -> {
            SessionHandler.CreateSessionParameters createSessionParameters = new SessionHandler.CreateSessionParameters(this.getSessionData());
            createSessionParameters.setCustomTimeout(timeInterval);
            createSessionParameters.setTrustedParams(string, l, string2);
            Session session = this.sessionHandler.create(createSessionParameters);
            IdentityProviderNotLinkReason identityProviderNotLinkReason = null;
            if (StringHelper.isNotBlank((Object)string3)) {
                identityProviderNotLinkReason = this.internalIdentityProviderService.linkAfterLogin(session, string3);
            }
            if (StringHelper.isNotBlank((Object)string4)) {
                this.fcmTokenService.assign(string4);
            }
            return new PerformLoginResult(session, identityProviderNotLinkReason);
        };
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isLoggedIn()) {
            if (ObjectHelper.anyIsNull((Object[])new Object[]{string, l, StringHelper.trimToNull((Object)string2)})) {
                throw new PermissionDeniedException();
            }
            try {
                TrustedDevice trustedDevice = (TrustedDevice)this.rawEntityManagerHandler.find(TrustedDevice.class, l);
                this.checkNetwork(sessionData, trustedDevice);
                DirectUserSessionData directUserSessionData = SessionDataFactory.direct((UserPrincipal)trustedDevice).honorAllUrgentSituations().build();
                directUserSessionData.checkConsistency();
                performLoginResult = (PerformLoginResult)this.invokerHandler.runAs((SessionData)directUserSessionData, () -> (PerformLoginResult)supplier.get());
            }
            catch (InvalidSessionDataException | LoginException throwable) {
                throw throwable;
            }
            catch (InvalidDeviceConfirmationException invalidDeviceConfirmationException) {
                throw new LoginException(invalidDeviceConfirmationException.getResult());
            }
            catch (EntityNotFoundException entityNotFoundException) {
                if (TrustedDevice.class.getSimpleName().equals(entityNotFoundException.getEntityType())) {
                    throw new LoginException();
                }
                throw entityNotFoundException;
            }
        } else {
            performLoginResult = supplier.get();
        }
        this.afterLogin(performLoginResult.getSession(), loginDTO.getUserAgentId(), loginDTO.getMobileAppVersion());
        return performLoginResult;
    }

    public void setSessionProperties(@NotNull SetSessionPropertiesDTO setSessionPropertiesDTO) throws FrameworkException {
        Session session = this.getSessionData().getSession();
        if (session == null) {
            throw new IllegalActionException("Not authenticated via session");
        }
        this.sessionHandler.setProperties(session, (SessionProperties)this.conversionHandler.convert(SessionProperties.class, (Object)setSessionPropertiesDTO));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void afterLogin(Session session, String string, String string2) {
        AccessLog accessLog;
        BasicUser basicUser = session.getUser();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        Date date = session.getCreationDate();
        String string3 = session.getRemoteAddress();
        InvocationContext.get().addCommitListener(false, () -> this.invokerHandler.submitAsInParallelTransaction(this.getSessionData(), TransactionLevel.READ_WRITE, transactionStatus -> this.nativeQueryHandler.storeLoginDate(basicUser, date)));
        UserAgent userAgent = null;
        boolean bl = false;
        if (StringHelper.isNotBlank((Object)string)) {
            userAgent = this.findUserAgent(basicUser, string);
            boolean bl2 = bl = basicUser.getEmail() != null && userAgent == null && configurationAccessor.isNotifyLoginsOnNewDevices() && this.hasAnyUserAgent(basicUser);
            if (userAgent == null) {
                accessLog = this.userAgentHandler.parse(this.getSessionData().getRequestData().getRequestInfo());
                userAgent = new UserAgent();
                userAgent.setUser(basicUser);
                userAgent.setAgentId(string);
                userAgent.setDeviceType(accessLog.getDeviceType());
                userAgent.setDevice(accessLog.getDevice());
                userAgent.setOperatingSystem(accessLog.getOperatingSystem());
                userAgent.setAgent(accessLog.getAgent());
                this.persist((IEntity)userAgent);
            }
        }
        accessLog = new AccessLog();
        accessLog.setUser(basicUser);
        accessLog.setUserAgent(userAgent);
        accessLog.setRemoteAddress(string3);
        accessLog.setDate(date);
        accessLog.setChannel(session.getChannel());
        accessLog.setMobileAppVersion(string2);
        this.rawEntityManagerHandler.persist((IEntity)accessLog);
        if (bl) {
            UserAgent userAgent2 = userAgent;
            this.mailHandler.send(null, basicUser, MailContext.LOGIN_ON_NEW_DEVICE, () -> {
                Object object;
                Object object2;
                Language language = configurationAccessor.getLanguage();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.message(MessageFormat.HTML, language, ContentManagementKeys.Emails.LOGIN_ON_NEW_DEVICE_WHEN, date));
                if (userAgent2 != null) {
                    object2 = session.getChannel().isMobile() ? this.message(MessageFormat.HTML, language, ContentManagementKeys.Emails.LOGIN_ON_NEW_DEVICE_DEVICE_MOBILE_APP, new Object[0]) : userAgent2.getAgent();
                    object = userAgent2.getDevice();
                    if (!((String)object).contains(userAgent2.getOperatingSystem())) {
                        object = (String)object + " (" + userAgent2.getOperatingSystem() + ")";
                    }
                    stringBuilder.append(this.message(MessageFormat.HTML, language, ContentManagementKeys.Emails.LOGIN_ON_NEW_DEVICE_DEVICE, object2, object));
                }
                if ((object2 = this.ipAddressService.geolocate(string3)) != null && object2.getCountry() != null) {
                    object = new StringBuilder();
                    if (object2.getCity() != null) {
                        ((StringBuilder)object).append(object2.getCity()).append(", ");
                    }
                    if (object2.getRegion() != null) {
                        ((StringBuilder)object).append(object2.getRegion()).append(", ");
                    }
                    ((StringBuilder)object).append(this.localizationService.getCountryName(object2.getCountry()));
                    stringBuilder.append(this.message(MessageFormat.HTML, language, ContentManagementKeys.Emails.LOGIN_ON_NEW_DEVICE_LOCATION, object));
                }
                stringBuilder.append(this.message(MessageFormat.HTML, language, ContentManagementKeys.Emails.LOGIN_ON_NEW_DEVICE_IP, string3));
                return new MailContent(this.message(language, ContentManagementKeys.Emails.LOGIN_ON_NEW_DEVICE_SUBJECT, new Object[0]), this.message(language, ContentManagementKeys.Emails.LOGIN_ON_NEW_DEVICE_BODY, stringBuilder));
            }, new FileInfo[0]);
        }
        if (basicUser instanceof User) {
            this.userSearchHandler.updateLastLogin(basicUser.getUser());
        }
    }

    private void checkNetwork(SessionData sessionData, TrustedDevice trustedDevice) {
        if (!(Objects.equals(sessionData.getNetwork(), trustedDevice.getNetwork()) || sessionData.getNetwork() != null && trustedDevice.getNetwork() == null)) {
            throw new IllegalActionException();
        }
    }

    private void fill(AuthVO authVO, SessionData sessionData) {
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        Session session = sessionData.getSession();
        if (session != null) {
            authVO.setSessionToken(session.getSessionToken());
        }
        Configuration configuration = configurationAccessor.getConfiguration();
        if (basicUser != null) {
            authVO.setGroup((GroupVO)this.conversionHandler.convert(GroupVO.class, (Object)basicUser.getUser().getGroup()));
        }
        authVO.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
        authVO.setConfigurationVersion(configuration.getVersion());
    }

    private AuthVO getAuthVO() {
        SessionData sessionData = this.getSessionData();
        FieldSelector fieldSelector = sessionData.getRequestData().getFields();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        AuthVO authVO = new AuthVO();
        authVO.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        if (fieldSelector.includes(PERMISSIONS)) {
            authVO.setPermissions(this.toPermissionsVO(sessionData));
        }
        this.fill(authVO, sessionData);
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        Language language = configurationAccessor.getLanguage();
        authVO.setLanguage((LanguageVO)this.conversionHandler.convert(LanguageVO.class, (Object)language));
        authVO.setLanguageVersion(language.getVersion());
        if (basicUser != null) {
            ChannelAccessAccessor channelAccessAccessor = sessionData.getChannelAccessAccessor();
            authVO.setGlobal(basicUser.isGlobal());
            authVO.setRoles(PermissionHelper.allRoles((RoleContainer)sessionData));
            authVO.setPasswordType((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)channelAccessAccessor.getAccessPassword()));
            authVO.setTrustedSession(sessionData.isTrusted());
            authVO.setAccessClient((AccessClientVO)this.conversionHandler.convert(AccessClientVO.class, (Object)sessionData.getAccessClient()));
            authVO.setPrincipalType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)sessionData.getPrincipalType()));
            authVO.setPrincipal(sessionData.getPrincipal());
            authVO.setPinInput(this.passwordHandler.toPinInput(channelAccessAccessor));
            sessionData.ifWraps(UserSessionData.class, userSessionData -> {
                authVO.setExpiredPassword(userSessionData.hasExpiredPassword());
                authVO.setPendingAgreements(userSessionData.hasPendingAgreements());
                authVO.setLoginConfirmation(userSessionData.getLoginConfirmation());
                authVO.setTotpEnabled(configurationAccessor.isTotpEnabled());
                if (!sessionData.isOperator()) {
                    authVO.setEverAcceptedAgreements(this.agreementLogService.isAnyAgreementAccepted(sessionData.getLoggedUser()));
                }
            });
        } else {
            InternetAddressList internetAddressList = sessionData.getChannelAccessAccessor().getWhitelist();
            authVO.setUnauthorizedAddress(!this.internetAddressListHandler.isWhitelisted(internetAddressList, sessionData.getRemoteAddress()));
        }
        return authVO;
    }

    private AuthVO getAuthVO(Session session) {
        return (AuthVO)this.invokerHandler.runAs(SessionDataFactory.stateful((Session)session, (RequestData)this.getSessionData().getRequestData()), this::getAuthVO);
    }

    private boolean hasAnyUserAgent(BasicUser basicUser) {
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{ua}).where((Predicate)ua.user().eq((Object)basicUser))).hasResults();
    }

    private OperationPermissionsVO toOperationPermissions(SessionData sessionData, CustomOperation customOperation) {
        OperationPermissionsVO operationPermissionsVO = new OperationPermissionsVO();
        operationPermissionsVO.setOperation((RunnableCustomOperationVO)this.conversionHandler.convert(RunnableCustomOperationVO.class, (Object)customOperation));
        operationPermissionsVO.setRun(true);
        return operationPermissionsVO;
    }

    private PasswordPermissionsVO toPasswordPermissions(SessionData sessionData, PasswordType passwordType) {
        BooleanProperties booleanProperties = sessionData.getProducts().product().getPasswordActions().get((Object)passwordType);
        PasswordPermissionsVO passwordPermissionsVO = new PasswordPermissionsVO();
        passwordPermissionsVO.setType((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType));
        QProductPasswordAction qProductPasswordAction = QProductPasswordAction.productPasswordAction;
        passwordPermissionsVO.setChange(booleanProperties.isSet((Path)qProductPasswordAction.change));
        passwordPermissionsVO.setEnable(booleanProperties.isSet((Path)qProductPasswordAction.enable));
        passwordPermissionsVO.setReset(booleanProperties.isSet((Path)qProductPasswordAction.reset));
        passwordPermissionsVO.setUnblock(booleanProperties.isSet((Path)qProductPasswordAction.unblock));
        return passwordPermissionsVO;
    }

    private PermissionsVO toPermissionsVO(SessionData sessionData) {
        boolean bl;
        boolean bl2;
        Object object;
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        PermissionsVO permissionsVO = new PermissionsVO();
        UsersPermissionsVO usersPermissionsVO = new UsersPermissionsVO();
        permissionsVO.setUsers(usersPermissionsVO);
        usersPermissionsVO.setViewPending(sessionData.hasPermission(Permission.PENDING_USERS_VIEW));
        usersPermissionsVO.setManagePending(sessionData.hasPermission(Permission.PENDING_USERS_MANAGE));
        usersPermissionsVO.setSearch(this.groupsHandler.users().basic().isNotEmpty());
        usersPermissionsVO.setMap(this.groupsHandler.directory().basic().isNotEmpty() && configurationAccessor.isUseMap());
        usersPermissionsVO.setViewProfile(sessionData.isBroker() || CollectionHelper.isNotEmpty((Iterable)this.groupsHandler.getViewProfileOnGroups()));
        if (sessionData.isAdmin()) {
            usersPermissionsVO.setRegisterAsAdmin(CollectionHelper.isNotEmpty((Iterable)this.groupsHandler.getPossibleRegistrationGroups(false, false)));
        }
        if (sessionData.isBroker()) {
            usersPermissionsVO.setRegisterAsBroker(CollectionHelper.isNotEmpty((Iterable)this.groupsHandler.getPossibleRegistrationGroups(false, false)));
        }
        if (sessionData.isMember()) {
            usersPermissionsVO.setRegisterAsMember(CollectionHelper.isNotEmpty((Iterable)this.groupsHandler.getPossibleRegistrationGroups(false, true)));
        }
        ProfilePermissionsVO profilePermissionsVO = new ProfilePermissionsVO();
        permissionsVO.setMyProfile(profilePermissionsVO);
        if (basicUser != null && !sessionData.isGlobalAdminInNetwork()) {
            profilePermissionsVO.setEditProfile(this.profileFieldHandler.canEditProfile(basicUser));
            profilePermissionsVO.setMaxLandlines(productsAccessor.product().getMaxLandlinePhones());
            profilePermissionsVO.setMaxMobiles(productsAccessor.product().getMaxMobilePhones());
            profilePermissionsVO.setMaxAddresses(productsAccessor.product().getMaxAddresses());
            profilePermissionsVO.setMaxProfileImages(productsAccessor.product().getMaxProfileImages());
            profilePermissionsVO.setMaxContactInfos(productsAccessor.member().getMaxContactInfos());
            profilePermissionsVO.setAddressRequired(configurationAccessor.isRequiredAddress());
            profilePermissionsVO.setLandLineRequired(configurationAccessor.isLandLineRequired());
            profilePermissionsVO.setMobileRequired(configurationAccessor.isMobileRequired());
            profilePermissionsVO.setProfileImageRequired(configurationAccessor.isProfileImageRequired());
            object = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.EDIT);
            profilePermissionsVO.setManagePhones(object.contains(BasicProfileField.PHONE));
            profilePermissionsVO.setManageAddresses(object.contains(BasicProfileField.ADDRESS));
            profilePermissionsVO.setManageImages(object.contains(BasicProfileField.IMAGE));
            profilePermissionsVO.setManageContactInfos(profilePermissionsVO.getMaxContactInfos() > 0);
        }
        object = new MarketplacePermissionsVO();
        permissionsVO.setMarketplace((MarketplacePermissionsVO)object);
        if (sessionData.isGuest()) {
            if (CollectionHelper.isEmpty((Iterable)configurationAccessor.getVisibleAdGroups())) {
                bl2 = false;
                bl = false;
            } else {
                bl = configurationAccessor.isAllowViewUserAd();
                bl2 = configurationAccessor.isAllowViewUserWebShop();
            }
        } else {
            bl = sessionData.hasPermission(Permission.USER_ADS_VIEW);
            bl2 = sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW);
        }
        object.setAdvertisementEnabled(sessionData.hasPermission(Permission.MY_ADS_ENABLE));
        object.setManageAdvertisement(sessionData.hasPermission(Permission.MY_ADS_MANAGE));
        object.setWebshopEnabled(sessionData.hasPermission(Permission.MY_WEB_SHOP_ENABLE));
        object.setManageWebshop(sessionData.hasPermission(Permission.MY_WEB_SHOP_MANAGE));
        object.setViewAdvertisement(bl);
        object.setViewWebshop(bl2);
        object.setPurchase(sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASE));
        object.setAdvertisementQuestions(sessionData.hasPermission(Permission.MY_AD_QUESTIONS_ENABLE));
        object.setWebshopQuestions(sessionData.hasPermission(Permission.MY_WEB_SHOP_QUESTIONS_ENABLE));
        object.setInterests(sessionData.hasPermission(Permission.MY_AD_INTERESTS_ENABLE));
        object.setFavorites(sessionData.hasPermission(Permission.MY_FAVORITE_ADS_ENABLE));
        object.setManageUserAdvertisement(sessionData.hasPermission(Permission.USER_ADS_MANAGE));
        object.setManageUserPendingAdvertisement(sessionData.hasPermission(Permission.USER_PENDING_ADS_MANAGE));
        object.setViewUserPendingAdvertisement(sessionData.hasPermission(Permission.USER_PENDING_ADS_VIEW));
        object.setManageUserWebshop(sessionData.hasPermission(Permission.USER_WEB_SHOP_MANAGE));
        object.setManageUserPendingWebshop(sessionData.hasPermission(Permission.USER_PENDING_WEB_SHOP_MANAGE));
        object.setViewUserPendingWebshop(sessionData.hasPermission(Permission.USER_PENDING_WEB_SHOP_VIEW));
        object.setViewUserPurchases(sessionData.hasPermission(Permission.USER_WEB_SHOP_PURCHASES_VIEW));
        object.setViewUserSales(sessionData.hasPermission(Permission.USER_WEB_SHOP_SALES_VIEW));
        object.setViewUserWebshopSettings(sessionData.hasPermission(Permission.USER_WEB_SHOP_SETTINGS_VIEW));
        object.setManageUserWebshopSettings(sessionData.hasPermission(Permission.USER_WEB_SHOP_SETTINGS_MANAGE));
        if (basicUser != null) {
            MyMessagesPermissionsVO myMessagesPermissionsVO;
            OperatorGroup operatorGroup;
            BankingPermissionsVO bankingPermissionsVO = new BankingPermissionsVO();
            if (sessionData.isUserManager()) {
                bankingPermissionsVO.setSearchUsersWithBalances(sessionData.hasPermission(Permission.USER_ACCOUNTS_VIEW));
                bankingPermissionsVO.setSearchGeneralTransfers(sessionData.hasPermission(new Permission[]{Permission.SYSTEM_ACCOUNTS_VIEW, Permission.USER_ACCOUNTS_VIEW}));
                bankingPermissionsVO.setSearchGeneralAuthorizedPayments(sessionData.hasPermission(new Permission[]{Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW, Permission.ADMIN_AUTHORIZATIONS_VIEW}));
                bankingPermissionsVO.setSearchGeneralScheduledPayments(sessionData.hasPermission(new Permission[]{Permission.USER_SCHEDULED_PAYMENTS_VIEW, Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW}));
                bankingPermissionsVO.setSearchGeneralExternalPayments(sessionData.hasPermission(new Permission[]{Permission.USER_EXTERNAL_PAYMENTS_VIEW, Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW}));
                bankingPermissionsVO.setSearchGeneralPaymentRequests(sessionData.hasPermission(new Permission[]{Permission.USER_PAYMENT_REQUESTS_VIEW, Permission.SYSTEM_PAYMENT_REQUESTS_VIEW}));
                bankingPermissionsVO.setSearchGeneralBalanceLimits(sessionData.hasPermission(Permission.USER_ACCOUNT_LIMIT_VIEW));
                bankingPermissionsVO.setSearchGeneralPaymentLimits(sessionData.hasPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_VIEW));
            }
            permissionsVO.setBanking(bankingPermissionsVO);
            List list = this.accountService.listVisible((InternalAccountOwner)basicUser);
            bankingPermissionsVO.setAccounts(list.stream().map(account -> {
                AccountPermissionsData accountPermissionsData = this.accountService.getPermissions(account);
                AccountPermissionsVO accountPermissionsVO = new AccountPermissionsVO();
                accountPermissionsVO.setAccount(accountPermissionsData.getAccount());
                accountPermissionsVO.setUserPayments(accountPermissionsData.getUserPayments());
                accountPermissionsVO.setSystemPayments(accountPermissionsData.getSystemPayments());
                accountPermissionsVO.setVisible(accountPermissionsData.isVisible());
                if (account instanceof UserAccount) {
                    if (accountPermissionsVO.isVisible()) {
                        boolean bl = true;
                        OperatorGroupAccountAccess operatorGroupAccountAccess = this.operatorService.accountAccess(account);
                        if (operatorGroupAccountAccess != null && operatorGroupAccountAccess != OperatorGroupAccountAccess.ALL_PAYMENTS) {
                            bl = false;
                        }
                        accountPermissionsVO.setViewStatus(bl);
                    }
                    accountPermissionsVO.setSelfPayments(accountPermissionsData.getSelfPayments());
                    accountPermissionsVO.setPosPayments(accountPermissionsData.getReceivePayments());
                } else {
                    accountPermissionsVO.setViewStatus(accountPermissionsVO.isVisible());
                }
                return accountPermissionsVO;
            }).collect(Collectors.toList()));
            bankingPermissionsVO.setAccountVisibilitySettings(this.accountVisibilitySettingsServiceLocal.hasAccountsToShowHide(basicUser));
            PaymentsPermissionsVO paymentsPermissionsVO = new PaymentsPermissionsVO();
            bankingPermissionsVO.setPayments(paymentsPermissionsVO);
            paymentsPermissionsVO.setUser(sessionData.hasPermission(new Permission[]{Permission.MY_PAYMENTS_PAY_TO_USER, Permission.SYSTEM_PAYMENTS_PAY_TO_USER}));
            paymentsPermissionsVO.setSystem(sessionData.hasPermission(new Permission[]{Permission.MY_PAYMENTS_PAY_TO_SYSTEM, Permission.SYSTEM_PAYMENTS_PAY_TO_SYSTEM}));
            paymentsPermissionsVO.setSelf(sessionData.hasPermission(Permission.MY_PAYMENTS_PAY_TO_SELF));
            paymentsPermissionsVO.setPos(sessionData.hasPermission(Permission.MY_PAYMENTS_RECEIVE));
            TransactionAuthorizationsPermissionsVO transactionAuthorizationsPermissionsVO = new TransactionAuthorizationsPermissionsVO();
            bankingPermissionsVO.setAuthorizations(transactionAuthorizationsPermissionsVO);
            if (!list.isEmpty()) {
                boolean bl3 = sessionData.hasPermission(new Permission[]{Permission.MY_AUTHORIZED_PAYMENTS_VIEW, Permission.ADMIN_AUTHORIZATIONS_VIEW});
                boolean bl4 = sessionData.hasPermission(new Permission[]{Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE, Permission.ADMIN_AUTHORIZATIONS_MANAGE});
                if (sessionData.isRestrictedOperator()) {
                    operatorGroup = sessionData.getLoggedOperator().getGroup();
                    boolean bl5 = this.operatorGroupService.canAuthorizeAnyPayment(operatorGroup);
                    bl3 = bl3 || this.operatorGroupService.anyRequiresAuthorization(operatorGroup) || bl5;
                    bl4 = bl4 || bl5;
                } else if (basicUser.isMember()) {
                    boolean bl6 = this.operatorGroupService.anyRequiresAuthorization(basicUser.getUser());
                    bl3 = bl3 || bl6;
                    bl4 = bl4 || bl6;
                }
                transactionAuthorizationsPermissionsVO.setView(bl3);
                transactionAuthorizationsPermissionsVO.setAuthorize(bl4);
                transactionAuthorizationsPermissionsVO.setDeny(transactionAuthorizationsPermissionsVO.isAuthorize());
                transactionAuthorizationsPermissionsVO.setCancel(sessionData.hasPermission(new Permission[]{Permission.MY_AUTHORIZED_PAYMENTS_CANCEL, Permission.SYSTEM_AUTHORIZED_PAYMENTS_CANCEL}));
            }
            ScheduledPaymentsPermissionsVO scheduledPaymentsPermissionsVO = new ScheduledPaymentsPermissionsVO();
            bankingPermissionsVO.setScheduledPayments(scheduledPaymentsPermissionsVO);
            scheduledPaymentsPermissionsVO.setView(sessionData.hasPermission(Permission.MY_SCHEDULED_PAYMENTS_VIEW) || sessionData.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW));
            scheduledPaymentsPermissionsVO.setBlock(sessionData.hasPermission(Permission.MY_SCHEDULED_PAYMENTS_BLOCK) || sessionData.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_BLOCK));
            scheduledPaymentsPermissionsVO.setUnblock(scheduledPaymentsPermissionsVO.isBlock());
            scheduledPaymentsPermissionsVO.setCancel(sessionData.hasPermission(Permission.MY_SCHEDULED_PAYMENTS_CANCEL) || sessionData.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_CANCEL));
            scheduledPaymentsPermissionsVO.setCancel(sessionData.hasPermission(Permission.MY_SCHEDULED_PAYMENTS_MODIFY) || sessionData.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_MODIFY));
            scheduledPaymentsPermissionsVO.setSettle(sessionData.hasPermission(Permission.MY_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT) || sessionData.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT));
            scheduledPaymentsPermissionsVO.setProcess(sessionData.hasPermission(Permission.MY_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT) || sessionData.hasPermission(Permission.SYSTEM_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT));
            ExternalPaymentsPermissionsVO externalPaymentsPermissionsVO = new ExternalPaymentsPermissionsVO();
            bankingPermissionsVO.setExternalPayments(externalPaymentsPermissionsVO);
            externalPaymentsPermissionsVO.setView(sessionData.hasPermission(new Permission[]{Permission.MY_EXTERNAL_PAYMENTS_VIEW, Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW}));
            externalPaymentsPermissionsVO.setPerform(sessionData.hasPermission(new Permission[]{Permission.MY_EXTERNAL_PAYMENTS_PAY_TO_USER, Permission.SYSTEM_EXTERNAL_PAYMENTS_PAY_TO_USER}));
            externalPaymentsPermissionsVO.setCancel(sessionData.hasPermission(new Permission[]{Permission.MY_EXTERNAL_PAYMENTS_CANCEL, Permission.SYSTEM_EXTERNAL_PAYMENTS_CANCEL}));
            operatorGroup = new PaymentRequestsPermissionsVO();
            bankingPermissionsVO.setPaymentRequests((PaymentRequestsPermissionsVO)operatorGroup);
            operatorGroup.setView(sessionData.hasPermission(new Permission[]{Permission.MY_PAYMENT_REQUESTS_VIEW, Permission.SYSTEM_PAYMENT_REQUESTS_VIEW}));
            operatorGroup.setSendToSystem(sessionData.hasPermission(Permission.MY_PAYMENT_REQUESTS_SEND_TO_SYSTEM));
            operatorGroup.setSendToUser(sessionData.hasPermission(new Permission[]{Permission.MY_PAYMENT_REQUESTS_SEND_TO_USER, Permission.SYSTEM_PAYMENT_REQUESTS_SEND_TO_USER}));
            operatorGroup.setAccept(sessionData.hasPermission(new Permission[]{Permission.MY_PAYMENT_REQUESTS_ACCEPT, Permission.SYSTEM_PAYMENT_REQUESTS_ACCEPT}));
            operatorGroup.setReject(operatorGroup.isAccept());
            operatorGroup.setCancel(sessionData.hasPermission(new Permission[]{Permission.MY_PAYMENT_REQUESTS_CANCEL, Permission.SYSTEM_PAYMENT_REQUESTS_CANCEL}));
            operatorGroup.setChangeExpiration(sessionData.hasPermission(new Permission[]{Permission.MY_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE, Permission.SYSTEM_PAYMENT_REQUESTS_CHANGE_EXPIRATION_DATE}));
            operatorGroup.setReschedule(operatorGroup.isAccept());
            TicketsPermissionsVO ticketsPermissionsVO = new TicketsPermissionsVO();
            bankingPermissionsVO.setTickets(ticketsPermissionsVO);
            ticketsPermissionsVO.setView(sessionData.hasPermission(Permission.MY_PAYMENT_TICKETS_VIEW));
            ticketsPermissionsVO.setCreate(sessionData.hasPermission(Permission.MY_PAYMENT_TICKETS_CREATE));
            ticketsPermissionsVO.setCancel(sessionData.hasPermission(Permission.MY_PAYMENT_TICKETS_CANCEL));
            ticketsPermissionsVO.setApprove(sessionData.hasPermission(Permission.MY_PAYMENT_TICKETS_APPROVE));
            RecordsPermissionsVO recordsPermissionsVO = new RecordsPermissionsVO();
            permissionsVO.setRecords(recordsPermissionsVO);
            recordsPermissionsVO.setUser(this.recordTypeService.listVisibleMyTypes().stream().map(userRecordType -> this.toRecordPermissions(sessionData, (RecordType)userRecordType)).collect(Collectors.toList()));
            if (sessionData.isUserManager()) {
                recordsPermissionsVO.setUserManagement(this.recordTypeService.listVisibleUserTypes().stream().filter(UserRecordType::isGeneralSearch).map(userRecordType -> this.toRecordPermissions(sessionData, (RecordType)userRecordType)).collect(Collectors.toList()));
            }
            if (sessionData.isAdmin()) {
                recordsPermissionsVO.setSystem(this.recordTypeService.listVisibleSystemTypes().stream().map(systemRecordType -> this.toRecordPermissions(sessionData, (RecordType)systemRecordType)).collect(Collectors.toList()));
            }
            OperationsPermissionsVO operationsPermissionsVO = new OperationsPermissionsVO();
            permissionsVO.setOperations(operationsPermissionsVO);
            operationsPermissionsVO.setUser(this.customOperationService.getRunnableOperationsForUser(basicUser.getUser()).stream().map(customOperation -> this.toOperationPermissions(sessionData, (CustomOperation)customOperation)).collect(Collectors.toList()));
            if (sessionData.isAdmin()) {
                operationsPermissionsVO.setSystem(this.customOperationService.getRunnableCustomOperationsForSystem().stream().map(customOperation -> this.toOperationPermissions(sessionData, (CustomOperation)customOperation)).collect(Collectors.toList()));
            }
            WizardsPermissionsVO wizardsPermissionsVO = new WizardsPermissionsVO();
            permissionsVO.setWizards(wizardsPermissionsVO);
            wizardsPermissionsVO.setMy(this.customWizardService.listForRun(basicUser.getUser()).stream().map(userWizard -> this.toWizardPermissions(sessionData, (CustomWizard)userWizard)).collect(Collectors.toList()));
            wizardsPermissionsVO.setSystem(this.customWizardService.listSystemForRun().stream().map(systemWizard -> this.toWizardPermissions(sessionData, (CustomWizard)systemWizard)).collect(Collectors.toList()));
            PasswordsPermissionsVO passwordsPermissionsVO = new PasswordsPermissionsVO();
            permissionsVO.setPasswords(passwordsPermissionsVO);
            passwordsPermissionsVO.setManage(sessionData.hasPermission(Permission.MY_PASSWORDS_MANAGE));
            passwordsPermissionsVO.setPasswords(configurationAccessor.getPasswords().stream().map(passwordType -> this.toPasswordPermissions(sessionData, (PasswordType)passwordType)).collect(Collectors.toList()));
            IdentityProvidersPermissionsVO identityProvidersPermissionsVO = new IdentityProvidersPermissionsVO();
            permissionsVO.setIdentityProviders(identityProvidersPermissionsVO);
            identityProvidersPermissionsVO.setEnabled(sessionData.hasPermission(Permission.MY_IDENTITY_PROVIDERS_ENABLE) && CollectionHelper.isNotEmpty((Iterable)this.identityProviderService.listEnabled(basicUser)));
            ContactsPermissionsVO contactsPermissionsVO = new ContactsPermissionsVO();
            contactsPermissionsVO.setEnable(sessionData.hasPermission(Permission.MY_CONTACTS_ENABLE));
            contactsPermissionsVO.setHasVisibleFields(CollectionHelper.isNotEmpty((Iterable)this.contactCustomFieldService.listVisible(sessionData.getLoggedUser())));
            contactsPermissionsVO.setHasEditableFields(CollectionHelper.isNotEmpty((Iterable)this.contactCustomFieldService.listEditable(sessionData.getLoggedUser())));
            permissionsVO.setContacts(contactsPermissionsVO);
            OperatorsPermissionsVO operatorsPermissionsVO = new OperatorsPermissionsVO();
            operatorsPermissionsVO.setEnable(sessionData.hasPermission(Permission.MY_OPERATORS_ENABLE));
            operatorsPermissionsVO.setManageOperators(sessionData.hasPermission(Permission.MY_OPERATORS_MANAGE_OPERATORS));
            operatorsPermissionsVO.setManageGroups(sessionData.hasPermission(Permission.MY_OPERATORS_MANAGE_GROUPS));
            permissionsVO.setOperators(operatorsPermissionsVO);
            NotificationsPermissionsVO notificationsPermissionsVO = new NotificationsPermissionsVO();
            notificationsPermissionsVO.setEnable(sessionData.hasPermission(Permission.MY_NOTIFICATIONS_ENABLE));
            permissionsVO.setNotifications(notificationsPermissionsVO);
            NotificationSettingsPermissionsVO notificationSettingsPermissionsVO = new NotificationSettingsPermissionsVO();
            notificationSettingsPermissionsVO.setEnable(sessionData.hasPermission(Permission.MY_NOTIFICATION_SETTINGS_ENABLE));
            permissionsVO.setNotificationSettings(notificationSettingsPermissionsVO);
            TokensPermissionsVO tokensPermissionsVO = new TokensPermissionsVO();
            List list2 = this.principalTypeService.listUserTokenPermissions(null, true);
            tokensPermissionsVO.setPersonalizeNfcTokensAsMember(list2.stream().filter(tokenPermissionsVO -> tokenPermissionsVO.getType().getTokenType().isNFCTag() && tokenPermissionsVO.isActivate()).map(TokenPermissionsVO::getType).collect(Collectors.toList()));
            tokensPermissionsVO.setMy(this.principalTypeService.listUserTokenPermissions(basicUser));
            tokensPermissionsVO.setUser(this.principalTypeService.listUserTokenPermissions((BasicUser)null));
            permissionsVO.setTokens(tokensPermissionsVO);
            ConnectedUsersPermissionsVO connectedUsersPermissionsVO = new ConnectedUsersPermissionsVO();
            connectedUsersPermissionsVO.setLogin(sessionData.hasPermission(Permission.CONNECTED_USERS_LOGIN));
            connectedUsersPermissionsVO.setManage(sessionData.hasPermission(Permission.CONNECTED_USERS_MANAGE));
            connectedUsersPermissionsVO.setView(sessionData.hasPermission(Permission.CONNECTED_USERS_VIEW));
            permissionsVO.setConnectedUsers(connectedUsersPermissionsVO);
            UserAlertsPermissionsVO userAlertsPermissionsVO = new UserAlertsPermissionsVO();
            userAlertsPermissionsVO.setView(sessionData.hasPermission(Permission.USER_ALERTS_VIEW));
            permissionsVO.setUserAlerts(userAlertsPermissionsVO);
            VouchersPermissionsVO vouchersPermissionsVO = new VouchersPermissionsVO();
            vouchersPermissionsVO.setVouchers(this.toVoucherPermissions(sessionData));
            permissionsVO.setVouchers(vouchersPermissionsVO);
            PrivacySettingsPermissionsVO privacySettingsPermissionsVO = new PrivacySettingsPermissionsVO();
            privacySettingsPermissionsVO.setView(sessionData.hasPermission(Permission.MY_PRIVACY_SETTINGS_VIEW));
            privacySettingsPermissionsVO.setManage(sessionData.hasPermission(Permission.MY_PRIVACY_SETTINGS_MANAGE));
            permissionsVO.setPrivacySettings(privacySettingsPermissionsVO);
            AgreementsPermissionsVO agreementsPermissionsVO = new AgreementsPermissionsVO();
            agreementsPermissionsVO.setView(sessionData.hasPermission(Permission.MY_AGREEMENT_LOG_VIEW));
            permissionsVO.setAgreements(agreementsPermissionsVO);
            ImagesPermissionsVO imagesPermissionsVO = new ImagesPermissionsVO();
            imagesPermissionsVO.setMyCustom(sessionData.hasPermission(Permission.MY_CUSTOM_IMAGES_ENABLE));
            if (basicUser.isAdmin()) {
                imagesPermissionsVO.setViewCategories(this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)productsAccessor.admin().getSystemImageCategoriesView()));
                imagesPermissionsVO.setManageCategories(this.conversionHandler.convertList(SystemImageCategoryVO.class, (Iterable)productsAccessor.admin().getSystemImageCategoriesManage()));
            }
            permissionsVO.setImages(imagesPermissionsVO);
            DocumentsPermissionsVO documentsPermissionsVO = new DocumentsPermissionsVO();
            documentsPermissionsVO.setViewIndividual(sessionData.hasPermission(Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW));
            documentsPermissionsVO.setViewShared(this.conversionHandler.convertList(DocumentCategoryVO.class, (Iterable)productsAccessor.member().getDocumentCategoryView()));
            permissionsVO.setDocuments(documentsPermissionsVO);
            ReferencesPermissionsVO referencesPermissionsVO = new ReferencesPermissionsVO();
            referencesPermissionsVO.setView(sessionData.hasPermission(Permission.MY_REFERENCES_VIEW));
            referencesPermissionsVO.setGive(sessionData.hasPermission(Permission.MY_REFERENCES_GIVE));
            referencesPermissionsVO.setReceive(sessionData.hasPermission(Permission.MY_REFERENCES_RECEIVE));
            permissionsVO.setReferences(referencesPermissionsVO);
            ReferencesPermissionsVO referencesPermissionsVO2 = new ReferencesPermissionsVO();
            referencesPermissionsVO2.setView(sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_VIEW));
            referencesPermissionsVO2.setGive(sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_GIVE));
            referencesPermissionsVO2.setReceive(sessionData.hasPermission(Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE));
            permissionsVO.setTransactionFeedbacks(referencesPermissionsVO2);
            InvitePermissionsVO invitePermissionsVO = new InvitePermissionsVO();
            invitePermissionsVO.setSend(sessionData.hasPermission(Permission.USER_INVITE));
            permissionsVO.setInvite(invitePermissionsVO);
            MessagesPermissionsVO messagesPermissionsVO = new MessagesPermissionsVO();
            if (!sessionData.isAdmin()) {
                myMessagesPermissionsVO = new MyMessagesPermissionsVO();
                myMessagesPermissionsVO.setSendToBrokered(sessionData.hasPermission(Permission.MY_MESSAGES_SEND_TO_BROKERED_USERS));
                myMessagesPermissionsVO.setSendToSystem(sessionData.hasPermission(Permission.MY_MESSAGES_SEND_TO_SYSTEM));
                myMessagesPermissionsVO.setSendToUser(sessionData.hasPermission(Permission.MY_MESSAGES_SEND_TO_USER));
                myMessagesPermissionsVO.setView(sessionData.hasPermission(Permission.MY_MESSAGES_VIEW));
                messagesPermissionsVO.setMy(myMessagesPermissionsVO);
            } else {
                myMessagesPermissionsVO = new SystemMessagesPermissionsVO();
                myMessagesPermissionsVO.setManage(sessionData.hasPermission(Permission.SYSTEM_MESSAGES_MANAGE));
                myMessagesPermissionsVO.setSendToGroups(sessionData.hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_GROUPS));
                myMessagesPermissionsVO.setSendToUser(sessionData.hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_USER));
                myMessagesPermissionsVO.setView(sessionData.hasPermission(Permission.SYSTEM_MESSAGES_VIEW));
                messagesPermissionsVO.setSystem((SystemMessagesPermissionsVO)myMessagesPermissionsVO);
            }
            permissionsVO.setMessages(messagesPermissionsVO);
            myMessagesPermissionsVO = new ImportsPermissionsVO();
            myMessagesPermissionsVO.setVisibleTypes(this.importServiceSecurity.getImportTypesWithPermission(false));
            permissionsVO.setImports((ImportsPermissionsVO)myMessagesPermissionsVO);
        }
        return permissionsVO;
    }

    private RecordPermissionsVO toRecordPermissions(SessionData sessionData, RecordType recordType) {
        ProductsAccessor productsAccessor = sessionData.getProducts();
        QProductMyRecordType qProductMyRecordType = QProductMyRecordType.productMyRecordType;
        BooleanProperties booleanProperties = recordType instanceof SystemRecordType ? productsAccessor.admin().getSystemRecordTypes().get((Object)((SystemRecordType)recordType)) : (recordType instanceof UserRecordType ? productsAccessor.product().getMyRecordTypes().get((Object)((UserRecordType)recordType)) : BooleanProperties.empty());
        RecordPermissionsVO recordPermissionsVO = new RecordPermissionsVO();
        recordPermissionsVO.setType((RecordTypeVO)this.conversionHandler.convert(RecordTypeVO.class, (Object)recordType));
        recordPermissionsVO.setCreate(booleanProperties.isSet((Path)qProductMyRecordType.create));
        recordPermissionsVO.setUpdate(booleanProperties.isSet((Path)qProductMyRecordType.edit));
        recordPermissionsVO.setRemove(booleanProperties.isSet((Path)qProductMyRecordType.remove));
        if (recordType.getResultsLayout() == RecordTypeResultsLayout.SINGLE_FORM) {
            SystemRecord systemRecord = null;
            if (recordType instanceof SystemRecordType) {
                systemRecord = this.recordService.getSingleFormRecord((SystemRecordType)recordType);
            } else if (recordType instanceof UserRecordType) {
                systemRecord = this.recordService.getSingleFormRecord((UserRecordType)recordType, sessionData.getLoggedUser());
            }
            recordPermissionsVO.setSingleId(SimpleEntity.id((SimpleEntity)systemRecord));
        }
        return recordPermissionsVO;
    }

    private List<VoucherPermissionsVO> toVoucherPermissions(SessionData sessionData) {
        QProductAdminVoucher qProductAdminVoucher = QProductAdminVoucher.productAdminVoucher;
        QProductMemberVoucher qProductMemberVoucher = QProductMemberVoucher.productMemberVoucher;
        BooleanPropertiesHolder booleanPropertiesHolder = this.voucherConfigurationService.resolveVoucherConfigurationPermissions(sessionData.getLoggedUser());
        return booleanPropertiesHolder.getBooleansMap().entrySet().stream().map(entry -> {
            BooleanProperties booleanProperties = (BooleanProperties)entry.getValue();
            VoucherPermissionsVO voucherPermissionsVO = new VoucherPermissionsVO();
            voucherPermissionsVO.setConfiguration((VoucherConfigurationVO)this.conversionHandler.convert(VoucherConfigurationVO.class, entry.getKey()));
            voucherPermissionsVO.setView(booleanProperties.isSet((Path)qProductAdminVoucher.view));
            voucherPermissionsVO.setCancel(booleanProperties.isSet((Path)qProductAdminVoucher.cancel));
            voucherPermissionsVO.setChangeExpirationDate(booleanProperties.isSet((Path)qProductAdminVoucher.changeExpirationDate));
            voucherPermissionsVO.setGenerate(booleanProperties.isSet((Path)qProductAdminVoucher.generate));
            voucherPermissionsVO.setEnabled(booleanProperties.isSet((Path)qProductMemberVoucher.enable));
            voucherPermissionsVO.setViewVouchers(booleanProperties.isSet((Path)qProductMemberVoucher.viewVouchers));
            voucherPermissionsVO.setBuy(booleanProperties.isSet((Path)qProductAdminVoucher.buy));
            voucherPermissionsVO.setSend(booleanProperties.isSet((Path)qProductAdminVoucher.send));
            voucherPermissionsVO.setRefund(booleanProperties.isSet((Path)qProductAdminVoucher.refund));
            voucherPermissionsVO.setViewTransactions(booleanProperties.isSet((Path)qProductMemberVoucher.viewTransactions));
            voucherPermissionsVO.setRedeem(booleanProperties.isSet((Path)qProductAdminVoucher.redeem));
            voucherPermissionsVO.setTopUp(booleanProperties.isSet((Path)qProductAdminVoucher.topUp));
            return voucherPermissionsVO;
        }).collect(Collectors.toList());
    }

    private WizardPermissionsVO toWizardPermissions(SessionData sessionData, CustomWizard customWizard) {
        WizardPermissionsVO wizardPermissionsVO = new WizardPermissionsVO();
        wizardPermissionsVO.setWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)customWizard));
        wizardPermissionsVO.setRun(true);
        return wizardPermissionsVO;
    }
}

