/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.access.Otp;
import org.cyclos.entities.access.OtpOwner;
import org.cyclos.entities.access.QOtp;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.messaging.OutboundSms;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QMobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.OtpHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandlerImplementor;
import org.cyclos.impl.utils.notifications.MailProcessingContext;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.IEntity;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.devices.RequestActivationResult;
import org.cyclos.model.access.devices.TrustedDeviceVO;
import org.cyclos.model.access.passwords.OtpType;
import org.cyclos.model.access.passwords.SendOtpData;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.sms.OutboundSmsStatus;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OtpHandlerImpl
extends BaseNetworkedHandlerImpl
implements OtpHandler {
    private static final QOtp $ = QOtp.otp;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;
    @Autowired
    private MailHandlerImplementor mailHandler;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private NetworkPathRegistry networkPathRegistry;
    @Autowired
    private PhoneServiceLocal phoneService;

    private static List<String> phoneNumbers(List<MobilePhone> list) {
        List<String> list2 = CollectionHelper.orEmpty(list).stream().map(Phone::getNormalizedNumber).collect(Collectors.toList());
        return list2;
    }

    public Otp find(Long l) {
        return this.find(Otp.class, l);
    }

    public Set<SendMedium> getAvailableSendMediums() {
        boolean bl;
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(sessionData.getLoggedBasicUser());
        EnumSet<SendMedium> enumSet = EnumSet.noneOf(SendMedium.class);
        boolean bl2 = bl = configurationAccessor.getOutboundSmsConfiguration() != null && configurationAccessor.getOutboundSmsConfiguration().isEnabled();
        if (bl) {
            enumSet.add(SendMedium.SMS);
        }
        boolean bl3 = bl = StringHelper.isNotBlank((Object)sessionData.getLoggedBasicUser().getEmail()) && StringHelper.isNotBlank((Object)configurationAccessor.getSmtpConfiguration().getHost());
        if (bl) {
            enumSet.add(SendMedium.EMAIL);
        }
        return enumSet;
    }

    public Date getDate(OtpType otpType, OtpOwner otpOwner) {
        return (Date)this.queryForTypeAndOwner(otpType, otpOwner).singleResult((Expression)OtpHandlerImpl.$.date.max());
    }

    public MobilePhone getMobilePhone(Otp otp) {
        MobilePhone mobilePhone = otp.getMobilePhone();
        if (mobilePhone != null) {
            return mobilePhone;
        }
        String string = otp.getSendMedium() == SendMedium.SMS ? otp.getSentTo() : null;
        QMobilePhone qMobilePhone = QMobilePhone.mobilePhone;
        return string == null ? null : (MobilePhone)((DBQuery)this.from(new EntityPath[]{qMobilePhone}).where((Predicate)qMobilePhone.normalizedNumber.eq((Object)string))).singleResult((Expression)qMobilePhone);
    }

    public SendOtpData getSendOtpData() {
        SendOtpData sendOtpData = new SendOtpData();
        Set<SendMedium> set = this.getAvailableSendMediums();
        sendOtpData.setSendMediums(EnumSet.noneOf(SendMedium.class));
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (set.contains(SendMedium.EMAIL)) {
            sendOtpData.setEmail(basicUser.getEmail());
            sendOtpData.getSendMediums().add(SendMedium.EMAIL);
        }
        List list = this.phoneService.listByUser(basicUser, PhoneNature.MOBILE);
        if (set.contains(SendMedium.SMS) && !CollectionHelper.isEmpty((Iterable)list)) {
            sendOtpData.setMobilePhones(this.conversionHandler.convertList(PhoneVO.class, (Iterable)list));
            sendOtpData.getSendMediums().add(SendMedium.SMS);
        }
        sendOtpData.setVerificationCodeSeconds(30);
        return sendOtpData;
    }

    public boolean hasAvailableSendMediums() {
        BasicUser basicUser = this.getLoggedBasicUser();
        Set<SendMedium> set = this.getAvailableSendMediums();
        List list = this.phoneService.listByUser(basicUser, PhoneNature.MOBILE);
        if (set.contains(SendMedium.SMS) && CollectionHelper.isEmpty((Iterable)list)) {
            set.remove(SendMedium.SMS);
        }
        return !set.isEmpty();
    }

    @PostConstruct
    public void initialize() {
        this.networkPathRegistry.register($.network());
    }

    public long remove(OtpType otpType, OtpOwner otpOwner) {
        return this.delete((EntityPath<?>)$).where(new Predicate[]{this.queryForTypeAndOwner(otpType, otpOwner).getMetadata().getWhere()}).execute();
    }

    public Otp sendForAccessClientActivation(User user, MobilePhone mobilePhone) {
        OtpTypeHandler otpTypeHandler = new OtpTypeHandler(OtpType.ACCESS_CLIENT_ACTIVATION, (OtpOwner)user, mobilePhone == null ? Collections.emptyList() : Collections.singletonList(mobilePhone), MailContext.ACCESS_CLIENT_ACTIVATION, OutboundSmsType.ACCESS_CLIENT_ACTIVATION){

            @Override
            protected MailContentProducer.MailContentBuilder mailContent(String string) {
                return OtpHandlerImpl.this.mailContentBuilder().subject(ContentManagementKeys.Emails.ACCESS_CLIENT_ACTIVATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.ACCESS_CLIENT_ACTIVATION_BODY, new Object[]{string});
            }

            @Override
            protected String smsMessage(String string) {
                return OtpHandlerImpl.this.message(AccessKeys.Clients.ACTIVATION_CODE_BY_SMS, new Object[]{this.configuration().getApplicationName(), string});
            }
        };
        return otpTypeHandler.send();
    }

    public RequestActivationResult sendForDeviceActivation(final TrustedDevice trustedDevice, MobilePhone mobilePhone) {
        var var3_3 = new OtpTypeHandler(OtpType.DEVICE_ACTIVATION, (OtpOwner)trustedDevice.getBasicUser(), mobilePhone == null ? Collections.emptyList() : Collections.singletonList(mobilePhone), MailContext.TRUSTED_DEVICE_ACTIVATION, OutboundSmsType.DEVICE_ACTIVATION){

            @Override
            protected Otp buildOtp() {
                Otp otp = super.buildOtp();
                otp.setTrustedDevice(trustedDevice);
                return otp;
            }

            @Override
            protected MailContentProducer.MailContentBuilder mailContent(String string) {
                return OtpHandlerImpl.this.mailContentBuilder().subject(ContentManagementKeys.Emails.DEVICE_ACTIVATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.DEVICE_ACTIVATION_BODY, new Object[]{string});
            }

            @Override
            protected Otp send() {
                Otp otp = super.send();
                trustedDevice.addOtp(otp);
                return otp;
            }

            @Override
            protected String smsMessage(String string) {
                return OtpHandlerImpl.this.message(AccessKeys.Devices.ACTIVATION_CODE_BY_SMS, new Object[]{this.configuration().getApplicationName(), string});
            }
        };
        Otp otp = var3_3.send();
        RequestActivationResult requestActivationResult = (RequestActivationResult)this.conversionHandler.convert(RequestActivationResult.class, (Object)otp);
        requestActivationResult.setDevice((TrustedDeviceVO)this.conversionHandler.convert(TrustedDeviceVO.class, (Object)trustedDevice));
        return requestActivationResult;
    }

    public Otp sendForForgotPassword(final LocateUserResult locateUserResult, List<MobilePhone> list, SendMedium sendMedium) {
        OtpTypeHandler otpTypeHandler = new OtpTypeHandler(OtpType.FORGOT_PASSWORD, (OtpOwner)locateUserResult.getBasicUser(), list, MailContext.FORGOT_PASSWORD, OutboundSmsType.FORGOT_PASSWORD, sendMedium){

            @Override
            protected MailContentProducer.MailContentBuilder mailContent(String string) {
                return OtpHandlerImpl.this.mailContentBuilder().body(ContentManagementKeys.Emails.FORGOT_PASSWORD_BODY_TEMPLATE, new Object[]{string}).subject(ContentManagementKeys.Emails.FORGOT_PASSWORD_SUBJECT, new Object[0]);
            }

            @Override
            protected boolean shouldMask(String string) {
                if (this.sendMedium == SendMedium.SMS) {
                    MobilePhone mobilePhone = locateUserResult.getMobilePhone();
                    return mobilePhone == null || mobilePhone.getNormalizedNumber().equals(string);
                }
                return !ExistingBuiltInPrincipalType.EMAIL.getInternalName().equals(locateUserResult.getPrincipalType().getInternalName());
            }

            @Override
            protected String smsMessage(String string) {
                return OtpHandlerImpl.this.message(ContentManagementKeys.Emails.FORGOT_PASSWORD_SMS, new Object[]{string});
            }
        };
        return otpTypeHandler.send();
    }

    public Otp sendForPhoneVerification(MobilePhone mobilePhone) {
        OtpTypeHandler otpTypeHandler = new OtpTypeHandler(OtpType.PHONE_VERIFICATION, (OtpOwner)mobilePhone, (List)Collections.singletonList(mobilePhone), null, OutboundSmsType.PHONE_VERIFICATION){

            @Override
            protected String emailAddress() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected MailContentProducer.MailContentBuilder mailContent(String string) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected String smsMessage(String string) {
                return OtpHandlerImpl.this.message(UsersKeys.Phones.MOBILE_VERIFICATION_SMS, new Object[]{this.configuration().getApplicationName(), string});
            }
        };
        return otpTypeHandler.send();
    }

    public Otp sendForTotpActivation(BasicUser basicUser, MobilePhone mobilePhone) {
        OtpTypeHandler otpTypeHandler = new OtpTypeHandler(OtpType.TOTP_ACTIVATION, (OtpOwner)basicUser, mobilePhone == null ? Collections.emptyList() : Collections.singletonList(mobilePhone), MailContext.TOTP_ACTIVATION, OutboundSmsType.TOTP_ACTIVATION){

            @Override
            protected MailContentProducer.MailContentBuilder mailContent(String string) {
                return OtpHandlerImpl.this.mailContentBuilder().subject(ContentManagementKeys.Emails.TOTP_ACTIVATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.TOTP_ACTIVATION_BODY, new Object[]{string});
            }

            @Override
            protected String smsMessage(String string) {
                return OtpHandlerImpl.this.message(AccessKeys.Totps.ACTIVATION_CODE_BY_SMS, new Object[]{this.configuration().getApplicationName(), string});
            }
        };
        return otpTypeHandler.send();
    }

    public Otp sendForWizardRegistration(CustomWizardExecution customWizardExecution, ConfigurationAccessor configurationAccessor, final String string, SendMedium sendMedium, final String string2) {
        OtpType otpType = sendMedium == SendMedium.SMS ? OtpType.WIZARD_PHONE : OtpType.WIZARD_EMAIL;
        OtpTypeHandler otpTypeHandler = new OtpTypeHandler(otpType, sendMedium == SendMedium.SMS ? Collections.singletonList(string2) : Collections.emptyList(), (OtpOwner)customWizardExecution, MailContext.WIZARD_EMAIL_VALIDATION, OutboundSmsType.PHONE_VERIFICATION){

            @Override
            protected String emailAddress() {
                return string2;
            }

            @Override
            protected MailContentProducer.MailContentBuilder mailContent(String string3) {
                return OtpHandlerImpl.this.mailContentBuilder().subject(ContentManagementKeys.Emails.VALIDATION_SUBJECT, new Object[0]).body(ContentManagementKeys.Emails.VALIDATION_WIZARD_BODY, new Object[]{this.configuration().getApplicationName(), string3});
            }

            @Override
            protected String mailName() {
                return string;
            }

            @Override
            protected String smsMessage(String string3) {
                return OtpHandlerImpl.this.message(UsersKeys.Phones.MOBILE_VERIFICATION_SMS, new Object[]{this.configuration().getApplicationName(), string3});
            }
        };
        return otpTypeHandler.send();
    }

    public Otp verify(OtpType otpType, OtpOwner otpOwner, String string) throws ValidationException {
        Otp otp = (Otp)((DBQuery)this.queryForTypeAndOwner(otpType, otpOwner).where((Predicate)OtpHandlerImpl.$.value.eq((Object)string))).singleResult((Expression)$);
        if (otp == null) {
            throw new ValidationException(this.message(AccessKeys.Passwords.OTP_ERROR_INVALID, new Object[0]));
        }
        InvocationContext invocationContext = InvocationContext.ensure();
        if (invocationContext.getTransactionLevel() == TransactionLevel.READ_WRITE) {
            invocationContext.addBeforeEndListener(() -> {
                MobilePhone mobilePhone = this.getMobilePhone(otp);
                if (mobilePhone != null && !mobilePhone.isVerified()) {
                    MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)this.phoneService.load(mobilePhone.getId());
                    mobilePhoneDTO.setVerified(true);
                    this.phoneService.save((EntityDTO)mobilePhoneDTO);
                }
                this.entityManagerHandler.remove((IEntity)otp);
            });
        }
        return otp;
    }

    private void checkResendAndRemoveExisting(OtpType otpType, OtpOwner otpOwner) {
        this.lockHandler.lock(LockType.OTP.key(String.valueOf(otpType) + "#" + otpOwner.getId()));
        List list = this.queryForTypeAndOwner(otpType, otpOwner).list((Expression)$);
        Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.SECONDS, (int)30);
        boolean bl = InvocationContext.ensure().getTransactionLevel() == TransactionLevel.READ_WRITE;
        for (Otp otp : list) {
            if (otp.getDate().after(date)) {
                throw new ValidationException(this.message(AccessKeys.Passwords.OTP_ERROR_CANT_RESEND_YET, 30));
            }
            if (!bl) continue;
            this.entityManagerHandler.remove((IEntity)otp);
        }
    }

    private String newValue(OtpType otpType, OtpOwner otpOwner) {
        for (int i = 0; i < 10; ++i) {
            String string = StringHelper.randomNumeric((int)6);
            if (!((DBQuery)this.queryForTypeAndOwner(otpType, otpOwner).where((Predicate)OtpHandlerImpl.$.value.eq((Object)string))).hasEmptyResults()) continue;
            return string;
        }
        throw new UnexpectedDataAccessException("Couldn't generate a unique OTP for " + String.valueOf(otpType) + " and " + String.valueOf(otpOwner));
    }

    private DBQuery<?> queryForTypeAndOwner(OtpType otpType, OtpOwner otpOwner) {
        return (DBQuery)this.entityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{OtpHandlerImpl.$.type.eq((Object)otpType), otpOwner.resolveOwnerPath((EntityPathBase)$).eq((Object)otpOwner)});
    }

    protected abstract class OtpTypeHandler {
        protected final OtpType type;
        protected final OtpOwner owner;
        protected final SendMedium sendMedium;
        protected final MailContext mailContext;
        protected final OutboundSmsType smsType;
        private List<String> phoneNumbers;
        private Otp otp;

        protected OtpTypeHandler(OtpType otpType, List<String> list, OtpOwner otpOwner, MailContext mailContext, OutboundSmsType outboundSmsType) {
            this(otpType, list, otpOwner, mailContext, outboundSmsType, CollectionHelper.isNotEmpty(list) ? SendMedium.SMS : SendMedium.EMAIL);
        }

        protected OtpTypeHandler(OtpType otpType, List<String> list, OtpOwner otpOwner, MailContext mailContext, OutboundSmsType outboundSmsType, SendMedium sendMedium) {
            this.type = otpType;
            this.owner = otpOwner;
            this.sendMedium = sendMedium;
            this.phoneNumbers = list;
            this.mailContext = mailContext;
            this.smsType = outboundSmsType;
        }

        protected OtpTypeHandler(OtpType otpType, OtpOwner otpOwner, List<MobilePhone> list, MailContext mailContext, OutboundSmsType outboundSmsType) {
            this(otpType, OtpHandlerImpl.phoneNumbers(list), otpOwner, mailContext, outboundSmsType);
        }

        protected OtpTypeHandler(OtpType otpType, OtpOwner otpOwner, List<MobilePhone> list, MailContext mailContext, OutboundSmsType outboundSmsType, SendMedium sendMedium) {
            this(otpType, OtpHandlerImpl.phoneNumbers(list), otpOwner, mailContext, outboundSmsType, sendMedium);
        }

        protected Otp buildOtp() {
            Otp otp = new Otp();
            otp.setType(this.type);
            otp.setDate(new Date());
            otp.setNetwork(this.owner.getNetwork());
            otp.setValue(OtpHandlerImpl.this.newValue(this.type, this.owner));
            this.owner.setAsOwnerFor(otp);
            otp.setSendMedium(this.sendMedium);
            return otp;
        }

        protected ConfigurationAccessor configuration() {
            BasicUser basicUser = this.user();
            return basicUser == null ? OtpHandlerImpl.this.getConfiguration() : OtpHandlerImpl.this.configurationHandler.getAccessor(basicUser);
        }

        protected String emailAddress() {
            BasicUser basicUser = this.user();
            return basicUser == null ? null : basicUser.getEmail();
        }

        protected abstract MailContentProducer.MailContentBuilder mailContent(String var1);

        protected String mailName() {
            return null;
        }

        protected Otp otp() {
            if (this.otp == null) {
                this.otp = this.buildOtp();
            }
            return this.otp;
        }

        protected Otp send() {
            OtpHandlerImpl.this.checkResendAndRemoveExisting(this.type, this.owner);
            Otp otp = this.otp();
            if (this.sendMedium == SendMedium.SMS) {
                this.sendSms();
            } else {
                this.sendEmail();
            }
            OtpHandlerImpl.this.entityManagerHandler.persist((IEntity)otp);
            this.owner.getOtps().add(otp);
            return otp;
        }

        protected boolean shouldMask(String string) {
            return false;
        }

        protected abstract String smsMessage(String var1);

        private void doSendEmail(BasicUser basicUser, String string, ConfigurationAccessor configurationAccessor, MailContentProducer.MailContentBuilder mailContentBuilder) {
            if (basicUser != null) {
                OtpHandlerImpl.this.mailHandler.send(null, basicUser, this.mailContext, (MailContentProducer)mailContentBuilder, new FileInfo[0]);
            } else {
                MailContent mailContent = mailContentBuilder.mailContent();
                MailProcessingContext mailProcessingContext = OtpHandlerImpl.this.mailHandler.createMailProcessingContext(this.mailName(), string, mailContent.getSubject(), mailContent.getBody(), configurationAccessor, new FileInfo[0]);
                OtpHandlerImpl.this.mailHandler.sendNow(mailProcessingContext, OtpHandlerImpl.this.mailHandler.getMailSender(configurationAccessor));
            }
        }

        private List<OutboundSms> doSendSms(BasicUser basicUser, String string3, ConfigurationAccessor configurationAccessor) {
            List list;
            if (basicUser != null) {
                List list2 = basicUser.getMobilePhones();
                List list3 = this.phoneNumbers.stream().map(string -> list2.stream().filter(mobilePhone -> mobilePhone.getNormalizedNumber().equals(string)).findAny().get()).collect(Collectors.toList());
                list = OtpHandlerImpl.this.outboundSmsHandler.sendEvenIfDisabled(list3, string3, this.smsType);
            } else {
                list = this.phoneNumbers.stream().map(string2 -> OtpHandlerImpl.this.outboundSmsHandler.sendToUnregistered(configurationAccessor, string2, string3, this.smsType)).collect(Collectors.toList());
            }
            return list;
        }

        private void sendEmail() {
            BasicUser basicUser = this.user();
            String string = this.emailAddress();
            if (StringHelper.isBlank((Object)string)) {
                throw new ValidationException(OtpHandlerImpl.this.message(AccessKeys.Passwords.OTP_ERROR_NO_EMAIL, new Object[0]));
            }
            this.otp.setSentTo(string);
            ConfigurationAccessor configurationAccessor = this.configuration();
            MailContentProducer.MailContentBuilder mailContentBuilder = this.mailContent(this.otp.getValue());
            this.doSendEmail(basicUser, string, configurationAccessor, mailContentBuilder);
        }

        private List<OutboundSms> sendSms() {
            BasicUser basicUser = this.user();
            SessionData sessionData = basicUser == null ? OtpHandlerImpl.this.getSessionData() : SessionDataFactory.user((BasicUser)basicUser);
            String string2 = (String)OtpHandlerImpl.this.invokerHandler.runAs(sessionData, () -> this.smsMessage(this.otp.getValue()));
            ConfigurationAccessor configurationAccessor = this.configuration();
            List<OutboundSms> list = this.doSendSms(basicUser, string2, configurationAccessor);
            List list2 = this.phoneNumbers.stream().filter(string -> list.stream().anyMatch(outboundSms -> outboundSms.getStatus() == OutboundSmsStatus.SUCCESS && string.equals(outboundSms.getPhoneNumber()))).collect(Collectors.toList());
            if (list2.isEmpty()) {
                throw new ValidationException(OtpHandlerImpl.this.message(GeneralKeys.Errors.CAN_NOT_SEND_SMS, new Object[0]));
            }
            this.otp().setSentTo(list2.stream().map(string -> {
                PhoneNumberDescriptor phoneNumberDescriptor = OtpHandlerImpl.this.phoneNumberHandler.parse(string, configurationAccessor);
                String string2 = phoneNumberDescriptor == null ? string : phoneNumberDescriptor.toNationalFormat();
                return this.shouldMask((String)string) ? StringHelper.maskPhone((String)string2) : string2;
            }).collect(Collectors.joining(",")));
            return list;
        }

        private BasicUser user() {
            return this.owner.getOtpUser();
        }
    }
}

