/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.Path;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.Password;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.messaging.OutboundSms;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.PinChannelConfiguration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.QMyProductPasswordAction;
import org.cyclos.entities.users.QProductPasswordAction;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.UserPrincipals;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TotpServiceLocal;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.access.UserCredentials;
import org.cyclos.impl.access.VirtualKeyboardData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.PasswordHelper;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.formatting.ShortFormat;
import org.cyclos.impl.utils.notifications.MailContentProducer;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialType;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidPasswordException;
import org.cyclos.model.access.OtpInvalidatedException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.PasswordStatusException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.PasswordAction;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.pins.PinInputDTO;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.sms.OutboundSmsStatus;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserRegistration;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class PasswordHandlerImpl
extends BaseNetworkedHandlerImpl
implements PasswordHandler {
    private static final Object IGNORE_CONFIRMATION_KEY = new Object();
    private static final Object CONFIRMATION_CREDENTIAL_TYPE_KEY = new Object();
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private TotpServiceLocal totpService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private PinServiceLocal pinService;
    @Autowired
    private ClusterHandler clusterHandler;
    private SharedStorage<String, VirtualKeyboardData> virtualKeyboards;

    public CredentialAccessor accessor(CredentialUsage credentialUsage) {
        if (credentialUsage == null) {
            throw new IllegalArgumentException("Can't create a credential accessor: usage is null.");
        }
        UserCredentials userCredentials = this.resolveUserCredentials(credentialUsage);
        return new CredentialAccessorImpl(userCredentials);
    }

    public CredentialType checkCredential(ChannelAccessAccessor channelAccessAccessor, CredentialUsage credentialUsage, UserPrincipal userPrincipal, CreateDeviceConfirmationParams createDeviceConfirmationParams, boolean bl, String string) throws PasswordException {
        CredentialType credentialType = null;
        boolean bl2 = this.validatePasswordValue(channelAccessAccessor, credentialUsage, string);
        if (bl2) {
            if (userPrincipal instanceof Pin) {
                this.pinService.checkPin((Pin)userPrincipal, string, channelAccessAccessor);
                credentialType = CredentialType.PIN;
            } else {
                if (credentialUsage == CredentialUsage.CONFIRMATION && this.mustConfirmWithPin(channelAccessAccessor)) {
                    this.pinService.checkPin(this.getSessionData().getPin(), string, channelAccessAccessor);
                    credentialType = CredentialType.PIN;
                } else {
                    CredentialsConfiguration credentialsConfiguration = channelAccessAccessor.getCredentials(credentialUsage);
                    if (credentialsConfiguration.isDevice() && this.deviceConfirmationService.isDeviceConfirmation(string)) {
                        string = StringHelper.removeStart((String)string, (String)"confirmation:");
                        TrustedDevice trustedDevice = this.deviceConfirmationService.check(string, createDeviceConfirmationParams);
                        this.markSessionAsTrusted(trustedDevice, credentialUsage);
                        credentialType = CredentialType.DEVICE;
                    } else if (credentialsConfiguration.isTotp() && this.totpService.isTotp(string)) {
                        string = StringHelper.removeStart((String)string, (String)"totp:");
                        this.totpService.check(userPrincipal.getBasicUser(), string);
                        credentialType = CredentialType.TOTP;
                    } else if (credentialsConfiguration.hasPassword()) {
                        PasswordType passwordType = credentialsConfiguration.getPassword();
                        this.doCheckPasswordValue(passwordType, userPrincipal.getBasicUser(), bl, string);
                        if (passwordType.getPasswordMode() == PasswordMode.OTP && !passwordType.isAllowReuseOTP()) {
                            this.passwordService.remove(userPrincipal.getBasicUser(), passwordType);
                        }
                    }
                }
                this.markSessionAsValidated(channelAccessAccessor, credentialUsage);
            }
            if (credentialUsage == CredentialUsage.CONFIRMATION) {
                this.confirmationPasswordChecked(credentialType);
            }
        }
        return credentialType;
    }

    public void checkPassword(PasswordType passwordType, BasicUser basicUser, boolean bl, String string) {
        if (StringHelper.isBlank((Object)string)) {
            String string2 = this.getTranslatedName((NamedEntity)passwordType);
            throw new ValidationException(this.message(GeneralKeys.Errors.REQUIRED, string2));
        }
        this.doCheckPasswordValue(passwordType, basicUser, bl, string);
    }

    public String encode(BasicUser basicUser, PasswordType passwordType, String string) {
        switch (passwordType.getInputMethod()) {
            case TEXT_BOX: {
                return this.getPasswordEncoder(passwordType).encode((CharSequence)string);
            }
            case VIRTUAL_KEYBOARD: {
                byte[] byArray = this.keyMask(passwordType, basicUser);
                return this.applicationHandler.encryptAsString(string, byArray);
            }
        }
        throw new IllegalStateException();
    }

    public CredentialInputDTO getCredentialInput(ChannelAccessAccessor channelAccessAccessor, CredentialUsage credentialUsage, BasicUser basicUser) {
        String string;
        Collection collection;
        Object object;
        CredentialsConfiguration credentialsConfiguration = channelAccessAccessor.getCredentials(credentialUsage);
        if (credentialsConfiguration == null || !credentialsConfiguration.isDefined()) {
            return null;
        }
        if (credentialUsage == CredentialUsage.CONFIRMATION && this.mustConfirmWithPin(channelAccessAccessor)) {
            List<CredentialType> list = Arrays.asList(CredentialType.PIN);
            CredentialInputDTO credentialInputDTO = new CredentialInputDTO();
            credentialInputDTO.setAllowedCredentials(list);
            credentialInputDTO.setActiveCredentials(list);
            credentialInputDTO.setPinInput(this.toPinInput(channelAccessAccessor));
            return credentialInputDTO;
        }
        PasswordType passwordType = credentialsConfiguration.getPassword();
        CredentialInputDTO credentialInputDTO = new CredentialInputDTO();
        ArrayList<CredentialType> arrayList = new ArrayList<CredentialType>();
        ArrayList<CredentialType> arrayList2 = new ArrayList<CredentialType>();
        credentialInputDTO.setAllowedCredentials(arrayList);
        credentialInputDTO.setActiveCredentials(arrayList2);
        if (credentialsConfiguration.isDevice()) {
            arrayList.add(CredentialType.DEVICE);
            if (this.trustedDeviceService.hasActiveDevices(basicUser)) {
                arrayList2.add(CredentialType.DEVICE);
            }
        }
        if (credentialsConfiguration.isTotp()) {
            arrayList.add(CredentialType.TOTP);
            if (this.totpService.isActive(basicUser)) {
                arrayList2.add(CredentialType.TOTP);
            }
        }
        if (credentialsConfiguration.hasPassword()) {
            arrayList.add(CredentialType.PASSWORD);
            credentialInputDTO.setPasswordType((PasswordTypeDetailedVO)this.conversionHandler.convert(PasswordTypeDetailedVO.class, (Object)passwordType));
            if (basicUser != null) {
                if (passwordType.getPasswordMode() == PasswordMode.SCRIPT) {
                    arrayList2.add(CredentialType.PASSWORD);
                    object = PasswordStatus.ACTIVE;
                } else if (passwordType.getPasswordMode() == PasswordMode.OTP) {
                    collection = CollectionHelper.orEmpty((Set)passwordType.getOtpSendMediums());
                    if (collection.contains(SendMedium.EMAIL) && StringHelper.isNotBlank((Object)basicUser.getEmail()) || collection.contains(SendMedium.SMS) && basicUser.getMobilePhones().stream().anyMatch(MobilePhone::isEnabledForSms)) {
                        arrayList2.add(CredentialType.PASSWORD);
                        object = PasswordStatus.ACTIVE;
                    } else {
                        object = PasswordStatus.DISABLED;
                    }
                    if (passwordType.isAllowReuseOTP()) {
                        string = this.passwordService.getPasswordAndStatus(basicUser, passwordType);
                        credentialInputDTO.setHasReusableOtp(string.getSecond() == PasswordStatus.ACTIVE);
                    }
                } else {
                    collection = this.passwordService.getPasswordAndStatus(basicUser, passwordType);
                    object = (PasswordStatus)collection.getSecond();
                    if (object == PasswordStatus.ACTIVE) {
                        arrayList2.add(CredentialType.PASSWORD);
                    }
                }
                credentialInputDTO.setPasswordStatus(object);
            }
        }
        if (credentialUsage == CredentialUsage.ACCESS && channelAccessAccessor.getPinConfiguration() != null) {
            arrayList.add(CredentialType.PIN);
            credentialInputDTO.setPinInput(this.toPinInput(channelAccessAccessor));
        }
        if (passwordType != null) {
            if (passwordType.getInputMethod() == PasswordInputMethod.VIRTUAL_KEYBOARD) {
                object = null;
                if (basicUser != null) {
                    collection = this.passwordService.getPasswordAndStatus(basicUser, passwordType);
                    string = (Password)collection.getFirst();
                    object = this.getPlainPassword((Password)string);
                }
                collection = PasswordHelper.generateVirtualKeyboardSequence((PasswordType)passwordType, object);
                string = UUID.randomUUID().toString();
                this.virtualKeyboards.set((Object)string, (Object)new VirtualKeyboardData(string, (List)collection));
                credentialInputDTO.setInputId(string);
                credentialInputDTO.setButtons(collection);
                credentialInputDTO.setSeparator("|");
            }
            if (passwordType.getPasswordMode() == PasswordMode.OTP) {
                credentialInputDTO.setOtpSendMediums(this.doGetAllowedOTPSendMediums(basicUser, passwordType));
                if (this.getLoggedUser().equals((Object)basicUser)) {
                    if (credentialInputDTO.getOtpSendMediums().contains(SendMedium.EMAIL)) {
                        credentialInputDTO.setEmailToSendOtp(basicUser.getEmail());
                    }
                    if (credentialInputDTO.getOtpSendMediums().contains(SendMedium.SMS)) {
                        credentialInputDTO.setMobilePhonesToSendOtp(this.conversionHandler.convertList(PhoneVO.class, (Iterable)basicUser.getMobilePhones().stream().filter(MobilePhone::isEnabledForSms).collect(Collectors.toSet())));
                    }
                }
            }
        }
        if (credentialUsage == CredentialUsage.CONFIRMATION) {
            credentialInputDTO.setConfirmationPasswordOncePerSession(this.getSessionData().getSession() != null && channelAccessAccessor.isConfirmationOncePerSession());
        }
        return credentialInputDTO;
    }

    public Map<PasswordType, Boolean> getPasswordTypesAtRegistration(Group group, UserRegistration userRegistration, PasswordMode passwordMode) {
        if (passwordMode != null && passwordMode != PasswordMode.MANUAL && passwordMode != PasswordMode.GENERATED) {
            throw new IllegalArgumentException("Only manual or generatd password are valid");
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        if (group.isGlobal()) {
            Channel channel = this.getSessionData().getChannel();
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            return Collections.singletonMap(channelConfiguration.getAccessPassword(), true);
        }
        if (userRegistration == UserRegistration.SMS) {
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(this.channelService.getSms());
            return Collections.singletonMap(channelConfiguration.getAccessPassword(), true);
        }
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicGroup)group);
        Set set = productsAccessor.product().getPasswordActions().keysSet((Path)QMyProductPasswordAction.myProductPasswordAction.atRegistration);
        if (passwordMode != null) {
            CollectionUtils.filter((Iterable)set, passwordType -> passwordMode == null || passwordType.getPasswordMode() == passwordMode);
        }
        List list = configurationAccessor.getPasswords();
        List list2 = configurationAccessor.getAccessPasswords();
        Map<PasswordType, Boolean> map = set.stream().filter(passwordType -> list.contains(passwordType)).filter(passwordType -> passwordMode == null || passwordType.getPasswordMode() == passwordMode).collect(Collectors.toMap(Function.identity(), passwordType -> list2.contains(passwordType)));
        return map;
    }

    public void ignoreNextConfirmationPasswords() {
        InvocationContext.ensure().setAttribute(IGNORE_CONFIRMATION_KEY, (Object)true);
    }

    @PostConstruct
    public void initialize() {
        this.virtualKeyboards = this.clusterHandler.getSharedStorage(SharedStorageType.VIRTUAL_KEYBOARDS);
    }

    public boolean matches(Password password, String string) {
        if (password == null || string == null) {
            return false;
        }
        Pair<Boolean, VirtualKeyboardData> pair = this.doValidate(password, string);
        return pair != null && Boolean.TRUE.equals(pair.getFirst());
    }

    public void notifyPasswordStatusChanged(PasswordType passwordType, BasicUser basicUser, PasswordStatus passwordStatus) {
        this.notificationHandler.user(basicUser).personal().passwordStatus(passwordType, passwordType, passwordStatus);
    }

    public PinInputDTO toPinInput(ChannelAccessAccessor channelAccessAccessor) {
        PinChannelConfiguration pinChannelConfiguration = channelAccessAccessor.getPinConfiguration();
        if (pinChannelConfiguration == null || pinChannelConfiguration.getPinLength() == null) {
            return null;
        }
        int n = pinChannelConfiguration.getPinLength();
        PinInputDTO pinInputDTO = new PinInputDTO();
        pinInputDTO.setMinLength(n);
        pinInputDTO.setMaxLength(n);
        return pinInputDTO;
    }

    public boolean wasConfirmedWithDevice() {
        return InvocationContext.ensure().getAttribute(CONFIRMATION_CREDENTIAL_TYPE_KEY) == CredentialType.DEVICE;
    }

    private void confirmationPasswordChecked(CredentialType credentialType) {
        InvocationContext.ensure().setAttribute(CONFIRMATION_CREDENTIAL_TYPE_KEY, (Object)credentialType);
    }

    private void doCheckPasswordValue(PasswordType passwordType, BasicUser basicUser, boolean bl, String string) throws PasswordException {
        boolean bl2;
        VirtualKeyboardData virtualKeyboardData;
        PasswordTypeVO passwordTypeVO = (PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType);
        if (passwordType.getPasswordMode() == PasswordMode.SCRIPT) {
            boolean bl3 = (Boolean)this.customScriptService.newAccessor(passwordType.getScript(), passwordType.getScriptParameters()).bind("user", (Object)basicUser).bind("passwordType", (Object)passwordType).bind("password", (Object)string).run(Boolean.TYPE);
            if (bl3) {
                return;
            }
            throw new InvalidPasswordException(passwordTypeVO);
        }
        Pair pair = this.passwordService.getPasswordAndStatus(basicUser, passwordType);
        Password password = (Password)pair.getFirst();
        PasswordStatus passwordStatus = (PasswordStatus)pair.getSecond();
        Pair<Boolean, VirtualKeyboardData> pair2 = this.doValidate(password, string);
        boolean bl4 = pair2 != null && Boolean.TRUE.equals(pair2.getFirst());
        VirtualKeyboardData virtualKeyboardData2 = virtualKeyboardData = pair2 == null ? null : (VirtualKeyboardData)pair2.getSecond();
        if (bl4) {
            boolean bl5;
            this.failedActionHandler.clearPasswordFailures(basicUser, passwordType, false);
            if (virtualKeyboardData != null) {
                InvocationContext.ensure().addCommitListener(false, () -> this.virtualKeyboards.remove((Object)virtualKeyboardData.getId()));
            }
            boolean bl6 = this.productsHandler.getAccessor(basicUser).product().getPasswordActions().isSet((Object)passwordType, (Path)QProductPasswordAction.productPasswordAction.change);
            boolean bl7 = bl && (bl6 || passwordType.getPasswordMode() == PasswordMode.GENERATED) ? EnumSet.of(PasswordStatus.ACTIVE, PasswordStatus.EXPIRED, PasswordStatus.RESET).contains(passwordStatus) : (bl5 = passwordStatus == PasswordStatus.ACTIVE);
            if (!bl5) {
                throw new PasswordStatusException((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType), passwordStatus);
            }
            return;
        }
        if (ObjectHelper.isOneOf((Object)passwordStatus, (Object[])new Object[]{PasswordStatus.ACTIVE, PasswordStatus.EXPIRED, PasswordStatus.RESET}) && (bl2 = this.failedActionHandler.recordPasswordFailure(basicUser, passwordType, false))) {
            boolean bl8;
            SessionData sessionData;
            if (virtualKeyboardData != null) {
                InvocationContext.ensure().addRollbackListener(false, () -> this.virtualKeyboards.remove((Object)virtualKeyboardData.getId()));
            }
            if ((sessionData = this.getSessionData()).getLoggedUser() == null && (bl8 = this.failedActionHandler.recordBlockedUserFailedAction(new UserLocatorVO(basicUser.getId())))) {
                throw new RemoteAddressBlockedException();
            }
            if (passwordType.getPasswordMode() == PasswordMode.OTP) {
                InvocationContext.ensure().addRollbackListener(true, () -> this.rawEntityManagerHandler.remove((IEntity)password));
                throw new OtpInvalidatedException();
            }
            throw new PasswordStatusException((PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)passwordType), passwordType.getInvalidAction().getPasswordStatus());
        }
        throw new InvalidPasswordException(passwordTypeVO);
    }

    private List<SendMedium> doGetAllowedOTPSendMediums(BasicUser basicUser, PasswordType passwordType) {
        List<SendMedium> list = new ArrayList<SendMedium>();
        if (passwordType != null && passwordType.getPasswordMode() == PasswordMode.OTP) {
            list = this.getAvailableSendMediums(basicUser);
            list.retainAll(passwordType.getOtpSendMediums());
        }
        return list;
    }

    private List<String> doRequestNewOTP(UserCredentials userCredentials, SendMedium sendMedium, List<Long> list) throws FrameworkException {
        PasswordType passwordType = userCredentials.getPassword();
        BasicUser basicUser = userCredentials.getUser();
        if (basicUser == null) {
            return Collections.emptyList();
        }
        Password password = (Password)this.passwordService.getPasswordAndStatus(basicUser, passwordType).getFirst();
        if (password != null) {
            this.rawEntityManagerHandler.remove((IEntity)password);
        }
        Pair pair = this.passwordService.create(basicUser, passwordType, null, PasswordStatus.ACTIVE);
        String string = (String)pair.getFirst();
        password = (Password)pair.getSecond();
        FormatterImpl formatterImpl = this.getFormatter();
        switch (sendMedium) {
            case EMAIL: {
                TranslationMessageSpecification translationMessageSpecification = new TranslationMessageSpecification(MessageFormat.HTML, passwordType.isAllowReuseOTP() ? ContentManagementKeys.Emails.NEW_OTP_BODY_REUSE_ALLOWED : ContentManagementKeys.Emails.NEW_OTP_BODY_REUSE_NOT_ALLOWED, new Object[]{ShortFormat.of((Object)this.passwordService.getExpirationDate(password))});
                String string2 = basicUser.getEmail();
                if (StringHelper.isBlank((Object)string2)) {
                    return Collections.emptyList();
                }
                this.mailHandler.send(null, basicUser, MailContext.OTP, (MailContentProducer)this.mailContentBuilder().subject(ContentManagementKeys.Emails.NEW_OTP_SUBJECT, new Object[]{passwordType}).body(ContentManagementKeys.Emails.NEW_OTP_BODY, new Object[]{passwordType, string, translationMessageSpecification}), new FileInfo[0]);
                return Collections.singletonList(string2);
            }
            case SMS: {
                TranslationMessageSpecification translationMessageSpecification = new TranslationMessageSpecification(passwordType.isAllowReuseOTP() ? AccessKeys.Passwords.NEW_OTP_BY_SMS_REUSE_ALLOWED : AccessKeys.Passwords.NEW_OTP_BY_SMS_REUSE_NOT_ALLOWED, new Object[]{ShortFormat.of((Object)this.passwordService.getExpirationDate(password))});
                String string3 = this.message(AccessKeys.Passwords.NEW_OTP_BY_SMS, this.getConfiguration().getApplicationName(), passwordType, string, translationMessageSpecification);
                ArrayList<String> arrayList = new ArrayList<String>();
                OutboundSmsStatus outboundSmsStatus = null;
                List list2 = this.conversionHandler.convertList(MobilePhone.class, list);
                List list3 = CollectionHelper.isEmpty((Iterable)list2) ? this.outboundSmsHandler.send(basicUser, string3, OutboundSmsType.OTP) : this.outboundSmsHandler.send(list2, string3, OutboundSmsType.OTP);
                for (OutboundSms outboundSms : list3) {
                    if (outboundSms.getStatus() == OutboundSmsStatus.SUCCESS) {
                        MobilePhone mobilePhone = new MobilePhone();
                        mobilePhone.setUser(basicUser);
                        mobilePhone.setNormalizedNumber(outboundSms.getPhoneNumber());
                        arrayList.add(formatterImpl.format((Phone)mobilePhone));
                        continue;
                    }
                    if (outboundSmsStatus == null) {
                        outboundSmsStatus = outboundSms.getStatus();
                        continue;
                    }
                    if (outboundSmsStatus == outboundSms.getStatus()) continue;
                    outboundSmsStatus = OutboundSmsStatus.UNKNOWN_ERROR;
                }
                if (arrayList.isEmpty()) {
                    throw new SmsSendingException("The temporary password couldn't be sent because an error has occurred", outboundSmsStatus);
                }
                return arrayList;
            }
        }
        throw new IllegalArgumentException("Unsupported OTP send medium: " + String.valueOf(sendMedium));
    }

    private Pair<Boolean, VirtualKeyboardData> doValidate(Password password, String string) {
        if (password == null) {
            return Pair.create((Object)false, null);
        }
        if (password.getType().getInputMethod() == PasswordInputMethod.TEXT_BOX) {
            boolean bl = this.isTextBoxValid(password, string);
            return Pair.create((Object)bl, null);
        }
        return this.validateVirtualKeyboard(password, string);
    }

    private List<SendMedium> getAvailableSendMediums(BasicUser basicUser) {
        boolean bl;
        boolean bl2;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        ArrayList<SendMedium> arrayList = new ArrayList<SendMedium>();
        boolean bl3 = basicUser.hasMobileEnabledForSMS();
        boolean bl4 = bl2 = StringHelper.isNotBlank((Object)basicUser.getEmail()) && StringHelper.isNotBlank((Object)configurationAccessor.getSmtpConfiguration().getHost());
        if (bl2) {
            arrayList.add(SendMedium.EMAIL);
        }
        boolean bl5 = bl = bl3 && configurationAccessor.getOutboundSmsConfiguration() != null && configurationAccessor.getOutboundSmsConfiguration().isEnabled();
        if (bl) {
            arrayList.add(SendMedium.SMS);
        }
        return arrayList;
    }

    private PasswordEncoder getPasswordEncoder(PasswordType passwordType) {
        if (passwordType == null || passwordType.getInputMethod() != PasswordInputMethod.TEXT_BOX) {
            throw new IllegalArgumentException("Input method of password type " + String.valueOf(passwordType) + " is not " + String.valueOf(PasswordInputMethod.TEXT_BOX));
        }
        int n = (Integer)ObjectHelper.defaultValue((Object)passwordType.getBcryptStrength(), (Object)10);
        return new BCryptPasswordEncoder(n);
    }

    private String getPlainPassword(Password password) {
        if (password == null) {
            return null;
        }
        PasswordType passwordType = password.getType();
        PasswordInputMethod passwordInputMethod = passwordType.getInputMethod();
        if (passwordInputMethod != PasswordInputMethod.VIRTUAL_KEYBOARD) {
            return null;
        }
        String string = password.getValue();
        if (string == null) {
            return null;
        }
        return this.applicationHandler.decrypt(string, this.keyMask(passwordType, password.getUser()));
    }

    private boolean isTextBoxValid(Password password, String string) {
        return this.getPasswordEncoder(password.getType()).matches((CharSequence)string, password.getValue());
    }

    private byte[] keyMask(PasswordType passwordType, BasicUser basicUser) {
        return ByteBuffer.allocate(16).putLong(passwordType.getId()).putLong(basicUser.getId()).array();
    }

    private void markSessionAsTrusted(TrustedDevice trustedDevice, CredentialUsage credentialUsage) {
        Session session;
        if (credentialUsage == CredentialUsage.LOGIN_CONFIRMATION && (session = this.getSessionData().getSession()) != null) {
            trustedDevice.addSession(session);
        }
    }

    private void markSessionAsValidated(ChannelAccessAccessor channelAccessAccessor, CredentialUsage credentialUsage) {
        Session session;
        if (credentialUsage == CredentialUsage.CONFIRMATION && channelAccessAccessor.isConfirmationOncePerSession() && (session = this.getSessionData().getSession()) != null) {
            session.setConfirmationValidated(true);
        }
    }

    private boolean mustConfirmWithPin(ChannelAccessAccessor channelAccessAccessor) {
        if (this.getSessionData().getPin() == null) {
            return false;
        }
        PasswordType passwordType = channelAccessAccessor.getAccessPassword();
        return passwordType != null && passwordType.equals((Object)channelAccessAccessor.getConfirmation().getPassword());
    }

    private UserCredentials resolveUserCredentials(ChannelAccessAccessor channelAccessAccessor, CredentialUsage credentialUsage) {
        return new UserCredentials(credentialUsage, channelAccessAccessor, this.getSessionData().getLoggedBasicUser());
    }

    private UserCredentials resolveUserCredentials(CredentialUsage credentialUsage) {
        InvocationContext invocationContext = InvocationContext.ensure();
        SessionData sessionData = invocationContext.sessionData();
        boolean bl = sessionData.isSystem() || sessionData.isScript() || sessionData.isGuest();
        ChannelAccessAccessor channelAccessAccessor = sessionData.getChannelAccessAccessor();
        if (!bl && credentialUsage == CredentialUsage.CONFIRMATION) {
            bl = Boolean.TRUE.equals(invocationContext.getAttribute(IGNORE_CONFIRMATION_KEY));
            Session session = sessionData.getSession();
            if (!bl && session != null) {
                bl = sessionData.isTrusted() && channelAccessAccessor.isSkipConfirmationForTrustedDevices() || channelAccessAccessor.isConfirmationOncePerSession() && session.isConfirmationValidated();
            }
            OidcAccessToken oidcAccessToken = sessionData.getAccessToken();
            if (!bl) {
                boolean bl2 = bl = oidcAccessToken != null;
            }
        }
        if (bl) {
            return UserCredentials.empty(credentialUsage);
        }
        return new UserCredentials(credentialUsage, channelAccessAccessor, sessionData.getLoggedBasicUser());
    }

    private boolean validatePasswordValue(ChannelAccessAccessor channelAccessAccessor, CredentialUsage credentialUsage, String string) {
        UserCredentials userCredentials = this.resolveUserCredentials(channelAccessAccessor, credentialUsage);
        CredentialAccessorImpl credentialAccessorImpl = new CredentialAccessorImpl(userCredentials);
        boolean bl = credentialAccessorImpl.isDefined();
        if (bl) {
            ConfirmationPasswordAccess confirmationPasswordAccess = credentialUsage == CredentialUsage.CONFIRMATION ? new ConfirmationPasswordAccess() : null;
            Validator validator = new Validator();
            credentialAccessorImpl.addRequiredValidation(validator, confirmationPasswordAccess);
            this.validate(validator, string, "validatePasswordValue");
        }
        return bl;
    }

    private Pair<Boolean, VirtualKeyboardData> validateVirtualKeyboard(Password password, String string) {
        Object object;
        int n;
        String[] stringArray;
        Object object2;
        VirtualKeyboardData virtualKeyboardData = null;
        if (string.contains("|")) {
            Object[] objectArray = StringUtils.split((String)string, (String)"|");
            try {
                object2 = objectArray[0];
                virtualKeyboardData = (VirtualKeyboardData)this.virtualKeyboards.get(object2);
                if (virtualKeyboardData == null) {
                    return null;
                }
            }
            catch (Exception exception) {
                return null;
            }
            stringArray = (String[])ArrayUtils.remove((Object[])objectArray, (int)0);
            object2 = virtualKeyboardData.getButtons();
            if (stringArray.length > object2.size()) {
                return null;
            }
            for (n = 0; n < stringArray.length; ++n) {
                String string2;
                object = StringHelper.splitTrimming((String)((String)object2.get(n)), (String)"|");
                if (object.contains(string2 = stringArray[n])) continue;
                return null;
            }
        } else {
            stringArray = StringUtils.split((String)StringHelper.delimit((String)string, (String)"|", (int)1), (String)"|");
        }
        boolean bl = false;
        object2 = this.getPlainPassword(password);
        if (stringArray.length == ((String)object2).length()) {
            bl = true;
            for (n = 0; n < ((String)object2).length(); ++n) {
                object = stringArray[n];
                if (((String)object).indexOf(((String)object2).charAt(n)) >= 0) continue;
                bl = false;
                break;
            }
        }
        return Pair.create((Object)bl, (Object)virtualKeyboardData);
    }

    private class CredentialAccessorImpl
    implements CredentialAccessor {
        private UserCredentials credentials;
        private boolean mustUsePin;
        private PasswordStatus passwordStatus;
        private Boolean hasTrustedDevices;
        private Boolean hasTotp;
        private List<CredentialType> activeCredentials;

        public CredentialAccessorImpl(UserCredentials userCredentials) {
            this.credentials = userCredentials;
            SessionData sessionData = PasswordHandlerImpl.this.getSessionData();
            if (userCredentials.getUsage() == CredentialUsage.CONFIRMATION && userCredentials.getUser() != null && userCredentials.getUser().equals((Object)sessionData.getLoggedBasicUser()) && PasswordHandlerImpl.this.mustConfirmWithPin(sessionData.getChannelAccessAccessor())) {
                this.mustUsePin = true;
            }
        }

        public void addRequiredValidation(Validator validator, Property<?, ?> property) {
            this.addRequiredValidation(validator, (PropertyAccess)new BeanPropertyAccess(property));
        }

        public void addRequiredValidation(Validator validator, PropertyAccess propertyAccess) {
            if (this.isDefined()) {
                if (propertyAccess == null) {
                    this.addGeneralValidations(validator);
                } else {
                    this.addPropertyValidations(validator, propertyAccess);
                }
            }
        }

        public boolean canActivateCredentials() {
            List<CredentialType> list = this.getActiveCredentials();
            for (CredentialType credentialType : this.getAllowedCredentials()) {
                if (list.contains(credentialType) || !this.canActivate(credentialType)) continue;
                return true;
            }
            return false;
        }

        public boolean canBeUsed() {
            return this.hasPassword() && (this.isPasswordExpired() || this.isPasswordActive()) || this.isDevice() && this.hasDevice() || this.isTotp() && this.hasTotp();
        }

        public void check(String string, CreateDeviceConfirmationParams createDeviceConfirmationParams) {
            if (!this.isDefined()) {
                return;
            }
            PasswordHandlerImpl.this.checkCredential(this.credentials.getChannelAccessAccessor(), this.credentials.getUsage(), UserPrincipals.username((BasicUser)this.credentials.getUser()), createDeviceConfirmationParams, this.credentials.getUsage() == CredentialUsage.LOGIN_CONFIRMATION, string);
        }

        public List<CredentialType> getActiveCredentials() {
            if (this.activeCredentials == null) {
                this.activeCredentials = new ArrayList<CredentialType>();
                if (this.mustUsePin) {
                    this.activeCredentials.add(CredentialType.PIN);
                } else {
                    if (this.hasPassword() && this.isPasswordActive()) {
                        this.activeCredentials.add(CredentialType.PASSWORD);
                    }
                    if (this.isDevice() && this.hasDevice()) {
                        this.activeCredentials.add(CredentialType.DEVICE);
                    }
                    if (this.isTotp() && this.hasTotp()) {
                        this.activeCredentials.add(CredentialType.TOTP);
                    }
                }
            }
            return this.activeCredentials;
        }

        public CredentialInputDTO getCredentialInput() {
            if (!this.isDefined()) {
                return null;
            }
            return PasswordHandlerImpl.this.getCredentialInput(this.credentials.getChannelAccessAccessor(), this.credentials.getUsage(), this.credentials.getUser());
        }

        public List<SendMedium> getOtpSendMediums() {
            return PasswordHandlerImpl.this.doGetAllowedOTPSendMediums(this.credentials.getUser(), this.getPassword());
        }

        public PasswordType getPassword() {
            return this.credentials.getPassword();
        }

        public boolean hasExpired() {
            return this.hasPassword() && this.isPasswordExpired();
        }

        public boolean isDevice() {
            return this.credentials.isDevice();
        }

        public boolean isTotp() {
            return this.credentials.isTotp();
        }

        public List<String> requestNewOTP(@NotNull SendMedium sendMedium, List<Long> list) throws SmsSendingException {
            return PasswordHandlerImpl.this.doRequestNewOTP(this.credentials, sendMedium, list);
        }

        private void addGeneralValidations(Validator validator) {
            MessageKey messageKey = AccessKeys.Passwords.CONFIRMATION_PASSWORD;
            validator.general(GeneralValidations.required((MessageKey)GeneralKeys.Errors.REQUIRED, (Object[])new Object[]{messageKey}));
            validator.general(object -> this.isValid((String)object) ? null : new ValidationError(GeneralKeys.Errors.INVALID, new Object[]{messageKey}));
        }

        private void addPropertyValidations(Validator validator, PropertyAccess propertyAccess) {
            org.cyclos.impl.utils.validation.Property property = validator.property(propertyAccess, AccessKeys.Passwords.CONFIRMATION_PASSWORD);
            property.required();
            property.add((object, object2, object3) -> this.isValid((String)object3) ? null : ValidationErrors.invalid());
        }

        private boolean canActivate(CredentialType credentialType) {
            SessionData sessionData = PasswordHandlerImpl.this.getSessionData();
            Session session = sessionData.getSession();
            boolean bl = session != null && !session.isPendingLoginConfirmation();
            switch (credentialType) {
                case PASSWORD: 
                case PIN: {
                    boolean bl2;
                    Set set = (Set)PasswordHandlerImpl.this.passwordService.getStatusAndActions(sessionData.getLoggedBasicUser(), this.getPassword()).getSecond();
                    boolean bl3 = bl2 = set.contains(PasswordAction.CHANGE) || set.contains(PasswordAction.ACTIVATE);
                    if (credentialType == CredentialType.PIN) {
                        PinChannelConfiguration pinChannelConfiguration = sessionData.getChannelAccessAccessor().getPinConfiguration();
                        bl2 &= bl && pinChannelConfiguration != null;
                    }
                    return bl2;
                }
                case TOTP: {
                    return true;
                }
                case DEVICE: {
                    return bl;
                }
            }
            return false;
        }

        private void ensurePasswordStatusIfUsed() {
            if (this.hasPassword() && this.passwordStatus == null) {
                this.passwordStatus = PasswordHandlerImpl.this.passwordService.getRedundantAccessPasswordStatus(this.credentials.getUser(), this.getPassword());
            }
        }

        private boolean hasDevice() {
            if (this.hasTrustedDevices == null) {
                this.hasTrustedDevices = this.isDevice() && PasswordHandlerImpl.this.trustedDeviceService.hasActiveDevices(PasswordHandlerImpl.this.getLoggedBasicUser());
            }
            return this.hasTrustedDevices;
        }

        private boolean hasTotp() {
            if (this.hasTotp == null) {
                this.hasTotp = this.isTotp() && PasswordHandlerImpl.this.totpService.isActive(this.credentials.getUser());
            }
            return this.hasTotp;
        }

        private boolean isPasswordActive() {
            this.ensurePasswordStatusIfUsed();
            return ObjectHelper.isOneOf((Object)this.passwordStatus, (Object[])new Object[]{PasswordStatus.ACTIVE});
        }

        private boolean isPasswordExpired() {
            this.ensurePasswordStatusIfUsed();
            return ObjectHelper.isOneOf((Object)this.passwordStatus, (Object[])new Object[]{PasswordStatus.EXPIRED, PasswordStatus.RESET});
        }

        private boolean isValid(String string) {
            if (StringHelper.isBlank((Object)string)) {
                return true;
            }
            if (this.credentials.hasPassword()) {
                return true;
            }
            return this.credentials.isTotp() && string.startsWith("totp:") || this.credentials.isDevice() && string.startsWith("confirmation:");
        }
    }

    private static class ConfirmationPasswordAccess
    implements PropertyAccess {
        private ConfirmationPasswordAccess() {
        }

        public Object get(Object object) {
            return object;
        }

        public Object getIdentifier() {
            return this.getPropertyName();
        }

        public String getPropertyName() {
            return "confirmationPassword";
        }
    }
}

