/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.QPasswordType;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.QUserManagementProduct;
import org.cyclos.entities.utils.IntegerRange;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.PasswordTypeServiceLocal;
import org.cyclos.impl.system.ChannelConfigurationServiceLocal;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.model.Availability;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.passwordtypes.InvalidPasswordAction;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeDTO;
import org.cyclos.model.access.passwordtypes.PasswordTypeData;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PasswordTypeServiceImpl
extends CRUDServiceImpl<PasswordType, QPasswordType, PasswordTypeDTO, PasswordTypeData, Void>
implements PasswordTypeServiceLocal {
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private ChannelConfigurationServiceLocal channelConfigurationService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    public PasswordTypeServiceImpl() {
        super(PasswordType.class, QPasswordType.passwordType, PasswordTypeDTO.class);
    }

    public PasswordType getByName(String string) throws FrameworkException {
        return (PasswordType)((DBQuery)this.from(this.$).where((Predicate)((QPasswordType)this.$).name.eq((Object)string))).requiredUniqueResult((Expression)this.$);
    }

    public List<PasswordTypeVO> list() {
        return ((DBQuery)this.from().orderBy(((QPasswordType)this.$).name.asc())).list(PasswordTypeVO.class, (Expression)this.$);
    }

    public List<PasswordType> listAll() {
        return ((DBQuery)this.from().orderBy(((QPasswordType)this.$).name.asc())).list((Expression)this.$);
    }

    @Override
    public PasswordType newEntity(Void void_) {
        PasswordType passwordType = new PasswordType();
        passwordType.setPasswordMode(PasswordMode.MANUAL);
        passwordType.setInputMethod(PasswordInputMethod.TEXT_BOX);
        passwordType.setBcryptStrength(Integer.valueOf(10));
        passwordType.setLowerCaseLetters(Availability.OPTIONAL);
        passwordType.setUpperCaseLetters(Availability.OPTIONAL);
        passwordType.setNumbers(Availability.OPTIONAL);
        passwordType.setSpecialCharacters(Availability.OPTIONAL);
        passwordType.setLength(new IntegerRange(Integer.valueOf(4), Integer.valueOf(4)));
        passwordType.setInvalidAttempts(Integer.valueOf(3));
        passwordType.setInvalidAction(InvalidPasswordAction.TEMPORARILY_BLOCK);
        passwordType.setBlockTime(new TimeInterval(Integer.valueOf(15), TimeField.MINUTES));
        passwordType.setExpiresAfter(new TimeInterval(Integer.valueOf(1), TimeField.YEARS));
        return passwordType;
    }

    @Override
    protected PasswordTypeData getData(PasswordType passwordType) {
        PasswordTypeData passwordTypeData = new PasswordTypeData();
        passwordTypeData.setDto((EntityDTO)((PasswordTypeDTO)this.toDTO(passwordType)));
        if (this.getSessionData().getNetwork() == null) {
            passwordTypeData.setModes(Arrays.asList(PasswordMode.MANUAL, PasswordMode.GENERATED, PasswordMode.OTP));
        } else {
            passwordTypeData.setModes(Arrays.asList(PasswordMode.values()));
            if (passwordType.isTransient() || passwordType.getPasswordMode() == PasswordMode.SCRIPT) {
                passwordTypeData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.PASSWORD_HANDLING)));
            }
        }
        passwordTypeData.setMinBCryptStrength(this.minBCryptStrength());
        passwordTypeData.setMaxBCryptStrength(this.maxBCryptStrength());
        return passwordTypeData;
    }

    @Override
    protected void onAfterRemove(PasswordType passwordType) {
        Long l = SimpleEntity.id((SimpleEntity)passwordType.getNetwork());
        List list = PropertyHelper.getGetterNames((Path[])new Path[]{QProduct.product.passwordActions, QUserManagementProduct.userManagementProduct.userPasswordActions});
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, (Collection)list));
    }

    @Override
    protected void onAfterSave(PasswordType passwordType, PasswordType passwordType2, Object object) {
        if (passwordType2 == null) {
            this.productService.updateProductPasswordActions(passwordType);
        }
    }

    @Override
    protected Object onBeforeSave(PasswordType passwordType, PasswordType passwordType2) {
        PasswordMode passwordMode = passwordType.getPasswordMode();
        if (passwordMode == PasswordMode.SCRIPT) {
            passwordType.setInputMethod(PasswordInputMethod.TEXT_BOX);
            passwordType.setLength(null);
            passwordType.setAvoidObvious(false);
            passwordType.setAvoidRepeatedValue(false);
            passwordType.setLowerCaseLetters(null);
            passwordType.setUpperCaseLetters(null);
            passwordType.setNumbers(null);
            passwordType.setSpecialCharacters(null);
            passwordType.setExpiresAfter(null);
            passwordType.setInvalidAction(null);
            passwordType.setBlockTime(null);
        } else if (passwordMode == PasswordMode.OTP) {
            passwordType.setInvalidAction(null);
        }
        if (passwordMode.isGeneratedPassword()) {
            passwordType.setUpperCaseLetters(Availability.DISABLED);
            passwordType.setSpecialCharacters(Availability.DISABLED);
        }
        if (passwordType.getInputMethod() != PasswordInputMethod.TEXT_BOX) {
            passwordType.setBcryptStrength(null);
        }
        if (passwordType.getInputMethod() != PasswordInputMethod.VIRTUAL_KEYBOARD) {
            passwordType.setNumberOfRows(null);
            passwordType.setNumberOfButtons(null);
            passwordType.setCharactersPerButton(null);
            passwordType.setPossibleCharacters(null);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(PasswordTypeDTO passwordTypeDTO, PasswordType passwordType) {
        passwordType.getOtpSendMediums().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QPasswordType)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(PasswordTypeDTO passwordTypeDTO) {
        PasswordType passwordType;
        Validator validator = new Validator();
        PasswordType passwordType2 = passwordType = passwordTypeDTO.isTransient() ? null : (PasswordType)this.find(passwordTypeDTO.getId());
        if (passwordTypeDTO.getPasswordMode() == PasswordMode.SCRIPT) {
            validator.property((Property)PasswordTypeDTO.SCRIPT, AccessKeys.PasswordTypes.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

                protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                    return customScript.getType() == ScriptType.PASSWORD_HANDLING;
                }
            });
        } else {
            if (passwordTypeDTO.getInputMethod() != PasswordInputMethod.VIRTUAL_KEYBOARD) {
                validator.property((Property)PasswordTypeDTO.BCRYPT_STRENGTH, AccessKeys.PasswordTypes.BCRYPT_STRENGTH).required().between((Comparable)Integer.valueOf(this.minBCryptStrength()), (Comparable)Integer.valueOf(this.maxBCryptStrength()));
                validator.property((Property)PasswordTypeDTO.LOWER_CASE_LETTERS, AccessKeys.PasswordTypes.LOWER_CASE_LETTERS).required();
                validator.property((Property)PasswordTypeDTO.UPPER_CASE_LETTERS, AccessKeys.PasswordTypes.UPPER_CASE_LETTERS).required();
                validator.property((Property)PasswordTypeDTO.NUMBERS, AccessKeys.PasswordTypes.NUMBERS).required();
                validator.property((Property)PasswordTypeDTO.SPECIAL_CHARACTERS, AccessKeys.PasswordTypes.SPECIAL_CHARACTERS).required();
            }
            validator.property((Property)PasswordTypeDTO.INVALID_ATTEMPTS, AccessKeys.PasswordTypes.INVALID_ATTEMPTS).required().between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(99));
            validator.property((Property)PasswordTypeDTO.INVALID_ACTION, AccessKeys.PasswordTypes.INVALID_ACTION).required();
            if (passwordTypeDTO.getInvalidAction() == InvalidPasswordAction.TEMPORARILY_BLOCK) {
                validator.property((Property)PasswordTypeDTO.BLOCK_TIME, AccessKeys.PasswordTypes.BLOCK_TIME).required().minInterval(0, TimeField.SECONDS).maxInterval(999, TimeField.DAYS);
            }
            validator.property((Property)PasswordTypeDTO.INPUT_METHOD, AccessKeys.PasswordTypes.INPUT_METHOD).required();
            int n = 3;
            int n2 = 50;
            validator.property((Property)PasswordTypeDTO.LENGTH, AccessKeys.PasswordTypes.LENGTH).range(RangeOptionalType.BOTH_REQUIRED).nested((Property)IntegerRangeDTO.MIN, GeneralKeys.Ui.RANGE_MIN).between((Comparable)Integer.valueOf(n), (Comparable)Integer.valueOf(n2)).nested((Property)IntegerRangeDTO.MAX, GeneralKeys.Ui.RANGE_MAX).between((Comparable)Integer.valueOf(n), (Comparable)Integer.valueOf(n2));
            validator.property((Property)PasswordTypeDTO.EXPIRES_AFTER, AccessKeys.PasswordTypes.EXPIRES_AFTER).required().timeInterval();
            if (passwordTypeDTO.getInputMethod() == PasswordInputMethod.VIRTUAL_KEYBOARD) {
                validator.property((Property)PasswordTypeDTO.CHARACTERS_PER_BUTTON, AccessKeys.PasswordTypes.CHARACTERS_PER_BUTTON).required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(8));
                validator.property((Property)PasswordTypeDTO.NUMBER_OF_BUTTONS, AccessKeys.PasswordTypes.NUMBER_OF_BUTTONS).required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(30));
                org.cyclos.impl.utils.validation.Property property = validator.property((Property)PasswordTypeDTO.NUMBER_OF_ROWS, AccessKeys.PasswordTypes.NUMBER_OF_ROWS);
                property.required().between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(30));
                Integer n3 = passwordTypeDTO.getNumberOfButtons();
                if (n3 != null) {
                    int n4 = n3;
                    int n5 = (int)Math.ceil((float)n3.intValue() / 10.0f);
                    property.greaterEquals((Comparable)Integer.valueOf(n5));
                    int n6 = (Integer)ObjectHelper.defaultValue((Object)passwordTypeDTO.getCharactersPerButton(), (Object)1);
                    if (passwordTypeDTO.getPossibleCharacters() != null && n4 * n6 < passwordTypeDTO.getPossibleCharacters().length() && passwordTypeDTO.getPasswordMode() == PasswordMode.OTP) {
                        validator.general(GeneralValidations.invalid((MessageKey)AccessKeys.PasswordTypes.ERROR_VK_LESS_BUTTONS_OTP, (Object[])new Object[0]));
                    }
                }
                org.cyclos.impl.utils.validation.Property property2 = validator.property((Property)PasswordTypeDTO.POSSIBLE_CHARACTERS, AccessKeys.PasswordTypes.POSSIBLE_CHARACTERS);
                property2.required().add(this.noRepeatedChars()).minLength(4);
                if (passwordType != null && this.channelConfigurationService.isUsedForAccess(passwordType) && !passwordType.getPossibleCharacters().equals(passwordTypeDTO.getPossibleCharacters())) {
                    property2.invalid(new ValidationError(AccessKeys.PasswordTypes.ERROR_POSSIBLE_CHARACTERS_IN_USE_FOR_ACCESS, new Object[]{passwordType.getPossibleCharacters()}));
                }
            } else if (passwordTypeDTO.getInputMethod() == PasswordInputMethod.TEXT_BOX) {
                int n7 = 0;
                if (passwordTypeDTO.getLowerCaseLetters() != Availability.DISABLED) {
                    ++n7;
                }
                if (passwordTypeDTO.getUpperCaseLetters() != Availability.DISABLED) {
                    ++n7;
                }
                if (passwordTypeDTO.getNumbers() != Availability.DISABLED) {
                    ++n7;
                }
                if (passwordTypeDTO.getSpecialCharacters() != Availability.DISABLED) {
                    ++n7;
                }
                if (n7 == 0) {
                    validator.general(GeneralValidations.invalid((ValidationError)new ValidationError(AccessKeys.PasswordTypes.ERROR_NO_CHARSET_SELECTED)));
                }
            }
            if (passwordTypeDTO.getPasswordMode() == PasswordMode.OTP) {
                validator.property((Property)PasswordTypeDTO.OTP_SEND_MEDIUMS, AccessKeys.PasswordTypes.OTP_SEND_MEDIUMS).required();
            }
            validator.property((Property)PasswordTypeDTO.EXPIRES_AFTER, AccessKeys.PasswordTypes.EXPIRES_AFTER).minInterval(1, TimeField.MINUTES).timeInterval();
        }
        return validator;
    }

    private int maxBCryptStrength() {
        return Math.min(this.cyclosProperties.getMaxBCryptStrength(), 31);
    }

    private int minBCryptStrength() {
        return 4;
    }

    private PropertyValidation noRepeatedChars() {
        return (object, object2, object3) -> {
            if (object3 != null) {
                String string = object3.toString();
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    int n = string.indexOf(Character.toString(c));
                    if (n < 0 || n == i) continue;
                    return new ValidationError(GeneralKeys.Errors.REPEATED_CHARACTERS);
                }
            }
            return null;
        };
    }
}

