/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.mutable.MutableLong;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.BuiltInPrincipalType;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.CustomFieldPrincipalType;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.QChannel;
import org.cyclos.entities.access.QPin;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.PinChannelConfiguration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.QGroup;
import org.cyclos.entities.users.QOperator;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.AccessClientSessionData;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.utils.PasswordHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.NamedEntityDTO;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidPasswordException;
import org.cyclos.model.access.InvalidPinRemovedException;
import org.cyclos.model.access.PasswordStatusException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.pins.CreatePinDTO;
import org.cyclos.model.access.pins.CurrentCredentialsForPinManage;
import org.cyclos.model.access.pins.NewCredentialsForPinManage;
import org.cyclos.model.access.pins.PinDTO;
import org.cyclos.model.access.pins.PinData;
import org.cyclos.model.access.pins.PinDetailedVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.pins.PinVO;
import org.cyclos.model.access.pins.SetPinParams;
import org.cyclos.model.access.pins.UserPinsData;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.ICustomField;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class PinServiceImpl
extends BaseServiceImpl
implements PinServiceLocal {
    private static final int PIN_BCRYPT_DEFAULT_STRENGTH = 4;
    private static QPin $ = QPin.pin;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private UserChannelServiceLocal userChannelService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private SessionHandler sessionHandler;

    public void checkPin(Pin pin, String string, ChannelAccessAccessor channelAccessAccessor) {
        boolean bl;
        PinChannelConfiguration pinChannelConfiguration = this.ensurePinEnabledForCurrentChannel(channelAccessAccessor);
        if (this.hasExpired(pinChannelConfiguration.getPinExpiresAfter(), pin.getDate())) {
            throw new PasswordStatusException(null, PasswordStatus.EXPIRED);
        }
        PasswordType passwordType = channelAccessAccessor.getAccessPassword();
        Channel channel = channelAccessAccessor.getChannel();
        boolean bl2 = bl = pin.getChannel().equals((Object)channel) && pin.getPasswordType().equals((Object)passwordType) && new BCryptPasswordEncoder(4).matches((CharSequence)string, pin.getValue());
        if (!bl) {
            boolean bl3 = this.failedActionHandler.recordPinFailure(pin, pinChannelConfiguration.getMaxPinTries(), () -> this.remove((IEntity)pin));
            throw bl3 ? new InvalidPinRemovedException() : new InvalidPasswordException();
        }
        this.failedActionHandler.clearPinFailures(pin);
    }

    public Pin ensurePin(PinLocatorVO pinLocatorVO) {
        Pin pin;
        Pin pin2 = pin = pinLocatorVO == null ? this.getSessionData().getPin() : (Pin)this.conversionHandler.convert(Pin.class, (Object)pinLocatorVO);
        if (pin == null) {
            throw new ValidationException(this.message(GeneralKeys.Errors.REQUIRED, "PIN"));
        }
        return pin;
    }

    public UserPinsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        UserPinsData userPinsData = new UserPinsData();
        userPinsData.setEnabled(this.pinEnabled(basicUser));
        return userPinsData;
    }

    public PinData getEditData(PinLocatorVO pinLocatorVO) throws FrameworkException {
        Pin pin = this.ensurePin(pinLocatorVO);
        PinData pinData = new PinData();
        pinData.setPin((PinDTO)this.conversionHandler.convert(PinDTO.class, (Object)pin));
        pinData.setCanManage(true);
        return pinData;
    }

    public Pair<Pin, ChannelAccessAccessor> getIfActive(PinLocatorVO pinLocatorVO, Channel channel) {
        try {
            QPin qPin;
            Pin pin;
            if (pinLocatorVO.getId() != null) {
                pin = (Pin)this.rawEntityManagerHandler.find(Pin.class, pinLocatorVO.getId());
            } else if (StringHelper.isNotBlank((Object)pinLocatorVO.getPrincipal())) {
                qPin = QPin.pin;
                pin = (Pin)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qPin}).where((com.querydsl.core.types.Predicate)qPin.pinPrincipal.eq((Object)pinLocatorVO.getPrincipal()))).requiredUniqueResult((Expression)qPin);
            } else {
                throw new IllegalActionException();
            }
            if (!pin.getChannel().equals((Object)channel)) {
                return null;
            }
            qPin = this.configurationHandler.getAccessAccessor(pin.getBasicUser()).getChannelConfiguration(channel);
            PinChannelConfiguration pinChannelConfiguration = qPin.getPinConfiguration();
            if (pinChannelConfiguration != null && pin.getPasswordType().equals((Object)qPin.getAccessPassword()) && qPin.getPrincipalTypes().contains(pin.getPrincipalType()) && !this.hasExpired(pinChannelConfiguration.getPinExpiresAfter(), pin.getDate()) && this.isPrincipalStillValid(pin)) {
                return Pair.create((Object)pin, (Object)qPin);
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public CredentialInputDTO getPasswordInputForCreate() throws FrameworkException {
        PinChannelConfiguration pinChannelConfiguration = this.getSessionData().getChannelAccessAccessor().getPinConfiguration();
        if (pinChannelConfiguration == null || pinChannelConfiguration.getPinLength() == null) {
            throw new IllegalActionException("Pin is not enabled");
        }
        return this.passwordHandler.accessor(CredentialUsage.ACCESS).getCredentialInput();
    }

    @PostConstruct
    public void initialize() {
        this.restBeanPropertyMapping.register((Property)NestedProperty.nested((Property)SetPinParams.NEW_AND_CURRENT_CREDENTIALS, (Property)NewCredentialsForPinManage.PIN), "pin");
        this.restBeanPropertyMapping.register((Property)NestedProperty.nested((Property)SetPinParams.NEW_AND_CURRENT_CREDENTIALS, (Property)NewCredentialsForPinManage.PIN_CONFIRMATION), "pinConfirmation");
        this.restBeanPropertyMapping.register((Property)NestedProperty.nested((Property)SetPinParams.NEW_AND_CURRENT_CREDENTIALS, (Property)NewCredentialsForPinManage.CURRENT_PIN), "currentPin");
        this.restBeanPropertyMapping.register((Property)NestedProperty.nested((Property)SetPinParams.NEW_AND_CURRENT_CREDENTIALS, (Property)NewCredentialsForPinManage.CURRENT_PASSWORD), "currentPassword");
    }

    public List<PinVO> list(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = userLocatorVO == null ? this.getLoggedBasicUser() : this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)$.user().eq((Object)basicUser))).orderBy(PinServiceImpl.$.name.asc())).list(PinVO.class, (Expression)$);
    }

    public PinDetailedVO locate(PinLocatorVO pinLocatorVO) {
        Pin pin = this.locatePin(pinLocatorVO, false);
        PinDetailedVO pinDetailedVO = this.toPinDetaileVo(pin);
        return pinDetailedVO;
    }

    public Pin locatePin(PinLocatorVO pinLocatorVO, boolean bl) {
        Pin pin = null;
        if (pinLocatorVO != null && (pin = (Pin)pinLocatorVO.getAttribute("pin")) == null) {
            if (pinLocatorVO.getId() != null) {
                pin = this.find(Pin.class, pinLocatorVO.getId());
            } else if (StringHelper.isNotBlank((Object)pinLocatorVO.getPrincipal())) {
                pin = (Pin)((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)PinServiceImpl.$.pinPrincipal.eq((Object)pinLocatorVO.getPrincipal()))).requiredUniqueResult((Expression)$);
                this.entityManagerHandler.checkAccess((IEntity)pin);
            }
        }
        if (pin == null || bl && !pin.getBasicUser().equals((Object)this.getLoggedBasicUser())) {
            throw new EntityNotFoundException(Pin.class);
        }
        pinLocatorVO.setAttribute("pin", (Object)pin);
        return pin;
    }

    public boolean pinEnabled(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessAccessor(basicUser);
        for (Channel channel : this.userChannelService.getAccessibleChannels(basicUser)) {
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            PinChannelConfiguration pinChannelConfiguration = channelConfiguration.getPinConfiguration();
            if (pinChannelConfiguration == null || pinChannelConfiguration.getPinLength() == null) continue;
            return true;
        }
        return false;
    }

    public <T extends NetworkedEntity> void relatedEntityRemoved(T t, Supplier<T> supplier) {
        if (t instanceof MobilePhone) {
            MobilePhone mobilePhone = (MobilePhone)t;
            if (((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)$.mobilePhone().eq((Object)mobilePhone))).hasResults()) {
                MobilePhone mobilePhone2 = (MobilePhone)supplier.get();
                if (mobilePhone2 == null) {
                    ((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)$.mobilePhone().eq((Object)mobilePhone))).stream((Expression)$).forEach(pin -> this.rawEntityManagerHandler.remove((IEntity)pin));
                } else {
                    this.update((EntityPath<?>)$).set((Path)$.mobilePhone(), (Object)mobilePhone2).where(new com.querydsl.core.types.Predicate[]{$.mobilePhone().eq((Object)mobilePhone)}).execute();
                }
            }
        } else if (t instanceof Token) {
            ((DBQuery)this.from(new EntityPath[]{$}).where((com.querydsl.core.types.Predicate)PinServiceImpl.$.token().id.eq((Object)t.getId()))).stream((Expression)$).forEach(pin -> this.rawEntityManagerHandler.remove((IEntity)pin));
        } else if (t instanceof UserAccount) {
            UserAccount userAccount = (UserAccount)t;
            ((DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{$.accountType().eq((Object)userAccount.getType()), $.user().eq((Object)userAccount.getUser())})).stream((Expression)$).forEach(pin -> this.rawEntityManagerHandler.remove((IEntity)pin));
        } else if (t instanceof UserCustomFieldValue) {
            // empty if block
        }
    }

    public void remove(PinLocatorVO pinLocatorVO, CurrentCredentialsForPinManage currentCredentialsForPinManage) throws FrameworkException {
        Pin pin = this.ensurePin(pinLocatorVO);
        this.checkCurrentCredentials(pin, currentCredentialsForPinManage);
        Session session = this.getSessionData().getSession();
        if (session != null && pin.equals((Object)session.getPin())) {
            session.setPin(null);
            this.entityManagerHandler.flush();
        }
        this.rawEntityManagerHandler.remove((IEntity)pin);
    }

    public long removeExpired() {
        QChannel qChannel = QChannel.channel;
        List list = this.rawEntityManagerHandler.selectFrom((EntityPath)qChannel).fetch();
        MutableLong mutableLong = new MutableLong();
        QGroup qGroup = QGroup.group;
        this.processBatch(this.rawEntityManagerHandler.selectFrom((EntityPath)qGroup).iterate(), (T group) -> mutableLong.add(this.removeExpired((Group)group, list)));
        return mutableLong.longValue();
    }

    public void save(PinDTO pinDTO) throws FrameworkException {
        if (pinDTO.isTransient()) {
            throw new IllegalActionException("This method only supports updating a device PIN. To create a new one, use the set() method");
        }
        this.validate(pinDTO);
        Pin pin = (Pin)this.conversionHandler.convert(Pin.class, (Object)pinDTO);
        if (pin.getTrustedDevice() != null) {
            pin.getTrustedDevice().setName(pin.getName());
        }
    }

    public CreatePinDTO set(SetPinParams setPinParams) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        this.ensurePinEnabledForCurrentChannel(sessionData.getChannelAccessAccessor());
        if (setPinParams.getAccessClient() != null) {
            throw new IllegalArgumentException("Pin for Access Clients is not supported");
        }
        if (sessionData.unwrap() instanceof AccessClientSessionData) {
            throw new IllegalArgumentException("Can not set a Pin when using an Access client");
        }
        Pin pin = sessionData.getPin();
        if (pin == null && setPinParams.getPinLocator() != null) {
            pin = this.locatePin(setPinParams.getPinLocator(), true);
        }
        this.validate(sessionData, setPinParams, pin);
        Session session = sessionData.getSession();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (pin == null) {
            this.checkCurrentCredentials(session, setPinParams.getPinCreationToken(), setPinParams.getNewAndCurrentCredentials().getCurrentPassword());
            pin = new Pin();
            if (setPinParams.getDeviceId() != null) {
                pin.setTrustedDevice(this.trustedDeviceService.loadForOperate(setPinParams.getDeviceId().longValue()));
                pin.setName(pin.getTrustedDevice().getName());
            } else {
                pin.setName(this.getUniquePinName(basicUser, setPinParams.getName()));
            }
            this.initFrom(pin, sessionData);
        } else {
            this.checkCurrentCredentials(pin, (CurrentCredentialsForPinManage)setPinParams.getNewAndCurrentCredentials());
        }
        String string = SecureRandomHelper.randomAlphanumeric((int)32);
        pin.setPinPrincipal(this.generatePrincipal(basicUser));
        pin.setValue(this.encode(setPinParams.getNewAndCurrentCredentials().getPin(), string));
        pin.setDate(new Date());
        if (pin.isTransient()) {
            this.persist((IEntity)pin);
        }
        if (session != null && session.isPersistent()) {
            session.setPin(pin);
            this.sessionHandler.clearPinCreationToken(session);
        }
        CreatePinDTO createPinDTO = new CreatePinDTO();
        PinDetailedVO pinDetailedVO = this.toPinDetaileVo(pin);
        createPinDTO.setPin(pinDetailedVO);
        createPinDTO.setPrincipal(pin.getPinPrincipal());
        createPinDTO.setSalt(string);
        return createPinDTO;
    }

    public ValidationResult validate(@NotNull String string) {
        SessionData sessionData = this.getSessionData();
        PinChannelConfiguration pinChannelConfiguration = sessionData.getChannelAccessAccessor().getPinConfiguration();
        if (pinChannelConfiguration == null || pinChannelConfiguration.getPinLength() == null) {
            throw new IllegalActionException("Pin is not enabled");
        }
        SetPinParams setPinParams = new SetPinParams();
        setPinParams.setName("Fake name");
        NewCredentialsForPinManage newCredentialsForPinManage = new NewCredentialsForPinManage();
        newCredentialsForPinManage.setPin(string);
        newCredentialsForPinManage.setPinConfirmation(string);
        setPinParams.setNewAndCurrentCredentials(newCredentialsForPinManage);
        try {
            this.validate(sessionData, setPinParams, null);
            return null;
        }
        catch (ValidationException validationException) {
            return validationException.getValidation();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.user().network(), true);
    }

    private void checkCurrentCredentials(Pin pin, CurrentCredentialsForPinManage currentCredentialsForPinManage) {
        if (!pin.getUser().equals((Object)this.getLoggedBasicUser())) {
            return;
        }
        String string = currentCredentialsForPinManage.getCurrentPin();
        String string2 = currentCredentialsForPinManage.getCurrentPassword();
        Supplier<CredentialAccessor> supplier = () -> this.passwordHandler.accessor(CredentialUsage.ACCESS);
        this.ensureOnlyOne(string, string2, AccessKeys.Pins.ERROR_PIN_MANAGE_CURRENT_CREDENTIALS_ALL_NULL, AccessKeys.Pins.ERROR_PIN_MANAGE_CURRENT_CREDENTIALS_ALL_NOT_NULL, supplier);
        if (StringHelper.isNotBlank((Object)string2)) {
            supplier.get().check(string2, null);
        } else {
            this.checkPin(pin, string, this.getSessionData().getChannelAccessAccessor());
        }
    }

    private void checkCurrentCredentials(Session session, String string, String string2) {
        Supplier<CredentialAccessor> supplier = () -> this.passwordHandler.accessor(CredentialUsage.ACCESS);
        this.ensureOnlyOne(string, string2, AccessKeys.Pins.ERROR_PIN_MANAGE_CURRENT_PASSWORD_OR_TOKEN_ALL_NULL, AccessKeys.Pins.ERROR_PIN_MANAGE_CURRENT_PASSWORD_OR_TOKEN_ALL_NOT_NULL, supplier);
        if (StringHelper.isNotBlank((Object)string2)) {
            supplier.get().check(string2, null);
        } else if (StringHelper.isBlank((Object)string) || !string.equals(this.sessionHandler.getPinCreationToken(session))) {
            throw new ValidationException(this.message(AccessKeys.Pins.ERROR_PIN_MANAGE_INVALID_CREATION_TOKEN, new Object[0]));
        }
    }

    private String encode(String string, String string2) {
        return new BCryptPasswordEncoder(4).encode((CharSequence)(string2 + string));
    }

    private void ensureOnlyOne(String string, String string2, MessageKey messageKey, MessageKey messageKey2, Supplier<CredentialAccessor> supplier) throws ValidationException {
        if (StringHelper.areAllBlanks((Object[])new Object[]{string, string2})) {
            throw new ValidationException(this.message(messageKey, supplier.get().getPassword()));
        }
        if (StringHelper.areAllNotBlanks((Object[])new Object[]{string, string2})) {
            throw new ValidationException(this.message(messageKey2, supplier.get().getPassword()));
        }
    }

    private PinChannelConfiguration ensurePinEnabledForCurrentChannel(ChannelAccessAccessor channelAccessAccessor) {
        PinChannelConfiguration pinChannelConfiguration = channelAccessAccessor.getPinConfiguration();
        if (pinChannelConfiguration == null) {
            throw new IllegalActionException("PIN is disabled for the current channel");
        }
        return pinChannelConfiguration;
    }

    private String generatePrincipal(BasicUser basicUser) {
        Predicate<String> predicate = string -> ((DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{$.user().eq((Object)basicUser), PinServiceImpl.$.pinPrincipal.eq(string)})).hasResults();
        String string2 = SecureRandomHelper.randomAlphanumeric((int)32);
        while (predicate.test(string2)) {
            string2 = SecureRandomHelper.randomAlphanumeric((int)32);
        }
        return string2;
    }

    private String getUniquePinName(BasicUser basicUser, String object) {
        Predicate<String> predicate = string -> ((DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{$.user().eq((Object)basicUser), PinServiceImpl.$.name.eq(string)})).hasResults();
        int n = 1;
        while (predicate.test((String)object)) {
            int n2 = ((String)object).lastIndexOf("_");
            if (n2 != -1) {
                object = ((String)object).substring(0, n2 + 1) + n++;
                continue;
            }
            object = (String)object + "_" + n++;
        }
        return object;
    }

    private boolean hasExpired(TimeInterval timeInterval, Date date) {
        if (timeInterval != null && timeInterval.isValid()) {
            Date date2 = DateHelper.add((Date)date, (ITimeInterval)timeInterval);
            return date2.before(new Date());
        }
        return false;
    }

    private void initFrom(Pin pin, SessionData sessionData) {
        pin.initFrom((UserPrincipal)sessionData);
        pin.setPasswordType(sessionData.getChannelAccessAccessor().getAccessPassword());
        pin.setChannel(sessionData.getChannel());
    }

    private boolean isPrincipalStillValid(Pin pin) {
        PrincipalType principalType = pin.getPrincipalType();
        if (principalType instanceof BuiltInPrincipalType && ((BuiltInPrincipalType)principalType).getBuiltInType() == ExistingBuiltInPrincipalType.EMAIL) {
            return StringHelper.isNotBlank((Object)pin.getUser().getEmail());
        }
        if (principalType instanceof CustomFieldPrincipalType) {
            UserCustomField userCustomField = ((CustomFieldPrincipalType)principalType).getCustomField();
            UserCustomFieldValue userCustomFieldValue = (UserCustomFieldValue)CustomFieldHelper.findValue((ICustomField)userCustomField, (Collection)pin.getUser().getCustomValues());
            return ObjectHelper.isNotEmpty((Object)CustomFieldHelper.getCustomFieldValue((ICustomFieldValue)userCustomFieldValue));
        }
        return true;
    }

    private long removeExpired(Group group, List<Channel> list) {
        QPin qPin = QPin.pin;
        QUser qUser = QUser.user;
        QOperator qOperator = OperatorServiceLocal.op;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        long l = 0L;
        for (Channel channel : list) {
            PinChannelConfiguration pinChannelConfiguration;
            ChannelConfiguration channelConfiguration;
            if (channel.getNetwork() != null && !channel.getNetwork().equals((Object)group.getNetwork()) || (channelConfiguration = configurationAccessor.getChannelConfiguration(channel)) == null || !channelConfiguration.isEnabled() || (pinChannelConfiguration = channelConfiguration.getPinConfiguration()) == null || pinChannelConfiguration.getPinLength() == null) continue;
            Date date = DateHelper.subtract((Date)new Date(), (ITimeInterval)pinChannelConfiguration.getPinExpiresAfter());
            this.processBatch(((DBQuery)this.rawEntityManagerHandler.selectFrom((EntityPath)qPin).where(new com.querydsl.core.types.Predicate[]{qPin.date.lt((Comparable)date), qPin.channel().eq((Object)channel), qPin.user().id.in((SubQueryExpression)((JPAQuery)new JPAQuery().select((Expression)qUser.id).from((EntityPath)qUser)).where((com.querydsl.core.types.Predicate)qUser.group().eq((Object)group))).or((com.querydsl.core.types.Predicate)qPin.user().id.in((SubQueryExpression)((JPAQuery)((JPAQuery)new JPAQuery().select((Expression)qUser.id).from((EntityPath)qOperator)).innerJoin((EntityPath)qOperator.user(), (Path)qUser)).where((com.querydsl.core.types.Predicate)qUser.group().eq((Object)group))))})).iterate(), (T pin) -> this.rawEntityManagerHandler.remove((IEntity)pin));
        }
        return l;
    }

    private PinDetailedVO toPinDetaileVo(Pin pin) {
        PinDetailedVO pinDetailedVO = (PinDetailedVO)this.conversionHandler.convert(PinDetailedVO.class, (Object)pin);
        if (pin.getUser().equals((Object)this.getLoggedBasicUser())) {
            pinDetailedVO.setPasswordInput(this.passwordHandler.accessor(CredentialUsage.ACCESS).getCredentialInput());
        }
        return pinDetailedVO;
    }

    private void validate(PinDTO pinDTO) {
        Validator validator = new Validator();
        BasicUser basicUser = this.getLoggedBasicUser();
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{$}).where(new com.querydsl.core.types.Predicate[]{$.user().eq((Object)basicUser), PinServiceImpl.$.name.eq((Object)pinDTO.getName()), PinServiceImpl.$.id.ne((Object)pinDTO.getId())});
        String string = "devicePin_" + basicUser.getId() + "_" + pinDTO.getName();
        validator.property(NamedEntityDTO.NAME, GeneralKeys.Ui.NAME).required().unique(string, (AbstractJPAQuery)dBQuery);
        this.validate(validator, pinDTO, "pinDTO");
    }

    private void validate(final SessionData sessionData, SetPinParams setPinParams, Pin pin) {
        Validator validator = new Validator();
        PinChannelConfiguration pinChannelConfiguration = sessionData.getChannelAccessAccessor().getPinConfiguration();
        if (pin == null) {
            validator.property((Property)SetPinParams.NAME, GeneralKeys.Ui.NAME).required();
        }
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)NestedProperty.nested((Property)SetPinParams.NEW_AND_CURRENT_CREDENTIALS, (Property)NewCredentialsForPinManage.PIN), AccessKeys.Pins.PIN).required().maskValue(StringHelper.repeat((String)"#", (int)pinChannelConfiguration.getPinLength()));
        if (sessionData.getChannelAccessAccessor().getAccessPassword().isAvoidObvious()) {
            property.add((PropertyValidation)new BasePropertyValidation(AccessKeys.Pins.ERROR_PIN_TOO_OBVIOUS){

                protected boolean isValid(Object object, Object object2, Object object3) {
                    BasicUser basicUser = sessionData.getLoggedBasicUser();
                    return !PasswordHelper.isTooObvious((String)((String)object3), Collections.singleton(basicUser.getUsername()));
                }
            });
        }
        validator.property((Property)NestedProperty.nested((Property)SetPinParams.NEW_AND_CURRENT_CREDENTIALS, (Property)NewCredentialsForPinManage.PIN_CONFIRMATION), AccessKeys.Pins.PIN_CONFIRMATION).required().add((object, object2, object3) -> {
            if (!Objects.equals(setPinParams.getNewAndCurrentCredentials().getPin(), setPinParams.getNewAndCurrentCredentials().getPinConfirmation())) {
                return new ValidationError(AccessKeys.Pins.ERROR_PIN_DOES_NOT_MATCH);
            }
            return null;
        });
        this.validate(validator, (Object)setPinParams, "setPinParams");
    }
}

