/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.util.Date;
import org.cyclos.entities.access.QSession;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurgeSessionsRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private SessionHandler sessionHandler;
    @Autowired
    private CyclosProperties cyclosProperties;

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NEXT;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.PURGE_SESSIONS;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_MINUTE;
    }

    @Override
    protected long execute() throws Throwable {
        int n = this.sessionHandler.purgeExpired();
        long l = 0L;
        int n2 = this.cyclosProperties.getPurgeSessionsDays();
        if (n2 > 0) {
            l = (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                QSession qSession = QSession.session;
                Date date = DateHelper.subtract((Date)new Date(), (TimeField)TimeField.DAYS, (int)n2);
                return this.rawEntityManagerHandler.delete((EntityPath)qSession).where(new Predicate[]{qSession.creationDate.before((Comparable)date)}).execute();
            });
        }
        return (long)n + l;
    }

    @Override
    protected boolean isRunInTransaction() {
        return false;
    }

    @Override
    protected void logTaskSuccess(String string, long l, long l2) {
    }
}

