/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QConfiguration;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.ServiceInvokerHandler;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.RequestDataCacheValue;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.logging.LogContext;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomWebServiceContext;
import org.cyclos.impl.system.CustomWebServiceServiceLocal;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingEntryType;
import org.cyclos.impl.system.ProfilingServiceLocal;
import org.cyclos.impl.utils.IdMask;
import org.cyclos.impl.utils.PushNotificationHandlerImplementor;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.InboundSmsHandler;
import org.cyclos.model.CredentialsNotSuppliedException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalInvocationException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.system.configurations.DefaultConfigurationType;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.model.utils.PushNotificationEventFilter;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.ReservedUris;
import org.cyclos.services.access.GuestInvocationData;
import org.cyclos.services.access.InvocationData;
import org.cyclos.services.access.InvocationResult;
import org.cyclos.services.access.ServiceFacade;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ServiceFacadeImpl
implements ServiceFacade {
    private static final Logger LOG = LogManager.getLogger(ServiceFacadeImpl.class);
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ServiceInvokerHandler serviceInvokerHandler;
    @Autowired
    private PushNotificationHandlerImplementor pushNotificationHandler;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private ConfigurationHandler configurationHandler;
    @Autowired
    private InboundSmsHandler inboundSmsHandler;
    @Autowired
    private CustomWebServiceServiceLocal customWebServiceService;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private CacheHandler cacheHandler;
    @Autowired
    @Lazy
    private ProfilingServiceLocal profilingService;
    private Cache<String, RequestDataCacheValue> _requestDataCache;

    public void closeSubscription(String string) {
        this.runInRequestContext(requestContext -> {
            this.pushNotificationHandler.close(string);
            return null;
        });
    }

    public String getResourceCacheKey() {
        return this.initializationService.getResourceCacheKey();
    }

    public ResponseInfo handleInboundSms(RequestData requestData) {
        return this.runInRequestContext(requestContext -> {
            this.ensureProcessed(requestData);
            return this.inboundSmsHandler.handleInboundSms(requestData);
        });
    }

    public InvocationResult invoke(InvocationData invocationData) throws FrameworkException, IllegalInvocationException {
        return this.runInRequestContext(requestContext -> {
            this.ensureProcessed(invocationData);
            Pair pair = this.profilingService.newIfEnabled(ProfilingEntryType.SERVICE, invocationData);
            requestContext.setProfiling(pair);
            InvocationResult invocationResult = this.serviceInvokerHandler.invoke(invocationData);
            if (pair != null) {
                this.profilingService.collect((ProfilingEntry)pair.getSecond(), invocationResult.getThrowable());
            }
            return invocationResult;
        });
    }

    public RequestData resolveRequestData(boolean bl, String string, String string2, String string3, String object) throws FrameworkException {
        String string4;
        String string5;
        List list = StringHelper.split((String)(object = StringHelper.removeEnd((String)object, (String)"/")), (String)"/");
        boolean bl2 = "global".equals(CollectionHelper.first((Iterable)list));
        if (bl2) {
            list.remove(0);
            object = StringUtils.removeStart((String)object, (String)"/global");
        }
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            string5 = (String)list.get(i);
            if (!ReservedUris.all().contains(string5)) continue;
            n = i;
            break;
        }
        Object object2 = n >= 0 ? "/" + StringHelper.join(list.subList(0, n), (String)"/") : object;
        if (bl2) {
            object2 = "/global" + (String)object2;
        }
        string5 = object2;
        String string6 = string3 + "\n" + string5;
        RequestDataCacheValue requestDataCacheValue = (RequestDataCacheValue)this._requestDataCache.get((Serializable)((Object)string6), () -> (RequestDataCacheValue)this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> {
            RequestDataCacheValue requestDataCacheValue = this.doResolveRequestData(string3, string5);
            requestDataCacheValue.setConfigurationId(this.getIdMask().apply(requestDataCacheValue.getConfigurationId()));
            requestDataCacheValue.setNetworkId(this.getIdMask().apply(requestDataCacheValue.getNetworkId()));
            return requestDataCacheValue;
        }));
        object = "/" + StringUtils.strip((String)object, (String)"/");
        if (bl2) {
            object = "/global" + (String)object;
        }
        if ((string4 = requestDataCacheValue.getConsumedPath()) != null && ((String)object).startsWith(string4) && !((String)(object = StringHelper.removeStart((String)object, (String)string4))).startsWith("/")) {
            object = "/" + (String)object;
        }
        RequestData requestData = new RequestData();
        requestData.setBaseUrl(bl ? requestDataCacheValue.getConfigurationRootUrl() : requestDataCacheValue.getBaseUrl());
        requestData.setApiUrl(requestDataCacheValue.getApiUrl());
        requestData.setConfigurationId(requestDataCacheValue.getConfigurationId());
        requestData.setNetworkId(requestDataCacheValue.getNetworkId());
        requestData.setNetworkInternalName(requestDataCacheValue.getNetworkInternalName());
        requestData.setDefaultGlobal(requestDataCacheValue.isDefaultGlobal());
        requestData.setConsumedPath(string4);
        requestData.setUri((String)object);
        requestData.setCustomUrl(requestDataCacheValue.isCustomUrl());
        requestData.setSecure("https".equalsIgnoreCase(string));
        requestData.setRemoteAddress(string2);
        return requestData;
    }

    public ResponseInfo runCustomWebService(InvocationData invocationData) {
        return this.runInRequestContext(requestContext -> {
            RequestData requestData = invocationData.getRequestData();
            RequestInfo requestInfo = requestData.getRequestInfo();
            this.ensureProcessed(requestData);
            Pair pair = this.profilingService.newIfEnabled(ProfilingEntryType.CUSTOM_WEB_SERVICE, invocationData);
            ProfilingEntry profilingEntry = pair == null ? null : (ProfilingEntry)pair.getSecond();
            requestContext.setProfiling(pair);
            CustomWebServiceContext customWebServiceContext = new CustomWebServiceContext();
            MutableObject mutableObject = new MutableObject((Object)LogContext.empty());
            try {
                String string = requestInfo.getHeader("Channel", BuiltInChannel.WEB_SERVICES.getInternalName());
                SessionData sessionData = SessionDataFactory.system((RequestData)requestData, (String)string);
                ResponseInfo responseInfo = (ResponseInfo)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
                    this.customWebServiceService.prepareContext(customWebServiceContext, invocationData);
                    LogConfiguration logConfiguration = customWebServiceContext.getRunAs().getConfiguration().getLogConfiguration();
                    mutableObject.setValue((Object)this.getLogContext(profilingEntry, customWebServiceContext, logConfiguration));
                    long l = System.currentTimeMillis();
                    ResponseInfo responseInfo = this.customWebServiceService.run(customWebServiceContext);
                    JsonNode jsonNode = null;
                    if (profilingEntry != null || logConfiguration.isLogServicesResults()) {
                        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                        linkedHashMap.put("status", responseInfo.getStatus());
                        linkedHashMap.put("headers", this.toMap(responseInfo.getHeaders()));
                        if (StringHelper.isNotBlank((Object)responseInfo.getStringBody())) {
                            linkedHashMap.put("body", responseInfo.getStringBody());
                        }
                        jsonNode = this.jsonConverter.toLogNode(linkedHashMap, false);
                        if (profilingEntry != null) {
                            profilingEntry.setResult((Object)jsonNode);
                        }
                    }
                    ((LogContext)mutableObject.getValue()).setTimeTaken(System.currentTimeMillis() - l).setResult(Pair.create((Object)responseInfo, logConfiguration.isLogServicesResults() ? jsonNode : null));
                    return responseInfo;
                });
                if (profilingEntry != null) {
                    this.profilingService.collect(profilingEntry, null);
                }
                ResponseInfo responseInfo2 = responseInfo;
                return responseInfo2;
            }
            catch (Exception exception) {
                ((LogContext)mutableObject.getValue()).setError((Throwable)exception);
                Object object = "Custom web service: ";
                if (customWebServiceContext.getCustomWebService() == null) {
                    object = (String)object + "NOT_FOUND";
                } else {
                    object = (String)object + customWebServiceContext.getCustomWebService().getName();
                    if (customWebServiceContext.getPath() != null) {
                        object = (String)object + " (" + customWebServiceContext.getPath() + ")";
                    }
                }
                this.serviceInvokerHandler.generateErrorLog(requestData.getRemoteAddress(), requestData.getNetworkId(), requestData.getConfigurationId(), invocationData.getChannel(), SimpleEntity.id((SimpleEntity)customWebServiceContext.getLoggedBasicUser()), (String)object, this.parametersGetter(requestInfo), (Throwable)exception);
                LOG.error("Error on " + (String)object, (Throwable)exception);
                if (profilingEntry != null) {
                    this.profilingService.collect(profilingEntry, (Throwable)exception);
                }
                throw exception;
            }
            finally {
                ((LogContext)mutableObject.getValue()).logService();
            }
        });
    }

    public String subscribe(InvocationData invocationData, String string, PushNotificationEventFilter pushNotificationEventFilter, Consumer<PushNotificationEvent<?>> consumer) {
        return this.runInRequestContext(requestContext -> {
            Set set;
            if (invocationData == null) {
                throw new IllegalInvocationException();
            }
            Set set2 = set = pushNotificationEventFilter == null ? null : pushNotificationEventFilter.getTypes();
            if (CollectionHelper.isEmpty((Iterable)set)) {
                throw new ValidationException("No event types provided for push notitications subscription");
            }
            boolean bl = invocationData instanceof GuestInvocationData;
            for (PushNotificationEventType pushNotificationEventType : PushNotificationEventType.getAll()) {
                boolean bl2;
                boolean bl3 = set.contains(pushNotificationEventType);
                if (bl3 && bl && !pushNotificationEventType.isAllowGuest()) {
                    throw new CredentialsNotSuppliedException();
                }
                Property property = pushNotificationEventType.getFilter();
                if (property == null) continue;
                boolean bl4 = ObjectHelper.isNotEmpty((Object)pushNotificationEventFilter.get(property));
                if (bl && bl3 && !bl4) {
                    throw new ValidationException("To be notified as guest for event type " + String.valueOf(pushNotificationEventType) + " you must supply a value for " + pushNotificationEventType.getFilter().getName());
                }
                if (!bl4 || bl3 || (bl2 = PushNotificationEventType.getAll().stream().anyMatch(pushNotificationEventType2 -> pushNotificationEventType2 != pushNotificationEventType && pushNotificationEventType2.getFilter() == property))) continue;
                throw new ValidationException("Cannot set a value to " + property.getName() + " when not subscribing to event " + String.valueOf(pushNotificationEventType));
            }
            this.ensureProcessed(invocationData);
            SessionData sessionData = this.serviceInvokerHandler.resolveSessionData(invocationData);
            return (String)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_ONLY, transactionStatus -> {
                sessionData.checkConsistency();
                return this.pushNotificationHandler.subscribe(string, pushNotificationEventFilter, consumer);
            });
        });
    }

    public void timeoutSubscription(String string) {
        this.runInRequestContext(requestContext -> {
            this.pushNotificationHandler.timeout(string);
            return null;
        });
    }

    private Collection<String> allSchemes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf("://");
        if (n >= 0) {
            String string2 = string.substring(n + "://".length());
            arrayList.add("http://" + string2);
            arrayList.add("https://" + string2);
        } else {
            arrayList.add("http://" + string);
            arrayList.add("https://" + string);
        }
        return arrayList;
    }

    private RequestDataCacheValue doResolveRequestData(String string, String string2) {
        String string3;
        Network network;
        boolean bl;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (StringHelper.isNotBlank((Object)string2)) {
            linkedList.addAll(Arrays.asList(StringUtils.removeEnd((String)StringUtils.removeStart((String)string2, (String)"/"), (String)"/").split("\\/")));
        }
        LinkedList<String> linkedList2 = new LinkedList<String>();
        string = StringUtils.removeEnd((String)string, (String)"/");
        String string4 = null;
        if (!linkedList.isEmpty()) {
            string4 = (String)linkedList.removeFirst();
            linkedList2.addLast(string4);
        }
        QConfiguration qConfiguration = QConfiguration.configuration;
        QNetwork qNetwork = QNetwork.network;
        String string5 = (String)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qConfiguration}).where((Predicate)qConfiguration.defaultType.eq((Object)DefaultConfigurationType.GLOBAL))).singleResult((Expression)qConfiguration.rootUrl);
        Configuration configuration = (Configuration)((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qConfiguration}).leftJoin((EntityPath)qConfiguration.network(), (Path)qNetwork)).where(new Predicate[]{qNetwork.id.isNull().or((Predicate)qNetwork.enabled.isTrue()), qConfiguration.defaultType.isNotNull().or((Predicate)qConfiguration.defineRootUrl.isTrue().or((Predicate)qConfiguration.path.isNotEmpty())), qConfiguration.rootUrl.notIn(this.allSchemes(string5)), qConfiguration.rootUrl.in(this.allSchemes(string)), string4 == null ? qConfiguration.path.isNull() : qConfiguration.path.isNull().or((Predicate)qConfiguration.path.eq((Object)string4))})).orderBy(new OrderSpecifier[]{qConfiguration.path.asc().nullsLast(), qConfiguration.defaultType.asc().nullsLast()})).singleResult((Expression)qConfiguration);
        boolean bl2 = bl = configuration != null;
        if (!linkedList2.isEmpty() && (configuration == null || StringHelper.isBlank((Object)configuration.getPath()))) {
            linkedList.addFirst((String)linkedList2.removeLast());
            string4 = null;
        }
        if (configuration == null) {
            network = null;
            boolean bl3 = false;
            if (!linkedList.isEmpty()) {
                string4 = (String)linkedList.removeFirst();
                if ("global".equals(string4)) {
                    bl3 = true;
                } else {
                    network = (Network)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qNetwork}).where(new Predicate[]{qNetwork.enabled.isTrue(), qNetwork.internalName.eq((Object)string4)})).singleResult((Expression)qNetwork);
                    boolean bl4 = bl3 = network != null;
                }
            }
            if (bl3) {
                linkedList2.addFirst(string4);
            } else {
                linkedList.addFirst(string4);
                network = this.networkService.getDefault();
                bl3 = true;
            }
            String string6 = string3 = linkedList.isEmpty() ? null : (String)linkedList.removeFirst();
            if (string3 != null) {
                configuration = (Configuration)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qConfiguration}).where(new Predicate[]{network == null ? qConfiguration.network().isNull() : qConfiguration.network().eq((Object)network), qConfiguration.path.eq((Object)string3)})).singleResult((Expression)qConfiguration);
                if (configuration != null) {
                    linkedList2.add(string3);
                } else {
                    linkedList.addFirst(string3);
                }
            }
            if (configuration == null) {
                configuration = network == null ? this.configurationHandler.getGlobalDefault() : network.getDefaultConfiguration();
            }
        }
        network = configuration.getNetwork();
        String string7 = linkedList2.isEmpty() ? null : "/" + StringUtils.join(linkedList2, (String)"/");
        string3 = StringUtils.removeEnd((String)(string + StringHelper.trim((Object)string7)), (String)"/");
        RequestDataCacheValue requestDataCacheValue = new RequestDataCacheValue();
        requestDataCacheValue.setBaseUrl(string3);
        requestDataCacheValue.setConfigurationId(configuration.getId());
        requestDataCacheValue.setDefaultGlobal(network == null && !"global".equals(string4));
        requestDataCacheValue.setCustomUrl(bl);
        requestDataCacheValue.setConsumedPath(string7);
        if (network != null) {
            requestDataCacheValue.setNetworkId(network.getId());
            requestDataCacheValue.setNetworkInternalName(network.getInternalName());
        }
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
        requestDataCacheValue.setConfigurationRootUrl(configurationAccessor.getFullUrl());
        requestDataCacheValue.setApiUrl(configurationAccessor.getApiUrl());
        return requestDataCacheValue;
    }

    private void ensureProcessed(InvocationData invocationData) {
        if (invocationData == null) {
            throw new NullPointerException("Null InvocationData received");
        }
        RequestData requestData = invocationData.getRequestData();
        this.ensureProcessed(requestData);
    }

    private void ensureProcessed(RequestData requestData) {
        if (!requestData.isProcessedIds()) {
            requestData.setConfigurationId(this.getIdMask().remove(requestData.getConfigurationId()));
            requestData.setNetworkId(this.getIdMask().remove(requestData.getNetworkId()));
            requestData.setProcessedIds(true);
        }
    }

    private IdMask getIdMask() {
        return this.applicationHandler.getIdMask();
    }

    private LogContext getLogContext(ProfilingEntry profilingEntry, CustomWebServiceContext customWebServiceContext, LogConfiguration logConfiguration) {
        Object object;
        boolean bl = logConfiguration.isEnableServicesLog() && (!logConfiguration.isLogServicesForGuests() || customWebServiceContext.getLoggedBasicUser() != null);
        boolean bl2 = bl && logConfiguration.isLogServicesParameters();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        JsonNode jsonNode = null;
        RequestInfo requestInfo = customWebServiceContext.getRequest();
        if (profilingEntry != null || bl2) {
            linkedHashMap.put("method", requestInfo.getMethod());
            linkedHashMap.put("path", customWebServiceContext.getPath());
            if (CollectionHelper.isNotEmpty((Map)customWebServiceContext.getPathVariables())) {
                linkedHashMap.put("pathVariables", customWebServiceContext.getPathVariables());
            }
            if (!(object = this.toMap(requestInfo.getParameters())).isEmpty()) {
                linkedHashMap.put("queryParameters", object);
            }
            jsonNode = this.jsonConverter.toLogNode(linkedHashMap, true);
            if (profilingEntry != null) {
                profilingEntry.setParameters((Object)jsonNode);
            }
        }
        object = customWebServiceContext.getCustomWebService();
        return this.serviceInvokerHandler.getLogContext(customWebServiceContext.getRunAs(), object.getId(), object.getName(), requestInfo.getMethod(), Pair.create(linkedHashMap, bl2 ? jsonNode : null));
    }

    @PostConstruct
    private void initialize() {
        this._requestDataCache = this.cacheHandler.getCache(CacheType.REQUEST_DATA);
    }

    private Supplier<String> parametersGetter(RequestInfo requestInfo) {
        return () -> {
            ParameterStorage parameterStorage = requestInfo.getParameters();
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            for (String string : CollectionHelper.iterable((Iterator)parameterStorage.getNames())) {
                List list = parameterStorage.getStringList(string);
                linkedHashMap.put(string, JsonConverter.mask(null, (String)string, (Object)CollectionHelper.maybeUnwrap((Collection)list)));
            }
            try {
                return this.jsonConverter.writeValueAsString(linkedHashMap);
            }
            catch (JsonGenerationException | JsonMappingException throwable) {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runInRequestContext(Function<RequestContext, T> function) {
        try {
            RequestContext requestContext = RequestContext.ensure();
            T t = function.apply(requestContext);
            return t;
        }
        finally {
            RequestContext.remove();
        }
    }

    private Map<String, Object> toMap(ParameterStorage parameterStorage) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        parameterStorage.getNames().forEachRemaining(string -> {
            if (PropertyHelper.isSecretProperty((String)string)) {
                hashMap.put((String)string, "****");
            } else {
                hashMap.put((String)string, CollectionHelper.maybeUnwrap((Collection)parameterStorage.getStringList(string)));
            }
        });
        return hashMap;
    }
}

